/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class GetCPU {
    public static String syncString = new String("GetCPU");
    private static GetCPU getCPUObj = null;
    private static String object = "Process";
    private static String[] counters = new String[]{"Working Set", "ID Process", "Handle Count", "Thread Count", "Virtual Bytes", "Private Bytes", "Pool Paged Bytes", "Pool Nonpaged Bytes", "% Processor Time", "IO Data Bytes/sec", "IO Data Operations/sec", "IO Read Bytes/sec", "IO Write Bytes/sec", "Page Faults/sec", "IO Read Operations/sec", "IO Write Operations/sec", "Creating Process ID"};
    private ArrayList outputList = new ArrayList();
    private ArrayList outList = new ArrayList();
    private ArrayList errList = new ArrayList();
    private String[] instances = null;
    private double[][] values = null;
    private EgPerfInstrumentation egPerfUtil = null;
    public static long lastRunTime = 0L;
    private static long cachePeriod = 30000L;
    private static long three_cachePeriod = 90000L;
    private static long eight_cachePeriod = 240000L;
    private static long myTimeout = 30000L;
    private static long startTime = System.currentTimeMillis();
    private static long endTime = System.currentTimeMillis();
    private static ArrayList lastResults = new ArrayList();
    public static Vector cacheResults = new Vector();
    public static String[] cacheInstances = null;
    public static double[][] cacheValues = null;
    private static double lowerrandomizeFactor = 0.4;
    private static double upperrandomizeFactor = 0.4;
    public static double midFactor = 1.5;

    private GetCPU() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GetCPU getInstance() {
        if (getCPUObj == null) {
            String string = syncString;
            synchronized (string) {
                if (getCPUObj == null) {
                    getCPUObj = new GetCPU();
                }
            }
        }
        return getCPUObj;
    }

    public static long getNextPeriod(long l) {
        double d = (double)l * (1.0 + upperrandomizeFactor);
        double d2 = (double)l * (1.0 - lowerrandomizeFactor);
        long l2 = (long)(d2 + GetCPU.getRandom() * (d - d2));
        return l2;
    }

    public static double getRandom() {
        long l = System.currentTimeMillis();
        double d = (double)(l % 100L) * 0.01;
        if (d < 0.1) {
            d = 0.1;
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getGetCPUData() {
        String string = syncString;
        synchronized (string) {
            int n;
            long l = endTime - startTime;
            myTimeout = l * 4L;
            if (myTimeout < cachePeriod) {
                myTimeout = cachePeriod;
            } else if (myTimeout > three_cachePeriod) {
                myTimeout = three_cachePeriod;
            } else if (myTimeout > eight_cachePeriod) {
                myTimeout = eight_cachePeriod;
            }
            long l2 = (long)(midFactor * (double)myTimeout);
            long l3 = GetCPU.getNextPeriod(l2);
            long l4 = System.currentTimeMillis();
            if (l4 - lastRunTime < l3 && lastResults != null) {
                return lastResults;
            }
            this.outputList = new ArrayList();
            this.outList = new ArrayList();
            this.errList = new ArrayList();
            this.outputList.add(this.outList);
            this.outputList.add(this.errList);
            System.out.println("[GetCPU] execution start at " + new Date());
            long l5 = System.currentTimeMillis();
            EgJNAUtilities egJNAUtilities = new EgJNAUtilities();
            this.instances = egJNAUtilities.getWinProcesseInstances();
            if (this.instances == null || this.instances.length == 0) {
                lastResults = this.outputList;
                this.finishWork();
                lastRunTime = System.currentTimeMillis();
                return this.outputList;
            }
            if (this.egPerfUtil == null) {
                this.egPerfUtil = new EgPerfInstrumentation();
            }
            this.values = this.egPerfUtil.getCounterValue(object, this.instances, counters);
            if (this.values == null || this.values.length == 0) {
                this.stopTest();
                this.instances = null;
                lastResults = this.outputList;
                this.finishWork();
                lastRunTime = System.currentTimeMillis();
                return this.outputList;
            }
            int n2 = -1;
            String string2 = "";
            String string3 = "";
            int n3 = this.instances.length;
            double d = 0.0;
            boolean bl = false;
            int n4 = -1;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = new String[n3];
            for (n = 0; n < n3; ++n) {
                string2 = this.instances[n];
                if (!bl) {
                    if (string2.equalsIgnoreCase("_Total")) {
                        d = this.values[n][8];
                        bl = true;
                        n4 = n;
                    } else if (this.values[n][8] > 0.0) {
                        d += this.values[n][8];
                    }
                }
                if ((n2 = string2.indexOf("#")) > 0) {
                    string2 = string2.substring(0, n2);
                }
                stringArray[n] = string2;
                string3 = n == 0 ? "##" + string2 : string3 + "#" + string2;
                String string4 = "#1:" + string2 + "=" + this.values[n][0] + "#" + this.values[n][1] + "#" + this.values[n][2] + "#" + this.values[n][3] + "#" + this.values[n][4] + "#" + this.values[n][5] + "#" + this.values[n][6] + "#" + this.values[n][7];
                arrayList.add(string4);
            }
            this.outList.add(string3);
            this.outList.addAll(arrayList);
            if (d == 0.0) {
                d = 1.0;
            }
            for (n = 0; n < n3; ++n) {
                string2 = stringArray[n];
                if (n == n4) continue;
                double d2 = this.values[n][8];
                if (d2 > 0.0) {
                    d2 = d2 / d * 100.0;
                }
                String string5 = "#2:" + string2 + "=" + d2 + "#" + this.values[n][1] + "#" + this.values[n][9] + "#" + this.values[n][10] + "#" + this.values[n][11] + "#" + this.values[n][12] + "#" + this.values[n][13] + "#" + this.values[n][14] + "#" + this.values[n][15];
                this.outList.add(string5);
            }
            this.outputList.set(0, this.outList);
            lastResults = this.outputList;
            long l6 = lastRunTime = System.currentTimeMillis();
            System.out.println("[GetCPU] execution end at " + new Date());
            this.finishWork();
            this.stopTest();
            return this.outputList;
        }
    }

    private void finishWork() {
        cacheInstances = this.instances != null ? this.instances : null;
        cacheValues = this.values != null ? this.values : (double[][])null;
        cacheResults = new Vector();
        cacheResults.add(cacheInstances);
        cacheResults.add(cacheValues);
    }

    private void stopTest() {
        if (this.egPerfUtil != null) {
            this.egPerfUtil.stop();
        }
        this.egPerfUtil = null;
    }

    public static void main(String[] stringArray) {
        Object object;
        GetCPU getCPU = GetCPU.getInstance();
        if (stringArray.length == 0) {
            try {
                object = System.getenv("EGVMAGENT_INSTALL_DIR");
                if (object != null && ((String)object).trim().length() > 0) {
                    EgInstallInfo.setInstallDir((String)object);
                }
            }
            catch (Exception exception) {}
        } else {
            EgInstallInfo.setInstallDir(stringArray[0]);
        }
        object = getCPU.getGetCPUData();
        System.out.println(object);
    }
}

