/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import com.egurkha.util.LogFileReader;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class CtxAppLayerReadLog {
    private String encode = "none";
    private int maxReadLines = 250;
    private long fileReadLimit = 50000L;
    private boolean appLayerAvailability = false;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    public ArrayList getLogData(long l) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            int n;
            ArrayList arrayList2;
            this.appLayerAvailability = this.checkAppLayerServiceAvailability();
            if (!this.appLayerAvailability) {
                return arrayList;
            }
            String string = System.getenv("ProgramData");
            if (string == null || string.trim().length() == 0) {
                return arrayList;
            }
            String string2 = string + "/unidesk/logs";
            File file = new File(string2);
            if (file == null || !file.exists() || !file.isDirectory()) {
                return arrayList;
            }
            String string3 = string2 + "/ulayersvc.log";
            file = new File(string3);
            if (file == null || !file.exists() || !file.isFile()) {
                return arrayList;
            }
            long l2 = file.lastModified();
            long l3 = System.currentTimeMillis() - l2;
            if (l3 > l) {
                System.out.println("[CtxAppLayerReadLog] given time limit log is not updated, So return! timeLimit: " + l + ", flie last update : " + l3);
                return arrayList;
            }
            long l4 = file.length();
            if (l4 > this.fileReadLimit) {
                l4 -= this.fileReadLimit;
            }
            if ((arrayList2 = this.readFromLogFile(string3, l4)) == null || arrayList2.size() == 0) {
                return arrayList;
            }
            String string4 = null;
            ArrayList arrayList3 = null;
            int n2 = 0;
            boolean bl = false;
            String string5 = null;
            for (int i = n = arrayList2.size() - 1; i >= 0; --i) {
                string4 = (String)arrayList2.get(i);
                if (string4 == null) continue;
                ++n2;
                if ((string4 = string4.trim()).indexOf("INFO") > 0 && string4.indexOf("RequestService:") > 0) {
                    String string6;
                    String string7;
                    if (string4.indexOf("Ending request") > 0 && string4.indexOf("started on behalf of") > 0) {
                        string7 = (String)arrayList2.get(i - 1);
                        if (string7.indexOf("Finished processing logon event") >= 0) {
                            string6 = string4.substring(0, string4.indexOf("started on behalf of")).trim();
                            arrayList3 = CtxAppLayerReadLog.myTokenizer(string6, " ");
                            if (arrayList3 == null || arrayList3.size() < 8) continue;
                            string5 = ((String)arrayList3.get(arrayList3.size() - 1)).trim();
                            if (string5 != null) {
                                bl = true;
                                arrayList.add(string4);
                            }
                        }
                    } else if (string4.indexOf("Starting request") > 0 && string4.indexOf("on behalf of") > 0) {
                        if (string5 != null && bl) {
                            string7 = string4.substring(0, string4.indexOf("on behalf of")).trim();
                            arrayList3 = CtxAppLayerReadLog.myTokenizer(string7, " ");
                            if (arrayList3 == null || arrayList3.size() < 8 || !string5.equalsIgnoreCase(string6 = ((String)arrayList3.get(arrayList3.size() - 1)).trim())) continue;
                            arrayList.add(string4);
                            break;
                        }
                        string7 = (String)arrayList2.get(i + 1);
                        if (string7.indexOf("Received logon event") >= 0) {
                            arrayList = new ArrayList();
                            break;
                        }
                    }
                } else if (bl) {
                    arrayList.add(string4);
                }
                if (n2 <= this.maxReadLines) continue;
                System.out.println("[CtxAppLayerReadLog] readLinesCount > maxReadLines: readLinesCount: " + n2);
                arrayList = new ArrayList();
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("[CtxAppLayerReadLog] got exception at getting log data time: " + exception);
        }
        System.out.println("[CtxAppLayerReadLog] final outList: " + arrayList);
        return arrayList;
    }

    private ArrayList readFromLogFile(String string, long l) {
        ArrayList arrayList = null;
        LogFileReader logFileReader = null;
        try {
            logFileReader = new LogFileReader(string, 0L, this.encode);
            arrayList = logFileReader.readAllLines();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2).trim();
            arrayList.add(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n).trim();
        arrayList.add(string3);
        return arrayList;
    }

    private long getTimeInMilliSec(String string) {
        long l = 0L;
        try {
            l = sdf.parse(string).getTime();
        }
        catch (Exception exception) {
            System.out.println("[CtxAppLayerReadLog] got some Exception when converting String to date, Given Time: , " + string);
        }
        return l;
    }

    private boolean checkAppLayerServiceAvailability() {
        boolean bl;
        block4: {
            bl = false;
            String string = "sc query UniService";
            try {
                EgUtilities egUtilities = EgUtilities.createInstance();
                ArrayList arrayList = egUtilities.getExecOutputLines(string);
                if (arrayList == null || arrayList.size() < 2) {
                    System.out.println("[CtxAppLayerReadLog] Could not Run cmdLine: " + string);
                    return bl;
                }
                if ((arrayList = (ArrayList)arrayList.get(0)) == null || arrayList.size() <= 0) break block4;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)arrayList.get(i);
                    if (!string2.startsWith("SERVICE_NAME") || string2.toLowerCase().indexOf("uniservice") < 0) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("[CtxAppLayerReadLog] cmdLine: " + string + " running time exception occured e: " + exception);
                bl = false;
            }
        }
        return bl;
    }
}

