<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.File" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	JSONObject rootJson = new JSONObject();
	String userFolderName = request.getParameter("userScriptFile");
	String egInstallDir = EgInstallInfo.getInstallDir();
	String fileDirectory = egInstallDir+"/manager/config/SyntheticScripts/";

	if (StringUtils.isNull(userFolderName))
	{
		try
		{
			String uName = (String)session.getAttribute("sess_userid");
			EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),uName);
			boolean allCompAccess = ri.hasAllComponentAccess();
			JSONArray userScriptFileArr = new JSONArray();
			JSONObject userScriptFileObj = new JSONObject();
			if (allCompAccess)
			{
				File folder = new File(fileDirectory);
				if (folder.exists())
				{
					String[] folders = folder.list();
					for (int x=0; x<folders.length; x++)
					{
						String folderStr = folders[x];
						folderStr = folderStr.toLowerCase();
						String uNameStr = "";
						int slash_idx = folderStr.indexOf("~slash~");
						if (slash_idx != -1)
						{
							ArrayList userNameTokenList = StringUtils.egTokenizer(folderStr,"~slash~");
							int token_size = userNameTokenList.size();
							for (int i=0; i<token_size; i++)
							{
								String userNameStr = (String) userNameTokenList.get(i);
								uNameStr += userNameStr+"/";
							}
							int forwardSlash = uNameStr.lastIndexOf("/");
							uNameStr = uNameStr.substring(0,forwardSlash);
						}
						if (!StringUtils.isNull(uNameStr) && uNameStr.trim().length() > 0)
						{
							if (uNameStr.startsWith("samlsso/"))
							{
								int idx = uNameStr.indexOf("/");
								uNameStr = uNameStr.substring(idx+1) + " (SAML)";
							}
							else if (uNameStr.indexOf("/") != -1)
							{
								ArrayList uNameList = StringUtils.egTokenizer(uNameStr,"/");
								if (uNameList != null && uNameList.size() == 3)
								{
									uNameStr += " (Group)";
								}
							}
						}
						else
						{
							uNameStr = folderStr;
						}
						userScriptFileObj.put("displayField",uNameStr);
						userScriptFileObj.put("valueField",folderStr);
						userScriptFileArr.add(userScriptFileObj);
					}
				}
			}
			else
			{
				EgUuidInfo egUuidInfo = new EgUuidInfo();
				ArrayList userNameList = egUuidInfo.getAllSubOrgsAndUsers(uName);
				if (egUuidInfo.isSuperOrg(uName))
				{
					userNameList.add(uName);
				}
				if (egUuidInfo.isUser(uName))
				{
					if (egUuidInfo.hasOURole(uName))
					{
						String dependentOU = egUuidInfo.getDirectDependentOU(uName);
						userNameList = egUuidInfo.getAllSubOrgsAndUsers(dependentOU);
						if (egUuidInfo.isSuperOrg(dependentOU))
						{
							userNameList.add(dependentOU);
						}
					}
				}

				int uname_size = userNameList.size();
				if (userNameList != null && uname_size > 0)
				{
					for (int x=0; x<uname_size; x++)
					{
						String fileDir = fileDirectory;
						String folderStr = (String) userNameList.get(x);
						folderStr = folderStr.toLowerCase();
						fileDir += folderStr;
						File folder = new File(fileDir);
						if (folder.exists())
						{
							String uNameStr = "";
							int slash_idx = folderStr.indexOf("~slash~");
							if (slash_idx != -1)
							{
								ArrayList userNameTokenList = StringUtils.egTokenizer(folderStr,"~slash~");
								int token_size = userNameTokenList.size();
								for (int i=0; i<token_size; i++)
								{
									String userNameStr = (String) userNameTokenList.get(i);
									uNameStr += userNameStr+"/";
								}
								int forwardSlash = uNameStr.lastIndexOf("/");
								uNameStr = uNameStr.substring(0,forwardSlash);
							}
							if (!StringUtils.isNull(uNameStr) && uNameStr.trim().length() > 0)
							{
								if (uNameStr.startsWith("samlsso/"))
								{
									int idx = uNameStr.indexOf("/");
									uNameStr = uNameStr.substring(idx+1) + " (SAML)";
								}
								else if (uNameStr.indexOf("/") != -1)
								{
									ArrayList uNameList = StringUtils.egTokenizer(uNameStr,"/");
									if (uNameList != null && uNameList.size() == 3)
									{
										uNameStr += " (Group)";
									}
								}
							}
							else
							{
								uNameStr = folderStr;
							}
							userScriptFileObj.put("displayField",uNameStr);
							userScriptFileObj.put("valueField",folderStr);
							userScriptFileArr.add(userScriptFileObj);
						}
					}
				}
			}
			if (userScriptFileArr == null || userScriptFileArr.size() == 0)
			{
				userScriptFileObj.put("displayField","Not Applicable");
				userScriptFileObj.put("valueField","-1");
				userScriptFileArr.add(userScriptFileObj);
			}
			rootJson.put("userScriptFileArr",userScriptFileArr);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	else
	{
		JSONArray scriptFileNameArr = new JSONArray();
		JSONObject scriptFileNameObj = new JSONObject();
		userFolderName = StringUtils.decodeSecurityChar(userFolderName);
		fileDirectory += userFolderName.toLowerCase();
		try
		{
			File folder = new File(fileDirectory);
			if (folder.exists())
			{
				File[] folders = folder.listFiles();
				for (int x=0; x<folders.length; x++)
				{
					File file = folders[x];
					if (!file.isDirectory())
					{
						String fileNameStr = file.getName();
						String displayField = fileNameStr;
						int df_ind = displayField.lastIndexOf(".");
						if (df_ind != -1)
						{
							displayField = displayField.substring(0,df_ind);
						}
						String valueField = fileNameStr+"#^#"+userFolderName;
						scriptFileNameObj.put("displayField",displayField);
						scriptFileNameObj.put("valueField",valueField);
						scriptFileNameArr.add(scriptFileNameObj);
					}
				}
			}
			if (scriptFileNameArr == null || scriptFileNameArr.size() == 0)
			{
				scriptFileNameObj.put("displayField","None");
				scriptFileNameObj.put("valueField","none");
				scriptFileNameArr.add(scriptFileNameObj);
			}
			rootJson.put("scriptFileNameArr",scriptFileNameArr);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	out.println(rootJson.toString());
%>



