<%
/*******************************************************************************
*       Name            :       EgconfigaggregatepJson.jsp
*       Purpose         :
*       Version         :       1.0
*******************************************************************************/
%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import="com.eg.EgAggregateInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="egurkha.EgUIUtils"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<%
	JSONObject rootJson = new JSONObject();
	/* code for auditlog starts */
	String previousIncludedDescriptors = request.getParameter("previousIncludedDescriptors");

	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Agents");
	auditLogThread.setValue("Activity","Specific Test Configuration");

	ArrayList previousDesc = new ArrayList();
	ArrayList currentDesc = new ArrayList();
	if(previousIncludedDescriptors != null && !previousIncludedDescriptors.equals("null")  && previousIncludedDescriptors.trim().length()>0)
	{
		previousIncludedDescriptors = EgUIUtils.decodeSecurityChar(previousIncludedDescriptors);
		String descs[] = StringUtils.getTokens(previousIncludedDescriptors.trim(),",");
		if(descs != null && descs.length>0)
			previousDesc.addAll(Arrays.asList(descs));
	}

	String[] currentIncludedDescriptors = request.getParameterValues("n_fassociate");
	StringBuffer include_infos = new StringBuffer();
	if(currentIncludedDescriptors != null && currentIncludedDescriptors.length>0)
	{
		for(int i=0;i<currentIncludedDescriptors.length;i++)
		{
			String cur_inc_info = EgUIUtils.decodeSecurityChar(currentIncludedDescriptors[i]);
			if(!previousDesc.contains(cur_inc_info))
			{
				include_infos.append(",");
				include_infos.append(cur_inc_info);
			}
		}
	}

	if(include_infos.length()>0)
	{
		auditLogThread.setCurrentValue("Included Descriptors",include_infos.toString().substring(1));
	}
	String test = request.getParameter("test");
	String comp = request.getParameter("comp");
	String server = request.getParameter("server");
	
	String m_test = test;
	if(test.endsWith("_ag"))
	{
		m_test = _mapping.getTestDescription(test.substring(0,test.indexOf("_ag")))+" Aggregate";
	}
	else if(test.endsWith("_agx"))
	{
		com.eg.IniFile agg_lang_file = new com.eg.IniFile(com.eg.EgConfigInfo.egMgrConfigDir+"eg_aggregate_lang_en_US.ini");
		m_test = agg_lang_file.getValue("TEST_NAME_MAPPING",test);
	}
	String m_server = server.substring(server.indexOf("_")+1);
	m_server = _mapping.getComponentTypeDescription(m_server)+" Aggregate";
	String m_comp = comp;
	if(m_comp.indexOf(":NULL") >-1)
	{
		m_comp = comp.substring(0,comp.indexOf(":"));
	}

	ArrayList excludedInfos = new ArrayList();
	String[] currentExcludedDescriptors = request.getParameterValues("fdissociate");
	if(currentExcludedDescriptors != null && currentExcludedDescriptors.length>0)
	{
		for(int i=0;i<currentExcludedDescriptors.length;i++)
		{
			excludedInfos.add(EgUIUtils.decodeSecurityChar(currentExcludedDescriptors[i]));
		}
	}
	IniFile aggregateInfoSync = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate.ini",true);
	String test_comp = test + ":" + server + ":" + comp + "#";

	if(!excludedInfos.isEmpty())
	{
		StringBuffer exclude_infos = new StringBuffer();
		String[] agg_test_infos = aggregateInfoSync.getVariables(EgAggregateInfo.testInfoExclude);
		if (agg_test_infos != null)
		{
			Vector v = new Vector();
			Vector pre_exclude_info = new Vector();
			StringTokenizer strTokens = new StringTokenizer(test_comp,",");
			while (strTokens.hasMoreTokens())
			{
				String temp_test = strTokens.nextToken();
				for(int i=0;i<agg_test_infos.length;i++)
				{
					String testInfo = agg_test_infos[i];
					if (testInfo.indexOf(temp_test) != -1)
					{
						pre_exclude_info.add(testInfo.substring(testInfo.indexOf("#")+1));
						v.add(testInfo);
					}
				}
			}
			for(int i=0;i<excludedInfos.size();i++)
			{
				String exc_info = (String)excludedInfos.get(i);
				if(!pre_exclude_info.contains(exc_info))
				{
					exclude_infos.append(",");
					exclude_infos.append(exc_info);
				}
			}
			if(!v.isEmpty())
			{
				aggregateInfoSync.deleteValues(EgAggregateInfo.testInfoExclude,v);
			}
		}
		Vector vars = new Vector();
		Vector vals = new Vector();
		for(int i=0;i<excludedInfos.size();i++)
		{
			vars.add(test_comp+(String)excludedInfos.get(i));
			vals.add("excluded");
		}
		aggregateInfoSync.setValues(EgAggregateInfo.testInfoExclude,vars,vals,false);
		if(exclude_infos.length() >0)
		{
			auditLogThread.setCurrentValue("Excluded Descriptors",exclude_infos.toString().substring(1));
		}
	}
	else
	{
		String[] agg_test_infos = aggregateInfoSync.getVariables(EgAggregateInfo.testInfoExclude);
		if (agg_test_infos != null)
		{
			Vector v = new Vector();
			StringTokenizer strTokens = new StringTokenizer(test_comp,",");
			while (strTokens.hasMoreTokens())
			{
				String temp_test = strTokens.nextToken();
				for(int i=0;i<agg_test_infos.length;i++)
				{
					if (agg_test_infos[i].indexOf(temp_test) != -1)
					{
						v.add(agg_test_infos[i]);
					}
				}
			}
			if(!v.isEmpty())
			{
				aggregateInfoSync.deleteValues(EgAggregateInfo.testInfoExclude,v);
			}
		}
	}
	auditLogThread.setValue("Description","Include/Exclude Descriptors for "+m_test+" ( "+m_server+" ) for "+m_comp +" has been done");
	auditLogThread.sendItToDB();
	aggregateInfoSync.saveFile();
	EgConfigFilesSync.releaseInstance(aggregateInfoSync);
	rootJson.put("requestStatus","success");
	JSONObject resultMsg = new JSONObject();
	resultMsg.put("title",_mapping.getTextDescription("admin.test.Descriptors"));
	resultMsg.put("message1",_mapping.getTextDescription("admin.test.Descriptors have been configured successfully")+".");
	rootJson.put("result",resultMsg);
	out.println(rootJson.toString());
%>


