/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.commons;

import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Opcodes;
import com.eg.org.objectweb.asm.tree.AbstractInsnNode;
import com.eg.org.objectweb.asm.tree.InsnList;
import com.eg.org.objectweb.asm.tree.InsnNode;
import com.eg.org.objectweb.asm.tree.JumpInsnNode;
import com.eg.org.objectweb.asm.tree.LabelNode;
import com.eg.org.objectweb.asm.tree.LocalVariableNode;
import com.eg.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.eg.org.objectweb.asm.tree.MethodNode;
import com.eg.org.objectweb.asm.tree.TableSwitchInsnNode;
import com.eg.org.objectweb.asm.tree.TryCatchBlockNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSRInlinerAdapter
extends MethodNode
implements Opcodes {
    private final BitSet mainSubroutineInsns = new BitSet();
    private final Map<LabelNode, BitSet> subroutinesInsns = new HashMap<LabelNode, BitSet>();
    final BitSet sharedSubroutineInsns = new BitSet();

    public JSRInlinerAdapter(MethodVisitor methodVisitor, int n, String string, String string2, String string3, String[] stringArray) {
        this(458752, methodVisitor, n, string, string2, string3, stringArray);
        if (this.getClass() != JSRInlinerAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected JSRInlinerAdapter(int n, MethodVisitor methodVisitor, int n2, String string, String string2, String string3, String[] stringArray) {
        super(n, n2, string, string2, string3, stringArray);
        this.mv = methodVisitor;
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        super.visitJumpInsn(n, label);
        LabelNode labelNode = ((JumpInsnNode)this.instructions.getLast()).label;
        if (n == 168 && !this.subroutinesInsns.containsKey(labelNode)) {
            this.subroutinesInsns.put(labelNode, new BitSet());
        }
    }

    @Override
    public void visitEnd() {
        if (!this.subroutinesInsns.isEmpty()) {
            this.findSubroutinesInsns();
            this.emitCode();
        }
        if (this.mv != null) {
            this.accept(this.mv);
        }
    }

    private void findSubroutinesInsns() {
        BitSet bitSet = new BitSet();
        this.findSubroutineInsns(0, this.mainSubroutineInsns, bitSet);
        for (Map.Entry<LabelNode, BitSet> entry : this.subroutinesInsns.entrySet()) {
            LabelNode labelNode = entry.getKey();
            BitSet bitSet2 = entry.getValue();
            this.findSubroutineInsns(this.instructions.indexOf(labelNode), bitSet2, bitSet);
        }
    }

    private void findSubroutineInsns(int n, BitSet bitSet, BitSet bitSet2) {
        boolean bl;
        this.findReachableInsns(n, bitSet, bitSet2);
        do {
            bl = false;
            for (TryCatchBlockNode tryCatchBlockNode : this.tryCatchBlocks) {
                int n2 = this.instructions.indexOf(tryCatchBlockNode.handler);
                if (bitSet.get(n2)) continue;
                int n3 = this.instructions.indexOf(tryCatchBlockNode.start);
                int n4 = this.instructions.indexOf(tryCatchBlockNode.end);
                int n5 = bitSet.nextSetBit(n3);
                if (n5 < n3 || n5 >= n4) continue;
                this.findReachableInsns(n2, bitSet, bitSet2);
                bl = true;
            }
        } while (bl);
    }

    private void findReachableInsns(int n, BitSet bitSet, BitSet bitSet2) {
        for (int i = n; i < this.instructions.size(); ++i) {
            AbstractInsnNode abstractInsnNode;
            if (bitSet.get(i)) {
                return;
            }
            bitSet.set(i);
            if (bitSet2.get(i)) {
                this.sharedSubroutineInsns.set(i);
            }
            bitSet2.set(i);
            AbstractInsnNode abstractInsnNode2 = this.instructions.get(i);
            if (abstractInsnNode2.getType() == 7 && abstractInsnNode2.getOpcode() != 168) {
                abstractInsnNode = (JumpInsnNode)abstractInsnNode2;
                this.findReachableInsns(this.instructions.indexOf(abstractInsnNode.label), bitSet, bitSet2);
            } else if (abstractInsnNode2.getType() == 11) {
                abstractInsnNode = (TableSwitchInsnNode)abstractInsnNode2;
                this.findReachableInsns(this.instructions.indexOf(((TableSwitchInsnNode)abstractInsnNode).dflt), bitSet, bitSet2);
                for (LabelNode labelNode : ((TableSwitchInsnNode)abstractInsnNode).labels) {
                    this.findReachableInsns(this.instructions.indexOf(labelNode), bitSet, bitSet2);
                }
            } else if (abstractInsnNode2.getType() == 12) {
                abstractInsnNode = (LookupSwitchInsnNode)abstractInsnNode2;
                this.findReachableInsns(this.instructions.indexOf(((LookupSwitchInsnNode)abstractInsnNode).dflt), bitSet, bitSet2);
                for (LabelNode labelNode : ((LookupSwitchInsnNode)abstractInsnNode).labels) {
                    this.findReachableInsns(this.instructions.indexOf(labelNode), bitSet, bitSet2);
                }
            }
            switch (this.instructions.get(i).getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
        }
    }

    private void emitCode() {
        LinkedList<Instantiation> linkedList = new LinkedList<Instantiation>();
        linkedList.add(new Instantiation(null, this.mainSubroutineInsns));
        InsnList insnList = new InsnList();
        ArrayList<TryCatchBlockNode> arrayList = new ArrayList<TryCatchBlockNode>();
        ArrayList<LocalVariableNode> arrayList2 = new ArrayList<LocalVariableNode>();
        while (!linkedList.isEmpty()) {
            Instantiation instantiation = (Instantiation)linkedList.removeFirst();
            this.emitInstantiation(instantiation, linkedList, insnList, arrayList, arrayList2);
        }
        this.instructions = insnList;
        this.tryCatchBlocks = arrayList;
        this.localVariables = arrayList2;
    }

    private void emitInstantiation(Instantiation instantiation, List<Instantiation> list, InsnList insnList, List<TryCatchBlockNode> list2, List<LocalVariableNode> list3) {
        Object object;
        Object object2;
        LabelNode labelNode;
        Object object3 = null;
        for (int i = 0; i < this.instructions.size(); ++i) {
            Object object4 = this.instructions.get(i);
            if (((AbstractInsnNode)object4).getType() == 8) {
                labelNode = (LabelNode)object4;
                object2 = instantiation.getClonedLabel(labelNode);
                if (object2 == object3) continue;
                insnList.add((AbstractInsnNode)object2);
                object3 = object2;
                continue;
            }
            if (instantiation.findOwner(i) != instantiation) continue;
            if (((AbstractInsnNode)object4).getOpcode() == 169) {
                labelNode = null;
                object2 = instantiation;
                while (object2 != null) {
                    if (((Instantiation)object2).subroutineInsns.get(i)) {
                        labelNode = ((Instantiation)object2).returnLabel;
                    }
                    object2 = ((Instantiation)object2).parent;
                }
                if (labelNode == null) {
                    throw new IllegalArgumentException("Instruction #" + i + " is a RET not owned by any subroutine");
                }
                insnList.add(new JumpInsnNode(167, labelNode));
                continue;
            }
            if (((AbstractInsnNode)object4).getOpcode() == 168) {
                labelNode = ((JumpInsnNode)object4).label;
                object2 = this.subroutinesInsns.get(labelNode);
                object = new Instantiation(instantiation, (BitSet)object2);
                LabelNode labelNode2 = ((Instantiation)object).getClonedLabelForJumpInsn(labelNode);
                insnList.add(new InsnNode(1));
                insnList.add(new JumpInsnNode(167, labelNode2));
                insnList.add(((Instantiation)object).returnLabel);
                list.add((Instantiation)object);
                continue;
            }
            insnList.add(((AbstractInsnNode)object4).clone(instantiation));
        }
        for (Object object4 : this.tryCatchBlocks) {
            labelNode = instantiation.getClonedLabel(((TryCatchBlockNode)object4).start);
            if (labelNode == (object2 = instantiation.getClonedLabel(((TryCatchBlockNode)object4).end))) continue;
            object = instantiation.getClonedLabelForJumpInsn(((TryCatchBlockNode)object4).handler);
            if (labelNode == null || object2 == null || object == null) {
                throw new AssertionError((Object)"Internal error!");
            }
            list2.add(new TryCatchBlockNode(labelNode, (LabelNode)object2, (LabelNode)object, ((TryCatchBlockNode)object4).type));
        }
        for (Object object4 : this.localVariables) {
            labelNode = instantiation.getClonedLabel(((LocalVariableNode)object4).start);
            if (labelNode == (object2 = instantiation.getClonedLabel(((LocalVariableNode)object4).end))) continue;
            list3.add(new LocalVariableNode(((LocalVariableNode)object4).name, ((LocalVariableNode)object4).desc, ((LocalVariableNode)object4).signature, labelNode, (LabelNode)object2, ((LocalVariableNode)object4).index));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Instantiation
    extends AbstractMap<LabelNode, LabelNode> {
        final Instantiation parent;
        final BitSet subroutineInsns;
        final Map<LabelNode, LabelNode> clonedLabels;
        final LabelNode returnLabel;

        Instantiation(Instantiation instantiation, BitSet bitSet) {
            Object object = instantiation;
            while (object != null) {
                if (((Instantiation)object).subroutineInsns == bitSet) {
                    throw new IllegalArgumentException("Recursive invocation of " + bitSet);
                }
                object = ((Instantiation)object).parent;
            }
            this.parent = instantiation;
            this.subroutineInsns = bitSet;
            this.returnLabel = instantiation == null ? null : new LabelNode();
            this.clonedLabels = new HashMap<LabelNode, LabelNode>();
            object = null;
            for (int i = 0; i < JSRInlinerAdapter.this.instructions.size(); ++i) {
                AbstractInsnNode abstractInsnNode = JSRInlinerAdapter.this.instructions.get(i);
                if (abstractInsnNode.getType() == 8) {
                    LabelNode labelNode = (LabelNode)abstractInsnNode;
                    if (object == null) {
                        object = new LabelNode();
                    }
                    this.clonedLabels.put(labelNode, (LabelNode)object);
                    continue;
                }
                if (this.findOwner(i) != this) continue;
                object = null;
            }
        }

        Instantiation findOwner(int n) {
            if (!this.subroutineInsns.get(n)) {
                return null;
            }
            if (!JSRInlinerAdapter.this.sharedSubroutineInsns.get(n)) {
                return this;
            }
            Instantiation instantiation = this;
            Instantiation instantiation2 = this.parent;
            while (instantiation2 != null) {
                if (instantiation2.subroutineInsns.get(n)) {
                    instantiation = instantiation2;
                }
                instantiation2 = instantiation2.parent;
            }
            return instantiation;
        }

        LabelNode getClonedLabelForJumpInsn(LabelNode labelNode) {
            return this.findOwner((int)JSRInlinerAdapter.this.instructions.indexOf((AbstractInsnNode)labelNode)).clonedLabels.get(labelNode);
        }

        LabelNode getClonedLabel(LabelNode labelNode) {
            return this.clonedLabels.get(labelNode);
        }

        @Override
        public Set<Map.Entry<LabelNode, LabelNode>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LabelNode get(Object object) {
            return this.getClonedLabelForJumpInsn((LabelNode)object);
        }

        @Override
        public boolean equals(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

