/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.commons;

import com.eg.org.objectweb.asm.ConstantDynamic;
import com.eg.org.objectweb.asm.Handle;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Opcodes;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.commons.GeneratorAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AdviceAdapter
extends GeneratorAdapter
implements Opcodes {
    private static final Object UNINITIALIZED_THIS = new Object();
    private static final Object OTHER = new Object();
    private static final String INVALID_OPCODE = "Invalid opcode ";
    protected int methodAccess;
    protected String methodDesc;
    private final boolean isConstructor;
    private boolean superClassConstructorCalled;
    private List<Object> stackFrame;
    private Map<Label, List<Object>> forwardJumpStackFrames;

    protected AdviceAdapter(int n, MethodVisitor methodVisitor, int n2, String string, String string2) {
        super(n, methodVisitor, n2, string, string2);
        this.methodAccess = n2;
        this.methodDesc = string2;
        this.isConstructor = "<init>".equals(string);
    }

    public void visitCode() {
        super.visitCode();
        if (this.isConstructor) {
            this.stackFrame = new ArrayList<Object>();
            this.forwardJumpStackFrames = new HashMap<Label, List<Object>>();
        } else {
            this.onMethodEnter();
        }
    }

    public void visitLabel(Label label) {
        List<Object> list;
        super.visitLabel(label);
        if (this.isConstructor && this.forwardJumpStackFrames != null && (list = this.forwardJumpStackFrames.get(label)) != null) {
            this.stackFrame = list;
            this.superClassConstructorCalled = false;
            this.forwardJumpStackFrames.remove(label);
        }
    }

    public void visitInsn(int n) {
        block23: {
            block22: {
                if (!this.isConstructor || this.superClassConstructorCalled) break block22;
                switch (n) {
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: {
                        throw new IllegalArgumentException("Invalid return in constructor");
                    }
                    case 177: {
                        this.onMethodExit(n);
                        break block23;
                    }
                    case 191: {
                        this.popValue();
                        this.onMethodExit(n);
                        break block23;
                    }
                    case 0: 
                    case 47: 
                    case 49: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 134: 
                    case 138: 
                    case 139: 
                    case 143: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 190: {
                        break block23;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 133: 
                    case 135: 
                    case 140: 
                    case 141: {
                        this.pushValue(OTHER);
                        break block23;
                    }
                    case 9: 
                    case 10: 
                    case 14: 
                    case 15: {
                        this.pushValue(OTHER);
                        this.pushValue(OTHER);
                        break block23;
                    }
                    case 46: 
                    case 48: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 87: 
                    case 96: 
                    case 98: 
                    case 100: 
                    case 102: 
                    case 104: 
                    case 106: 
                    case 108: 
                    case 110: 
                    case 112: 
                    case 114: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 128: 
                    case 130: 
                    case 136: 
                    case 137: 
                    case 142: 
                    case 144: 
                    case 149: 
                    case 150: 
                    case 194: 
                    case 195: {
                        this.popValue();
                        break block23;
                    }
                    case 88: 
                    case 97: 
                    case 99: 
                    case 101: 
                    case 103: 
                    case 105: 
                    case 107: 
                    case 109: 
                    case 111: 
                    case 113: 
                    case 115: 
                    case 127: 
                    case 129: 
                    case 131: {
                        this.popValue();
                        this.popValue();
                        break block23;
                    }
                    case 79: 
                    case 81: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 148: 
                    case 151: 
                    case 152: {
                        this.popValue();
                        this.popValue();
                        this.popValue();
                        break block23;
                    }
                    case 80: 
                    case 82: {
                        this.popValue();
                        this.popValue();
                        this.popValue();
                        this.popValue();
                        break block23;
                    }
                    case 89: {
                        this.pushValue(this.peekValue());
                        break block23;
                    }
                    case 90: {
                        int n2 = this.stackFrame.size();
                        this.stackFrame.add(n2 - 2, this.stackFrame.get(n2 - 1));
                        break block23;
                    }
                    case 91: {
                        int n3 = this.stackFrame.size();
                        this.stackFrame.add(n3 - 3, this.stackFrame.get(n3 - 1));
                        break block23;
                    }
                    case 92: {
                        int n4 = this.stackFrame.size();
                        this.stackFrame.add(n4 - 2, this.stackFrame.get(n4 - 1));
                        this.stackFrame.add(n4 - 2, this.stackFrame.get(n4 - 1));
                        break block23;
                    }
                    case 93: {
                        int n5 = this.stackFrame.size();
                        this.stackFrame.add(n5 - 3, this.stackFrame.get(n5 - 1));
                        this.stackFrame.add(n5 - 3, this.stackFrame.get(n5 - 1));
                        break block23;
                    }
                    case 94: {
                        int n6 = this.stackFrame.size();
                        this.stackFrame.add(n6 - 4, this.stackFrame.get(n6 - 1));
                        this.stackFrame.add(n6 - 4, this.stackFrame.get(n6 - 1));
                        break block23;
                    }
                    case 95: {
                        int n7 = this.stackFrame.size();
                        this.stackFrame.add(n7 - 2, this.stackFrame.get(n7 - 1));
                        this.stackFrame.remove(n7);
                        break block23;
                    }
                    default: {
                        throw new IllegalArgumentException(INVALID_OPCODE + n);
                    }
                }
            }
            switch (n) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    this.onMethodExit(n);
                    break;
                }
            }
        }
        super.visitInsn(n);
    }

    public void visitVarInsn(int n, int n2) {
        super.visitVarInsn(n, n2);
        if (this.isConstructor && !this.superClassConstructorCalled) {
            switch (n) {
                case 21: 
                case 23: {
                    this.pushValue(OTHER);
                    break;
                }
                case 22: 
                case 24: {
                    this.pushValue(OTHER);
                    this.pushValue(OTHER);
                    break;
                }
                case 25: {
                    this.pushValue(n2 == 0 ? UNINITIALIZED_THIS : OTHER);
                    break;
                }
                case 54: 
                case 56: 
                case 58: {
                    this.popValue();
                    break;
                }
                case 55: 
                case 57: {
                    this.popValue();
                    this.popValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(INVALID_OPCODE + n);
                }
            }
        }
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        super.visitFieldInsn(n, string, string2, string3);
        if (this.isConstructor && !this.superClassConstructorCalled) {
            char c = string3.charAt(0);
            boolean bl = c == 'J' || c == 'D';
            switch (n) {
                case 178: {
                    this.pushValue(OTHER);
                    if (!bl) break;
                    this.pushValue(OTHER);
                    break;
                }
                case 179: {
                    this.popValue();
                    if (!bl) break;
                    this.popValue();
                    break;
                }
                case 181: {
                    this.popValue();
                    this.popValue();
                    if (!bl) break;
                    this.popValue();
                    break;
                }
                case 180: {
                    if (!bl) break;
                    this.pushValue(OTHER);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(INVALID_OPCODE + n);
                }
            }
        }
    }

    public void visitIntInsn(int n, int n2) {
        super.visitIntInsn(n, n2);
        if (this.isConstructor && !this.superClassConstructorCalled && n != 188) {
            this.pushValue(OTHER);
        }
    }

    public void visitLdcInsn(Object object) {
        super.visitLdcInsn(object);
        if (this.isConstructor && !this.superClassConstructorCalled) {
            this.pushValue(OTHER);
            if (object instanceof Double || object instanceof Long || object instanceof ConstantDynamic && ((ConstantDynamic)object).getSize() == 2) {
                this.pushValue(OTHER);
            }
        }
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        super.visitMultiANewArrayInsn(string, n);
        if (this.isConstructor && !this.superClassConstructorCalled) {
            for (int i = 0; i < n; ++i) {
                this.popValue();
            }
            this.pushValue(OTHER);
        }
    }

    public void visitTypeInsn(int n, String string) {
        super.visitTypeInsn(n, string);
        if (this.isConstructor && !this.superClassConstructorCalled && n == 187) {
            this.pushValue(OTHER);
        }
    }

    @Deprecated
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        if (this.api >= 327680) {
            super.visitMethodInsn(n, string, string2, string3);
            return;
        }
        this.mv.visitMethodInsn(n, string, string2, string3, n == 185);
        this.doVisitMethodInsn(n, string3);
    }

    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        if (this.api < 327680) {
            super.visitMethodInsn(n, string, string2, string3, bl);
            return;
        }
        this.mv.visitMethodInsn(n, string, string2, string3, bl);
        this.doVisitMethodInsn(n, string3);
    }

    private void doVisitMethodInsn(int n, String string) {
        if (this.isConstructor && !this.superClassConstructorCalled) {
            Object object;
            for (Type type : Type.getArgumentTypes(string)) {
                this.popValue();
                if (type.getSize() != 2) continue;
                this.popValue();
            }
            switch (n) {
                case 182: 
                case 185: {
                    this.popValue();
                    break;
                }
                case 183: {
                    object = this.popValue();
                    if (object != UNINITIALIZED_THIS || this.superClassConstructorCalled) break;
                    this.superClassConstructorCalled = true;
                    this.onMethodEnter();
                    break;
                }
            }
            object = Type.getReturnType(string);
            if (object != Type.VOID_TYPE) {
                this.pushValue(OTHER);
                if (((Type)object).getSize() == 2) {
                    this.pushValue(OTHER);
                }
            }
        }
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        super.visitInvokeDynamicInsn(string, string2, handle, objectArray);
        this.doVisitMethodInsn(186, string2);
    }

    public void visitJumpInsn(int n, Label label) {
        super.visitJumpInsn(n, label);
        if (this.isConstructor && !this.superClassConstructorCalled) {
            switch (n) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    this.popValue();
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    this.popValue();
                    this.popValue();
                    break;
                }
                case 168: {
                    this.pushValue(OTHER);
                    break;
                }
            }
            this.addForwardJump(label);
        }
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        super.visitLookupSwitchInsn(label, nArray, labelArray);
        if (this.isConstructor && !this.superClassConstructorCalled) {
            this.popValue();
            this.addForwardJumps(label, labelArray);
        }
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        super.visitTableSwitchInsn(n, n2, label, labelArray);
        if (this.isConstructor && !this.superClassConstructorCalled) {
            this.popValue();
            this.addForwardJumps(label, labelArray);
        }
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        super.visitTryCatchBlock(label, label2, label3, string);
        if (this.isConstructor && !this.forwardJumpStackFrames.containsKey(label3)) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(OTHER);
            this.forwardJumpStackFrames.put(label3, arrayList);
        }
    }

    private void addForwardJumps(Label label, Label[] labelArray) {
        this.addForwardJump(label);
        for (Label label2 : labelArray) {
            this.addForwardJump(label2);
        }
    }

    private void addForwardJump(Label label) {
        if (this.forwardJumpStackFrames.containsKey(label)) {
            return;
        }
        this.forwardJumpStackFrames.put(label, new ArrayList<Object>(this.stackFrame));
    }

    private Object popValue() {
        return this.stackFrame.remove(this.stackFrame.size() - 1);
    }

    private Object peekValue() {
        return this.stackFrame.get(this.stackFrame.size() - 1);
    }

    private void pushValue(Object object) {
        this.stackFrame.add(object);
    }

    protected void onMethodEnter() {
    }

    protected void onMethodExit(int n) {
    }
}

