/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jvmmonitor;

import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.JVMConfig;
import com.eg.jtm.PropsManager;
import com.eg.jtm.ThreadPoolManager;
import com.eg.jvmmonitor.JVMMetricData;
import com.eg.jvmmonitor.JVMMetricPoller;
import com.eg.jvmmonitor.utils.JVMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class JVMMetricsManager
implements Runnable {
    final ArrayList<String> jvmTestList = new ArrayList();
    final Hashtable testTimeMappingTable = new Hashtable();
    private static boolean isPlatFormMbeanInitialized = false;

    public JVMMetricsManager() {
    }

    public JVMMetricsManager(String string) {
        JVMConfig.setJvmCollectorThreadRunning(true);
        String string2 = JVMConfig.getJvm_Tests();
        if (string2 != null && !string2.equalsIgnoreCase("none") && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            long l = System.currentTimeMillis();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                this.jvmTestList.add(string3);
                this.testTimeMappingTable.put(string3, l);
            }
            this.startThread();
        } else {
            this.jvmTestList.clear();
            this.testTimeMappingTable.clear();
        }
    }

    private void startThread() {
        Thread thread = new Thread(this);
        thread.setName("eGJvmMetricCollectorThread");
        thread.setDaemon(true);
        thread.start();
        BTMLog.logger.debug("[eGJvmMetricCollectorThread] started successfully !!!");
    }

    public void run() {
        while (!isPlatFormMbeanInitialized) {
            try {
                isPlatFormMbeanInitialized = JVMUtils.isPlatFormMbeanInitialized();
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                isPlatFormMbeanInitialized = false;
            }
        }
        BTMLog.logger.debug("[eGJvmMetricCollectorThread] can access Platform MBean Server and Platform MXBeans with out any issues !!!");
        while (true) {
            try {
                boolean bl = JVMConfig.isJarModeEnabled();
                boolean bl2 = BTMOffLoadConfig.isDataCollectionMode();
                if (!PropsManager.isOldModel() && BTMOffLoadConfig.isOKToSendOffloadData() && bl && bl2) {
                    this.pullJVMMeticData();
                } else if (this.suspendThread()) {
                    break;
                }
            }
            catch (Throwable throwable) {
                BTMLog.logger.warn("[eGJvmMetricCollectorThread] Exception occured while runnning the thread {}", throwable);
            }
            this.sleep(10000L);
        }
    }

    private boolean suspendThread() {
        int n;
        int n2 = 12;
        long l = 300000L;
        for (n = 0; n < n2; ++n) {
            this.sleep(l);
            if (!PropsManager.isOldModel() && BTMOffLoadConfig.isOKToSendOffloadData() && JVMConfig.isJarModeEnabled()) break;
        }
        if (n == n2) {
            JVMConfig.setJvmCollectorThreadRunning(false);
            return true;
        }
        return false;
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void pullJVMMeticData() {
        Hashtable<String, Boolean> hashtable = JVMConfig.getTestMappingTable();
        for (int i = 0; i < this.jvmTestList.size(); ++i) {
            boolean bl;
            boolean bl2;
            String string = this.jvmTestList.get(i);
            if (!hashtable.containsKey(string) || !(bl2 = hashtable.get(string).booleanValue()) || !(bl = this.scheduleNextTestPeriod(string))) continue;
            this.collectMetrics(string);
        }
    }

    private void collectMetrics(String string) {
        JVMMetricPoller jVMMetricPoller = new JVMMetricPoller(string);
        ArrayList arrayList = jVMMetricPoller.getMetrics();
        if (arrayList != null) {
            BTMLog.logger.trace("[eGJvmMetricCollectorThread] Metrics collected  for the entity : {}  Results : {}", (Object)string, (Object)arrayList.size());
        }
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        hashtable.put(string, arrayList);
        BTMLog.logger.debug("[eGJvmMetricCollectorThread] Collected metrics are going to put in the queue for the entity : {}", (Object)string);
        this.sendDataToQueue(hashtable);
        this.sleep(2500L);
    }

    private void sendDataToQueue(Hashtable hashtable) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("JvmGUID", PropsManager.getJvmGUID());
        hashMap.put("JVM", hashtable);
        JVMMetricData jVMMetricData = new JVMMetricData();
        jVMMetricData.setProperties(hashMap);
        try {
            ThreadPoolManager threadPoolManager = ThreadPoolManager.getThreadPoolManager();
            threadPoolManager.submitTask(jVMMetricData);
            BTMLog.logger.debug("[eGJvmMetricCollectorThread] JVMMetricData object added into the queue & current queue size is {}", (Object)threadPoolManager.getQueueSize());
        }
        catch (Exception exception) {
            BTMLog.logger.error("[eGJvmMetricCollectorThread] JVMMetricData object not added into the queue due to {}", exception);
        }
    }

    private boolean scheduleNextTestPeriod(String string) {
        long l;
        boolean bl = false;
        Hashtable<String, Long> hashtable = JVMConfig.getTestTimeMappingTable();
        long l2 = (Long)this.testTimeMappingTable.get(string);
        if (l2 > 0L && (l = System.currentTimeMillis()) >= l2) {
            bl = true;
            long l3 = hashtable.get(string);
            BTMLog.logger.trace("[eGJvmMetricCollectorThread] Scheduling the next test run period for entity : {} testFrequency : {} ", (Object)string, (Object)l3);
            long l4 = l + l3;
            this.testTimeMappingTable.put(string, l4);
        }
        return bl;
    }
}

