/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.discovery;

import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.discovery.AutoDiscovery;

public class WebsphereDiscovery
extends Thread {
    public boolean isPlatFormMbeanInitialized = false;

    public void run() {
        long l = BTMOffLoadConfig.getDiscoveryMaxWaitTime() - 60000L;
        long l2 = 0L;
        if (this.validateUsingSystemProperty()) {
            while (!this.isPlatFormMbeanInitialized) {
                try {
                    this.isPlatFormMbeanInitialized = AutoDiscovery.isPlatFormMbeanInitilized();
                    BTMLog.logger.info("connection to Platform MBean Server and Platform MXBeans is not initialized waiting, wait time : {}", (Object)l2);
                    if (l2 >= l) {
                        BTMLog.logger.info("time out for Platform MBean Server and Platform MXBeans connection...");
                        break;
                    }
                    BTMLog.logger.info("connection to Platform MBean Server and Platform MXBeans is not initialized waiting, wait time : {}", (Object)(l2 += 10000L));
                    AutoDiscovery.waitTime(10000L);
                }
                catch (Exception exception) {
                    this.isPlatFormMbeanInitialized = false;
                }
            }
            if (AutoDiscovery.getmServerConnection() != null) {
                BTMLog.logger.trace("connection to Platform MBean Server and Platform MXBeans is initialized collecting details...");
                if (this.validateUsingMBeanServer()) {
                    AutoDiscovery.setServerName("WebSphere_server");
                    AutoDiscovery.setStausOfClassNameDiscovery(true);
                }
            }
        }
    }

    private boolean validateUsingMBeanServer() {
        boolean bl = false;
        try {
            String[] stringArray = AutoDiscovery.getmServerConnection().getDomains();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase("websphere")) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("exception while checking Platform MBean Server and Platform MXBeans Jboss {} ", exception);
        }
        return bl;
    }

    private boolean validateUsingSystemProperty() {
        if (AutoDiscovery.isSystemPropertyKeyAvailable("was.install.root") || AutoDiscovery.isSystemPropertyKeyAvailable("com.ibm.cpu.endian") || AutoDiscovery.isSystemPropertyKeyAvailable("com.ibm.security.jgss.debug") || AutoDiscovery.isSystemPropertyKeyAvailable("derby.system.home") || AutoDiscovery.isSystemPropertyKeyAvailable("com.ibm.jcl.checkClassPath") || AutoDiscovery.isSystemPropertyKeyAvailable("com.ibm.security.krb5.Krb5Debug") || AutoDiscovery.isSystemPropertyKeyAvailable("com.ibm.oti.vm.bootstrap.library.path") || AutoDiscovery.isSystemPropertyKeyAvailable("ibm.websphere.internalClassAccessMode") || AutoDiscovery.isSystemPropertyKeyAvailable("com.ibm.util.extralibs.properties") || AutoDiscovery.isSystemPropertyKeyAvailable("com.ibm.vm.bitmode") || AutoDiscovery.isSystemPropertyKeyAvailable("com.ibm.oti.configuration") || AutoDiscovery.isSystemPropertyKeyAvailable("osgi.configuration.area")) {
            String string = System.getProperty("sun.java.command");
            if (string.indexOf("com.ibm.wsspi.bootstrap.WSPreLauncher") > -1 || string.indexOf("com.ibm.ws.bootstrap.WSLauncher") > -1 || string.indexOf("com.ibm.ws.runtime.WsServer") > -1) {
                AutoDiscovery.setServerName("WebSphere_server");
            }
            return true;
        }
        return false;
    }
}

