/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMDiscovery;
import com.eg.jtm.BTMLog;
import com.eg.jtm.PlatformThreadMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class ThreadDiagnosis {
    private static boolean trackThreadCpuTime = false;
    private static boolean trackThreadBlockedWaitedTime = false;
    private long blocked_time_begin = -5L;
    private long blocked_time_end = -5L;
    private long waited_time_begin = -5L;
    private long waited_time_end = -5L;
    private long cpu_time_begin = -5L;
    private long cpu_time_end = -5L;
    private long cpu_time = -5L;
    private long blocked_time = -5L;
    private long waited_time = -5L;
    private long currentThreadId = -1L;
    private static boolean cpuTimeNotSupported = false;
    private static boolean blockedWaitedTimeNotSupported = false;

    public ThreadDiagnosis() {
        try {
            this.currentThreadId = Thread.currentThread().getId();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isThreadContentionEnabled() {
        return trackThreadBlockedWaitedTime;
    }

    public static void setTrackThreadBlockedWaitedTime(String string) {
        if (string != null && string.length() > 0) {
            trackThreadBlockedWaitedTime = string.equalsIgnoreCase("true");
        }
    }

    public static boolean isTrackThreadCpuTime() {
        return trackThreadCpuTime;
    }

    public static void setTrackThreadCpuTime(String string) {
        if (string != null && string.length() > 0) {
            trackThreadCpuTime = string.equalsIgnoreCase("true");
        }
    }

    public long getCPUTime() {
        if (this.cpu_time_end > -1L && this.cpu_time_begin > -1L) {
            this.cpu_time = (this.cpu_time_end - this.cpu_time_begin) / 1000000L;
        }
        return this.cpu_time;
    }

    public long getBlockedTime() {
        if (this.blocked_time_end > -1L && this.blocked_time_begin > -1L) {
            this.blocked_time = this.blocked_time_end - this.blocked_time_begin;
        }
        return this.blocked_time;
    }

    public long getWaitedTime() {
        if (this.waited_time_end > -1L && this.waited_time_begin > -1L) {
            this.waited_time = this.waited_time_end - this.waited_time_begin;
        }
        return this.waited_time;
    }

    public void recordTimings(boolean bl) {
        ThreadMXBean threadMXBean = PlatformThreadMXBean.getInstance();
        this.recordCPUTime(bl, threadMXBean);
        this.recordContentionMonitoringTimings(bl, threadMXBean);
    }

    private void recordCPUTime(boolean bl, ThreadMXBean threadMXBean) {
        if (cpuTimeNotSupported) {
            this.cpu_time = -100L;
            return;
        }
        if (trackThreadCpuTime) {
            try {
                if (!threadMXBean.isThreadCpuTimeEnabled()) {
                    threadMXBean.setThreadCpuTimeEnabled(true);
                }
                if (bl) {
                    this.cpu_time_begin = threadMXBean.getThreadCpuTime(this.currentThreadId);
                } else {
                    this.cpu_time_end = threadMXBean.getThreadCpuTime(this.currentThreadId);
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception occured while tracking Thread CPU Time {} ", exception);
            }
        }
    }

    private void recordContentionMonitoringTimings(boolean bl, ThreadMXBean threadMXBean) {
        if (blockedWaitedTimeNotSupported) {
            this.blocked_time = -100L;
            this.waited_time = -100L;
            return;
        }
        if (trackThreadBlockedWaitedTime) {
            try {
                ThreadInfo threadInfo;
                if (!threadMXBean.isThreadContentionMonitoringEnabled()) {
                    threadMXBean.setThreadContentionMonitoringEnabled(true);
                }
                if ((threadInfo = threadMXBean.getThreadInfo(this.currentThreadId)) != null) {
                    if (bl) {
                        this.blocked_time_begin = threadInfo.getBlockedTime();
                        this.waited_time_begin = threadInfo.getWaitedTime();
                    } else {
                        this.blocked_time_end = threadInfo.getBlockedTime();
                        this.waited_time_end = threadInfo.getWaitedTime();
                    }
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception occured while tracking ThreadContentionMonitoring {}", exception);
            }
        }
    }

    static {
        ThreadMXBean threadMXBean = PlatformThreadMXBean.getInstance();
        if (!threadMXBean.isThreadCpuTimeSupported()) {
            cpuTimeNotSupported = true;
            BTMDiscovery.getDataBaseHT().put("cpuTimeNotSupported", "true");
        }
        if (!threadMXBean.isThreadContentionMonitoringSupported()) {
            blockedWaitedTimeNotSupported = true;
            BTMDiscovery.getDataBaseHT().put("blockedWaitedTimeNotSupported", "true");
        }
    }
}

