/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.PropsManager;
import com.eg.jtm.SnapshotTaker;
import com.eg.jtm.UPDManager;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class SnapshotManager {
    static Timer SSTimer;
    static SnapshotTaker ST;
    static int numUnreadSnapshots;
    private static boolean AGENT_REACHABLE;
    private static Date lastContactDateTime;
    private static final int snapshotPeriod = 30000;
    private static boolean initial;
    private static int MAX_UNREAD_LOSTCONN;
    private static int MAX_UNREAD_AGTNA;

    public static void incrSnapshotCtr() {
        if (SnapshotManager.isAgentReachable()) {
            if (++numUnreadSnapshots >= MAX_UNREAD_AGTNA) {
                SnapshotManager.resetIsAgentReachable();
                PropsManager.setTalkingToAgent(false);
                BTMLog.logger.warn("!!! AGENT NOT REACHABLE. SWITCHING OFF MONITORING !!!");
                UPDManager.clearStoredData();
            } else if (PropsManager.isTalkingToAgent() && numUnreadSnapshots >= MAX_UNREAD_LOSTCONN) {
                long l = numUnreadSnapshots * 30000;
                long l2 = MAX_UNREAD_AGTNA * 30000;
                long l3 = l2 - l;
                BTMLog.logger.warn("*** Looks like the eG agent is running slow & if it continues , after {} millisecond BTM Monitoring will be switched OFF !!!", (Object)l3);
            }
        } else {
            BTMLog.logger.warn("eG Agent is not reachable from {}", (Object)lastContactDateTime);
        }
    }

    private static void assignValues(long l) {
        if (l >= 30000L) {
            numUnreadSnapshots = (int)(l / 30000L);
            MAX_UNREAD_LOSTCONN = numUnreadSnapshots + 5;
            MAX_UNREAD_AGTNA = numUnreadSnapshots + 10;
        } else {
            numUnreadSnapshots = (int)l;
            MAX_UNREAD_LOSTCONN = numUnreadSnapshots + 2;
            MAX_UNREAD_AGTNA = numUnreadSnapshots + 5;
        }
        if (initial) {
            BTMLog.logger.info(" Since measure period has changed , following shapshot attributes are reassigned!!!");
        } else {
            BTMLog.logger.info("Initialized the following shapshot attributes !!!");
            initial = true;
        }
        BTMLog.logger.info(" numUnreadSnapshots   : {} ", (Object)numUnreadSnapshots);
        BTMLog.logger.info(" MAX_UNREAD_LOSTCONN  : {} ", (Object)MAX_UNREAD_LOSTCONN);
        BTMLog.logger.info(" MAX_UNREAD_AGTNA     : {}", (Object)MAX_UNREAD_AGTNA);
    }

    public static void resetSnapshotCtr() {
        PropsManager.setTalkingToAgent(true);
        numUnreadSnapshots = 0;
        SnapshotManager.setIsAgentReachable();
    }

    public static void scheduleSnapshotTaker() {
        try {
            if (SSTimer != null) {
                SSTimer.cancel();
                SSTimer = null;
            }
            if (ST != null) {
                ST.cancel();
                ST = null;
            }
            SSTimer = new Timer("SnapshotTaker", true);
            ST = new SnapshotTaker();
            SSTimer.schedule((TimerTask)ST, 60000L, 30000L);
            BTMLog.logger.info("Scheduled snapshot timer with a period of \"30000\" milliseconds.");
            SnapshotManager.assignValues(PropsManager.getEgMeasPeriod());
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception in scheduleSnapshotTaker {} ", exception);
        }
    }

    static void stopSnapshotTaker() {
        SSTimer.cancel();
        ST.cancel();
        BTMLog.logger.info("Snapshot taker stopped.");
    }

    private static void setIsAgentReachable() {
        BTMLog.logger.info("*** Agent is Reachable ***");
        AGENT_REACHABLE = true;
        lastContactDateTime = null;
    }

    private static void resetIsAgentReachable() {
        BTMLog.logger.info("*** Agent is NOT reachable***");
        AGENT_REACHABLE = false;
        lastContactDateTime = new Date();
    }

    public static boolean isAgentReachable() {
        return AGENT_REACHABLE;
    }

    public static long getSnapshotPeriod() {
        return 30000L;
    }

    static {
        numUnreadSnapshots = 3;
        AGENT_REACHABLE = false;
        SnapshotManager.resetIsAgentReachable();
        AGENT_REACHABLE = true;
        lastContactDateTime = null;
        initial = false;
        MAX_UNREAD_LOSTCONN = 5;
        MAX_UNREAD_AGTNA = 10;
    }
}

