/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.OffLoadAgentCheck;
import com.eg.jtm.PropsManager;
import com.eg.jtm.STATUS;
import com.eg.jtm.ThreadPoolManager;

public final class OffLoadAgentInfiniteCheck
implements Runnable {
    private static OffLoadAgentInfiniteCheck offloadAgentInfiniteCheckInstance;
    private STATUS checkStatus = STATUS.NONE;
    private boolean isFirstTime = false;

    private OffLoadAgentInfiniteCheck() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OffLoadAgentInfiniteCheck getInstance() {
        if (offloadAgentInfiniteCheckInstance != null) return offloadAgentInfiniteCheckInstance;
        Class<OffLoadAgentInfiniteCheck> clazz = OffLoadAgentInfiniteCheck.class;
        synchronized (OffLoadAgentInfiniteCheck.class) {
            if (offloadAgentInfiniteCheckInstance != null) return offloadAgentInfiniteCheckInstance;
            offloadAgentInfiniteCheckInstance = new OffLoadAgentInfiniteCheck();
            // ** MonitorExit[var0] (shouldn't be in output)
            return offloadAgentInfiniteCheckInstance;
        }
    }

    public STATUS getCheckStatus() {
        return this.checkStatus;
    }

    public void setCheckStatus(STATUS sTATUS) {
        this.checkStatus = sTATUS;
    }

    public void run() {
        String string = "[" + Thread.currentThread().getName() + "]";
        if (this.checkStatus == STATUS.DISCOVERY) {
            this.initiateDiscoveryCheck(string);
            this.checkStatus = STATUS.NONE;
        } else if (this.checkStatus == STATUS.OFFLOAD) {
            this.initializeOffloadCheck(string);
            this.checkStatus = STATUS.NONE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeOffloadCheck(String string) {
        int n = 1;
        this.isFirstTime = true;
        long l = 20000L;
        long l2 = 180000L;
        while (!BTMOffLoadConfig.isNodeIDValidatedWithAgent()) {
            try {
                BTMLog.logger.trace("{}  Is this JVMGUID / NodeID validated by eG Agent? {} ", (Object)string, (Object)BTMOffLoadConfig.isNodeIDValidatedWithAgent());
                OffLoadAgentCheck offLoadAgentCheck = OffLoadAgentCheck.getInstance();
                if (offLoadAgentCheck.getCheckStatus().isStatusNone()) {
                    offLoadAgentCheck.setCheckStatus(STATUS.OFFLOAD);
                    Thread thread = new Thread((Runnable)offLoadAgentCheck, "OFFLoad_PortNo_Finder_" + n);
                    thread.setDaemon(true);
                    thread.start();
                    ++n;
                }
            }
            catch (Exception exception) {
                BTMOffLoadConfig.resetThisOffloadAgent();
                BTMLog.logger.warn(string + "Exception while trying to find OFFLoad Port No. of eG Agent. ", exception);
            }
            finally {
                this.clearQueue(string, 500, "agent not reachable");
                if (n > 3) {
                    BTMLog.logger.warn("{} eG Agent not reachable for couple of attempts. So, going to clear collected data.!!!", (Object)string);
                    ThreadPoolManager.getThreadPoolManager().clearData();
                    PropsManager.setTalkingToAgent(false);
                    BTMOffLoadConfig.setFlagToSendOffloadData(false);
                    BTMLog.logger.warn("{} eG Java BTM cleared collected data from the queue.!!!", (Object)string);
                    n = 1;
                }
            }
            if (this.isFirstTime) {
                try {
                    BTMLog.logger.info("{} eG Java BTM will try to find the OFFLoad port after 20 seconds.!!!", (Object)string);
                    Thread.sleep(l);
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("{} Unable to do sleep {}", (Object)string, (Object)exception);
                }
                this.isFirstTime = false;
                continue;
            }
            if (BTMOffLoadConfig.isThisOffloadAgent()) continue;
            try {
                if (n > 2) {
                    // empty if block
                }
                BTMLog.logger.info("{} eG Java BTM will try to find the OFFLoad port after 3 minutes.!!! ", (Object)string);
                Thread.sleep(l2);
            }
            catch (Exception exception) {
                BTMLog.logger.warn("{} Unable to do sleep {} ", (Object)string, (Object)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateDiscoveryCheck(String string) {
        int n = 1;
        this.isFirstTime = true;
        long l = 15000L;
        long l2 = 60000L;
        while (!BTMOffLoadConfig.isValidComponentIDAssigned()) {
            try {
                OffLoadAgentCheck offLoadAgentCheck = OffLoadAgentCheck.getInstance();
                if (!offLoadAgentCheck.getCheckStatus().isStatusNone()) continue;
                offLoadAgentCheck.setCheckStatus(STATUS.DISCOVERY);
                Thread thread = new Thread((Runnable)offLoadAgentCheck, "Discovery_Checker_" + n);
                thread.setDaemon(true);
                thread.start();
                ++n;
            }
            catch (Exception exception) {
                BTMOffLoadConfig.resetThisComponentManaged();
                BTMLog.logger.warn("{} Exception in Contacting agent {}", (Object)string, (Object)exception);
            }
            finally {
                this.clearQueue(string, 50, "this JVM waiting to be monitored[Auto-managed] by eG Manager");
                if (this.isFirstTime) {
                    try {
                        BTMLog.logger.info("{}  Infinite Discovery check : Waiting for 15 secs and will retry  ", (Object)string);
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        BTMLog.logger.warn("{}  Unable to do sleep {} ", (Object)string, (Object)interruptedException);
                    }
                    this.isFirstTime = false;
                    continue;
                }
                if (BTMOffLoadConfig.isValidComponentIDAssigned()) continue;
                try {
                    BTMLog.logger.info("{} Infinite Discovery check : Waiting for 1 minute and will retry  ", (Object)string);
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    BTMLog.logger.warn("{} Unable to do sleep {}", (Object)string, (Object)interruptedException);
                }
            }
        }
    }

    private void clearQueue(String string, int n, String string2) {
        int n2 = ThreadPoolManager.getThreadPoolManager().getQueueSize();
        BTMLog.logger.debug("{} eG BTM Queue : Current size {} ", (Object)string, (Object)n2);
        if (n2 >= n) {
            BTMLog.logger.warn("{} eG BTM Queue size reached maximum threshold size of [{}] while {}. To avoid overhead, going to clear collected data.!!!", string, n, string2);
            ThreadPoolManager.getThreadPoolManager().clearData();
            BTMLog.logger.warn("{} eG Java BTM cleared collected data from the queue.!!! Cleared count is {}", (Object)string, (Object)n2);
        }
    }
}

