/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.ch.qos.logback.classic.AsyncAppender;
import com.eg.ch.qos.logback.classic.Level;
import com.eg.ch.qos.logback.classic.Logger;
import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import com.eg.ch.qos.logback.core.rolling.RollingFileAppender;
import com.eg.ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import com.eg.ch.qos.logback.core.util.FileSize;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.org.slf4j.LoggerFactory;

public class LogbackFileUtils {
    public static final String BTMLogger = "BTMLog";
    public static final String BTMDebugLogger = "BTMDebug";
    private static boolean BTMLoggerInitialized = false;
    private static boolean BTMDebugLoggerInitialized = false;
    private static AsyncAppender btmAsyncAppender;
    private static AsyncAppender btmDebugAsyncAppender;
    private static String btmLogFileName;
    private static String btmLogFolderName;
    private static Level btmLogLevel;
    private static int btmLogFileMaxCount;
    private static int btmLogFileLimit;
    private static String btmLogHomeFolder;
    private static int asyncQueueSize;
    private static int discardThresholdLimit;
    private static Level btmDebugLogLevel;
    private static int btmDebugLogFileMaxCount;
    private static int btmDebugLogFileLimit;
    private static final String btmDebugLogFileName = "BTMDebug.log";

    private static void initBTMLogger(String string) {
        btmLogFolderName = BTMOffLoadConfig.getBtmLogFolderName(true);
        if (!BTMLoggerInitialized) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            RollingFileAppender<ILoggingEvent> rollingFileAppender = new RollingFileAppender<ILoggingEvent>();
            rollingFileAppender.setContext(loggerContext);
            rollingFileAppender.setFile(string + btmLogFolderName + btmLogFileName);
            FixedWindowRollingPolicy fixedWindowRollingPolicy = new FixedWindowRollingPolicy();
            fixedWindowRollingPolicy.setContext(loggerContext);
            fixedWindowRollingPolicy.setFileNamePattern(string + btmLogFolderName + BTMLogger + "-%i.log");
            fixedWindowRollingPolicy.setMinIndex(1);
            fixedWindowRollingPolicy.setMaxIndex(btmLogFileMaxCount);
            fixedWindowRollingPolicy.setParent(rollingFileAppender);
            fixedWindowRollingPolicy.start();
            SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = new SizeBasedTriggeringPolicy();
            FileSize fileSize = FileSize.valueOf(btmLogFileLimit + "MB");
            sizeBasedTriggeringPolicy.setMaxFileSize(fileSize);
            sizeBasedTriggeringPolicy.start();
            PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
            patternLayoutEncoder.setContext(loggerContext);
            patternLayoutEncoder.setPattern("%date %-5level - %msg%n");
            patternLayoutEncoder.start();
            rollingFileAppender.setEncoder(patternLayoutEncoder);
            rollingFileAppender.setRollingPolicy(fixedWindowRollingPolicy);
            rollingFileAppender.setTriggeringPolicy(sizeBasedTriggeringPolicy);
            rollingFileAppender.start();
            btmAsyncAppender = new AsyncAppender();
            btmAsyncAppender.setContext(loggerContext);
            btmAsyncAppender.setName("BTMAsync");
            btmAsyncAppender.addAppender(rollingFileAppender);
            btmAsyncAppender.setDiscardingThreshold(discardThresholdLimit);
            btmAsyncAppender.setQueueSize(asyncQueueSize);
            btmAsyncAppender.start();
            Logger logger = loggerContext.getLogger(BTMLogger);
            logger.addAppender(btmAsyncAppender);
            logger.setLevel(btmLogLevel);
            logger.setAdditive(true);
            BTMLoggerInitialized = true;
            btmLogHomeFolder = string;
        }
    }

    public static void reInitializeBTMLogger() {
        if (BTMLoggerInitialized) {
            BTMLoggerInitialized = false;
            LogbackFileUtils.stop();
            LogbackFileUtils.initBTMLogger(btmLogHomeFolder);
        }
    }

    public static void reInitializeBTMDebugLogger() {
        if (BTMDebugLoggerInitialized) {
            BTMDebugLoggerInitialized = false;
            LogbackFileUtils.stop();
            LogbackFileUtils.initBTMDebugLogger(btmLogHomeFolder);
        }
    }

    public static void setBTMDebugLogbackLevel(Level level) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = loggerContext.getLogger(BTMDebugLogger);
        LogbackFileUtils.setBtmDebugLogLevel(level);
        logger.setLevel(level);
        BTMLog.logger.debug("BTMDebugLogger Log Level is  : {} ", (Object)level.toString());
    }

    public static void setBTMLogbackLevel(Level level) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = loggerContext.getLogger(BTMLogger);
        LogbackFileUtils.setBtmLogLevel(level);
        logger.setLevel(level);
        BTMLog.logger.debug("BTMLogger Log Level is  : {} ", (Object)level.toString());
    }

    private static void initBTMDebugLogger(String string) {
        if (!BTMDebugLoggerInitialized) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            RollingFileAppender<ILoggingEvent> rollingFileAppender = new RollingFileAppender<ILoggingEvent>();
            rollingFileAppender.setContext(loggerContext);
            rollingFileAppender.setFile(string + btmLogFolderName + btmDebugLogFileName);
            FixedWindowRollingPolicy fixedWindowRollingPolicy = new FixedWindowRollingPolicy();
            fixedWindowRollingPolicy.setContext(loggerContext);
            fixedWindowRollingPolicy.setFileNamePattern(string + btmLogFolderName + BTMDebugLogger + "-%i.log");
            fixedWindowRollingPolicy.setMinIndex(1);
            fixedWindowRollingPolicy.setMaxIndex(btmDebugLogFileMaxCount);
            fixedWindowRollingPolicy.setParent(rollingFileAppender);
            fixedWindowRollingPolicy.start();
            SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = new SizeBasedTriggeringPolicy();
            FileSize fileSize = FileSize.valueOf(btmDebugLogFileLimit + "MB");
            sizeBasedTriggeringPolicy.setMaxFileSize(fileSize);
            sizeBasedTriggeringPolicy.start();
            PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
            patternLayoutEncoder.setContext(loggerContext);
            patternLayoutEncoder.setPattern("%date %-5level - %msg%n");
            patternLayoutEncoder.start();
            rollingFileAppender.setEncoder(patternLayoutEncoder);
            rollingFileAppender.setRollingPolicy(fixedWindowRollingPolicy);
            rollingFileAppender.setTriggeringPolicy(sizeBasedTriggeringPolicy);
            rollingFileAppender.start();
            btmDebugAsyncAppender = new AsyncAppender();
            btmDebugAsyncAppender.setContext(loggerContext);
            btmDebugAsyncAppender.setName("BTMDebugAsync");
            btmDebugAsyncAppender.addAppender(rollingFileAppender);
            btmDebugAsyncAppender.setDiscardingThreshold(discardThresholdLimit);
            btmDebugAsyncAppender.setQueueSize(asyncQueueSize);
            btmDebugAsyncAppender.start();
            Logger logger = loggerContext.getLogger(BTMDebugLogger);
            logger.addAppender(btmDebugAsyncAppender);
            logger.setLevel(btmDebugLogLevel);
            logger.setAdditive(true);
            BTMDebugLoggerInitialized = true;
        }
    }

    public static void reset() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.reset();
    }

    public static void start(String string) {
        LogbackFileUtils.stop();
        LogbackFileUtils.initBTMLogger(string);
    }

    public static void startDebug(String string) {
        LogbackFileUtils.stopDebug();
        LogbackFileUtils.initBTMDebugLogger(string);
    }

    private static void stop() {
        if (btmAsyncAppender != null && btmAsyncAppender.isStarted()) {
            btmAsyncAppender.stop();
        }
    }

    private static void stopDebug() {
        if (btmDebugAsyncAppender != null && btmDebugAsyncAppender.isStarted()) {
            btmDebugAsyncAppender.stop();
        }
    }

    public static String getBtmLogFileName() {
        return btmLogFileName;
    }

    public static void setBtmLogFileName(String string) {
        btmLogFileName = string;
    }

    public static Level getBtmLogLevel() {
        return btmLogLevel;
    }

    public static void setBtmLogLevel(Level level) {
        btmLogLevel = level;
    }

    public static int getBtmLogFileMaxCount() {
        return btmLogFileMaxCount;
    }

    public static void setBtmLogFileMaxCount(int n) {
        btmLogFileMaxCount = n;
    }

    public static int getBtmLogFileLimit() {
        return btmLogFileLimit;
    }

    public static void setBtmLogFileLimit(int n) {
        btmLogFileLimit = n;
    }

    public static Level getBtmDebugLogLevel() {
        return btmDebugLogLevel;
    }

    public static void setBtmDebugLogLevel(Level level) {
        btmDebugLogLevel = level;
    }

    public static int getBtmDebugLogFileMaxCount() {
        return btmDebugLogFileMaxCount;
    }

    public static void setBtmDebugLogFileMaxCount(int n) {
        btmDebugLogFileMaxCount = n;
    }

    public static int getBtmDebugLogFileLimit() {
        return btmDebugLogFileLimit;
    }

    public static void setBtmDebugLogFileLimit(int n) {
        btmDebugLogFileLimit = n;
    }

    static void setAsyncQueueSize(int n) {
        asyncQueueSize = n;
    }

    static void setDiscardThreshold(int n) {
        discardThresholdLimit = n;
    }

    static int getQsize() {
        return asyncQueueSize;
    }

    static int getThreshold() {
        return discardThresholdLimit;
    }

    public static void printDetails() {
        int n;
        int n2;
        int n3;
        if (btmAsyncAppender != null) {
            n3 = btmAsyncAppender.getNumberOfElementsInQueue();
            n2 = btmAsyncAppender.getRemainingCapacity();
            n = btmAsyncAppender.getQueueSize();
            System.out.println(" asyncAppender Details :" + n + " " + n3 + "  " + n2);
        } else {
            System.out.println(" asyncAppender is NULL ");
        }
        if (btmDebugAsyncAppender != null) {
            n3 = btmDebugAsyncAppender.getNumberOfElementsInQueue();
            n2 = btmDebugAsyncAppender.getRemainingCapacity();
            n = btmDebugAsyncAppender.getQueueSize();
            System.out.println(" asyncAppender Details :" + n + " " + n3 + "  " + n2);
        } else {
            System.out.println(" asyncAppender is NULL ");
        }
    }

    static {
        btmLogFolderName = BTMConstants.btmLogFolderName;
    }
}

