/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.ACTION;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.ContainerDiscovery;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class LogCleanUp {
    private static final String LOG_HEADER = "[eG BTM Log Folder Clean-up] ";
    private static final long cleanUpThreshold = 43200000L;
    private static LogCleanUpCode cleanUpCode = LogCleanUpCode.NONE;

    public static void initLogDeletion() {
        ContainerDiscovery.discoverContainerInformation(ACTION.DELETE_BTM_LOG_FILES, 15);
    }

    private static Hashtable getBtmjarLogFolderNames() {
        Hashtable<Object, Long> hashtable = new Hashtable<Object, Long>();
        String string = BTMOffLoadConfig.getLogPathWithSubFolderName();
        try {
            File file = new File(string);
            Object[] objectArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return new File(file, string).isDirectory();
                }
            });
            BTMLog.logger.info("{} Available folder names under {} : {} ", LOG_HEADER, string, Arrays.toString(objectArray));
            if (objectArray != null && objectArray.length > 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    String string2 = string + (String)object + File.separator + "BTMLog.log";
                    File file2 = new File(string2);
                    if (!file2.exists()) continue;
                    long l = file2.lastModified();
                    hashtable.put(object, l);
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} Unable to get BTM jar log folder name from {}: ", LOG_HEADER, string, exception);
        }
        return hashtable;
    }

    public static void doLogDeletionProcess() {
        Hashtable hashtable = LogCleanUp.getBtmjarLogFolderNames();
        BTMLog.logger.info("{} logFolderNamemap  : {}", (Object)LOG_HEADER, (Object)hashtable);
        Iterator iterator = hashtable.entrySet().iterator();
        long l = System.currentTimeMillis();
        String string = BTMOffLoadConfig.getLogPathWithSubFolderName();
        while (iterator.hasNext()) {
            try {
                String string2;
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                long l2 = (Long)entry.getValue();
                long l3 = l - l2;
                if (l3 < 43200000L || !LogCleanUp.deleteFullDirectory(string2 = string + string3)) continue;
                BTMLog.logger.warn("{} Old eG_BTM log folder [{}] that belongs to {} has been deleted ", LOG_HEADER, string2, string3);
            }
            catch (Exception exception) {
                BTMLog.logger.warn("{} Unable to do log folder deletion process for specific foldername : ", (Object)LOG_HEADER, (Object)exception);
            }
        }
    }

    private static boolean deleteFullDirectory(String string) {
        try {
            File file = new File(string);
            try {
                if (file.exists()) {
                    LogCleanUp.deleteDirectory(file);
                }
                if (!file.exists()) {
                    BTMLog.logger.debug("{} Directory deleted : {} [ {} ] ", LOG_HEADER, file.getName(), string);
                    return true;
                }
            }
            catch (Exception exception) {
                BTMLog.logger.error("{} Unable to delete folder : {} [ {} ] {}", LOG_HEADER, file.getName(), string, exception);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("{} File name is empty {}", (Object)LOG_HEADER, (Object)exception.getMessage());
        }
        return false;
    }

    private static void deleteDirectory(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        LogCleanUp.cleanDirectory(file);
        if (!file.delete()) {
            String string = "Unable to delete directory " + file + ".";
            throw new IOException(string);
        }
    }

    private static void cleanDirectory(File file) throws IOException {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        IOException iOException = null;
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            try {
                LogCleanUp.forceDelete(file2);
                continue;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    private static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            LogCleanUp.deleteDirectory(file);
        } else {
            if (!file.exists()) {
                throw new FileNotFoundException("File does not exist: " + file);
            }
            if (!file.delete()) {
                String string = "Unable to delete file: " + file;
                throw new IOException(string);
            }
        }
    }

    public static void setLastModifiedTimeToLogFile() {
        try {
            File file = new File(BTMOffLoadConfig.getAbsoluteBTMLogFilePath());
            if (file.exists()) {
                boolean bl = file.setLastModified(System.currentTimeMillis());
                BTMLog.logger.info("{} Updated last modified time to {} : {}", LOG_HEADER, BTMOffLoadConfig.getAbsoluteBTMLogFilePath(), bl);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} Unable to set last modified time to : {}", LOG_HEADER, BTMOffLoadConfig.getAbsoluteBTMLogFilePath(), exception);
        }
    }

    public static LogCleanUpCode getCleanUpCode() {
        return cleanUpCode;
    }

    public static void setCleanUpCode(LogCleanUpCode logCleanUpCode) {
        cleanUpCode = logCleanUpCode;
    }

    public static void checkLogHomeCode() {
        try {
            if (LogCleanUp.getCleanUpCode() != LogCleanUpCode.LC000) {
                String string = BTMOffLoadConfig.getBtmLogHomeFolder().toLowerCase();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("egurkha");
                stringBuilder.append(File.separatorChar);
                stringBuilder.append("lib");
                stringBuilder.append(File.separatorChar);
                stringBuilder.append("apm");
                stringBuilder.append(File.separatorChar);
                stringBuilder.append("java");
                stringBuilder.append(File.separatorChar);
                stringBuilder.append("default");
                if (string.contains(stringBuilder)) {
                    LogCleanUp.setCleanUpCode(LogCleanUpCode.LC000);
                    return;
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} Unable to check default log home : {}", (Object)LOG_HEADER, (Object)exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogCleanUpCode {
        NONE,
        LC000,
        LC001,
        LC002,
        LC003,
        LC004,
        LC005;

    }
}

