/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalCallDiagnosis {
    private HashMap<String, double[]> externalCallDetailsTable = null;
    private HashMap<String, Boolean> streamErrorMap = null;
    private String reqType;
    private String guidString;
    private boolean isEntryNode;
    private double totalExternalCallTime = 0.0;

    public ExternalCallDiagnosis(String string, String string2, boolean bl) {
        this.reqType = string;
        this.guidString = string2;
        this.isEntryNode = bl;
        this.externalCallDetailsTable = new HashMap();
        this.streamErrorMap = new HashMap();
    }

    public void updateExternalCallDetails(String string, double d, boolean bl) {
        try {
            double[] dArray = this.externalCallDetailsTable.get(string);
            dArray = this.updateDetailsKeyAlreadyAvailable(dArray, d, bl, false);
            this.externalCallDetailsTable.put(string, dArray);
        }
        catch (Exception exception) {
            double[] dArray = new double[]{1.0, d, 0.0};
            if (bl) {
                dArray[2] = 1.0;
            }
            this.externalCallDetailsTable.put(string, dArray);
        }
        this.totalExternalCallTime += d;
        BTMLog.logger.debug("[Transaction Flow Test] KeyString : {} Time: {}  ERROR:  {} GUID : {} ", string, d, bl, this.guidString);
    }

    public void updateExternalCallDetails(String string, double d, boolean bl, boolean bl2) {
        try {
            double[] dArray = this.externalCallDetailsTable.get(string);
            dArray = this.updateDetailsKeyAlreadyAvailable(dArray, d, bl, bl2);
            this.externalCallDetailsTable.put(string, dArray);
        }
        catch (Exception exception) {
            double[] dArray = new double[]{1.0, d, 0.0};
            if (bl) {
                dArray[2] = 1.0;
            }
            this.externalCallDetailsTable.put(string, dArray);
        }
        this.totalExternalCallTime += d;
        BTMLog.logger.debug("[Transaction Flow Test] KeyString : {} Time: {}  ERROR:  {} GUID : {} ", string, d, bl, this.guidString);
    }

    private double[] updateDetailsKeyAlreadyAvailable(double[] dArray, double d, boolean bl, boolean bl2) {
        if (dArray == null) {
            dArray = new double[3];
        }
        if (!bl2) {
            dArray[0] = dArray[0] + 1.0;
        }
        dArray[1] = dArray[1] + d;
        if (bl) {
            dArray[2] = dArray[2] + 1.0;
        }
        return dArray;
    }

    public Map<String, double[]> computeSelfNodeTime(double d, boolean bl, String string) {
        double d2 = 0.0;
        d2 = string.equals("JMS_ENTRY") ? this.totalExternalCallTime : d - this.totalExternalCallTime;
        double[] dArray = new double[]{d, d2, 0.0, 0.0};
        if (this.isEntryNode) {
            dArray[3] = 1.0;
        }
        if (bl) {
            dArray[2] = 1.0;
        }
        this.externalCallDetailsTable.put("NODE_DETAILS_" + this.reqType, dArray);
        return this.externalCallDetailsTable;
    }

    public Boolean isStreamErrorCaptured(String string) {
        return this.streamErrorMap.containsKey(string);
    }

    public void registerStreamNodeOrderErrorMap(String string) {
        this.streamErrorMap.put(string, true);
    }
}

