/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.net.ssl;

import com.eg.ch.qos.logback.core.net.ssl.SSLConfigurable;
import com.eg.ch.qos.logback.core.spi.ContextAwareBase;
import com.eg.ch.qos.logback.core.util.OptionHelper;
import com.eg.ch.qos.logback.core.util.StringCollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class SSLParametersConfiguration
extends ContextAwareBase {
    private String includedProtocols;
    private String excludedProtocols;
    private String includedCipherSuites;
    private String excludedCipherSuites;
    private Boolean needClientAuth;
    private Boolean wantClientAuth;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;

    public void configure(SSLConfigurable sSLConfigurable) {
        sSLConfigurable.setEnabledProtocols(this.enabledProtocols(sSLConfigurable.getSupportedProtocols(), sSLConfigurable.getDefaultProtocols()));
        sSLConfigurable.setEnabledCipherSuites(this.enabledCipherSuites(sSLConfigurable.getSupportedCipherSuites(), sSLConfigurable.getDefaultCipherSuites()));
        if (this.isNeedClientAuth() != null) {
            sSLConfigurable.setNeedClientAuth(this.isNeedClientAuth());
        }
        if (this.isWantClientAuth() != null) {
            sSLConfigurable.setWantClientAuth(this.isWantClientAuth());
        }
    }

    private String[] enabledProtocols(String[] stringArray, String[] stringArray2) {
        if (this.enabledProtocols == null) {
            this.enabledProtocols = OptionHelper.isEmpty(this.getIncludedProtocols()) && OptionHelper.isEmpty(this.getExcludedProtocols()) ? Arrays.copyOf(stringArray2, stringArray2.length) : this.includedStrings(stringArray, this.getIncludedProtocols(), this.getExcludedProtocols());
            for (String string : this.enabledProtocols) {
                this.addInfo("enabled protocol: " + string);
            }
        }
        return this.enabledProtocols;
    }

    private String[] enabledCipherSuites(String[] stringArray, String[] stringArray2) {
        if (this.enabledCipherSuites == null) {
            this.enabledCipherSuites = OptionHelper.isEmpty(this.getIncludedCipherSuites()) && OptionHelper.isEmpty(this.getExcludedCipherSuites()) ? Arrays.copyOf(stringArray2, stringArray2.length) : this.includedStrings(stringArray, this.getIncludedCipherSuites(), this.getExcludedCipherSuites());
            for (String string : this.enabledCipherSuites) {
                this.addInfo("enabled cipher suite: " + string);
            }
        }
        return this.enabledCipherSuites;
    }

    private String[] includedStrings(String[] stringArray, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        arrayList.addAll(Arrays.asList(stringArray));
        if (string != null) {
            StringCollectionUtil.retainMatching(arrayList, this.stringToArray(string));
        }
        if (string2 != null) {
            StringCollectionUtil.removeMatching(arrayList, this.stringToArray(string2));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] stringToArray(String string) {
        return string.split("\\s*,\\s*");
    }

    public String getIncludedProtocols() {
        return this.includedProtocols;
    }

    public void setIncludedProtocols(String string) {
        this.includedProtocols = string;
    }

    public String getExcludedProtocols() {
        return this.excludedProtocols;
    }

    public void setExcludedProtocols(String string) {
        this.excludedProtocols = string;
    }

    public String getIncludedCipherSuites() {
        return this.includedCipherSuites;
    }

    public void setIncludedCipherSuites(String string) {
        this.includedCipherSuites = string;
    }

    public String getExcludedCipherSuites() {
        return this.excludedCipherSuites;
    }

    public void setExcludedCipherSuites(String string) {
        this.excludedCipherSuites = string;
    }

    public Boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(Boolean bl) {
        this.needClientAuth = bl;
    }

    public Boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(Boolean bl) {
        this.wantClientAuth = bl;
    }
}

