/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran.util;

import com.eg.ch.qos.logback.core.joran.spi.DefaultClass;
import com.eg.ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import com.eg.ch.qos.logback.core.joran.util.StringToObjectConverter;
import com.eg.ch.qos.logback.core.joran.util.beans.BeanDescription;
import com.eg.ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import com.eg.ch.qos.logback.core.joran.util.beans.BeanUtil;
import com.eg.ch.qos.logback.core.spi.ContextAwareBase;
import com.eg.ch.qos.logback.core.util.AggregationType;
import com.eg.ch.qos.logback.core.util.PropertySetterException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySetter
extends ContextAwareBase {
    protected final Object obj;
    protected final Class<?> objClass;
    protected final BeanDescription beanDescription;

    public PropertySetter(BeanDescriptionCache beanDescriptionCache, Object object) {
        this.obj = object;
        this.objClass = object.getClass();
        this.beanDescription = beanDescriptionCache.getBeanDescription(this.objClass);
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        Method method = this.findSetterMethod(string);
        if (method == null) {
            this.addWarn("No setter for property [" + string + "] in " + this.objClass.getName() + ".");
        } else {
            try {
                this.setProperty(method, string, string2);
            }
            catch (PropertySetterException propertySetterException) {
                this.addWarn("Failed to set property [" + string + "] to value \"" + string2 + "\". ", propertySetterException);
            }
        }
    }

    private void setProperty(Method method, String string, String string2) throws PropertySetterException {
        Object object;
        Class<?>[] classArray = method.getParameterTypes();
        try {
            object = StringToObjectConverter.convertArg(this, string2, classArray[0]);
        }
        catch (Throwable throwable) {
            throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed. ", throwable);
        }
        if (object == null) {
            throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed.");
        }
        try {
            method.invoke(this.obj, object);
        }
        catch (Exception exception) {
            throw new PropertySetterException(exception);
        }
    }

    public AggregationType computeAggregationType(String string) {
        Object object;
        String string2 = this.capitalizeFirstLetter(string);
        Method method = this.findAdderMethod(string2);
        if (method != null) {
            object = this.computeRawAggregationType(method);
            switch (1.$SwitchMap$com$eg$ch$qos$logback$core$util$AggregationType[((Enum)object).ordinal()]) {
                case 1: {
                    return AggregationType.NOT_FOUND;
                }
                case 2: {
                    return AggregationType.AS_BASIC_PROPERTY_COLLECTION;
                }
                case 3: {
                    return AggregationType.AS_COMPLEX_PROPERTY_COLLECTION;
                }
                case 4: 
                case 5: {
                    this.addError("Unexpected AggregationType " + object);
                }
            }
        }
        if ((object = this.findSetterMethod(string)) != null) {
            return this.computeRawAggregationType((Method)object);
        }
        return AggregationType.NOT_FOUND;
    }

    private Method findAdderMethod(String string) {
        String string2 = BeanUtil.toLowerCamelCase(string);
        return this.beanDescription.getAdder(string2);
    }

    private Method findSetterMethod(String string) {
        String string2 = BeanUtil.toLowerCamelCase(string);
        return this.beanDescription.getSetter(string2);
    }

    private Class<?> getParameterClassForMethod(Method method) {
        if (method == null) {
            return null;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return null;
        }
        return classArray[0];
    }

    private AggregationType computeRawAggregationType(Method method) {
        Class<?> clazz = this.getParameterClassForMethod(method);
        if (clazz == null) {
            return AggregationType.NOT_FOUND;
        }
        if (StringToObjectConverter.canBeBuiltFromSimpleString(clazz)) {
            return AggregationType.AS_BASIC_PROPERTY;
        }
        return AggregationType.AS_COMPLEX_PROPERTY;
    }

    private boolean isUnequivocallyInstantiable(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        try {
            Object obj = clazz.newInstance();
            return obj != null;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    public Class<?> getObjClass() {
        return this.objClass;
    }

    public void addComplexProperty(String string, Object object) {
        Method method = this.findAdderMethod(string);
        if (method != null) {
            Class<?>[] classArray = method.getParameterTypes();
            if (!this.isSanityCheckSuccessful(string, method, classArray, object)) {
                return;
            }
            this.invokeMethodWithSingleParameterOnThisObject(method, object);
        } else {
            this.addError("Could not find method [add" + string + "] in class [" + this.objClass.getName() + "].");
        }
    }

    void invokeMethodWithSingleParameterOnThisObject(Method method, Object object) {
        Class<?> clazz = object.getClass();
        try {
            method.invoke(this.obj, object);
        }
        catch (Exception exception) {
            this.addError("Could not invoke method " + method.getName() + " in class " + this.obj.getClass().getName() + " with parameter of type " + clazz.getName(), exception);
        }
    }

    public void addBasicProperty(String string, String string2) {
        Object object;
        if (string2 == null) {
            return;
        }
        Method method = this.findAdderMethod(string = this.capitalizeFirstLetter(string));
        if (method == null) {
            this.addError("No adder for property [" + string + "].");
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        this.isSanityCheckSuccessful(string, method, classArray, string2);
        try {
            object = StringToObjectConverter.convertArg(this, string2, classArray[0]);
        }
        catch (Throwable throwable) {
            this.addError("Conversion to type [" + classArray[0] + "] failed. ", throwable);
            return;
        }
        if (object != null) {
            this.invokeMethodWithSingleParameterOnThisObject(method, string2);
        }
    }

    public void setComplexProperty(String string, Object object) {
        Method method = this.findSetterMethod(string);
        if (method == null) {
            this.addWarn("Not setter method for property [" + string + "] in " + this.obj.getClass().getName());
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (!this.isSanityCheckSuccessful(string, method, classArray, object)) {
            return;
        }
        try {
            this.invokeMethodWithSingleParameterOnThisObject(method, object);
        }
        catch (Exception exception) {
            this.addError("Could not set component " + this.obj + " for parent component " + this.obj, exception);
        }
    }

    private boolean isSanityCheckSuccessful(String string, Method method, Class<?>[] classArray, Object object) {
        Class<?> clazz = object.getClass();
        if (classArray.length != 1) {
            this.addError("Wrong number of parameters in setter method for property [" + string + "] in " + this.obj.getClass().getName());
            return false;
        }
        if (!classArray[0].isAssignableFrom(object.getClass())) {
            this.addError("A \"" + clazz.getName() + "\" object is not assignable to a \"" + classArray[0].getName() + "\" variable.");
            this.addError("The class \"" + classArray[0].getName() + "\" was loaded by ");
            this.addError("[" + classArray[0].getClassLoader() + "] whereas object of type ");
            this.addError("\"" + clazz.getName() + "\" was loaded by [" + clazz.getClassLoader() + "].");
            return false;
        }
        return true;
    }

    private String capitalizeFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public Object getObj() {
        return this.obj;
    }

    Method getRelevantMethod(String string, AggregationType aggregationType) {
        Method method;
        if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY_COLLECTION) {
            method = this.findAdderMethod(string);
        } else if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY) {
            method = this.findSetterMethod(string);
        } else {
            throw new IllegalStateException((Object)((Object)aggregationType) + " not allowed here");
        }
        return method;
    }

    <T extends Annotation> T getAnnotation(String string, Class<T> clazz, Method method) {
        if (method != null) {
            return method.getAnnotation(clazz);
        }
        return null;
    }

    Class<?> getDefaultClassNameByAnnonation(String string, Method method) {
        DefaultClass defaultClass = this.getAnnotation(string, DefaultClass.class, method);
        if (defaultClass != null) {
            return defaultClass.value();
        }
        return null;
    }

    Class<?> getByConcreteType(String string, Method method) {
        Class<?> clazz = this.getParameterClassForMethod(method);
        if (clazz == null) {
            return null;
        }
        boolean bl = this.isUnequivocallyInstantiable(clazz);
        if (bl) {
            return clazz;
        }
        return null;
    }

    public Class<?> getClassNameViaImplicitRules(String string, AggregationType aggregationType, DefaultNestedComponentRegistry defaultNestedComponentRegistry) {
        Class<?> clazz = defaultNestedComponentRegistry.findDefaultComponentType(this.obj.getClass(), string);
        if (clazz != null) {
            return clazz;
        }
        Method method = this.getRelevantMethod(string, aggregationType);
        if (method == null) {
            return null;
        }
        Class<?> clazz2 = this.getDefaultClassNameByAnnonation(string, method);
        if (clazz2 != null) {
            return clazz2;
        }
        return this.getByConcreteType(string, method);
    }
}

