/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.pattern;

import com.eg.ch.qos.logback.classic.pattern.ClassicConverter;
import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.classic.util.LevelToSyslogSeverity;
import com.eg.ch.qos.logback.core.net.SyslogAppenderBase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class SyslogStartConverter
extends ClassicConverter {
    long lastTimestamp = -1L;
    String timesmapStr = null;
    SimpleDateFormat simpleMonthFormat;
    SimpleDateFormat simpleTimeFormat;
    private final Calendar calendar = Calendar.getInstance(Locale.US);
    String localHostName;
    int facility;

    public void start() {
        int n = 0;
        String string = this.getFirstOption();
        if (string == null) {
            this.addError("was expecting a facility string as an option");
            return;
        }
        this.facility = SyslogAppenderBase.facilityStringToint(string);
        this.localHostName = this.getLocalHostname();
        try {
            this.simpleMonthFormat = new SimpleDateFormat("MMM", Locale.US);
            this.simpleTimeFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addError("Could not instantiate SimpleDateFormat", illegalArgumentException);
            ++n;
        }
        if (n == 0) {
            super.start();
        }
    }

    public String convert(ILoggingEvent iLoggingEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.facility + LevelToSyslogSeverity.convert(iLoggingEvent);
        stringBuilder.append("<");
        stringBuilder.append(n);
        stringBuilder.append(">");
        stringBuilder.append(this.computeTimeStampString(iLoggingEvent.getTimeStamp()));
        stringBuilder.append(' ');
        stringBuilder.append(this.localHostName);
        stringBuilder.append(' ');
        return stringBuilder.toString();
    }

    public String getLocalHostname() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.addError("Could not determine local host name", unknownHostException);
            return "UNKNOWN_LOCALHOST";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String computeTimeStampString(long l) {
        SyslogStartConverter syslogStartConverter = this;
        synchronized (syslogStartConverter) {
            if (l / 1000L != this.lastTimestamp) {
                this.lastTimestamp = l / 1000L;
                Date date = new Date(l);
                this.calendar.setTime(date);
                this.timesmapStr = String.format("%s %2d %s", this.simpleMonthFormat.format(date), this.calendar.get(5), this.simpleTimeFormat.format(date));
            }
            return this.timesmapStr;
        }
    }
}

