/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.html;

import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.classic.spi.IThrowableProxy;
import com.eg.ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.eg.ch.qos.logback.core.CoreConstants;
import com.eg.ch.qos.logback.core.helpers.Transform;
import com.eg.ch.qos.logback.core.html.IThrowableRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThrowableRenderer
implements IThrowableRenderer<ILoggingEvent> {
    static final String TRACE_PREFIX = "<br />&nbsp;&nbsp;&nbsp;&nbsp;";

    @Override
    public void render(StringBuilder stringBuilder, ILoggingEvent iLoggingEvent) {
        stringBuilder.append("<tr><td class=\"Exception\" colspan=\"6\">");
        for (IThrowableProxy iThrowableProxy = iLoggingEvent.getThrowableProxy(); iThrowableProxy != null; iThrowableProxy = iThrowableProxy.getCause()) {
            this.render(stringBuilder, iThrowableProxy);
        }
        stringBuilder.append("</td></tr>");
    }

    @Override
    void render(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        this.printFirstLine(stringBuilder, iThrowableProxy);
        int n = iThrowableProxy.getCommonFrames();
        StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
        for (int i = 0; i < stackTraceElementProxyArray.length - n; ++i) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[i];
            stringBuilder.append(TRACE_PREFIX);
            stringBuilder.append(Transform.escapeTags(stackTraceElementProxy.toString()));
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        if (n > 0) {
            stringBuilder.append(TRACE_PREFIX);
            stringBuilder.append("\t... ").append(n).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public void printFirstLine(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        int n = iThrowableProxy.getCommonFrames();
        if (n > 0) {
            stringBuilder.append("<br />").append("Caused by: ");
        }
        stringBuilder.append(iThrowableProxy.getClassName()).append(": ").append(Transform.escapeTags(iThrowableProxy.getMessage()));
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
    }
}

