/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.ux;

import com.eg.agent.RetransformThread;
import com.eg.agent.adapter.EgMeasureMethodVisitor;
import com.eg.agent.ux.Measure;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMUtils;
import com.eg.org.objectweb.asm.MethodVisitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MeasureUtil {
    private static final Hashtable<String, Measure> methodArgumentMeasureTable = new Hashtable();
    private static final Hashtable<String, Measure> staticMethodMeasureTable = new Hashtable();
    private static final Hashtable<String, Measure> sessionAttributeMeasureTable = new Hashtable();
    private static final Hashtable<String, Measure> requestParameterMeasureTable = new Hashtable();
    private static boolean isICExists = false;
    private static final Hashtable currentProperties = new Hashtable();
    private static final Hashtable previousProperties = new Hashtable();

    private MeasureUtil() {
    }

    public static void addMeasures(Properties properties) {
        MeasureUtil.addMeasures(properties, "IC_IDS", "IC_");
    }

    public static void addMeasures(Properties properties, String string) {
        MeasureUtil.addMeasures(properties, "business.context.conf.bt.IC_IDS", "business.context.conf.bt.");
    }

    public static void addMeasures(Properties properties, String string, String string2) {
        BTMLog.logger.info("[IC_for_APM] Entering to add the IC Measure...");
        try {
            String string3 = properties.getProperty(string, null);
            Object[] objectArray = null;
            int n = 0;
            if (string3 != null) {
                objectArray = string3.split("\\~\\|\\~");
                if (objectArray == null) {
                    objectArray = new String[]{string3};
                }
                if ((n = objectArray.length) > 0) {
                    isICExists = true;
                }
            }
            if (BTMLog.logger.isDebugEnabled()) {
                BTMLog.logger.debug("[IC_for_APM] IC Measure IDs: " + Arrays.toString(objectArray));
            }
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                String string4 = properties.getProperty(string2 + (String)object, null);
                BTMLog.logger.debug("[IC_for_APM] - Property & Value {} : {} ", (Object)(string2 + (String)object), (Object)string4);
                if (string4 == null) continue;
                String[] stringArray = string4.split("\\~\\|\\~");
                String string5 = null;
                try {
                    string5 = stringArray[0];
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading Measure Description from props!!.. Setting the default value..{Measure id = {} ", object);
                }
                int n2 = -1;
                try {
                    n2 = MeasureUtil.parseInt(stringArray[1], -1);
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading Field Type from props!!.. Setting the default value..{Measure id = {} ", object);
                }
                int n3 = -1;
                try {
                    n3 = MeasureUtil.parseInt(stringArray[2], -1);
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading Fetch Type from props!!.. Setting the default value..{Measure id = {}", object);
                }
                String string6 = null;
                try {
                    string6 = stringArray[3];
                    if (n3 == 2 && string6 != null) {
                        string6 = string6.replaceAll("/", ".");
                    }
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading Classname from props!!.. Setting the default value..{Measure id = {}", object);
                }
                String string7 = null;
                try {
                    string7 = stringArray[4];
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading Methodname from props!!.. Setting the default value..{Measure id = {}", object);
                }
                String string8 = null;
                try {
                    string8 = stringArray[5];
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading Method Signature from props!!.. Setting the default value..{Measure id = {}", object);
                }
                int n4 = -1;
                try {
                    n4 = MeasureUtil.parseInt(stringArray[6], -1);
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading Method Argument Index from props!!.. Setting the default value..{Measure id = {}", object);
                }
                boolean bl = true;
                try {
                    bl = MeasureUtil.parseBoolean(stringArray[7], true);
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading FetchOnce from props!!.. Setting the default value..{Measure id = {}", object);
                }
                boolean bl2 = false;
                try {
                    bl2 = MeasureUtil.parseBoolean(stringArray[8], false);
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading Request Object from props!!.. Setting the default value..{Measure id = {}", object);
                }
                boolean bl3 = false;
                try {
                    bl3 = MeasureUtil.parseBoolean(stringArray[9], false);
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading Execute at Begin or End from props!!.. Setting the default value..{Measure id = {}", object);
                }
                String string9 = null;
                try {
                    string9 = stringArray[10];
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading Session attribute name from props!!.. Setting the default value..{Measure id = {}", object);
                }
                String string10 = "*";
                try {
                    string10 = stringArray[11];
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while reading URL patterns from props!!.. Setting the default value..{Measure id = {}", object);
                }
                boolean bl4 = MeasureUtil.isValidMeasure((String)object, n2, n3, string6, string7, string8, n4, bl, bl2, bl3, string9, string10);
                if (bl4) {
                    Measure measure = new Measure();
                    measure.setId((String)object);
                    measure.setDescription(string5);
                    measure.setFieldType(n2);
                    measure.setFetchType(n3);
                    measure.setClassName(string6);
                    measure.setMethodName(string7);
                    measure.setMethodDesc(string8);
                    measure.setMethodParamIndex(n4);
                    measure.setFetchOnce(bl);
                    measure.setInputRequestObj(bl2);
                    measure.setFetchOnReqStart(bl3);
                    measure.setSessionKey(string9);
                    measure.setUrlPatterns(string10);
                    MeasureUtil.addToTables(measure);
                    if (n3 == 1) {
                        ArrayList<String> arrayList = (ArrayList<String>)currentProperties.get(string6);
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                            arrayList.add(string7 + "#" + string8);
                            currentProperties.put(string6, arrayList);
                        } else {
                            arrayList.add(string7 + "#" + string8);
                        }
                    }
                }
                BTMLog.logger.debug("_MEASURE_ID = {} ; _MEASURE_NAME= {} ; _MEASURE_METHOD_TYPE= {} ; _MEASURE_CLASS_NAME= {} ; _MEASURE_METHOD_NAME= {} ; _MEASURE_METHOD_DESC= {} ; _MEASURE_ARGUMENT_INDEX= {} ; _MEASURE_CAPTURE_FIRST_EXECUTION= {} ; _MEASURE_PASS_REQUEST_OBJ= {} ; _MEASURE_EXECUTE_AT_BEGIN= {} ; _MEASURE_SESSION_NAME= {} ; _MEASURE_URL_PATTERN= {} ", object, string5, n3, string6, string7, string8, n4, bl, bl2, bl3, string9, string10);
            }
            if (currentProperties != null) {
                MeasureUtil.doRetransformClasses();
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[IC_For_APM] Error while setting the IC Measures  : {} ", exception);
        }
    }

    private static void doRetransformClasses() {
        Object object;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Set set = currentProperties.keySet();
        for (Object object2 : set) {
            object = (ArrayList)currentProperties.get(object2);
            Collections.sort(object);
            if (previousProperties.containsKey(object2)) {
                ArrayList arrayList = (ArrayList)previousProperties.get(object2);
                Collections.sort(arrayList);
                boolean bl = ((ArrayList)object).equals(arrayList);
                if (bl) continue;
                hashtable.put(object2, object);
                continue;
            }
            hashtable.put(object2, object);
        }
        previousProperties.clear();
        previousProperties.putAll(currentProperties);
        currentProperties.clear();
        if (hashtable.size() > 0) {
            Object object2;
            object2 = new ArrayList(hashtable.keySet());
            object = new RetransformThread((ArrayList<String>)object2);
        }
    }

    private static boolean isValidMeasure(String string, int n, int n2, String string2, String string3, String string4, int n3, boolean bl, boolean bl2, boolean bl3, String string5, String string6) {
        if (!MeasureUtil.isValidFieldType(n)) {
            BTMLog.logger.warn(" Invalid Measure, you have entered invalid FieldType.. [Measure id = {}]", (Object)string);
            return false;
        }
        if (!MeasureUtil.isValidFetchType(n2)) {
            BTMLog.logger.warn(" Invalid Measure, you have entered invalid FetchType.. [Measure id = {}]", (Object)string);
            return false;
        }
        if (!MeasureUtil.isJavaClassNameOrMethodName(n2, string2, true)) {
            BTMLog.logger.warn(" Invalid Measure, you have entered invalid ClassName.. [Measure id = {}]", (Object)string);
            return false;
        }
        if (!MeasureUtil.isJavaClassNameOrMethodName(n2, string3, false)) {
            BTMLog.logger.warn(" Invalid Measure, you have entered invalid MethodName.. [Measure id = {}]", (Object)string);
            return false;
        }
        if (!MeasureUtil.isValidMethodDesc(n2, string4)) {
            BTMLog.logger.warn(" Invalid Measure, you have entered invalid MethodDesc.. [Measure id = {}]", (Object)string);
            return false;
        }
        if (!MeasureUtil.isValidMethodArgumentIndex(n2, n3)) {
            BTMLog.logger.warn(" Invalid Measure, you have entered invalid MethodArgumentIndex.. [Measure id = {}]", (Object)string);
            return false;
        }
        if (n2 == 4) {
            if (string5 == null) {
                BTMLog.logger.warn(" Invalid Measure, Request Parameter Name is NULL.. [Measure id = {}]", (Object)string);
                return false;
            }
            if (string6 == null) {
                BTMLog.logger.warn(" Invalid Measure, URL Pattern is NULL.. [Measure id = {}]", (Object)string);
                return false;
            }
        }
        return true;
    }

    private static boolean isValidFieldType(int n) {
        boolean bl = false;
        if (1 == n || 2 == n) {
            bl = true;
        }
        return bl;
    }

    private static boolean isValidFetchType(int n) {
        boolean bl = false;
        if (1 == n || 2 == n || 3 == n || 4 == n) {
            bl = true;
        }
        return bl;
    }

    private static boolean isJavaClassNameOrMethodName(int n, String string, boolean bl) {
        boolean bl2 = false;
        if (1 == n || 2 == n) {
            Pattern pattern = Pattern.compile("[A-Za-z_$]+[a-zA-Z0-9_$]*");
            if (bl && string.contains("/")) {
                string = string.replaceAll("/", ".");
            }
            for (String string2 : string.split("\\.")) {
                if (!BTMConstants.javaKeywords.contains(string2) && pattern.matcher(string2).matches()) continue;
                return false;
            }
            bl2 = true;
        } else if (3 == n || 4 == n) {
            bl2 = true;
        }
        return bl2;
    }

    private static boolean isValidMethodDesc(int n, String string) {
        boolean bl = false;
        if (1 == n && string.indexOf("(") > -1 && string.indexOf(")") > -1) {
            bl = true;
        } else if (2 == n || 3 == n || 4 == n) {
            bl = true;
        }
        return bl;
    }

    private static boolean isValidMethodArgumentIndex(int n, int n2) {
        boolean bl = false;
        if (1 == n && n2 > 0) {
            bl = true;
        } else if (2 == n || 3 == n || 4 == n) {
            bl = true;
        }
        return bl;
    }

    private static void addToTables(Measure measure) {
        String string = measure.getId();
        BTMLog.logger.info("[IC_For_APM] Started to add the Measure...[Measure id = {}]", (Object)string);
        int n = measure.getFetchType();
        if (n == 1) {
            String string2 = MeasureUtil.getMethodDescForMethodArgMeasure(measure.getMethodDesc());
            String string3 = MeasureUtil.getKeyForMethodArgument(measure.getClassName(), measure.getMethodName(), string2);
            if (string3 != null) {
                measure.setMethodDesc(string2);
                methodArgumentMeasureTable.put(string3, measure);
            }
        } else if (2 == n) {
            staticMethodMeasureTable.put(string, measure);
        } else if (3 == n) {
            sessionAttributeMeasureTable.put(string, measure);
        } else if (4 == n) {
            requestParameterMeasureTable.put(string, measure);
        }
    }

    private static Object[] getMeasureForClassMethod(String string, String string2, String string3) {
        String string4;
        Object[] objectArray = null;
        String string5 = MeasureUtil.getMethodSignatureFromDesc(string3);
        if (string5 != null && methodArgumentMeasureTable.containsKey(string4 = MeasureUtil.getKeyForMethodArgument(string, string2, string5))) {
            BTMLog.logger.debug("[IC_for_APM] [MeasureUtil] Getting Meaure for classWithMethodKey : {} ", (Object)string4);
            Measure measure = methodArgumentMeasureTable.get(string4);
            objectArray = new Object[]{measure, string4};
            BTMLog.logger.debug("[IC_for_APM] [MeasureUtil] Found Meaure: {} for classWithMethodKey : {} ", (Object)measure.getId(), (Object)string4);
        }
        return objectArray;
    }

    private static String getKeyForMethodArgument(String string, String string2, String string3) {
        String string4 = null;
        if (string != null && string2 != null && string3 != null) {
            string4 = string + "." + string2 + "." + string3;
        }
        return string4;
    }

    public static Hashtable<String, Measure> getMethodMeasures() {
        return methodArgumentMeasureTable;
    }

    public static Hashtable<String, Measure> getStaticMethodMeasures() {
        return staticMethodMeasureTable;
    }

    public static Hashtable<String, Measure> getSessionMeasures() {
        return sessionAttributeMeasureTable;
    }

    public static Hashtable<String, Measure> getRequestParamMeasureTable() {
        return requestParameterMeasureTable;
    }

    public static String getRequestUriOnly(String string) {
        String string2 = null;
        if (string != null && string.lastIndexOf("@") > -1) {
            String string3 = string.substring(0, string.lastIndexOf("@"));
            string2 = string3.trim();
        }
        return string2;
    }

    public static boolean isPatternMatched(String string, ArrayList arrayList) {
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (string != null && string2 != null && (bl = BTMUtils.patternMatch(string, string2))) break;
        }
        return bl;
    }

    public static void removeRuntimeInvalidMeasure(String string, String string2, int n) {
        Hashtable<String, Measure> hashtable = null;
        if (string != null && string2 != null) {
            try {
                if (1 == n) {
                    hashtable = MeasureUtil.getMethodMeasures();
                } else if (2 == n) {
                    hashtable = MeasureUtil.getStaticMethodMeasures();
                }
                if (hashtable != null) {
                    hashtable.remove(string2);
                }
                BTMLog.logger.debug("[IC_For_APM] Successfully removed the measure.. [Measure id = {}]", (Object)string);
            }
            catch (Exception exception) {
                BTMLog.logger.warn("[IC_For_APM] Couldnt able to remove the measure..[Measure id = {}]", (Object)string);
                BTMLog.logger.trace("Exception : {}", exception);
            }
        }
    }

    public static Measure getMethodArgMeasureByKey(String string, String string2) {
        Measure measure = null;
        try {
            measure = methodArgumentMeasureTable.get(string);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception while retrieving Method Argument Measures by its key...[Measure id = {}]", (Object)string2);
        }
        return measure;
    }

    private static Integer parseInt(String string, int n) {
        Integer n2 = n;
        if (string == null || string.equals("null")) {
            return n2;
        }
        try {
            if (string != null && (string = string.trim()).length() > 0) {
                n2 = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception while parsing String to int, so default value has set..{}", exception);
        }
        return n2;
    }

    private static Boolean parseBoolean(String string, boolean bl) {
        Boolean bl2 = bl;
        try {
            if (string != null && (string = string.trim()).length() > 0) {
                bl2 = Boolean.parseBoolean(string);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception while parsing String to boolean, so default value has set..{}", exception);
        }
        return bl2;
    }

    private static String getMethodDescForMethodArgMeasure(String string) {
        String string2 = "";
        try {
            List<String> list;
            ArrayList<String> arrayList;
            String string3 = null;
            if (string != null) {
                string3 = string.replaceAll("\\s", "");
            }
            if (string3 != null && string3.indexOf("(") > -1 && (arrayList = new ArrayList<String>(list = Arrays.asList((string3 = string3.substring(1, string3.length() - 1)).split(",")))) != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object object;
                    String string4 = arrayList.get(i);
                    if (string4 == null || string4.length() <= 0) continue;
                    if (BTMUtils.IC_INPUT_METHODDESC_MAPPING.containsKey(string4)) {
                        object = BTMUtils.IC_INPUT_METHODDESC_MAPPING.get(string4);
                        String string5 = object.toString();
                        string2 = string2 + "" + string5;
                        continue;
                    }
                    if (string4 != null && string4.lastIndexOf("[") > -1) {
                        object = string4.substring(0, string4.lastIndexOf("["));
                        object = ((String)object).length() > 0 ? "[L" + (String)object + ";" : "";
                        string2 = string2 + "" + (String)object;
                        continue;
                    }
                    string4 = "L" + string4 + ";";
                    string2 = string2 + "" + string4;
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[IC_For_APM] Error while parsing the method description.. {}", exception);
        }
        return string2;
    }

    private static String getMethodSignatureFromDesc(String string) {
        String string2 = null;
        try {
            if (string != null) {
                string2 = string.substring(1, string.lastIndexOf(")"));
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[IC_For_APM] Exception while getting Method signature from Method description {} ", exception);
        }
        return string2;
    }

    public static MethodVisitor methodMeasure(int n, MethodVisitor methodVisitor, String string, String string2, String string3) {
        if (methodArgumentMeasureTable.isEmpty()) {
            return methodVisitor;
        }
        Object[] objectArray = MeasureUtil.getMeasureForClassMethod(string3, string, string2);
        if (objectArray != null && objectArray.length == 2) {
            Measure measure = (Measure)objectArray[0];
            String string4 = (String)objectArray[1];
            String string5 = measure.getId();
            int n2 = measure.getMethodParamIndex();
            BTMLog.logger.debug("[IC_for_APM] [MeasureUtil] Instrumenting Meaure ID: {} ", (Object)string5);
            methodVisitor = new EgMeasureMethodVisitor(n, methodVisitor, string, string2, string3, string5, n2, string4);
        }
        return methodVisitor;
    }

    public static Method getMethodFromClass(Class clazz, String string, Class[] classArray, boolean bl) {
        Method method = null;
        if (clazz != null) {
            try {
                method = clazz.getMethod(string, classArray);
            }
            catch (Exception exception) {
                try {
                    if (bl) {
                        String string2;
                        while (method == null && !(string2 = clazz.getName()).equals("java.lang.Object")) {
                            if (method == null) {
                                clazz = clazz.getSuperclass();
                            }
                            try {
                                method = clazz.getMethod(string, classArray);
                            }
                            catch (Exception exception2) {}
                        }
                    }
                }
                catch (Exception exception3) {
                    BTMLog.logger.warn("[IC_For_APM] Exception while getting Method from available class.{}", exception3);
                }
            }
        }
        return method;
    }

    public static boolean isICExists() {
        return isICExists;
    }
}

