/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent;

import com.eg.agent.trace.utils.CustomConfigurationManager;
import com.eg.agent.ux.MeasureUtil;
import com.eg.jtm.BTMLog;
import com.eg.jtm.PropsManager;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    static ArrayList<String> excludeClassList = new ArrayList();
    static ArrayList<String> excludePackageList = new ArrayList();
    static ArrayList<String> excludePojoList = new ArrayList();
    static ArrayList<String> excludePatternList = new ArrayList();
    static ArrayList<String> LazyList = new ArrayList();
    static ArrayList<String> includePackageList = new ArrayList();
    static ArrayList<String> includeClassList = new ArrayList();
    static ArrayList<String> jdbcClassList = new ArrayList();

    public static void prepareExcludeList() {
        Object object;
        Properties properties = new Properties();
        if (PropsManager.EG_BTM_HOME == null || PropsManager.EG_BTM_HOME.length() == 0) {
            PropsManager.EG_BTM_HOME = System.getProperty("EG_BTM_HOME");
        }
        try {
            properties.load(new BufferedInputStream(new FileInputStream(PropsManager.EG_BTM_HOME + "/exclude.props")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTMLog.debugLogger.warn("[PROPERTIES] : {} ", (Object)(PropsManager.EG_BTM_HOME + "/exclude.props is not available"));
        }
        catch (IOException iOException) {
            BTMLog.debugLogger.warn("[PROPERTIES] : {} ", (Object)(PropsManager.EG_BTM_HOME + "/exclude.props is not available"));
        }
        if (properties.size() > 0) {
            object = properties.getProperty("exclude.class");
            String string = properties.getProperty("exclude.package.STARTSWITH");
            String string2 = properties.getProperty("exclude.pojo");
            String string3 = properties.getProperty("exclude.package.CONTAINS");
            String string4 = properties.getProperty("lazy.retransform.packages");
            String string5 = properties.getProperty("include.package");
            String string6 = properties.getProperty("include.class");
            String string7 = properties.getProperty("jdbc.driver.STARTSWITH");
            excludeClassList = Utilities.getList((String)object, false);
            excludePackageList = Utilities.getList(string, true);
            excludePojoList = Utilities.getList(string2, true);
            excludePatternList = Utilities.getExcludePatterns(string3);
            LazyList = Utilities.getLazyList(string4);
            includePackageList = Utilities.getList(string5, true);
            includeClassList = Utilities.getList(string6, false);
            jdbcClassList = Utilities.getList(string7, false);
            for (int i = 0; i < jdbcClassList.size(); ++i) {
                String string8 = jdbcClassList.get(i);
                if (excludePojoList.contains(string8)) continue;
                excludePojoList.add(string8);
            }
            MeasureUtil.addMeasures(properties);
        }
        object = CustomConfigurationManager.readCPCProps();
        CustomConfigurationManager.getCustomConfiguredPatternMap((Properties)object);
        if (PropsManager.isCommonGuidPropsFileAvailable()) {
            PropsManager.processIcMeasuresFromGuidPropsFile();
        }
        BTMLog.debugLogger.info(" ExcludeClassList        \t: {} ", (Object)excludeClassList);
        BTMLog.debugLogger.info(" IncludeClassList        \t: {} ", (Object)includeClassList);
        BTMLog.debugLogger.info(" ExcludePackageList \t\t: {} ", (Object)excludePackageList);
        BTMLog.debugLogger.info(" IncludePackageList \t\t: {} ", (Object)includePackageList);
        BTMLog.debugLogger.info(" ExcludePojoList    \t\t: {} ", (Object)excludePojoList);
        BTMLog.debugLogger.info(" ExcludePatternList \t\t: {} ", (Object)excludePatternList);
        BTMLog.debugLogger.info(" LazyList           \t\t: {} ", (Object)LazyList);
        BTMLog.debugLogger.info(" jdbcClassList           \t: {} ", (Object)jdbcClassList);
    }

    public static int getExcludeClassSize() {
        int n = -1;
        if (excludeClassList != null) {
            n = excludeClassList.size();
        }
        return n;
    }

    public static int getExcludePojoSize() {
        int n = -1;
        if (excludePojoList != null) {
            n = excludePojoList.size();
        }
        return n;
    }

    public static boolean isClassPresentExcludePojo(String string) {
        boolean bl = false;
        for (int i = 0; i < excludePojoList.size(); ++i) {
            String string2 = excludePojoList.get(i);
            if (!string.startsWith(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isThreadClassExcluded(String string) {
        String string2;
        int n;
        int n2;
        boolean bl = false;
        if (string == null) {
            bl = true;
            return bl;
        }
        String string3 = string.replace(".", "/");
        if (excludeClassList.contains(string3)) {
            bl = true;
            return bl;
        }
        if (includeClassList.contains(string3)) {
            bl = false;
            return bl;
        }
        boolean bl2 = false;
        for (n2 = 0; n2 < excludePackageList.size(); ++n2) {
            String string4 = excludePackageList.get(n2);
            if (!string3.startsWith(string4)) continue;
            bl2 = true;
            break;
        }
        n2 = 0;
        for (n = 0; n < excludePatternList.size(); ++n) {
            string2 = excludePatternList.get(n);
            if (!string3.startsWith(string2) && string3.indexOf("/" + string2) <= 0) continue;
            n2 = 1;
            break;
        }
        if (bl2 || n2 != 0) {
            bl = true;
            for (n = 0; n < includePackageList.size(); ++n) {
                string2 = includePackageList.get(n);
                if (!string3.startsWith(string2)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    static boolean isDriverClass(String string) {
        boolean bl = false;
        for (int i = 0; i < jdbcClassList.size(); ++i) {
            String string2 = jdbcClassList.get(i);
            if (!string.startsWith(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static ArrayList<String> getExcludePatternList() {
        return excludePatternList;
    }

    static ArrayList<String> getExcludePackageList() {
        return excludePackageList;
    }

    static ArrayList<String> getExcludeClassList() {
        return excludeClassList;
    }

    static boolean isLazyList(String string) {
        boolean bl = false;
        int n = LazyList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = LazyList.get(i);
            if (string2.startsWith("/")) {
                if (string2.endsWith("/") && string.indexOf(string2) > 0) {
                    bl = true;
                } else if (string.endsWith(string2)) {
                    bl = true;
                }
            } else if (string2.endsWith("/")) {
                if (string.startsWith(string2)) {
                    bl = true;
                }
            } else if (string.equals(string2)) {
                bl = true;
            }
            if (bl) break;
        }
        return bl;
    }

    private static ArrayList<String> getList(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            if (bl) {
                while (stringTokenizer.hasMoreTokens()) {
                    int n;
                    String string2 = stringTokenizer.nextToken();
                    if (string2 == null || string2.length() <= 0 || (n = (string2 = string2.trim()).length()) <= 2 || !string2.endsWith("/*")) continue;
                    String string3 = string2.substring(0, n - 1);
                    hashSet.add(string3);
                }
            } else {
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (string4 == null || string4.length() <= 0) continue;
                    hashSet.add(string4.trim());
                }
            }
            if (hashSet != null && hashSet.size() > 0) {
                arrayList = new ArrayList(hashSet);
            }
        }
        return arrayList;
    }

    private static ArrayList<String> getExcludePatterns(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            HashSet<String> hashSet = new HashSet<String>();
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || string2.length() <= 0 || (n = (string2 = string2.trim()).length()) <= 4 || !string2.startsWith("*/") || !string2.endsWith("/*")) continue;
                hashSet.add(string2.substring(2, n - 1));
            }
            if (hashSet != null && hashSet.size() > 0) {
                arrayList = new ArrayList(hashSet);
            }
        }
        return arrayList;
    }

    private static ArrayList<String> getLazyList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || string2.length() <= 0) continue;
                string2 = string2.trim();
                int n = string2.indexOf("*/");
                int n2 = string2.lastIndexOf("/*");
                if (n < 0 && n2 < 0) {
                    hashSet.add(string2);
                    continue;
                }
                if (n >= 0 && n2 > 0) {
                    hashSet.add(string2.substring(n + 1, n2 + 1));
                    continue;
                }
                if (n >= 0) {
                    hashSet.add(string2.substring(n + 1));
                    continue;
                }
                if (n2 <= 0) continue;
                hashSet.add(string2.substring(0, n2 + 1));
            }
            if (hashSet != null && hashSet.size() > 0) {
                arrayList = new ArrayList(hashSet);
            }
        }
        return arrayList;
    }

    static boolean isExcludedClass(String string) {
        boolean bl = false;
        if (excludeClassList.contains(string) && Utilities.isIncludedPackage(string)) {
            bl = Utilities.isNotPresentIncludedClass(string);
        }
        return bl;
    }

    static boolean isExcludedPackage(String string) {
        boolean bl = false;
        for (int i = 0; i < excludePackageList.size(); ++i) {
            String string2 = excludePackageList.get(i);
            if (!string.startsWith(string2)) continue;
            if (!Utilities.isIncludedPackage(string)) break;
            bl = Utilities.isNotPresentIncludedClass(string);
            break;
        }
        return bl;
    }

    static boolean isIncludedPackage(String string) {
        boolean bl = true;
        for (int i = 0; i < includePackageList.size(); ++i) {
            String string2 = includePackageList.get(i);
            if (!string.startsWith(string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    static boolean isNotPresentIncludedClass(String string) {
        boolean bl = true;
        if (includeClassList.contains(string)) {
            bl = false;
        }
        return bl;
    }

    static boolean isExcludedPattern(String string) {
        boolean bl = false;
        for (int i = 0; i < excludePatternList.size(); ++i) {
            String string2 = excludePatternList.get(i);
            if (!string.startsWith(string2) && string.indexOf("/" + string2) <= 0) continue;
            if (!Utilities.isIncludedPackage(string)) break;
            bl = Utilities.isNotPresentIncludedClass(string);
            break;
        }
        return bl;
    }

    static boolean isEligible(String string) {
        if (Utilities.isExcludedClass(string)) {
            return false;
        }
        if (Utilities.isExcludedPackage(string)) {
            return false;
        }
        return !Utilities.isExcludedPattern(string);
    }

    static boolean isSQLClass(String string) {
        boolean bl = false;
        if (string.indexOf("/jdbc/") > 0 || string.indexOf("/jdbcx/") > 0) {
            bl = true;
            return bl;
        }
        bl = Utilities.isDriverClass(string);
        return bl;
    }
}

