/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgCrypt;
import com.eg.EgDateInfo;
import com.eg.EgDbInfo;
import com.eg.EgInstallInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class EgDbRecovery {
    static String entity = "Manager DB Recovery";
    String domain = null;
    public static EgConfigInfo configInfo = new EgConfigInfo("manager");
    public File file;
    public Connection conn = null;
    public Statement stmt = null;
    public String host;
    public String sid;
    public String port;
    public String url;
    public String user;
    public String password;
    public String pathDir;
    public String ntlmV2;
    public String errorMsg = " ";
    public String dbDriver;
    public String dbUrl;
    private static boolean isOraAdapter = false;
    EgDbInfo egDbInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            EgDbRecovery.logToErrorFile("", "", "==============EgDbRecovery starts==============");
            if (stringArray.length != 14) {
                System.out.println("Please pass 14 arguments to execute ...!");
                return;
            }
            if (!(stringArray[0].equals("-host") && stringArray[2].equals("-port") && stringArray[4].equals("-sid") && stringArray[6].equals("-user") && stringArray[8].equals("-password") && stringArray[10].equals("-dir") && stringArray[12].equals("-ntlmv2"))) {
                System.out.println("Usage java com.eg.EgDbRecovery -host <hostname>  -port <portNo> -sid<Database Instance Name> -user <DbUser>  -password <UserPasswd> -dir <source dir of SQL Files> -ntlmv2 <true / false> ");
                return;
            }
            EgDbRecovery.logToErrorFile("INFO", entity, "Recovering Default Tables..");
            EgDbRecovery egDbRecovery = new EgDbRecovery(stringArray);
            egDbRecovery.queryExec();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EgDbRecovery.logToErrorFile("Error", entity, "Exception - " + exception);
        }
        finally {
            EgDbRecovery.logToErrorFile("", "", "==============EgDbRecovery ends==============");
        }
    }

    public EgDbRecovery(String[] stringArray) {
        this.host = stringArray[1];
        this.port = stringArray[3];
        this.sid = stringArray[5];
        this.user = stringArray[7];
        int n = this.user.indexOf("\\");
        if (n < 0) {
            n = this.user.indexOf("/");
        }
        if (n > 0) {
            this.domain = this.user.substring(0, n);
            this.user = this.user.substring(n + 1);
        }
        this.password = stringArray[9];
        this.pathDir = stringArray[11];
        this.ntlmV2 = stringArray[13];
        this.file = new File(this.pathDir);
        if (!EgDbInfo.initialized) {
            this.egDbInfo = new EgDbInfo("manager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryExec() {
        if (!this.connect()) {
            EgDbRecovery.logToErrorFile("Error ", entity, "Db connection failed");
        }
        try {
            Object object;
            Object object2;
            int n;
            this.stmt = this.conn.createStatement();
            File[] fileArray = this.file.listFiles();
            if (fileArray.length == 0) {
                EgDbRecovery.logToErrorFile("Error ", entity, this.pathDir + " doesn't have any .sql files");
                this.closeConnection();
            }
            ArrayList arrayList = new ArrayList();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (n = 0; n < fileArray.length; ++n) {
                String string = fileArray[n].getPath();
                if (!string.endsWith(".sql") || new File(string).length() <= 0L) continue;
                object2 = null;
                Object var8_9 = null;
                object = "";
                String string2 = "";
                Hashtable<String, ArrayList<String>> hashtable = new Hashtable<String, ArrayList<String>>();
                try {
                    object2 = new BufferedReader(new FileReader(string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    EgDbRecovery.logToErrorFile("Error ", entity, "Exception - " + fileNotFoundException);
                }
                try {
                    while ((object = ((BufferedReader)object2).readLine()) != null) {
                        if (((String)object).length() <= 0 || (string2 = " " + (String)object).indexOf(";") <= -1) continue;
                        String string3 = string2.substring(0, string2.length() - 1);
                        if (string.indexOf("PK_") > -1) {
                            arrayList3.add(string3);
                            continue;
                        }
                        arrayList2.add(string3);
                    }
                    if (object2 != null) {
                        ((BufferedReader)object2).close();
                    }
                    if (string.indexOf("PK_") > -1) {
                        if (string.endsWith("user_info.sql")) {
                            hashtable.put("user_info", arrayList3);
                            arrayList3 = new ArrayList();
                        } else if (string.endsWith("user_reports.sql")) {
                            hashtable.put("user_reports", arrayList3);
                            arrayList3 = new ArrayList();
                        } else if (string.endsWith("user_report.sql")) {
                            hashtable.put("user_report", arrayList3);
                            arrayList3 = new ArrayList();
                        } else if (string.endsWith("schedule_info.sql")) {
                            hashtable.put("schedule_info", arrayList3);
                            arrayList3 = new ArrayList();
                        } else if (string.endsWith("onetime_schedule_info.sql")) {
                            hashtable.put("onetime_schedule_info", arrayList3);
                            arrayList3 = new ArrayList();
                        } else if (string.endsWith("asset_info_default.sql")) {
                            hashtable.put("asset_info_default", arrayList3);
                            arrayList3 = new ArrayList();
                        }
                    }
                }
                catch (Exception exception) {
                    EgDbRecovery.logToErrorFile("Error", entity, "Exception - " + exception);
                }
                if (hashtable == null || hashtable.size() <= 0) continue;
                if (hashtable.containsKey("user_info")) {
                    arrayList.addAll((ArrayList)hashtable.get("user_info"));
                }
                if (hashtable.containsKey("user_reports")) {
                    arrayList.addAll((ArrayList)hashtable.get("user_reports"));
                }
                if (hashtable.containsKey("user_report")) {
                    arrayList.addAll((ArrayList)hashtable.get("user_report"));
                }
                if (hashtable.containsKey("schedule_info")) {
                    arrayList.addAll((ArrayList)hashtable.get("schedule_info"));
                }
                if (hashtable.containsKey("onetime_schedule_info")) {
                    arrayList.addAll((ArrayList)hashtable.get("onetime_schedule_info"));
                }
                if (!hashtable.containsKey("asset_info_default")) continue;
                arrayList.addAll((ArrayList)hashtable.get("asset_info_default"));
            }
            if (arrayList != null && arrayList.size() > 0) {
                for (n = 0; n < arrayList.size(); ++n) {
                    object2 = "";
                    try {
                        object2 = (String)arrayList.get(n);
                        if (object2 == null || ((String)object2).length() <= 0) continue;
                        int n2 = this.stmt.executeUpdate((String)object2);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        EgDbRecovery.logToErrorFile("Error", entity, "Error while Executing a Query! - " + sQLException.toString() + "\n Query was " + (String)object2);
                    }
                }
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                object2 = "";
                try {
                    object2 = (String)arrayList2.get(n);
                    if (object2 == null || ((String)object2).length() <= 0) continue;
                    int n3 = this.stmt.executeUpdate((String)object2);
                    continue;
                }
                catch (SQLException sQLException) {
                    object = sQLException;
                    EgDbRecovery.logToErrorFile("Error", entity, "Error while executing query! - " + sQLException.toString() + "\n Query was " + (String)object2);
                }
            }
        }
        catch (Exception exception) {
            EgDbRecovery.logToErrorFile("Error", entity, "Exception - " + exception);
        }
        finally {
            EgDbRecovery.logToErrorFile("INFO ", entity, " Closing Connection");
            this.closeConnection();
        }
    }

    public void closeConnection() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            this.errorMsg = "Error when closing the database connection ...";
            EgDbRecovery.logToErrorFile("INFO ", entity, this.errorMsg + exception);
        }
    }

    public boolean connect() {
        String string = "sql";
        try {
            Object object;
            this.dbDriver = this.egDbInfo.getDriverForDb(string);
            this.dbUrl = this.egDbInfo.getUrlForDb(string);
            EgDbRecovery egDbRecovery = this;
            String string2 = egDbRecovery.egDbInfo.checkDBType();
            if (string2 != null && !string2.equals("EgMsSqlAdapter")) {
                isOraAdapter = true;
            }
            Class.forName(this.dbDriver).newInstance();
            if (this.password.equals("NULL") || this.password.equals("null") || this.password.equals("none") || this.password.equals("NONE")) {
                this.password = "";
            } else {
                object = new EgCrypt();
                this.password = EgCrypt.decrypt(this.password);
            }
            EgDbRecovery.logToErrorFile("INFO ", entity, this.dbUrl + " " + this.user + " ****");
            if (this.domain == null || this.domain.equals("none")) {
                this.conn = DriverManager.getConnection(this.dbUrl, this.user, this.password);
            } else {
                object = new Properties();
                ((Properties)object).put("user", this.user);
                ((Properties)object).put("password", this.password);
                ((Properties)object).put("domain", this.domain);
                if (this.ntlmV2 != null && this.ntlmV2.equals("true")) {
                    ((Properties)object).put("useNTLMv2", this.ntlmV2);
                }
                this.conn = DriverManager.getConnection(this.dbUrl, (Properties)object);
            }
        }
        catch (Exception exception) {
            this.errorMsg = "Database connection failed ...";
            EgDbRecovery.logToErrorFile("INFO ", entity, this.errorMsg + exception);
            return false;
        }
        return true;
    }

    public static synchronized void logToErrorFile(String string, String string2, String string3) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string4 = egDateInfo.egetDate(false);
        File file = new File(EgConfigInfo.egMgrErrorFile);
        if (file.length() >= 5000000L) {
            EgInstallInfo.fileRename(EgConfigInfo.egMgrErrorFile, EgConfigInfo.egMgrErrorFile + ".1");
        }
        file = null;
        try {
            printWriter = new PrintWriter(new FileWriter(EgConfigInfo.egMgrErrorFile, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string5 = new String(string4 + " " + string + " " + string2 + " " + string3);
        printWriter.println(string5);
        printWriter.close();
    }
}

