/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgCrypt;
import com.eg.EgDbInfo;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class CreateIndex {
    private Connection conn = null;
    private Statement st = null;
    private ResultSet rs = null;
    private String dbType = null;
    private String db_driver = null;
    private String conn_string = null;
    private String db_user = null;
    private String db_password = null;
    private String fileName = null;
    private String fileName_ddd = null;
    private String indexFileName = null;
    private ArrayList indexList = new ArrayList();
    private String dbName = null;
    private String ntlmV2 = null;
    private String query = new String();
    private static boolean b_flag = true;
    private boolean isOracle = false;
    private boolean isMsSql = false;
    private File temp = null;
    private File file = null;
    private BufferedWriter fw;
    ArrayList fileList = new ArrayList();
    private boolean online = true;
    private boolean isOracleAbove10g = false;
    private String prevTableName = "";
    String dbdir = EgInstallInfo.getInstallDir() + "/manager/config/eg_db.ini";
    String egIndexDir = EgInstallInfo.getInstallDir() + "/manager/config/eg_indextables.ini";
    private boolean isSql2005AndAbove = false;
    private boolean isSqlAzureDb = false;
    private boolean isSqlSecondary = false;
    private boolean isSql2k8AndAbove = false;
    private boolean isOrcl9iEntrPrceEdition = false;
    private Hashtable blobDatTypeTableHash = new Hashtable();
    private ArrayList orclIOT_TableList = new ArrayList();
    private String schemaName = "";
    private Hashtable funBasIdxTableHash = new Hashtable();

    public CreateIndex(boolean bl) {
        this.online = bl;
        this.init();
        this.processIndex();
    }

    public CreateIndex() {
        this(true);
    }

    public CreateIndex(String string) {
        try {
            this.online = !string.equalsIgnoreCase("offline");
            this.init();
            this.processIndex();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() {
        IniFile iniFile = new IniFile(this.dbdir);
        this.dbType = iniFile.getValue("DB_PROPERTIES", "DB_Server_Type");
        this.db_driver = iniFile.getValue("DB_PROPERTIES", "sql.driver");
        this.conn_string = iniFile.getValue("DB_PROPERTIES", "sql.url");
        this.db_user = iniFile.getValue("DB_PROPERTIES", "sql.user");
        this.db_password = EgCrypt.decrypt(iniFile.getValue("DB_PROPERTIES", "sql.password")).trim();
        this.ntlmV2 = iniFile.getValue("DB_PROPERTIES", "sql.ntlmv2");
        this.dbName = this.conn_string.substring(this.conn_string.lastIndexOf("/") + 1);
        int n = this.dbName.indexOf(";");
        if (n >= 0) {
            this.dbName = this.dbName.substring(0, n);
        }
        this.indexList = new ArrayList();
        boolean bl = this.setConnection();
        if (!bl) {
            System.err.println("Error in Establishing Database Connection.");
        }
        if (this.dbType.equalsIgnoreCase("EgMsSqlAdapter")) {
            this.indexFileName = new String(EgInstallInfo.getInstallDir() + "/bin/database/mssql");
            this.isOracle = false;
            this.isMsSql = true;
            this.fileName = new String(EgInstallInfo.getInstallDir() + "/bin/database/mssql/total.sql");
            this.fileName_ddd = new String(EgInstallInfo.getInstallDir() + "/bin/database/mssql/dddtotal.sql");
        } else if (this.dbType.equalsIgnoreCase("EgOracleAdapter")) {
            this.indexFileName = new String(EgInstallInfo.getInstallDir() + "/bin/database");
            this.isOracle = true;
            this.isMsSql = false;
            this.fileName = new String(EgInstallInfo.getInstallDir() + "/bin/database/total.sql");
            this.fileName_ddd = new String(EgInstallInfo.getInstallDir() + "/bin/database/dddtotal.sql");
        }
        this.temp = new File(this.indexFileName);
        this.file = new File(this.temp, "indexCreation.sql");
        if (this.file.exists()) {
            this.file.delete();
        }
    }

    private void processIndex() {
        try {
            Object object;
            this.fw = new BufferedWriter(new FileWriter(this.file.getPath()));
            if (this.isOracle) {
                this.isOracleAbove10g = this.getOracleVersion();
            } else {
                this.isSql2005AndAbove = this.getSqlVersion();
                object = new IniFile(this.egIndexDir);
                String string = ((IniFile)object).getValue("INDEX_CONFIG", "RebuildSecondaryIndexOnly");
                if (string == null || string.trim().length() == 0) {
                    string = "false";
                }
                if ((string = string.toLowerCase()) != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
                    this.isSqlSecondary = true;
                }
            }
            if (this.isOracle) {
                this.blobDatTypeTableHash = this.getBlobDatTypeTableList();
                this.orclIOT_TableList = this.getIOTTableList();
                this.funBasIdxTableHash = this.getFuncBasIdxTableList();
            } else {
                this.schemaName = this.getSchemaName();
                if (this.schemaName == null || this.schemaName.length() == 0) {
                    this.schemaName = this.dbName;
                }
            }
            object = this.getAllTableIndexDetails();
            b_flag = this.createIndexOnTables((Hashtable)object);
            this.fw.close();
            this.indexList = null;
            this.fileList = null;
            try {
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.err.println("CreateIndex: Error Creating index queries : " + exception.toString());
            exception.printStackTrace();
            try {
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    private String getPrimaryKeyIndex(String string) {
        String string2;
        String string3 = "";
        string3 = this.isOracle ? "SELECT index_name from USER_INDEXES WHERE TABLE_NAME='" + string + "' and index_name like 'PK%'" : ((string2 = EgDbInfo.getDBVersion()) != null && string2.indexOf("SQL") > -1 && (string2.indexOf("2005") > -1 || string2.indexOf("2000") > -1) ? "SELECT Constraint_Name from information_schema.table_constraints where TABLE_NAME='" + string + "' and constraint_type = 'Primary Key'" : "select name Constraint_Name from sys.indexes where object_id = OBJECT_ID('" + string + "') and is_primary_key =1");
        string2 = "";
        try {
            this.st = this.conn.createStatement();
            ResultSet resultSet = this.st.executeQuery(string3);
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (this.st != null) {
                this.st.close();
                this.st = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                if (this.st != null) {
                    this.st.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return string2;
    }

    private Hashtable getBlobDatTypeTableList() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            try {
                this.st = this.conn.createStatement();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            String string = "select TABLE_NAME,COLUMN_NAME from user_tab_cols where data_type='BLOB'";
            ResultSet resultSet = this.st.executeQuery(string);
            String string2 = "";
            String string3 = "";
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                string3 = resultSet.getString(2);
                if (string2 == null || string2.length() <= 0 || string3 == null || string3.length() <= 0) continue;
                hashtable.put(string2, string3);
            }
        }
        catch (Exception exception) {
            System.err.println("Error: getBlobDatTypeTableList() getting table information " + exception.toString());
            exception.printStackTrace();
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.st != null) {
                    this.st.close();
                    this.st = null;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
        return hashtable;
    }

    private ArrayList getIOTTableList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            try {
                this.st = this.conn.createStatement();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            String string = "Select table_name FROM user_TABLES where IOT_TYPE ='IOT'";
            ResultSet resultSet = this.st.executeQuery(string);
            String string2 = "";
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                if (string2 == null || string2.length() <= 0 || (string2 = string2.trim()).startsWith("SYS_")) continue;
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            System.err.println("Error: getIOTTableList() getting table information " + exception.toString());
            exception.printStackTrace();
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.st != null) {
                    this.st.close();
                    this.st = null;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
        return arrayList;
    }

    private Hashtable getFuncBasIdxTableList() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            try {
                this.st = this.conn.createStatement();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            String string = "select table_name,index_name,index_type from  user_indexes where  index_type like 'FUNCTION-BASED%'";
            ResultSet resultSet = this.st.executeQuery(string);
            String string2 = "";
            String string3 = "";
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                string3 = resultSet.getString(2);
                if (string2 == null || string2.length() <= 0 || string3 == null || string3.length() <= 0) continue;
                hashtable.put(string2, string3);
            }
        }
        catch (Exception exception) {
            System.err.println("Error: getFuncBasIdxTableList() getting table information " + exception.toString());
            exception.printStackTrace();
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.st != null) {
                    this.st.close();
                    this.st = null;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
        return hashtable;
    }

    private Hashtable getAllTableIndexDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            if (this.isOracle) {
                this.query = "select TABLE_NAME, INDEX_NAME, INDEX_TYPE from user_indexes ORDER BY TABLE_NAME,INDEX_NAME DESC";
            } else if (this.isMsSql) {
                this.query = this.isSqlAzureDb ? "select b.name,a.name,a.type_desc from sys.indexes a,sys.objects b  where a.object_id = b.object_id and a.index_id > 0 and a.index_id < 255 and b.type='U' order by b.name" : "select t.name table_name, i.name index_name, i.type_desc index_type from sys.tables t inner join sys.indexes i on t.object_id=i.object_id and t.type='U' order by t.name";
            }
            try {
                this.st = this.conn.createStatement();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            ResultSet resultSet = this.st.executeQuery(this.query);
            String string = "";
            String string2 = "";
            String string3 = "";
            while (resultSet.next()) {
                ArrayList arrayList;
                string = resultSet.getString(1).toUpperCase().trim();
                string2 = resultSet.getString(2);
                string3 = resultSet.getString(3);
                if (string2 != null && string2.length() > 0) {
                    string2 = string2.trim();
                }
                if (this.isMsSql && !this.isSqlAzureDb && string3.equalsIgnoreCase("HEAP")) {
                    if (this.isSqlSecondary || !this.isSql2k8AndAbove) continue;
                    string2 = string;
                }
                if (this.isOracle && this.orclIOT_TableList != null && this.orclIOT_TableList.size() > 0 && this.orclIOT_TableList.contains(string) && string2.startsWith("PK_")) {
                    string2 = string.toUpperCase();
                }
                if (hashtable != null && hashtable.size() > 0) {
                    if (hashtable.containsKey(string)) {
                        arrayList = (ArrayList)hashtable.get(string);
                        arrayList.add(string2);
                        hashtable.put(string, arrayList);
                        continue;
                    }
                    arrayList = new ArrayList();
                    arrayList.add(string2);
                    hashtable.put(string, arrayList);
                    continue;
                }
                arrayList = new ArrayList();
                arrayList.add(string2);
                hashtable.put(string, arrayList);
            }
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (this.st != null) {
                this.st.close();
                this.st = null;
            }
            b_flag = true;
        }
        catch (Exception exception) {
            System.err.println("Error: Create.getAllTableIndexDetails() getting table information " + exception.toString());
            exception.printStackTrace();
            b_flag = false;
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.st != null) {
                    this.st.close();
                    this.st = null;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (this.file.exists()) {
                this.file.delete();
            }
            return null;
        }
        if (this.blobDatTypeTableHash != null && this.blobDatTypeTableHash.size() > 0) {
            hashtable = this.getAlignedIndex(hashtable);
        }
        return hashtable;
    }

    private Hashtable getAlignedIndex(Hashtable hashtable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.blobDatTypeTableHash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            arrayList.add(string);
        }
        if (hashtable != null && hashtable.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                ArrayList arrayList2 = (ArrayList)hashtable.get(string);
                if (arrayList2 == null || arrayList2.size() <= 0) continue;
                String string2 = "";
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (int j = 0; j < arrayList2.size(); ++j) {
                    String string3 = (String)arrayList2.get(j);
                    if (string3.startsWith("SYS_") && string3.indexOf("$$") > -1) {
                        string2 = string3;
                        continue;
                    }
                    if (this.isOracle && j == 1 && !string3.startsWith("PK_")) {
                        arrayList3.add(string2);
                    }
                    arrayList3.add(string3);
                    if (!this.isOracle || !string3.startsWith("PK_")) continue;
                    arrayList3.add(string2);
                }
                hashtable.put(string, arrayList3);
            }
        }
        return hashtable;
    }

    private String getSchemaName() {
        String string = "";
        String string2 = "SELECT SCHEMA_NAME()";
        try {
            this.st = this.conn.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.st.executeQuery(string2);
            while (resultSet.next()) {
                string = resultSet.getString(1).trim();
            }
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (this.st != null) {
                this.st.close();
                this.st = null;
            }
        }
        catch (Exception exception) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (this.st != null) {
                    this.st.close();
                    this.st = null;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return string;
    }

    private ArrayList getAllTables() {
        try {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.isOracle) {
                this.query = "SELECT table_name FROM user_tables WHERE ( TABLE_NAME LIKE '%_TEST'  OR TABLE_NAME LIKE '%_test' OR TABLE_NAME LIKE '%_ex'  OR TABLE_NAME LIKE '%_ag' OR TABLE_NAME LIKE '%_agx'  OR TABLE_NAME LIKE '%_EX' OR TABLE_NAME LIKE '%_DDD' OR TABLE_NAME LIKE '%_ddd')  OR  TABLE_NAME = 'EG_UD_MEASURE'  OR TABLE_NAME = 'eg_ud_measure' OR TABLE_NAME = 'state_hist' OR TABLE_NAME = 'STATE_HIST' OR TABLE_NAME = 'alarm_history_summary' OR TABLE_NAME = 'ALARM_HISTORY_SUMMARY' OR TABLE_NAME = 'err_tbl' OR TABLE_NAME = 'ERR_TBL' OR TABLE_NAME = 'fixtable' OR TABLE_NAME = 'FIXTABLE' OR TABLE_NAME = 'measure_last' OR TABLE_NAME = 'MEASURE_LAST' OR TABLE_NAME = 'websitetransactiontest_last' OR TABLE_NAME = 'WEBSITETRANSACTIONTEST_LAST' OR TABLE_NAME = 'report' OR TABLE_NAME = 'REPORT' OR TABLE_NAME = 'alarm_history' OR TABLE_NAME = 'ALARM_HISTORY'";
            } else if (this.isMsSql) {
                object = EgDbInfo.getDBVersion();
                this.query = object != null && ((String)object).indexOf("SQL") > -1 && (((String)object).indexOf("2005") > -1 || ((String)object).indexOf("2000") > -1) ? "SELECT TABLE_NAME from INFORMATION_SCHEMA.TABLES  where TABLE_TYPE = 'BASE TABLE' AND ( TABLE_NAME LIKE '%_TEST'  OR TABLE_NAME LIKE '%_test' OR TABLE_NAME LIKE '%_ex'  OR TABLE_NAME LIKE '%_EX' OR TABLE_NAME LIKE '%_DDD' OR TABLE_NAME LIKE '%_ddd')   OR  TABLE_NAME = 'EG_UD_MEASURE'  OR TABLE_NAME = 'eg_ud_measure' OR TABLE_NAME = 'state_hist' OR TABLE_NAME = 'STATE_HIST' OR TABLE_NAME = 'alarm_history_summary' OR TABLE_NAME = 'ALARM_HISTORY_SUMMARY' OR TABLE_NAME = 'err_tbl' OR TABLE_NAME = 'ERR_TBL' OR TABLE_NAME = 'fixtable' OR TABLE_NAME = 'FIXTABLE' OR TABLE_NAME = 'measure_last' OR TABLE_NAME = 'MEASURE_LAST' OR TABLE_NAME = 'websitetransactiontest_last' OR TABLE_NAME = 'WEBSITETRANSACTIONTEST_LAST' OR TABLE_NAME = 'report' OR TABLE_NAME = 'REPORT' OR TABLE_NAME = 'alarm_history' OR TABLE_NAME = 'ALARM_HISTORY'" : "SELECT name from sysobjects where xtype='U' AND ( NAME LIKE '%_TEST' OR NAME LIKE '%_test' OR NAME LIKE '%_ex' OR NAME LIKE '%_EX' OR NAME LIKE '%_DDD' OR NAME LIKE '%_ddd') OR  NAME = 'EG_UD_MEASURE' OR NAME = 'eg_ud_measure' OR NAME = 'state_hist' OR NAME = 'STATE_HIST' OR NAME = 'alarm_history_summary' OR NAME = 'ALARM_HISTORY_SUMMARY' OR NAME = 'err_tbl' OR NAME = 'ERR_TBL' OR NAME = 'fixtable' OR NAME = 'FIXTABLE' OR NAME = 'measure_last' OR NAME = 'MEASURE_LAST' OR NAME = 'websitetransactiontest_last' OR NAME = 'WEBSITETRANSACTIONTEST_LAST' OR NAME = 'report' OR NAME = 'REPORT' OR NAME = 'alarm_history' OR NAME = 'ALARM_HISTORY'";
            }
            this.st = this.conn.createStatement();
            object = this.st.executeQuery(this.query);
            while (object.next()) {
                String string = object.getString(1).toUpperCase().trim();
                arrayList.add(string);
            }
            if (object != null) {
                object.close();
                object = null;
            }
            if (this.st != null) {
                this.st.close();
                this.st = null;
            }
            b_flag = true;
            return arrayList;
        }
        catch (Exception exception) {
            System.err.println("Error: Create.GetAllTables() getting table information " + exception.toString());
            exception.printStackTrace();
            b_flag = false;
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.st != null) {
                    this.st.close();
                    this.st = null;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (this.file.exists()) {
                this.file.delete();
            }
            return null;
        }
    }

    private boolean setConnection() {
        try {
            Class.forName(this.db_driver);
            int n = this.db_user.indexOf("\\");
            if (n < 0) {
                n = this.db_user.indexOf("/");
            }
            if (n < 0) {
                this.conn = DriverManager.getConnection(this.conn_string, this.db_user, this.db_password);
            } else {
                String string = this.db_user.substring(0, n);
                String string2 = this.db_user.substring(n + 1);
                Properties properties = new Properties();
                properties.put("user", string2);
                properties.put("password", this.db_password);
                properties.put("domain", string);
                if (this.ntlmV2 != null && this.ntlmV2.equals("true")) {
                    properties.put("useNTLMv2", this.ntlmV2);
                }
                this.conn = DriverManager.getConnection(this.conn_string, properties);
            }
            this.st = this.conn.createStatement();
            return true;
        }
        catch (Exception exception) {
            System.err.println("Problem In DB Connection : " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    private boolean createIndexOnTables(ArrayList arrayList, ArrayList arrayList2) {
        try {
            if (arrayList == null || arrayList.size() == 0) {
                return false;
            }
            block2: for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                if ((string = string.toLowerCase()).endsWith("ex")) {
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        String string2 = (String)arrayList2.get(j);
                        string2 = string2.substring(string2.lastIndexOf(System.getProperty("file.separator")) + 1).toLowerCase().trim();
                        if (!(string2 = string2.substring(0, string2.indexOf("_ex") + 3)).equalsIgnoreCase(string)) continue;
                        b_flag = this.createICIndexOnTable((String)arrayList.get(i), (String)arrayList2.get(j));
                        continue block2;
                    }
                    continue;
                }
                b_flag = this.createIndexOnTable((String)arrayList.get(i));
            }
            return true;
        }
        catch (Exception exception) {
            if (this.file.exists()) {
                this.file.delete();
            }
            return false;
        }
    }

    private boolean createIndexOnTables(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable.get(string);
            try {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n = arrayList.size();
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2;
                    String string3 = (String)arrayList.get(i);
                    if (this.isOracle) {
                        String string4;
                        String string5 = "";
                        if (this.online) {
                            if (!this.isOracleAbove10g) {
                                if (this.isOrcl9iEntrPrceEdition) {
                                    this.arrangeLine("ALTER INDEX " + string3 + " REBUILD ONLINE ");
                                    continue;
                                }
                                this.arrangeLine("ALTER INDEX " + string3 + " REBUILD ");
                                continue;
                            }
                            if (this.orclIOT_TableList != null && this.orclIOT_TableList.size() > 0 && this.orclIOT_TableList.contains(string) && this.blobDatTypeTableHash != null && this.blobDatTypeTableHash.size() >= 0 && !this.blobDatTypeTableHash.containsKey(string)) {
                                if (!this.prevTableName.equalsIgnoreCase(string)) {
                                    this.arrangeLine("ALTER TABLE " + string.toUpperCase() + " SHRINK SPACE CASCADE");
                                } else if (!string3.equalsIgnoreCase(string)) {
                                    this.arrangeLine("ALTER INDEX " + string3 + " SHRINK SPACE");
                                }
                            } else if (this.blobDatTypeTableHash != null && this.blobDatTypeTableHash.size() > 0 && this.blobDatTypeTableHash.containsKey(string) && this.orclIOT_TableList != null && this.orclIOT_TableList.size() > 0 && this.orclIOT_TableList.contains(string)) {
                                if (!this.prevTableName.equalsIgnoreCase(string)) {
                                    this.arrangeLine("ALTER TABLE " + string.toUpperCase() + " SHRINK SPACE CASCADE");
                                }
                                if ((string2 = string3.toUpperCase()).startsWith("SYS_") && string2.indexOf("$$") > -1) {
                                    string4 = (String)this.blobDatTypeTableHash.get(string);
                                    this.arrangeLine("ALTER TABLE " + string.toUpperCase() + " MODIFY LOB (" + string4 + ") (SHRINK SPACE CASCADE)");
                                } else if (!string3.equalsIgnoreCase(string)) {
                                    this.arrangeLine("ALTER INDEX " + string3 + " SHRINK SPACE");
                                }
                            } else if (this.blobDatTypeTableHash != null && this.blobDatTypeTableHash.size() > 0 && this.blobDatTypeTableHash.containsKey(string) && this.orclIOT_TableList != null && (this.orclIOT_TableList.size() == 0 || !this.orclIOT_TableList.contains(string))) {
                                if (!this.prevTableName.equalsIgnoreCase(string)) {
                                    this.fw.write("ALTER TABLE " + string.toUpperCase() + " ENABLE ROW MOVEMENT,");
                                }
                                if ((string2 = string3.toUpperCase()).startsWith("SYS_") && string2.indexOf("$$") > -1) {
                                    string4 = (String)this.blobDatTypeTableHash.get(string);
                                    this.fw.write("ALTER TABLE " + string.toUpperCase() + " MODIFY LOB (" + string4 + ") (SHRINK SPACE CASCADE),");
                                } else {
                                    this.fw.write("ALTER INDEX " + string3 + " SHRINK SPACE,");
                                }
                                if (i == n - 1) {
                                    this.fw.write("ALTER TABLE " + string.toUpperCase() + " DISABLE ROW MOVEMENT;");
                                    this.fw.newLine();
                                }
                            } else if (this.funBasIdxTableHash != null && this.funBasIdxTableHash.size() > 0 && this.funBasIdxTableHash.containsKey(string)) {
                                if (!this.prevTableName.equalsIgnoreCase(string)) {
                                    this.arrangeLine("ALTER TABLE " + string.toUpperCase() + " ENABLE ROW MOVEMENT");
                                }
                                this.arrangeLine("ALTER INDEX " + string3 + " COALESCE");
                                if (i == n - 1) {
                                    this.arrangeLine("ALTER TABLE " + string.toUpperCase() + " DISABLE ROW MOVEMENT");
                                }
                            } else if (!this.prevTableName.equalsIgnoreCase(string)) {
                                this.arrangeLine("ALTER TABLE " + string.toUpperCase() + " ENABLE ROW MOVEMENT");
                                this.arrangeLine("ALTER TABLE " + string.toUpperCase() + " SHRINK SPACE CASCADE");
                                this.arrangeLine("ALTER TABLE " + string.toUpperCase() + " DISABLE ROW MOVEMENT");
                            }
                            this.prevTableName = string;
                            continue;
                        }
                        if (!arrayList2.contains(string)) {
                            string5 = "ALTER TABLE " + string + " MOVE";
                            if (!this.arrangeLine(string5)) {
                                return false;
                            }
                            arrayList2.add(string);
                        }
                        if ((string2 = string3.toUpperCase()).startsWith("SYS_") && string2.indexOf("$$") > -1) {
                            string4 = (String)this.blobDatTypeTableHash.get(string);
                            this.arrangeLine("ALTER TABLE " + string.toUpperCase() + " MODIFY LOB (" + string4 + ") (SHRINK SPACE CASCADE)");
                            continue;
                        }
                        if (this.orclIOT_TableList != null && this.orclIOT_TableList.size() > 0 && this.orclIOT_TableList.contains(string) && string3.equalsIgnoreCase(string)) continue;
                        this.arrangeLine("ALTER INDEX " + string3 + " REBUILD ");
                        continue;
                    }
                    string3 = string3.toUpperCase();
                    boolean bl = false;
                    if (string.equalsIgnoreCase(string3)) {
                        bl = true;
                    }
                    if (!this.online && !this.isSqlAzureDb) {
                        string3 = string;
                    }
                    if (this.indexList.contains(string3)) continue;
                    string2 = "";
                    if (this.online) {
                        if (string3.startsWith("PK_") && this.isSqlSecondary) continue;
                        if (this.isSqlAzureDb) {
                            string2 = "ALTER INDEX " + string3 + " ON " + string.toUpperCase() + " REBUILD WITH (ONLINE = ON);";
                        } else if (this.isSql2005AndAbove) {
                            if (bl) {
                                if (!this.isSql2k8AndAbove) continue;
                                string2 = "ALTER TABLE " + string.toUpperCase() + " REBUILD;";
                            } else {
                                string2 = "ALTER INDEX " + string3 + " ON " + string.toUpperCase() + " REORGANIZE;";
                            }
                        } else {
                            string2 = "DBCC INDEXDEFRAG('" + this.schemaName + "','" + string + "','" + string3 + "');";
                        }
                    } else if (this.isSqlAzureDb) {
                        if (string3.startsWith("PK") && this.isSqlSecondary) continue;
                        string2 = "ALTER INDEX " + string3 + " ON " + string.toUpperCase() + " REBUILD WITH (ONLINE = OFF);";
                    } else if (this.isSql2005AndAbove) {
                        if (bl && this.isSql2k8AndAbove) {
                            this.arrangeLine("ALTER TABLE " + string.toUpperCase() + " REBUILD");
                        }
                        string2 = "ALTER INDEX ALL ON [" + this.schemaName + "].[" + string3 + "] REBUILD WITH (ONLINE=OFF);";
                    } else {
                        string2 = "DBCC DBREINDEX ('" + string + "');";
                    }
                    this.fw.write(string2);
                    this.fw.newLine();
                    this.indexList.add(string3);
                }
            }
            catch (Exception exception) {
                System.err.println("Error in Writng to indexCreation.sql File.");
                exception.printStackTrace();
                if (this.file.exists()) {
                    this.file.delete();
                }
                return false;
            }
        }
        return true;
    }

    private boolean createIndexOnTable(String string) {
        Vector vector;
        String string2 = this.fileName;
        String string3 = "";
        if (string.toLowerCase().endsWith("test_ddd")) {
            string2 = this.fileName_ddd;
        }
        if ((vector = this.getQuery(string2, string)) == null) {
            return true;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < vector.size(); ++i) {
                String string4;
                String string5 = (String)vector.get(i);
                int n = string5.indexOf("/");
                String string6 = string5.substring(0, n);
                String string7 = string5.substring(n + 1);
                if (this.isOracle) {
                    string4 = "";
                    if (this.online) {
                        if (!this.isOracleAbove10g) {
                            string4 = "ALTER INDEX " + string7 + " REBUILD ONLINE  ";
                            if (!arrayList.contains(string6)) {
                                string3 = this.getPrimaryKeyIndex(string6);
                                if (string3 != null && string3.trim().length() > 0) {
                                    this.arrangeLine("ALTER INDEX " + string3 + " REBUILD ONLINE ");
                                }
                                arrayList.add(string6);
                            }
                        } else {
                            if (!this.prevTableName.equalsIgnoreCase(string6)) {
                                this.arrangeLine("ALTER TABLE " + string6.toUpperCase() + " ENABLE ROW MOVEMENT");
                                string4 = "ALTER TABLE " + string6.toUpperCase() + " SHRINK SPACE CASCADE";
                            }
                            this.prevTableName = string6;
                        }
                    } else {
                        if (!arrayList.contains(string6)) {
                            string4 = "ALTER TABLE " + string6 + " MOVE";
                            if (!this.arrangeLine(string4)) {
                                return false;
                            }
                            string3 = this.getPrimaryKeyIndex(string6);
                            if (string3 != null && string3.trim().length() > 0) {
                                this.arrangeLine("ALTER INDEX " + string3 + " REBUILD ");
                            }
                            arrayList.add(string6);
                        }
                        string4 = "ALTER INDEX " + string7 + " REBUILD ";
                    }
                    if (this.arrangeLine(string4)) continue;
                    return false;
                }
                if (!this.online) {
                    string7 = string6;
                }
                if (this.indexList.contains(string7)) continue;
                string4 = "";
                if (this.online) {
                    string3 = this.getPrimaryKeyIndex(string6);
                    if (this.isSqlAzureDb) {
                        if (!this.isSqlSecondary && string3 != null && string3.trim().length() > 0) {
                            this.arrangeLine("ALTER INDEX " + string3 + " ON " + string6.toUpperCase() + " REBUILD WITH (ONLINE = ON)");
                        }
                        string4 = "ALTER INDEX " + string7 + " ON " + string6.toUpperCase() + " REBUILD WITH (ONLINE = ON);";
                    } else if (this.isSql2005AndAbove) {
                        if (!this.isSqlSecondary && string3 != null && string3.trim().length() > 0) {
                            this.arrangeLine("ALTER INDEX " + string3 + " ON " + string6.toUpperCase() + " REORGANIZE");
                        }
                        string4 = "ALTER INDEX " + string7 + " ON " + string6.toUpperCase() + " REORGANIZE;";
                    } else {
                        string4 = "DBCC INDEXDEFRAG('" + this.dbName + "','" + string6 + "','" + string7 + "');";
                    }
                } else if (this.isSqlAzureDb) {
                    if (!this.isSqlSecondary && (string3 = this.getPrimaryKeyIndex(string6)) != null && string3.trim().length() > 0) {
                        this.arrangeLine("ALTER INDEX " + string3 + " ON " + string6.toUpperCase() + " REBUILD WITH (ONLINE = OFF)");
                    }
                    string4 = "ALTER INDEX " + string7 + " ON " + string6.toUpperCase() + " REBUILD WITH (ONLINE = OFF);";
                } else {
                    string4 = "DBCC DBREINDEX ('" + string6 + "');";
                }
                this.fw.write(string4);
                this.fw.newLine();
                this.indexList.add(string7);
            }
        }
        catch (Exception exception) {
            System.err.println("Error in Writng to indexCreation.sql File.");
            exception.printStackTrace();
            if (this.file.exists()) {
                this.file.delete();
            }
            return false;
        }
        return true;
    }

    private boolean createICIndexOnTable(String string, String string2) {
        String string3 = "";
        boolean bl = false;
        Vector vector = this.getQuery(string2, string);
        if (vector != null && vector.size() > 0) {
            bl = this.CreateICIndexFromFile(vector, string);
        }
        if (!bl) {
            if (this.isOracle) {
                if (this.online) {
                    if (!this.isOracleAbove10g) {
                        string3 = "ALTER TABLE PK_" + string.toUpperCase() + " REBUILD ONLINE ";
                        if (!this.arrangeLine(string3)) {
                            return false;
                        }
                        string3 = "ALTER INDEX  IDX_" + string.toUpperCase() + " REBUILD ONLINE ";
                    } else {
                        if (!this.prevTableName.equalsIgnoreCase(string)) {
                            this.arrangeLine("ALTER TABLE " + string.toUpperCase() + " ENABLE ROW MOVEMENT");
                            string3 = "ALTER TABLE " + string.toUpperCase() + " SHRINK SPACE CASCADE";
                        }
                        this.prevTableName = string;
                    }
                } else {
                    string3 = "ALTER TABLE " + string.toUpperCase() + " MOVE";
                    if (!this.arrangeLine(string3)) {
                        return false;
                    }
                    string3 = "ALTER TABLE PK_" + string.toUpperCase() + " REBUILD";
                    if (!this.arrangeLine(string3)) {
                        return false;
                    }
                    string3 = "ALTER INDEX  IDX_" + string.toUpperCase() + " REBUILD ";
                }
                if (!this.arrangeLine(string3)) {
                    return false;
                }
            } else if (this.isMsSql) {
                String string4 = "IDX_" + string.toUpperCase();
                String string5 = "";
                if (this.online) {
                    if (this.isSqlAzureDb) {
                        if (!this.isSqlSecondary) {
                            string5 = "ALTER INDEX PK_" + string.toUpperCase() + " ON " + string.toUpperCase() + " REBUILD WITH (ONLINE = ON)";
                            this.arrangeLine(string5);
                        }
                        string3 = "ALTER INDEX " + string4 + " ON " + string.toUpperCase() + " REBUILD WITH (ONLINE = ON)";
                    } else if (this.isSql2005AndAbove) {
                        if (!this.isSqlSecondary) {
                            string5 = "ALTER INDEX PK_" + string.toUpperCase() + " ON " + string.toUpperCase() + " REORGANIZE";
                            this.arrangeLine(string5);
                        }
                        string3 = "ALTER INDEX " + string4 + " ON " + string.toUpperCase() + " REORGANIZE";
                    } else {
                        string3 = "DBCC INDEXDEFRAG  ('" + this.dbName + "','" + string.toUpperCase() + "','" + string4 + "')";
                    }
                } else if (this.isSqlAzureDb) {
                    if (!this.isSqlSecondary) {
                        string5 = "ALTER INDEX PK_" + string.toUpperCase() + " ON " + string.toUpperCase() + " REBUILD WITH (ONLINE = OFF)";
                        this.arrangeLine(string5);
                    }
                    string3 = "ALTER INDEX " + string4 + " ON " + string.toUpperCase() + " REBUILD WITH (ONLINE = OFF)";
                } else {
                    string3 = "DBCC DBREINDEX  ('" + string.toUpperCase() + "')";
                }
                this.arrangeLine(string3);
            }
        }
        try {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private boolean CreateICIndexFromFile(Vector vector, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.get(i);
                int n = string2.indexOf("/");
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                String string5 = "";
                if (this.isOracle) {
                    if (this.online) {
                        if (!this.isOracleAbove10g) {
                            string5 = "ALTER INDEX  " + string4 + " REBUILD ONLINE ";
                        } else {
                            if (!this.prevTableName.equalsIgnoreCase(string3)) {
                                this.arrangeLine("ALTER TABLE " + string3.toUpperCase() + " ENABLE ROW MOVEMENT");
                                string5 = "ALTER TABLE " + string3.toUpperCase() + " SHRINK SPACE CASCADE";
                            }
                            this.prevTableName = string3;
                        }
                    } else {
                        string5 = "ALTER TABLE " + string3 + " MOVE";
                        if (!this.arrangeLine(string5)) {
                            return false;
                        }
                        string5 = "ALTER INDEX  " + string4 + " REBUILD ";
                    }
                    if (this.arrangeLine(string5)) continue;
                    return false;
                }
                if (!this.isMsSql || this.indexList.contains(string4)) continue;
                if (this.online) {
                    string5 = this.isSqlAzureDb ? "ALTER INDEX " + string4 + " ON " + string3.toUpperCase() + " REBUILD WITH (ONLINE = ON);" : (this.isSql2005AndAbove ? "ALTER INDEX " + string4 + " ON " + string3.toUpperCase() + " REORGANIZE;" : "DBCC INDEXDEFRAG  ('" + this.dbName + "','" + string3.toUpperCase() + "','" + string4 + "');");
                } else {
                    if (arrayList.contains(string3.toUpperCase())) continue;
                    string5 = this.isSqlAzureDb ? "ALTER INDEX " + string4 + " ON " + string3.toUpperCase() + " REBUILD WITH (ONLINE = OFF);" : "DBCC DBREINDEX   ('" + string3.toUpperCase() + "');";
                    arrayList.add(string3.toUpperCase());
                }
                this.fw.write(string5);
                this.fw.newLine();
                this.indexList.add(string4);
            }
        }
        catch (Exception exception) {
            System.err.println("Error in Writng to indexCreation.sql File.");
            if (this.file.exists()) {
                this.file.delete();
            }
            return false;
        }
        return true;
    }

    private Vector getQuery(String string, String string2) {
        String string3 = "";
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        try {
            if (!(this.fileList.size() != 0 && this.fileList.get(0) == string || (bl = this.loadFile(string)))) {
                return null;
            }
            if (string2 != null) {
                string2 = string2.toUpperCase();
            }
            for (int i = 1; i < this.fileList.size(); ++i) {
                string3 = (String)this.fileList.get(i);
                int n = (string3 = string3.toUpperCase()).indexOf(" " + string2);
                if (n <= -1) continue;
                int n2 = string3.indexOf("IDX");
                int n3 = string3.indexOf(" ", n2);
                String string4 = string3.substring(n2, n3).trim();
                n2 = n + 1;
                n3 = string3.indexOf("(", n2);
                String string5 = string3.substring(n2, n3).trim();
                vector.add(string5 + "/" + string4);
            }
        }
        catch (Exception exception) {
            System.out.println("problem " + string3);
            exception.printStackTrace();
        }
        return vector;
    }

    private boolean createIndexNow(String string) {
        string = string.substring(0, string.length() - 1);
        try {
            this.st = this.conn.createStatement();
            boolean bl = this.st.execute(string);
            if (bl) {
                // empty if block
            }
            return true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 955) {
                SQLException sQLException2;
                while (sQLException2 != null) {
                    System.out.println("Message: " + sQLException2.getMessage());
                    System.out.println("SQLState: " + sQLException2.getSQLState());
                    System.out.println("ErrorCode: " + sQLException2.getErrorCode());
                    sQLException2 = sQLException2.getNextException();
                }
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean loadFile(String string) {
        BufferedReader bufferedReader = null;
        String string2 = "";
        String string3 = "";
        this.fileList.clear();
        this.fileList.add(string);
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (Exception exception) {
            System.out.println("Error in Reading File.");
            if (this.file.exists()) {
                this.file.delete();
            }
            return false;
        }
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                string3 = string3 + " " + string2;
                if ((string3 = string3.toUpperCase().trim()).indexOf(";") <= -1) continue;
                int n = string3.indexOf("CREATE ");
                int n2 = string3.indexOf(" INDEX ");
                int n3 = string3.indexOf(" ON ");
                if (n > -1 && n2 > -1 && n3 > -1) {
                    this.fileList.add(string3);
                }
                string3 = "";
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            bufferedReader = null;
            return true;
        }
        catch (Exception exception) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            bufferedReader = null;
            System.out.println("Error in loading total.sql");
            if (this.file.exists()) {
                this.file.delete();
            }
            return false;
        }
    }

    private ArrayList getFiles() {
        File file = new File(EgInstallInfo.getInstallDir() + "/bin/database");
        String string = "MsSql";
        string = this.isOracle ? "Oracle" : "MsSql";
        try {
            File[] fileArray = file.listFiles();
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = "";
            int n = 0;
            for (int i = 0; i < fileArray.length; ++i) {
                String string3;
                int n2;
                string2 = fileArray[i].getPath();
                if (fileArray[i].isDirectory() || (n2 = (string3 = fileArray[i].getName().substring(0, fileArray[i].getName().lastIndexOf(".")).trim()).lastIndexOf("_")) <= -1) continue;
                String string4 = string3.substring(n2 - 2, n2);
                String string5 = string3.substring(n2 + 1, string3.length());
                if (!string4.equalsIgnoreCase("ex") || !string5.equalsIgnoreCase(string)) continue;
                arrayList.add(n++, string2);
            }
            return arrayList;
        }
        catch (Exception exception) {
            System.err.println("Error in retrieving the SQL Files Specific to IC thresh : " + exception);
            if (file.exists()) {
                file.delete();
            }
            return null;
        }
    }

    private boolean arrangeLine(String string) {
        if (string.length() > 0) {
            String string2 = string.trim() + ";";
            int n = 0;
            int n2 = 0;
            n = string2.indexOf("(");
            if (n > -1 && string2.indexOf(" MODIFY LOB ") == 0) {
                while (n > -1) {
                    String string3 = string2.substring(n2, n + 1);
                    try {
                        this.fw.write(string3);
                        String string4 = string2.substring(n + 1);
                        if (string4.equals(";")) {
                            this.fw.write(string4);
                        }
                        this.fw.newLine();
                    }
                    catch (Exception exception) {
                        System.out.println("Error in Writng to indexCreation.sql File.");
                        if (this.file.exists()) {
                            this.file.delete();
                        }
                        return false;
                    }
                    if ((n = (string2 = string2.substring(n + 1)).indexOf(",")) > -1 || (n = string2.indexOf(")")) <= -1) continue;
                }
            } else {
                try {
                    this.fw.write(string2);
                    this.fw.newLine();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return true;
    }

    private void writeToFile(String string, String string2) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new FileWriter(string, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open  file = " + string);
            return;
        }
        printWriter.println();
        printWriter.println(string2);
        printWriter.close();
    }

    public static void main(String[] stringArray) {
        System.setProperty("jsse.enableCBCProtection", "false");
        try {
            if (stringArray != null && stringArray.length == 1) {
                CreateIndex createIndex = new CreateIndex(stringArray[0]);
            } else {
                System.out.println("Enter your Choice of Index Creation offline or online [DEFAULT:Online] : ");
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = bufferedReader.readLine().trim();
                if (string == null) {
                    System.err.println("Invalid Input ");
                } else {
                    string = string.trim();
                    CreateIndex createIndex = new CreateIndex(string);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR: " + exception.toString());
        }
    }

    private boolean getOracleVersion() {
        String string = "select version from v$instance";
        String string2 = "";
        ResultSet resultSet = null;
        try {
            this.st = this.conn.createStatement();
            resultSet = this.st.executeQuery(string);
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (this.st != null) {
                this.st.close();
                this.st = null;
            }
            if ((string2 = string2.toUpperCase()).startsWith("6") || string2.startsWith("7") || string2.startsWith("8") || string2.startsWith("9")) {
                this.st = this.conn.createStatement();
                resultSet = this.st.executeQuery("select banner from v$version");
                if (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    if ((string3 = string3.toLowerCase()).indexOf("enterprise") > -1) {
                        this.isOrcl9iEntrPrceEdition = true;
                    }
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (this.st != null) {
                    this.st.close();
                    this.st = null;
                }
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (this.st != null) {
                    this.st.close();
                }
                return false;
            }
            catch (Exception exception2) {
                return false;
            }
        }
    }

    private boolean getSqlVersion() {
        String string = "select @@version";
        String string2 = "";
        ResultSet resultSet = null;
        try {
            this.st = this.conn.createStatement();
            resultSet = this.st.executeQuery(string);
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (this.st != null) {
                this.st.close();
                this.st = null;
            }
            if ((string2 = string2.toUpperCase()).startsWith("MICROSOFT SQL AZURE") || string2.indexOf("AZURE") > -1) {
                this.isSqlAzureDb = true;
                return true;
            }
            if (string2.startsWith("MICROSOFT SQL SERVER  7.00") || string2.startsWith("SQL SERVER 2000") || string2.startsWith("MICROSOFT SQL SERVER 2000")) {
                return false;
            }
            if (!string2.startsWith("SQL SERVER 2005") || !string2.startsWith("MICROSOFT SQL SERVER 2005")) {
                this.isSql2k8AndAbove = true;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (this.st != null) {
                    this.st.close();
                }
                return false;
            }
            catch (Exception exception2) {
                return false;
            }
        }
    }
}

