﻿
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

$testargs=$args

$reportingname='EXO\'  +$testargs[0]
$lastTime=$testargs[1]
$lastTime=$lastTime.Replace('_',' ')
 try{  
    $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
    $DateFormat = $CultureDateTimeFormat.ShortDatePattern
    $TimeFormat = $CultureDateTimeFormat.LongTimePattern
    $DateTimeFormat = "$DateFormat $TimeFormat"

    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "dlpdetails" -keyFileName "kdlpdetails" -EgPath $egurkhaPath
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $csvfile =Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    $alogFile= import-csv $csvfile
    Remove-Item $csvfile
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'dlpdetails' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kdlpdetails' -InputFile $readfiles[4]
    Write-Host 'ReadFile:'$readfiles[3]
    }
    catch [System.Management.Automation.RuntimeException] {
        Write-Error -Message "File not found. The $reportingname location does not contain dlpdetails files."
    }
    catch{
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }
    $dlphits= New-Object System.Collections.ArrayList
    $sndadd = New-Object System.Collections.ArrayList
    $recadd = New-Object System.Collections.ArrayList

    $alogFile=  $alogFile  | Sort-Object { [DateTime]::ParseExact($_.'CreationDate',$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)}  -Descending
	$LastDatedlp=$alogFile|select -Property CreationDate -First 1   

	if($alogFile -ne $null){ 
	    foreach($log in $alogFile){
        $entryflg=$false
            if($lastTime -ne $null -and $lastTime -ne '' -and $lastTime -ne 'none'){               
                $logDate = [DateTime]::ParseExact($log.CreationDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
                $prevTime = [DateTime]::ParseExact($lastTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
                if($logDate -gt $prevTime){
                    $entryflg=$true
                }
            }
            else{
                $entryflg=$true
            }
            if($entryflg){
                $data= $log.AuditData | ConvertFrom-Json
		try{
			$dlphits.Add($data.CreationTime +'~!~'+$data.Operation  +'~!~'+$data.ExchangeMetaData.BCC +'~!~'+ $data.ExchangeMetaData.CC +'~!~'+$data.ExchangeMetaData.From+'~!~'+$data.ExchangeMetaData.To +'~!~'+$data.ExchangeMetaData.RecipientCount+'~!~'+$data.ExchangeMetaData.Sent +'~!~'+$data.ExchangeMetaData.Subject +'~!~'+$data.UserType+'~!~'+$data.PolicyDetails.PolicyName+'~!~'+$data.PolicyDetails.Rules.Actions+'~!~'+ $data.PolicyDetails.Rules.ConditionsMatched.OtherConditions.Name +'~!~'+$data.PolicyDetails.Rules.ConditionsMatched.SensitiveInformation.Confidence +'~!~'+$data.PolicyDetails.Rules.ConditionsMatched.SensitiveInformation.Count+'~!~'+$data.PolicyDetails.Rules.ConditionsMatched.SensitiveInformation.Location +'~!~'+$data.PolicyDetails.Rules.ConditionsMatched.SensitiveInformation.SensitiveType+'~!~'+$data.PolicyDetails.Rules.ConditionsMatched.SensitiveInformation.UniqueCount+'~!~'+$data.PolicyDetails.Rules.RuleMode +'~!~'+$data.PolicyDetails.Rules.RuleName +'~!~'+$data.PolicyDetails.Rules.Severity+'~!~'+$data.UserID+'~!~'+$data.ExchangeMetaData.MessageID)
		}catch{
			$dlphits.Add($data.CreationTime +'~!~'+$data.Operation  +'~!~'+$data.ExchangeMetaData.BCC +'~!~'+ $data.ExchangeMetaData.CC +'~!~'+$data.ExchangeMetaData.From+'~!~'+$data.ExchangeMetaData.To +'~!~'+$data.ExchangeMetaData.RecipientCount+'~!~'+$data.ExchangeMetaData.Sent +'~!~'+$data.ExchangeMetaData.Subject +'~!~'+$data.UserType+'~!~'+$data.PolicyDetails.PolicyName+'~!~'+$data.PolicyDetails.Rules.Actions+'~!~'+ '-' +'~!~'+'-'+'~!~'+'-'+'~!~'+'-'+'~!~'+'-'+'~!~'+'-'+'~!~'+$data.PolicyDetails.Rules.RuleMode +'~!~'+$data.PolicyDetails.Rules.RuleName +'~!~'+$data.PolicyDetails.Rules.Severity+'~!~'+$data.UserID+'~!~'+$data.ExchangeMetaData.MessageID)
		}
                $sender=$data.ExchangeMetaData.From.Split(" ")
		        $Recv  =$data.ExchangeMetaData.To.Split(" ")
		        foreach($snd in $sender){
			        if($sndadd -notcontains $snd){
			            $sndadd.Add($snd)
			        }
		        }
		        foreach($Rec in $Recv){
			        if($recadd -notcontains $Rec){
			            $recadd.Add($Rec)
			        }
		        }
            }
		    }
clear

Write-Host 'ComplianceDLPExchangecnt'$dlphits.Count '~'$sndadd.Count'~'$recadd.Count
            foreach($dlphit in $dlphits){
		           Write-Host 'DlpDetect' $dlphit
	        }		    
            foreach($snd in $sndadd){
		           Write-Host 'Send'$snd
		    }
		    foreach($rec in $recadd){
		           Write-Host 'Recv'$rec
		    }
	    Write-Host 'LastDate:'$LastDatedlp.CreationDate.Replace(' ','_')
	    }
	else
	  {
	    Write-Host 'ComplianceDLPExchangecnt0~0~0'
	  }
