﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear

$testargs=$args
$reportingname='EXO\'+$testargs[0]
$ExcludingNames=$testargs[1]

$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value

Function Get-MailStatsFile{
    $readfiles1=Eg-ReadFile -ComntRptPath $reportingname -FileName "statsmailbox" -keyFileName "kstatsmailbox" -EgPath $egurkhaPath
    if((Get-Item $readfiles1[1]).length -le 2kb){
        Remove-Item $readfiles1[1]
        Get-MailStatsFile
    }
    else{
        return $readfiles1
    }
}

$readMBS=Get-MailStatsFile
$mbsFileNam=$readMBS[1] -replace (".csv",".dat") 
Write-Host $readMBS[1]
$csvDatas=Unprotect-File $mbsFileNam -Algorithm AES -KeyAsPlainText $readMBS[0]	
$mbStatReports= import-csv $csvDatas
Remove-Item $csvDatas
$mailStats=$mbStatReports | select -First 1
#$isPreviousScript=[bool]($mailStats.PSobject.Properties.name -match "PrimarySmtpAddress")
<#
if($isPreviousScript){
    $ErrorCount=0
    $readfiles=0
    $readfiles1=0
    try{   
        $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "mailbox" -keyFileName "kmailbox" -EgPath $egurkhaPath
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
        $TotMailbxcnt= import-csv $csvfile
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'mailbox' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kmailbox' -InputFile $readfiles[4]
    }
    catch [System.Management.Automation.RuntimeException] {
	    $ErrorCount++	
        Write-Error -Message "File not found. The $reportingname location does not contain mailbox files."
    }
    catch{
    $ErrorCount++
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }

    try{   
        $readfiles1=Get-MailStatsFile  #Eg-ReadFile -ComntRptPath $reportingname -FileName "statsmailbox" -keyFileName "kstatsmailbox" -EgPath $egurkhaPath
        $datafile1=$readfiles1[1] -replace (".csv",".dat") 
        $csvfile1=Unprotect-File $datafile1 -Algorithm AES -KeyAsPlainText $readfiles1[0]	
        $MailStatReport= import-csv $csvfile1
        Remove-Item $csvfile1
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'statsmailbox' -InputFile $readfiles1[3]
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'kstatsmailbox' -InputFile $readfiles1[4]
    }
    catch [System.Management.Automation.RuntimeException] {
    $ErrorCount++
        Write-Error -Message "File not found. The $reportingname location does not contain statsmailbox files."
        $MailStatReport= $null
    }
    catch{
    $ErrorCount++
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }

    if( $MailStatReport -eq $null -or  $MailStatReport -eq ''){
        write-host "#TotMailbxcnt~-5"   
        write-host "#DbSndQte~-5" 
        write-host "#DbSndRecQte~-5" 
        Write-host '#MailbxOverQte~-5'
        write-host "#TotMailbxSize~-5" 
        write-host "#inactivecnt~-5" 
        write-host "#inactiveMailbxSize~-5" 
        Write-Host '#Arrcnt~-5'
        Write-Host '#Arrmailbxsize~-5'
        Write-Host '#ClutterEnabledcnt~-5'
        Write-Host '#ClutterDisabledcnt~-5'
        Write-Host '#ArchiveWarnMailscnt~-5'
        exit
    }
    Write-Host 'ReadFile:'$readfiles[3]','$readfiles1[3]

	$inactivecnt=0
	$Arrcnt=0
	$ClutterEnabledcnt=0
	$ClutterDisabledcnt=0
	$inactiveMailbxSize=0
	$SendQte=0
	$SendRecvQte=0
	$MailbxOverQte=0
	$Arrmailbxsize=0
	$TotMailbxSize=0
	$inact=0
    $ArrWarnMailcnt=0
    $ArchiveMailboxMap=@{}
    $ArchiveWarnMailboxsMap=@{}
    if($ErrorCount -eq 0){
	    $TotMailbxcnt= $TotMailbxcnt|where {$ExcludingNames -notcontains $_.DisplayName}
	    $MailStatReport=$MailStatReport|where {$ExcludingNames -notcontains $_.DisplayName}
	    $inactive=$TotMailbxcnt|Where{$_.WasInactiveMailbox -eq $true}|Select *
	    $ShrdMailboxes = $TotMailbxcnt|Where{$_.RecipientTypeDetails -eq 'SharedMailbox'}|Select *
	    $litigationhold=$TotMailbxcnt|Where{$_.LitigationHoldEnabled -eq $true}|Select *
	    $FrwdMailbx=$TotMailbxcnt|Where{$_.DeliverToMailboxAndForward -eq $true}|Select *
	    $Inplacehold=$TotMailbxcnt|Where{$_.InPlaceHolds -eq $true -and $_.InPlaceHolds -notcontains ' '}|Select *
	    foreach($Measures in $TotMailbxcnt){
		    $StatReport= $MailStatReport| Where {$_.PrimarySMTPAddress -eq $Measures.PrimarySmtpAddress }|Select PrimarySMTPAddress,IsArchiveMailbox,IsClutterEnabled,TotalItemSize,DatabaseIssueWarningQuota,DisplayName,ItemCount,DatabaseProhibitSendQuota,DatabaseProhibitSendReceiveQuota
            if($StatReport -ne $null) {
	            if($Measures.ArchiveStatus -eq 'Active'){
		            $Arrcnt++;
		            $repTot=[String]$StatReport.TotalItemSize
		            $resBytes= $repTot.Split('(')[1].Split(' ')
		            $Arrmailbxsize+=[double]$resBytes[0].Trim()
		            $ArchiveSize=[math]::round([double]$resBytes[0] /1Gb, 4)
		            $ArchiveQuota=[double]($Measures.ArchiveQuota).Split(' ')[0]
		            $ArchivewarnQuota=[double]($Measures.ArchiveWarningQuota).Split(' ')[0]
		            $ArchiveMailboxSize=[math]::round([double]$resBytes[0] /1Gb, 4)
		            $ddstng= $Measures.Name +'~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ '+ $Measures.ArchiveName +'~!~'+$Measures.ArchiveState +'~!~'+$ArchiveMailboxSize.tostring("#.##").replace(',','.') +'~!~'+$ArchiveQuota+'~!~'+$ArchivewarnQuota
		            $ArchiveMailboxMap[$ArchiveMailboxSize]=$ddstng
	                if($ArchiveMailboxSize -gt $ArchivewarnQuota){
	                $ArrWarnMailcnt++
	                $ArchiveWarnMailboxsMap[$ArchiveMailboxSize]=$ddstng           
	                }           
		        }
		        if($StatReport.IsClutterEnabled -eq $true){
		            $ClutterEnabledcnt++;
		        }
		        else{
		            $ClutterDisabledcnt++;
		        }

	            #Total MailBox Size
		        if($StatReport.TotalItemSize -ne $null){
		            $repOvrall=$StatReport.TotalItemSize
		            $restotBytes= $repOvrall.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
		            $TotMailbxSize+=[double]$restotBytes

	                #MailBox Over Quota
		            $DbWarn=[String]$Measures.IssueWarningQuota
    	            $DbWarnBytes= $DbWarn.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
                    if([double]$restotBytes -ge [double]$DbWarnBytes){
			            $MailbxOverQte++;
			            write-host " #ddOverWarning " $StatReport.DisplayName '~!~'  $Measures.UserPrincipalName '~!~' $StatReport.ItemCount '~!~'  $StatReport.totalItemSize  '~!~' $Measures.IssueWarningQuota  '~!~-~!~-'
		            }
		        }

                #MailBox Send Over Quota 
		        $SendQuota=[String]$Measures.ProhibitSendQuota
    	        $SendQuotaBytes= $SendQuota.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
		        if([double]$restotBytes -ge [double]$SendQuotaBytes){
			        $SendQte++;
			        write-host " #ddSendOverWarning " $StatReport.DisplayName '~!~'  $Measures.UserPrincipalName '~!~' $StatReport.ItemCount '~!~'  $StatReport.totalItemSize  '~!~-~!~' $Measures.ProhibitSendQuota '~!~-'
		        }
	
                #MailBox Send/recv Over Quota
		        $SendRecvQuota=[String]$Measures.ProhibitSendReceiveQuota
    	        $SendRecvQuotaBytes= $SendRecvQuota.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
		        if([double]$restotBytes -ge [double]$SendRecvQuotaBytes){
			        $SendRecvQte++;
			        write-host " #ddSendRecvOverWarning " $StatReport.DisplayName '~!~'  $Measures.UserPrincipalName '~!~' $StatReport.ItemCount '~!~'  $StatReport.totalItemSize  '~!~-~!~-~!~' $Measures.ProhibitSendReceiveQuota
		        }

                #Inactive MailBox Size

		        if($Measures.WasInactiveMailbox -eq $true){
                    $inactivecnt++
			        $inactSize=[String]$StatReport.TotalItemSize
			        $restotBytes= $inactSize.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
			        $inactiveMailbxSize+=[double]$restotBytes
		        }
	        }
        }

        foreach ( $in in $ArchiveMailboxMap.GetEnumerator() | sort -Property key  -Descending | select -first 10){
    	    Write-host '#ddArchivemails' $in.Value
        }

        foreach ( $in in $ArchiveWarnMailboxsMap.GetEnumerator() | sort -Property key  -Descending ){
    	    Write-host '#ddArchiveWarnMails' $in.Value
        }

	    $TotMailbxSize=[math]::round($TotMailbxSize /1Gb, 4)
	    $Arrmailbxsize=[math]::round($Arrmailbxsize /1Gb, 4)
		
	    # Top 10 Size DD
	    $ddlineMailbox= $MailStatReport| Select-Object DisplayName, @{name=”TotalItemSize_mb”;expression={[math]::Round((($_.TotalItemSize).Split(“(“)[1].Split(” “)[0].Replace(“,”,””)/1GB),4)}},PrimarySmtpAddress, ItemCount ,totalItemSize,DatabaseIssueWarningQuota,DatabaseProhibitSendQuota,DatabaseProhibitSendReceiveQuota | Sort-Object “TotalItemSize_mb” -Descending

	    For ($i=0; $i -lt 10; $i++) {
		    $ddline=$ddlineMailbox[$i]
			if($ddline -ne $null){
                $mailbx=$TotMailbxcnt | Where {$_.PrimarySMTPAddress -eq $Measures.PrimarySmtpAddress }|Select IssueWarningQuota,ProhibitSendQuota,ProhibitSendReceiveQuota
			    Write-Host  '#ddTop10Size '$ddline.DisplayName  '~!~' $ddline.ItemCount '~!~' $ddline.TotalItemSize_mb  '~!~' $mailbx.IssueWarningQuota.ToString().Split(" ")[0]  '~!~' $mailbx.ProhibitSendQuota.ToString().Split(" ")[0] '~!~' $mailbx.ProhibitSendReceiveQuota.ToString().Split(" ")[0]
			}
	    }
	
        #Inactive Measure DD
	    if($inactive -ne $null){
		    foreach($inact in $inactive){
		        $inactivecnt++
		        Write-Host '#ddinactive '$inact.DisplayName '~!~' $inact.PrimarySmtpAddress '~!~'$inact.WhenSoftDeleted
		    }
        }
    }
    #write-host "#TotMailbxcnt~" $TotMailbxcnt.Count
	write-host "#DbSndQte~" $SendQte
	write-host "#DbSndRecQte~" $SendRecvQte
	Write-host '#MailbxOverQte~'$MailbxOverQte
	write-host "#TotMailbxSize~" $TotMailbxSize.tostring("#.##").replace(',','.')
	write-host "#inactivecnt~" $inactivecnt
	write-host "#inactiveMailbxSize~" $inactiveMailbxSize.tostring("#.##").replace(',','.')
	Write-Host '#Arrcnt~' $Arrcnt
	Write-Host '#Arrmailbxsize~' $Arrmailbxsize.tostring("#.##").replace(',','.')
	Write-Host '#ClutterEnabledcnt~' $ClutterEnabledcnt
	Write-Host '#ClutterDisabledcnt~' $ClutterDisabledcnt
    Write-Host '#ArchiveWarnMailscnt~' $ArrWarnMailcnt
}
#>
#else{        
        $totMailBxSiz=0;$top10cnt=0;
        $iwarnQuotaCnt=0;$iwqCnt=0;
        $inActMBCnt=0;$iaCnt=0;
        $inactivMBSiz=0;
        $prohbtSndQuotaCnt=0;
        $prohbtSndRecvQCnt=0;
        $mbStatReports|Where-Object {$_.IsDeleted -eq $false}|Sort-Object{ $_.StorageUsed -as [Long] } -Descending  | ForEach-Object{
            $totMailBxSiz+=$_.StorageUsed
            if($top10cnt -lt 10){
                $top10cnt++
                $top10DD='#ddTop10Size '+$_.DisplayName+'~!~'+$_.ItemCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.IssueWarningQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.ProhibitSendQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.'ProhibitSend/ReceiveQuota'/(1024*1024*1024)),2)
                Write-Host $top10DD
            }

            if([long]$_.StorageUsed -ge [long]$_.IssueWarningQuota){
                $iwarnQuotaCnt++
                if($iwqCnt -lt 10){
                    $iwqCnt++
                    $iwqDD='#ddOverWarning '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~'+$_.ItemCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.IssueWarningQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.ProhibitSendQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.'ProhibitSend/ReceiveQuota'/(1024*1024*1024)),2)+'~!~-~!~-'
                    Write-Host $iwqDD
                }
            }

            if([long]$_.StorageUsed -ge [long]$_.ProhibitSendQuota){
                $prohbtSndQuotaCnt++
            }
            if([long]$_.StorageUsed -ge [long]$_.'ProhibitSend/ReceiveQuota'){
                $prohbtSndRecvQCnt++
            }       
        }

        $mbStatReports|Sort-Object{ $_.LastActivityDate -as [DateTime] } | ForEach-Object{
            if($_.LastActivityDate -ne $null -and $_.LastActivityDate -ne ''){
                $tDat=(Get-Date).AddDays(-30)
                $ldat=[String]($_.LastActivityDate)
                $lstActDat=[DateTime]$ldat.Trim()
                if($lstActDat -lt $tDat){
                    $inActMBCnt++
                    $inactivMBSiz+=$_.StorageUsed
                    if($iaCnt -lt 10){
                        $iaCnt++
                        if($_.IsDeleted -eq $true){
                            $inactivDD='#ddinactive '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~'+$_.DeletedDate
                        }else{
                            $inactivDD='#ddinactive '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~-'
                        }
                        Write-Host $inactivDD
                    }
                }
            }
        }

        $totMailBxSiz=[math]::Round(($totMailBxSiz/(1024*1024*1024)),2)
        write-host "#TotMailbxSize~"$totMailBxSiz
        Write-host '#MailbxOverQte~'$iwarnQuotaCnt
        write-host "#inactivecnt~"$inActMBCnt
        $inactivMBSiz=[math]::Round(($inactivMBSiz/(1024*1024*1024)),2)
        write-host "#inactiveMailbxSize~"$inactivMBSiz
        Write-Host '#Arrcnt~-5'
	    Write-Host '#Arrmailbxsize~-5'
	    Write-Host '#ClutterEnabledcnt~-5'
	    Write-Host '#ClutterDisabledcnt~-5'
        write-host "#DbSndQte~"$prohbtSndQuotaCnt
		write-host "#DbSndRecQte~"$prohbtSndRecvQCnt
        Write-Host '#ArchiveWarnMailscnt~-5'
#}

# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUYew2JW1R6RJakODs9Gs6+Ud/
# Hh6ggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUn8wsajiHajmTIxeWW+lnM/d3
# 1oEwDQYJKoZIhvcNAQEBBQAEggEAIpnmA+HtdXaYINTIXnbStWefwugUKrXdFCMk
# okvq6TFmT+t/ADH4I0AN3RoS9AcT5uXamfD/NgDhEU2gtOnVJWPNcjOfoViYEw1z
# +Zylrk4pQqo+mjh2SiOLK7PPWbA5SPq4KvOxNUDJsRKXZQCbTWKpCWH8yL/ZSTkW
# rx88DIiCnrB/56LHvOQL2OnW0rRNfYkvv0dQLOkHiITQoqVHQPQoKHqCIstF/BNK
# bexGIkQ1vtWrZ81EH+jcciCADvEwjYx7E1DGm/MPLQMwFYkfAPGgFkPxGdSd37dz
# IIhdwzK3quqAnU8IR940TG5dsLMBy4BaO3H63lAvFkupK+5S+qGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwNzIzMDIwMzU3WjAjBgkqhkiG9w0BCQQxFgQU7+Fpb+M7eI9tnF9/tMAd
# 3erWlXYwDQYJKoZIhvcNAQEBBQAEggEAJ0iczqA3fP15j8zUKK1Q+TUHpBH0rBvn
# 16Zkz4iTRF9ybnWoVvqCahCBV2Jf0ydHZzckPsDoauSJCmor2OpP99RYsUzb3R0d
# 4ymba8nzqeohzk19rGdmPSd8XFOC8G5Pt/z3kqXMoNgcHD1s8UR20WTqiXU6gCH5
# 6WLKEYUcMOw5WuQP5OjNy4zkpbcjFvnhGzSPMDB1iT6c1DY+crFUQo6TQywgGDAe
# zFe3K6nCRRSolNCC1OyLxnvIRFP6kVpaalj6Ek1m0rgPoUTcTOZihMpkOIqolu0a
# NyVDt5gWexuywRNOhWS2EbKjFyi6k5w9gIaY/DtmMwzO1cTgTddB3w==
# SIG # End signature block
