﻿##/*********************************************************************************************
##Author                :  Guravareddy T
##Purpose               : It is the base script for some SBO tests and it will get skype call sessions data of all users in the domain and save the data
##Created               :  11/08/2018
##Modified By		    :
##reference link        :(https://msconfiggallery.cloudapp.net/packages/CxdCallData/1.2.2.0/Content/CxdCallData.psm1)
                         #(https://gallery.technet.microsoft.com/Get-CSUserSessionDomains-c8b0257c)

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$egurkhaPath+'\lib\EGFileEncryption.psm1'
$egDatnKy=$egurkhaPath+'\lib\GetDatnKeyFiles.psm1'
Import-Module $egEncryPath,$egDatnKy

$testargs=$args
$userName=$testargs[0]
$Password=Eg-O365Dcr -EncStr $testargs[1]
$prxycrdlsServer=($testargs[2]).ToString().Split("#")
$proxyUsr=$prxycrdlsServer[0]
$proxyPass=Eg-O365Dcr -EncStr $prxycrdlsServer[1]
$proxyserverip=$prxycrdlsServer[2]
$rNamefreq=$testargs[3]
$rptnamefrq=$rNamefreq.split('#')
$rName=$rptnamefrq[0]
$Testfreqency=$rptnamefrq[1]
$overrideUri=$testargs[4]
$rptPath='SBO\'+$rName

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
$wratSyallsessions=Eg-WriteFile -ComntRptPath $rptPath -FileName "Syallsessions" -keyFileName "kSyallsessions" -EgPath $egurkhaPath
$wratMycalFeedBack=Eg-WriteFile -ComntRptPath $rptPath -FileName "SyRatMycalFeedBack" -keyFileName "kSyRatMycalFeedBack" -EgPath $egurkhaPath
$wratSyVideoSes=Eg-WriteFile -ComntRptPath $rptPath -FileName "SyVideoSessions" -keyFileName "kSyVideoSessions" -EgPath $egurkhaPath
$wratSyAppshrngSes=Eg-WriteFile -ComntRptPath $rptPath -FileName "SyAppshrngSessions" -keyFileName "kSyAppshrngSessions" -EgPath $egurkhaPath
$wratSyalldomains=Eg-WriteFile -ComntRptPath $rptPath -FileName "Syalldomains" -keyFileName "kSyalldomains" -EgPath $egurkhaPath

$domins=New-Object System.Collections.ArrayList
$WriteLog=$true
$LogFile = $egurkhaPath+'/agent/SBO/'+$rName+"\sbousersesn.log"
$LogFile1 = $egurkhaPath+'/agent/SBO/'+$rName+"\sbousersesn1.log"
$isFrstTimLog=$true
function Get-CurrentLineNumber {
    $MyInvocation.ScriptLineNumber
}

Function Write-Log {
	Param ([string]$string)

	[string]$date = Get-Date -Format G
	
    if ($WriteLog) {
       ( "[" + $date + "] - [" +$rName+"] mTime -  " + $Testfreqency + " - " + $string ) | Out-File -FilePath $LogFile -Append } 

    if($isFrstTimLog){     
        if ($WriteLog -eq $true){ #if flag is true 
            if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                    Remove-Item $LogFile1 
                } 
                Rename-Item $LogFile $LogFile1
            }
        }
        $isFrstTimLog=$false
    }

}

function Get-CxdCallData{
    [cmdletbinding()]
        Param
        (
            [Parameter(Mandatory=$true)][int]$NumberOfMinutesToSearch,
            [Parameter(Mandatory=$false)][string]$rptPath,
            [Parameter(Mandatory=$false)][PSCredential]$Credential
        )

    begin {
        try{
            Set-WinRMNetworkDelayMS -value "60000" -WarningAction SilentlyContinue -ErrorAction SilentlyContinue -ErrorVariable WinRMError
        }catch{
            Write-log "[ERROR]Unable to set the WinRM Network Delay. This may be due to User Account Control settings. If you're not encountering timeouts you can safely ignore this warning, otherwise try running the script as an elevated user (Administrator)."
        }
    }

    process {
        $startTime = (Get-Date).AddMinutes(-$NumberOfMinutesToSearch) #note the .AddDays is subtracting the number of days to search
        $endTime = Get-Date
        $global:sessionStartTime = $null
        $numBuckets = 0
        $numUsers = 0
        $enabledUsers = $null
        $arrNotUsingSkype = $null

        if (!$Credential){
            $Credential = Get-Credential -Message "Authenticate to Skype for Business Online"
        }
        Write-Log '.................Strating the execution of the script..................'
        #create initial SFBO Connection
        Invoke-CxdSkypeOnlineConnection


        try{
            [array]$enabledUsers = ProcessSkypeOnlineUsers $rptPath
        }catch{
            Write-Log " [Error] Exception encounterd while getting users. Attempting to remove the PowerShell PSSession and will retry."
            Invoke-CxdSkypeOnlineConnection -RepairPSSession
            [array]$enabledUsers = ProcessSkypeOnlineUsers $rptPath
        }
        
        if (!$enabledUsers.Count){
            Write-Log  "We didn't find any users matching your query. Exiting..."
            Write-Log "Aborting the Script"
            break
        }

        $userTotal = $enabledUsers.Count
        $userBuckets = [math]::Ceiling($userTotal /10)
        $arrUserBuckets = @{}

        #create users and put them into buckets
        Write-Verbose -Message "Putting $($enabledUsers.Count) users into buckets..."
        $count = 0
        $enabledUsers | ForEach-Object {
            $arrUserBuckets[$count % $userBuckets] += @($_)
            $count++
        }
        Write-Log "Placed $($enabledUsers.Count) users into $($arrUserBuckets.Count) bucket(s)."
        $enabledUsers=$null
        #process all discovered users into buckets
        $arrUserBuckets | ProcessBuckets


    }
    end{
        Write-Log "Removing PowerShell Sessions......"
        Get-PSSession | Remove-PSSession
        Write-Log "Script completed Successfully"
    }   
}

function ProcessBuckets{
    [cmdletbinding()]
    Param(
        [Parameter(Mandatory=$true,ValueFromPipeline=$true)]$arrUserBuckets
    )
    begin{}
    process{
        foreach ($userItem in $arrUserBuckets.Values){
            #progress bar for total buckets
            $numBuckets++
            ProcessUsersInBuckets -userItem $userItem
        }
    }
    end{
    }   
}

function ProcessUsersInBuckets{
    [cmdletbinding()]
    Param(
        [Parameter(Mandatory=$false)]$userItem
    )
    begin{

        #before we process this bucket of users we need to check the global session timer to prevent access token expiration
        Invoke-CxdSkypeOnlineConnection
    }
    process{
        foreach($userI in $userItem){
            #set variables
            $userSession=$null
            $Sessions=$null
            $getUserSessionError = $null
            $sipAddress = $userI.SipAddress.Replace("sip:","")
            Try{
                [array]$userSession = ObtainUserSessionData -startTime $startTime -endTime $endTime -sipAddress $sipAddress
            }Catch{
                Write-Log "Unable to retrieve user session information. Attempting to repair the Skype Online connection and will try again."
                Invoke-CxdSkypeOnlineConnection -RepairPSSession
                [array]$userSession = ObtainUserSessionData -startTime $startTime -endTime $endTime -sipAddress $sipAddress
            }
             if ($userSession){
                $Sessions=$userSession | where-object {$_.FromUri -ne $_.ToUri}
                if($Sessions){
                    UsersDomains -userSession $Sessions
                    SeperateSessions -userSession $Sessions
                } 
            }
            $userSession=$null;$Sessions=$null

        }
    }
    end{
    }
            
}

function ObtainUserSessionData{
    [cmdletbinding()]
    Param(
        $startTime,
        $endTime,
        $sipAddress
    )

    begin {}
    process {
        $usrPath=$egurkhaPath+'\agent\'+$rptPath
        if(!(Test-Path -Path $usrPath )){
            $null=New-Item -ItemType directory -Path $usrPath
        }
        Try{
            $userSession=$null
            $Error.Clear()

           $ScriptBlock = {
                param($startTime,$endTime,$sipAddress)
                    Get-CsUserSession -StartTime $startTime -EndTime $endTime -User $sipAddress
                }
            [array]$userSession=invoke-command -scriptblock $ScriptBlock -ArgumentList $startTime,$endTime,$sipAddress -session (get-pssession)
           # [array]$userSession = Get-CsUserSession -StartTime $startTime -EndTime $endTime -User $sipAddress # -WarningAction SilentlyContinue -ErrorAction SilentlyContinue -ErrorVariable $userSessionError
           if($Error)
           {
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] "+$Error)
           # throw $_
           }
        }Catch{
             $ErrorMessage = $_.Exception.Message
             Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running Get-CsUserSession: "+$ErrorMessage)
             #there was an exception and the command did not execute
             #throw $_
        }Finally{
            if ($userSessionError){
                #the command executed but returned an error
                #throw $getUserSessionError
            }
        }

        #sort data by oldest to newest to check the array for the oldest call in preparation for recursion
        $userSession = $userSession | Sort-Object -Property EndTime

        #verify record count hasn't been exceeded and perform recursion if necessary to retrieve additional records
        if ($userSession.Count -ge 1000){
            $newStart = $userSession[-1].endTime
            Write-Information -Message "Found more than 1000 records for $sipAddress. Performing recursive query to obtain more data using revised start date of $newStart"
            $userSession += ObtainUserSessionData -startTime $newStart -endTime $endTime -sipAddress $sipAddress
        }   
    }
    end {
        return $userSession
    }
}

function SeperateSessions{
    [cmdletbinding()]
    Param(
        [Parameter()]$userSession
    )

    begin {}
    process {

            [array]$allsessions = $userSession | Where-Object {$_.MediaTypesDescription -like "*IM*" -or $_.MediaTypesDescription -eq ""}
            [array]$audioSessions = $userSession | Where-Object MediaTypesDescription -like "*Audio*"
            [array]$videosessions = $userSession | Where-Object MediaTypesDescription -like "*Video*"
            [array]$Appshrngsessions = $userSession | Where-Object MediaTypesDescription -like "*AppSharing*"
    }
    end {

        if ($allsessions){
            Export-CxdData -DataInput $allsessions -ReportType 'Syallsessions' -Append
        }
        if ($audioSessions){
            Export-CxdData -DataInput $audioSessions -ReportType 'SyRatMycalFeedBack' -Append
        }
        if ($videosessions){
            Export-CxdData -DataInput $videosessions -ReportType 'SyVideoSessions' -Append
        }
        if ($Appshrngsessions){
            Export-CxdData -DataInput $Appshrngsessions -ReportType 'SyAppshrngSessions' -Append
        }
        $allsessions=$null;$audioSessions=$null;$videosessions=$null;$Appshrngsessions=$null
    }
}

function UsersDomains{
    [cmdletbinding()]
    Param(
        [Parameter()]$userSession
    )

    begin {}
    process {
        [array]$allSessions = $userSession | Select-Object FromUri,ToUri
        if($allSessions){
            foreach($entry in $allSessions)
            {
                $domain=($entry.FromUri).split('@')[1].trim()
                if(!$domins.Contains($domain)) { $domins.Add($domain) }
                $domain=($entry.ToUri).split('@')[1].trim()
                if(!$domins.Contains($domain)){  $domins.Add($domain) }
            }

        }
    }
    end {
    }
}

function Export-CxdData{
    
    [cmdletbinding()]
    Param
    (
        [Parameter(mandatory=$true, valuefrompipeline=$false)][PSObject]$DataInput,
        [Parameter(mandatory=$true, valuefrompipeline=$false)][string]$ReportType,
        [Parameter(mandatory=$false, valuefrompipeline=$false)][switch]$Append
    )

    begin{}
    process{           
            switch($ReportType){ 
            
                'Syallsessions'{$dataInput | Export-Csv $wratSyallsessions[1] -NoTypeInformation -Append}               
                'SyRatMycalFeedBack'{$dataInput | Export-Csv $wratMycalFeedBack[1] -NoTypeInformation -Append}
                'SyVideoSessions'{$dataInput | Export-Csv $wratSyVideoSes[1] -NoTypeInformation -Append}
                'SyAppshrngSessions'{$dataInput | Export-Csv $wratSyAppshrngSes[1] -NoTypeInformation -Append}
                'Syalldomains'{$dataInput | Export-Csv $wratSyalldomains[1] -NoTypeInformation -Append}
                'CSOnlineUsr'{$dataInput | Export-Csv $wratCSOnlineUsr[1] -NoTypeInformation -Append}
            }
    }
    end{
        
    }

}

function Invoke-CxdSkypeOnlineConnection{
    [cmdletbinding()]
    Param
    (
    [Parameter(mandatory=$false, valuefrompipeline=$false)]
    [switch]$RepairPSSession
    )
    begin{}
    process{
        #calculate session timer to handle access token expiration
        if ($global:sessionStartTime){
            $global:sessionTotalTime = ((Get-Date) - $global:sessionStartTime)
        }

        #determine if Skype for Business PsSession is loaded in memory
        $sessionInfo = Get-PsSession

        #need to loop through each session a user might have opened previously
        foreach ($sessionItem in $sessionInfo){
            #check session timer to know if we need to break the connection in advance of a timeout. Break and make new after 40 minutes.
            if ($sessionItem.ComputerName.Contains(".online.") -and $sessionItem.State -eq "Opened" -and $global:sessionTotalTime.TotalSeconds -ge "2400"){
                Write-Log "The PowerShell session has been running for $($global:sessionTotalTime.TotalMinutes) minutes. We need to shut it down and create a new session due to the access token expiration at 60 minutes."
                $sessionItem | Remove-PSSession
                Start-Sleep -Seconds 2
                $SessionFound = $false
                $global:sessionTotalTime = $null #reset the timer
            }

            #try to repair PSSession
            if ($sessionItem.ComputerName.Contains(".online.") -and $sessionItem.State -ne "Opened" -and $RepairPSSession){
                Write-Verbose -Message "Attempting to repair broken PowerShell session to Skype for Business Online using cached credential."
                $sessionItem | Remove-PSSession
                Start-Sleep -Seconds 3
                $SessionFound = $false
                $global:sessionTotalTime = $null
            }elseif ($sessionItem.ComputerName.Contains(".online.") -and $sessionItem.State -eq "Opened"){
                $SessionFound = $true
            }
        }

        if (!$SessionFound){
            Write-Log "Creating new Skype Online PowerShell session..."
            try{
                 $sessionOption = New-PSSessionOption -SkipRevocationCheck 
	             if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	                 $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
	                 $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
	                    #[System.Net.WebRequest]::DefaultWebProxy.Credentials = $proxyCred    
	                    #$prx=(netsh winhttp show proxy)[3].Split(":")
	                    #$proxyserverip=($prx[1]+':'+$prx[2]).Trim()
	                    $proxyserver='http://'+$proxyserverip
	                    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
	                    [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
	                    [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true	             
                 }
                 if($overrideUri -ne 'none'){
                    $lyncsession = New-CsOnlineSession -Credential $Credential -SessionOption $sessionOption –OverridePowershellUri $overrideUri # -WarningAction SilentlyContinue -ErrorAction SilentlyContinue -ErrorVariable $newOnlineSessionError 
                 }
                 else{ $lyncsession = New-CsOnlineSession -Credential $Credential -SessionOption $sessionOption }

                 Write-Log 'Session got created successfully.'

            }catch{
             $ErrorMessage = $_.Exception.Message
             Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while creating session: "+$ErrorMessage)         
             throw;
            }finally{
                if ($newOnlineSessionError){
                    throw $newOnlineSessionError
                }
            }
            Write-Verbose -Message "Importing remote PowerShell session..."
            $global:sessionStartTime = (Get-Date)
            Import-PSSession $lyncsession -AllowClobber | Out-Null
        }
    }
    end{}
}


function ProcessSkypeOnlineUsers{
    [cmdletbinding()]
    Param(
        [Parameter()]$reportingname
    )
    process{
            $allusers=""
            try{
                $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "CSOnlineUsr" -keyFileName "kCSOnlineUsr" -EgPath $egurkhaPath
                $datafile=$readfiles[1] -replace (".csv",".dat") 
                $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
                $allusers= import-csv $csvfile | Select-Object *
                write-log ('readed users csv file '+$readfiles[3])                                  			 			 					
                Remove-Item $csvfile
                $readtime = (Get-Item $readfiles[1]).LastWriteTime
    		    $readfiledif=(NEW-TIMESPAN –Start $readtime –End (Get-Date) | Select-Object TotalMinutes).TotalMinutes
                if($readfiledif -gt 1440)
                {
                   $allusers=""
                   write-log ' Readed CSOnlineUsr csv file is older..... so we are creating new file' 
                }
            }
            catch{
               write-log ' CSOnlineUsr csv file is not found going to creating the file'   
               $allusers=""
             }

            if($allusers)
            {  try{
                    write-log  "getting all users of Skype for Business Online from input CSV file"
                    $enabledUsers = $allusers | Select-Object Enabled,SipAddress | Where-Object {$_.Enabled -eq 'TRUE'}
                    return $enabledUsers
                  }
                  catch{
                        $ErrorMessage = $_.Exception.Message                   
                        Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Exception while reading the users from csv:"+$ErrorMessage)
                        return ""
                  }

            }else{
                $wratCSOnlineUsr=Eg-WriteFile -ComntRptPath $rptPath -FileName "CSOnlineUsr" -keyFileName "kCSOnlineUsr" -EgPath $egurkhaPath
                $allusers=Get-CSOnlineUser |Select-Object AcpInfo,AssignedPlan,DisplayName,RegistrarPool,SoftDeletionTimestamp,UserPrincipalName,WhenChanged,WhenCreated,Enabled,SipAddress
                Export-CxdData -DataInput $allusers -ReportType 'CSOnlineUsr' -Append
                $null=Protect-File  $wratCSOnlineUsr[1] -Algorithm AES -KeyAsPlainText $wratCSOnlineUsr[0] -RemoveSource 
                $enabledUsers = $allusers | Select-Object Enabled,SipAddress | Where-Object {$_.Enabled -eq '$True'}
                Return $enabledUsers
            }
    }
    end{}
}


function Set-WinRMNetworkDelayMS{

  param(
    [Parameter(Mandatory = $false)] [string] $value="30000"
  )

  $networkDelay = Get-Item WSMan:\localhost\Client\NetworkDelayms

  if($networkDelay -eq $null)
  {
    # If cannot get NetworkDelayms due to permission or other reason, just return.
    return
  }

  $oldValue = $networkDelay.Value
  $newValue = $value

  if($newValue -ne $oldValue)
  {
    Set-Item WSMan:\localhost\Client\NetworkDelayms $newValue

  }
}

try{

    Get-CxdCallData -NumberOfMinutesToSearch $Testfreqency -Credential $credential -rptPath $rptPath

}catch{
    $ErrorMessage = $_.Exception.Message
    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running Get-CsUserSession: "+$ErrorMessage)
    exit
}


$uPath=$egurkhaPath+'\agent\'+$rptPath

if($domins){
    foreach($domain in $domins){        
            $newObject = [PSCustomObject][ordered]@{
            domain=$domain
        }        
        Export-CxdData -DataInput $newObject -ReportType 'Syalldomains' -Append                  
        
    }
}

if(Test-Path $wratSyallsessions[1] -PathType Leaf){
    $null=Protect-File  $wratSyallsessions[1] -Algorithm AES -KeyAsPlainText $wratSyallsessions[0] -RemoveSource
}else{
    $temp=Split-Path $wratSyallsessions[1] -leaf
    $temp='\k'+$temp.Replace('.csv','.dat')
    Remove-Item -Path $uPath$temp
}

if(Test-Path $wratMycalFeedBack[1] -PathType Leaf){
    $null=Protect-File  $wratMycalFeedBack[1] -Algorithm AES -KeyAsPlainText $wratMycalFeedBack[0] -RemoveSource
}else{
    $temp=Split-Path $wratMycalFeedBack[1] -leaf
    $temp='\k'+$temp.Replace('.csv','.dat')
    Remove-Item -Path $uPath$temp
}

if(Test-Path $wratSyVideoSes[1] -PathType Leaf){
   $null=Protect-File  $wratSyVideoSes[1] -Algorithm AES -KeyAsPlainText $wratSyVideoSes[0] -RemoveSource 
}else{
    $temp=Split-Path $wratSyVideoSes[1] -leaf
    $temp='\k'+$temp.Replace('.csv','.dat')
    Remove-Item -Path $uPath$temp
}

if(Test-Path $wratSyAppshrngSes[1] -PathType Leaf){
   $null=Protect-File  $wratSyAppshrngSes[1] -Algorithm AES -KeyAsPlainText $wratSyAppshrngSes[0] -RemoveSource 
}else{
    $temp=Split-Path $wratSyAppshrngSes[1] -leaf
    $temp='\k'+$temp.Replace('.csv','.dat')
    Remove-Item -Path $uPath$temp
}

if(Test-Path $wratSyalldomains[1] -PathType Leaf){
   $null=Protect-File  $wratSyalldomains[1] -Algorithm AES -KeyAsPlainText $wratSyalldomains[0] -RemoveSource 
}else{
    $temp=Split-Path $wratSyalldomains[1] -leaf
    $temp='\k'+$temp.Replace('.csv','.dat')
    Remove-Item -Path $uPath$temp
}

$csvDir=$egInstallpath.Value+'/agent/'+$rptPath+'/'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'Syallsessions'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'SyRatMycalFeedBack'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'Syalldomains'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'SyVideoSessions'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'SyAppshrngSessions'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'CSOnlineUsr'
    exit

# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUeYw5aDAJveNxn8qdRnMDC2tA
# RYCggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUNk5/gBp0kChdYV6BcZBrKkp3
# pW8wDQYJKoZIhvcNAQEBBQAEggEAifqW/+VqsROkyG9mTEgX80h4WM47JxIHGT9S
# 6P4weDJZsY7kQnJY74f+z900uVw+D+WUipGlsE3rKEVDmZQtw5AzHPRNaIldeBhf
# wdfgiArZprqNTvAgbEB9jGnsgAvV+JKANBFOWM05KaOPGyNTHjlZ1Od+qaDQl9oI
# TC1GJVo2ymmqhZ9t4THodeseNoVxQ0zoBhh0q2uxlVDOoIgUZU2bnXMi27Ewngwf
# X6edX8pJO/4fPrSTrIshdNifu1B6T933wbWl6RVF9yizPJLxYcxfjEQAo6qFp2td
# Q+hEKFukXyJZriWkedlsNZcEqwdWiSkcGZOcotZPQRS40mt/gKGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwNzIzMDIwNDIwWjAjBgkqhkiG9w0BCQQxFgQU9yKdOXhL6aTvjEtjhAvA
# s1ej1zEwDQYJKoZIhvcNAQEBBQAEggEAh4f/ZeQ4JrJHoPxLVgj406YDcTfZlBt2
# IK6tz2kMScTQcZMiG+X+MQqVW1dzEB2Pkypl5EQw2X5OWA9TvvtW55xEq5HUBZm3
# hzEncbjL/jgwqniRq1LzKOVozb0Gx1tGsQYBMCqgte/3pV3YKQXIWjHayAWIggi/
# iljsQShTJQGH09iQD7IJ9YjO+E+ZeoxCNTzkkGwilXPIIUd+CSTBX0LQ+Ma8YgDh
# ns9cGX2NBmKN7djxh7iotkDXuxd6vfWNJ2gUgS5rhqCKwWxX/R+/CqPIe3Kp2g59
# XDGQpzRKdcbbbdw9KNxTeUD4O4Tzs74UBn+XTiwU2TbhRd3/tCxHmA==
# SIG # End signature block
