/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.utils;

import com.sybase.jdbc4.utils.Debug;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;

public class SybVersion {
    static String _url = "jdbc:sybase:Tds:hostname:0000";
    public static byte MAJOR_VERSION = (byte)6;
    public static byte MINOR_VERSION = 0;
    public static byte SP_NUMBER = (byte)5;
    public static String PRODUCT_NAME = "jConnect (TM) for JDBC(TM)";
    public static String PRODUCT_VERSION = MAJOR_VERSION + "." + MINOR_VERSION + SP_NUMBER;
    public static String BUILD_NUMBER = "XXXXX";
    public static String BUILD_TYPE = "P";
    public static int EBF_NUMBER = 0;
    public static byte PL_NUMBER = 0;
    public static String SP_STRING = "SP000";
    public static String BUILD_CODELINE = "main";
    public static String JDK_VERSION = "JDK16";
    public static String BUILD_MODE = "FBO";
    public static String BUILD_DATE = "Sat Jan 1 0:00:01 2011";
    public static String VERSION_STRING = "jConnect (TM) for JDBC(TM)/16.0 SP03 PL08 (Build 27463)/P/EBF29225/JDK 1.6.0/jdbcdev/OPT/Sun Jan 12 19:56:00 PST 2020";
    public static String EXPIRES_STRING = "Aug 1, 2008";
    public static GregorianCalendar EXPIRES = new GregorianCalendar(2008, 7, 1);
    public static GregorianCalendar WARN_AT = new GregorianCalendar(2008, 6, 17);
    static final char FORWARD_SLASH = '/';
    static final char SPACE = ' ';

    private static byte getDigitFromString(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            string2 = string2 + Character.toString(string.charAt(i));
        }
        return Integer.parseInt(string2) > 127 ? (byte)-1 : (byte)Byte.parseByte(string2);
    }

    private static void disAssembleVersionString(String string) {
        if (string == null) {
            return;
        }
        VERSION_STRING = string;
        try {
            String[] stringArray = string.split("/");
            PRODUCT_NAME = stringArray[0];
            String string2 = stringArray[1].substring(0, stringArray[1].indexOf(32));
            String[] stringArray2 = stringArray[1].split(" ");
            int n = string2.indexOf(".");
            MAJOR_VERSION = Byte.parseByte("" + string2.substring(0, n));
            MINOR_VERSION = Byte.parseByte("" + string2.substring(n + 1, n + 2));
            string2 = string2.substring(n + 2);
            if (MAJOR_VERSION >= 16) {
                SP_NUMBER = 0;
                PL_NUMBER = 0;
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i].contains("SP")) {
                        SP_NUMBER = SybVersion.getDigitFromString(stringArray2[i]);
                    }
                    if (!stringArray2[i].contains("PL")) continue;
                    PL_NUMBER = SybVersion.getDigitFromString(stringArray2[i]);
                }
            } else {
                SP_NUMBER = string2.trim().equals("") ? (byte)0 : Byte.parseByte(string2);
                PL_NUMBER = 0;
            }
            PRODUCT_VERSION = MAJOR_VERSION + "." + MINOR_VERSION + "." + SP_NUMBER + "." + PL_NUMBER;
            string2 = stringArray[1];
            BUILD_NUMBER = string2.substring(string2.indexOf(40) + "(Build ".length(), string2.indexOf(41));
            BUILD_TYPE = stringArray[2];
            EBF_NUMBER = Integer.parseInt(stringArray[3].substring("EBF".length() + 1));
            JDK_VERSION = stringArray[4].substring(stringArray[4].indexOf(32) + 1);
            BUILD_CODELINE = stringArray[5];
            BUILD_MODE = stringArray[6];
            BUILD_DATE = stringArray[7];
        }
        catch (PatternSyntaxException patternSyntaxException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        Properties properties = new Properties();
        Driver driver = (Driver)Class.forName("com.sybase.jdbc4.jdbc.SybDriver").newInstance();
        DriverPropertyInfo[] driverPropertyInfoArray = driver.getPropertyInfo(_url, properties);
        for (int i = 0; i < driverPropertyInfoArray.length; ++i) {
            if (!driverPropertyInfoArray[i].name.equals("VERSIONSTRING")) continue;
            Debug.println(driverPropertyInfoArray[i].value);
            break;
        }
    }

    static {
        SybVersion.disAssembleVersionString(VERSION_STRING);
    }
}

