/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class LtmPoolMemberTest
extends EgSnmpGenericTest {
    private Hashtable prevBytesIn = new Hashtable();
    private Hashtable prevBytesOut = new Hashtable();
    private Hashtable prevPktsIn = new Hashtable();
    private Hashtable prevPktsOut = new Hashtable();
    private Hashtable prevTotConns = new Hashtable();
    private Hashtable prevTotReq = new Hashtable();
    private static final double BYTE_TO_MB = 1048576.0;

    public LtmPoolMemberTest(String[] stringArray) {
        super(stringArray);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(12);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.4.3.1.6");
            Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.4.3.1.8");
            Hashtable hashtable4 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.4.3.1.5");
            Hashtable hashtable5 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.4.3.1.7");
            Hashtable hashtable6 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.4.3.1.11");
            Hashtable hashtable7 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.4.3.1.10");
            Hashtable hashtable8 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.4.3.1.9");
            Hashtable hashtable9 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.4.3.1.19");
            Hashtable hashtable10 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.6.2.1.5");
            Hashtable hashtable11 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.6.2.1.6");
            Hashtable hashtable12 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.2.3.1.1");
            Hashtable hashtable13 = this.getMeasure(".1.3.6.1.4.1.3375.2.2.5.3.2.1.19");
            if (hashtable10 == null || hashtable10.size() == 0) {
                this.logToErrorFile("Error :", "LtmPoolMemberTest error occured in Compute Measures for ", this.targetHost);
            }
            Hashtable hashtable14 = this.getDiff(hashtable2, this.prevBytesIn, true);
            Hashtable hashtable15 = this.getDiff(hashtable3, this.prevBytesOut, true);
            Hashtable hashtable16 = this.getDiff(hashtable4, this.prevPktsIn, false);
            Hashtable hashtable17 = this.getDiff(hashtable5, this.prevPktsOut, false);
            Hashtable hashtable18 = this.getDiff(hashtable9, this.prevTotReq, false);
            Enumeration enumeration = hashtable12.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable12.get(string);
                Enumeration enumeration2 = hashtable10.keys();
                while (enumeration2.hasMoreElements()) {
                    String string3 = (String)enumeration2.nextElement();
                    if (string3.indexOf(string) == -1) continue;
                    String string4 = (String)hashtable13.get(string3);
                    String string5 = (String)hashtable11.get(string3);
                    String string6 = (String)hashtable10.get(string3);
                    String string7 = string3.substring(string3.lastIndexOf(".") + 1);
                    String string8 = string2 + "#" + string4 + ":" + string7;
                    if (string5 == null || string5.length() == 0) {
                        string5 = "-5";
                    }
                    string6 = string6.equalsIgnoreCase("0") ? "1" : (string6.equalsIgnoreCase("1") ? "2" : (string6.equalsIgnoreCase("2") ? "3" : (string6.equalsIgnoreCase("3") ? "4" : (string6.equalsIgnoreCase("4") ? "0" : (!string6.equalsIgnoreCase("-5") ? "5" : "-5")))));
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    if (string6.equalsIgnoreCase("0") || string6.equalsIgnoreCase("2") || string6.equalsIgnoreCase("3") || string6.equalsIgnoreCase("4") || string6.equalsIgnoreCase("5")) {
                        arrayList.add(new Double(string6));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        this.addNewMeasure(string8, arrayList);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("0") || string5.equalsIgnoreCase("2") || string5.equalsIgnoreCase("3")) {
                        arrayList.add(new Double(string6));
                        arrayList.add(new Double(string5));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        this.addNewMeasure(string8, arrayList);
                        continue;
                    }
                    String string9 = (String)hashtable7.get(string3);
                    String string10 = (String)hashtable6.get(string3);
                    String string11 = (String)hashtable8.get(string3);
                    String string12 = (String)this.prevTotConns.get(string3);
                    if (string9 == null || string9.length() == 0) {
                        string9 = "-5";
                    }
                    if (string10 == null || string10.length() == 0) {
                        string10 = "-5";
                    }
                    if (string11 == null || string11.length() == 0) {
                        string11 = "-5";
                    }
                    double d = -5.0;
                    double d2 = -5.0;
                    double d3 = this.getDoubleValue(string10);
                    double d4 = this.getDoubleValue(string9);
                    double d5 = this.getDoubleValue(string12);
                    if (d4 >= 0.0 && d5 >= 0.0) {
                        d2 = d4 - d5;
                    }
                    if (d2 > 0.0 && d2 >= d3) {
                        d = d3 / d2 * 100.0;
                    }
                    if (d < 0.0) {
                        d = -5.0;
                    }
                    arrayList.add(new Double(string6));
                    arrayList.add(new Double(string5));
                    arrayList.add(this.getValue(hashtable15, string3));
                    arrayList.add(this.getValue(hashtable14, string3));
                    arrayList.add(this.getValue(hashtable17, string3));
                    arrayList.add(this.getValue(hashtable16, string3));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(string11));
                    arrayList.add(this.getValue(hashtable18, string3));
                    System.out.println("[LtmPoolMemberTest]memberName===>" + string8 + "  measure===>" + arrayList);
                    this.addNewMeasure(string8, arrayList);
                }
            }
            this.prevBytesIn = hashtable2;
            this.prevBytesOut = hashtable3;
            this.prevPktsIn = hashtable4;
            this.prevPktsOut = hashtable5;
            this.prevTotConns = hashtable7;
            this.prevTotReq = hashtable9;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Hashtable getDiff(Hashtable hashtable, Hashtable hashtable2, boolean bl) {
        Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
        if (hashtable == null || hashtable2 == null) {
            return hashtable3;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            String string3 = (String)hashtable2.get(string);
            if (string3 == null) {
                hashtable3.put(string, new Double(-5.0));
                continue;
            }
            if (string2 == null) continue;
            try {
                double d = -5.0;
                double d2 = this.getDoubleValue(string2);
                double d3 = this.getDoubleValue(string3);
                if (d2 >= 0.0 && d3 >= 0.0) {
                    d = d2 - d3;
                    if (bl) {
                        d /= 1048576.0;
                    }
                    d = this.timeSinceLastTest > 0.0 && d >= 0.0 ? (d /= this.timeSinceLastTest) : -5.0;
                }
                hashtable3.put(string, new Double(d));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable3;
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".")) continue;
                    string2 = this.lhs[i];
                    string3 = this.rhs[i];
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "LtmPoolMemberTest error occured in getMeasures", exception.toString());
            exception.printStackTrace();
        }
        return hashtable;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = string != null && string.trim().length() > 0 ? Double.parseDouble(string) : -5.0;
        }
        catch (Exception exception) {
            System.out.println("Exception in getDoubleValueMethod:" + exception);
            exception.printStackTrace();
        }
        return d;
    }

    private Double getValue(Hashtable hashtable, String string) {
        Double d = new Double(-5.0);
        if (hashtable == null) {
            return d;
        }
        try {
            Double d2 = (Double)hashtable.get(string);
            if (d2 == null) {
                return d;
            }
            return d2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return d;
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.8.49", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        LtmPoolMemberTest ltmPoolMemberTest = new LtmPoolMemberTest(stringArray);
        try {
            while (true) {
                ltmPoolMemberTest.computeMeasures(new Hashtable());
                Thread.sleep(500L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

