/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.jmx;

import com.eg.ch.qos.logback.classic.Level;
import com.eg.ch.qos.logback.classic.Logger;
import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.jmx.JMXConfiguratorMBean;
import com.eg.ch.qos.logback.classic.joran.JoranConfigurator;
import com.eg.ch.qos.logback.classic.spi.LoggerContextListener;
import com.eg.ch.qos.logback.classic.util.ContextInitializer;
import com.eg.ch.qos.logback.core.joran.spi.JoranException;
import com.eg.ch.qos.logback.core.spi.ContextAwareBase;
import com.eg.ch.qos.logback.core.status.Status;
import com.eg.ch.qos.logback.core.status.StatusListener;
import com.eg.ch.qos.logback.core.status.StatusListenerAsList;
import com.eg.ch.qos.logback.core.status.StatusManager;
import com.eg.ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXConfigurator
extends ContextAwareBase
implements JMXConfiguratorMBean,
LoggerContextListener {
    private static String EMPTY = "";
    LoggerContext loggerContext;
    MBeanServer mbs;
    ObjectName objectName;
    String objectNameAsString;
    boolean debug = true;
    boolean started = true;

    public JMXConfigurator(LoggerContext loggerContext, MBeanServer mBeanServer, ObjectName objectName) {
        this.context = loggerContext;
        this.loggerContext = loggerContext;
        this.mbs = mBeanServer;
        this.objectName = objectName;
        this.objectNameAsString = objectName.toString();
        if (this.previouslyRegisteredListenerWithSameObjectName()) {
            this.addError("Previously registered JMXConfigurator named [" + this.objectNameAsString + "] in the logger context named [" + loggerContext.getName() + "]");
        } else {
            loggerContext.addListener(this);
        }
    }

    private boolean previouslyRegisteredListenerWithSameObjectName() {
        List<LoggerContextListener> list = this.loggerContext.getCopyOfListenerList();
        for (LoggerContextListener loggerContextListener : list) {
            if (!(loggerContextListener instanceof JMXConfigurator)) continue;
            JMXConfigurator jMXConfigurator = (JMXConfigurator)loggerContextListener;
            if (!this.objectName.equals(jMXConfigurator.objectName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reloadDefaultConfiguration() throws JoranException {
        ContextInitializer contextInitializer = new ContextInitializer(this.loggerContext);
        URL uRL = contextInitializer.findURLOfDefaultConfigurationFile(true);
        this.reloadByURL(uRL);
    }

    @Override
    public void reloadByFileName(String string) throws JoranException, FileNotFoundException {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            try {
                URL uRL = file.toURI().toURL();
                this.reloadByURL(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("Unexpected MalformedURLException occured. See nexted cause.", malformedURLException);
            }
        } else {
            String string2 = "Could not find [" + string + "]";
            this.addInfo(string2);
            throw new FileNotFoundException(string2);
        }
    }

    void addStatusListener(StatusListener statusListener) {
        StatusManager statusManager = this.loggerContext.getStatusManager();
        statusManager.add(statusListener);
    }

    void removeStatusListener(StatusListener statusListener) {
        StatusManager statusManager = this.loggerContext.getStatusManager();
        statusManager.remove(statusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadByURL(URL uRL) throws JoranException {
        StatusListenerAsList statusListenerAsList = new StatusListenerAsList();
        this.addStatusListener(statusListenerAsList);
        this.addInfo("Resetting context: " + this.loggerContext.getName());
        this.loggerContext.reset();
        this.addStatusListener(statusListenerAsList);
        try {
            if (uRL != null) {
                JoranConfigurator joranConfigurator = new JoranConfigurator();
                joranConfigurator.setContext(this.loggerContext);
                joranConfigurator.doConfigure(uRL);
                this.addInfo("Context: " + this.loggerContext.getName() + " reloaded.");
            }
        }
        finally {
            this.removeStatusListener(statusListenerAsList);
            if (this.debug) {
                StatusPrinter.print(statusListenerAsList.getStatusList());
            }
        }
    }

    @Override
    public void setLoggerLevel(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 == null) {
            return;
        }
        string = string.trim();
        string2 = string2.trim();
        this.addInfo("Trying to set level " + string2 + " to logger " + string);
        LoggerContext loggerContext = (LoggerContext)this.context;
        Logger logger = loggerContext.getLogger(string);
        if ("null".equalsIgnoreCase(string2)) {
            logger.setLevel(null);
        } else {
            Level level = Level.toLevel(string2, null);
            if (level != null) {
                logger.setLevel(level);
            }
        }
    }

    @Override
    public String getLoggerLevel(String string) {
        if (string == null) {
            return EMPTY;
        }
        LoggerContext loggerContext = (LoggerContext)this.context;
        Logger logger = loggerContext.exists(string = string.trim());
        if (logger != null && logger.getLevel() != null) {
            return logger.getLevel().toString();
        }
        return EMPTY;
    }

    @Override
    public String getLoggerEffectiveLevel(String string) {
        if (string == null) {
            return EMPTY;
        }
        LoggerContext loggerContext = (LoggerContext)this.context;
        Logger logger = loggerContext.exists(string = string.trim());
        if (logger != null) {
            return logger.getEffectiveLevel().toString();
        }
        return EMPTY;
    }

    @Override
    public List<String> getLoggerList() {
        LoggerContext loggerContext = (LoggerContext)this.context;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Logger logger : loggerContext.getLoggerList()) {
            arrayList.add(logger.getName());
        }
        return arrayList;
    }

    @Override
    public List<String> getStatuses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Status> iterator = this.context.getStatusManager().getCopyOfStatusList().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().toString());
        }
        return arrayList;
    }

    @Override
    public void onStop(LoggerContext loggerContext) {
        if (!this.started) {
            this.addInfo("onStop() method called on a stopped JMXActivator [" + this.objectNameAsString + "]");
            return;
        }
        if (this.mbs.isRegistered(this.objectName)) {
            try {
                this.addInfo("Unregistering mbean [" + this.objectNameAsString + "]");
                this.mbs.unregisterMBean(this.objectName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                this.addError("Unable to find a verifiably registered mbean [" + this.objectNameAsString + "]", instanceNotFoundException);
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                this.addError("Failed to unregister [" + this.objectNameAsString + "]", mBeanRegistrationException);
            }
        } else {
            this.addInfo("mbean [" + this.objectNameAsString + "] was not in the mbean registry. This is OK.");
        }
        this.stop();
    }

    @Override
    public void onLevelChange(Logger logger, Level level) {
    }

    @Override
    public void onReset(LoggerContext loggerContext) {
        this.addInfo("onReset() method called JMXActivator [" + this.objectNameAsString + "]");
    }

    @Override
    public boolean isResetResistant() {
        return true;
    }

    private void clearFields() {
        this.mbs = null;
        this.objectName = null;
        this.loggerContext = null;
    }

    private void stop() {
        this.started = false;
        this.clearFields();
    }

    @Override
    public void onStart(LoggerContext loggerContext) {
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.context.getName() + ")";
    }
}

