﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear

$testargs=$args
$reportingname='EXO\'+$testargs[0]
$showUsrRuleMails=$testargs[1]
$userName=$testargs[2]
$startTime=$testargs[3]
$startTime=$startTime.Replace('_',' ')

try{
    $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
    $DateFormat = $CultureDateTimeFormat.ShortDatePattern
    $TimeFormat = $CultureDateTimeFormat.LongTimePattern
    $DateTimeFormat = "$DateFormat $TimeFormat"
    
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "transportrules" -keyFileName "ktransportrules" -EgPath $egurkhaPath
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
    $ruledetail= import-csv $csvfile
    Remove-Item $csvfile
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'transportrules' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'ktransportrules' -InputFile $readfiles[4]
    Write-Host 'ReadFile:'$readfiles[3]
    }
    catch [System.Management.Automation.RuntimeException] {
        Write-Error -Message "File not found. The $reportingname location does not contain transportrules files."
    }
    catch{
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }
$InEvnType= @{}
$OutEvnType= @{}
$UniqSen= @{}
$UniqRec= @{}
$evntarr= New-Object System.Collections.ArrayList

	$ruledetail= $ruledetail | Sort-Object {[DateTime]::ParseExact($_.'Date',$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)}  -Descending
	$LastDaterule=$ruledetail|select -Property Date -First 1    
	$TotInboundSize=0
	$TotOutboundSize=0

	$reg="^\d*/\d*/[2-9]\d\d\d \d*:\d*:\d*$"

	       foreach($ruledata in $ruledetail){
            $entryflg=$false
            if($startTime -ne $null -and $startTime -ne ''){
               $ruleDate = [DateTime]::ParseExact($ruledata.Date,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
               $prevTime = [DateTime]::ParseExact($startTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
                if($ruleDate -gt $prevTime){
                    $entryflg=$true
                }
            }
            else{
                $entryflg=$true
            }
            if($entryflg){  
                if(!$showUsrRuleMails)
                {
                    if( ($ruledata.SenderAddress).toString().toLower().trim() -eq $userName.toString().toLower().trim() -or ($ruledata.RecipientAddress).toString().toLower().trim() -eq $userName.toString().toLower().trim() )
                    {
                        continue;
                    }
                }

		if($evntarr -notcontains ($ruledata.EventType)){
		       $evntarr.Add( $ruledata.EventType)
		   }
			$TotMsgSize=[math]::round($ruledata.MessageSize /1Kb, 4)

	       if($ruledata.Direction -eq 'Inbound'){
		
		    if($InEvnType.Contains($ruledata.EventType)){
		  $tmparr=$InEvnType[$ruledata.EventType]
		  $tmparr.Add(''+$ruledata.Date+'~!~'+$ruledata.Domain+'~!~'+$ruledata.TransportRule+'~!~'+$ruledata.Subject+'~!~'+$TotMsgSize.tostring("#.##").replace(',','.')+'~!~'+$ruledata.SenderAddress+'~!~'+$ruledata.RecipientAddress+'~!~'+$ruledata.Action+'~!~'+$ruledata.MessageId)
		    }else{
		  $tmparr= New-Object System.Collections.ArrayList
		  $tmparr.Add(''+$ruledata.Date+'~!~'+$ruledata.Domain+'~!~'+$ruledata.TransportRule+'~!~'+$ruledata.Subject+'~!~'+$TotMsgSize.tostring("#.##").replace(',','.')+'~!~'+$ruledata.SenderAddress+'~!~'+$ruledata.RecipientAddress+'~!~'+$ruledata.Action+'~!~'+$ruledata.MessageId)
		  $InEvnType.Add($ruledata.EventType,$tmparr)
		    }
			$TotSize=[math]::round($spamdata.MessageSize /1Gb, 4)
			$TotInboundSize+=$TotSize 
	     }else{
		if($OutEvnType.Contains($ruledata.EventType)){
		   $tmparr=$OutEvnType[$ruledata.EventType]
		   $tmparr.Add(''+$ruledata.Date+'~!~'+$ruledata.Domain+'~!~'+$ruledata.TransportRule+'~!~'+$ruledata.Subject+'~!~'+$TotMsgSize.tostring("#.##").replace(',','.')+'~!~'+$ruledata.SenderAddress+'~!~'+$ruledata.RecipientAddress+'~!~'+$ruledata.Action+'~!~'+$ruledata.MessageId) 
		    }else{
		   $tmparr= New-Object System.Collections.ArrayList
		   $tmparr.Add(''+$ruledata.Date+'~!~'+$ruledata.Domain+'~!~'+$ruledata.TransportRule+'~!~'+$ruledata.Subject+'~!~'+$TotMsgSize.tostring("#.##").replace(',','.')+'~!~'+$ruledata.SenderAddress+'~!~'+$ruledata.RecipientAddress+'~!~'+$ruledata.Action+'~!~'+$ruledata.MessageId) 
		   $OutEvnType.Add($ruledata.EventType,$tmparr)
		    }	
			$TotSize=[math]::round($spamdata.MessageSize /1Gb, 4)
			$TotOutboundSize+=$TotSize 			
		}
		if($UniqSen.Contains($ruledata.EventType)){
		   $tmpSenAdd=$UniqSen[$ruledata.EventType]
		   $tmpRecAdd=$UniqRec[$ruledata.EventType]
		   if($tmpSenAdd -notcontains ($ruledata.SenderAddress)){
		     $tmpSenAdd.Add($ruledata.SenderAddress)
		   }
		   if($tmpRecAdd -notcontains($ruledata.RecipientAddress)){
		     $tmpRecAdd.Add($ruledata.RecipientAddress)
		   }
		}
		else{
		    $SndAdd=  New-Object System.Collections.ArrayList
		    $RecAdd=  New-Object System.Collections.ArrayList
		    $SndAdd.Add($ruledata.SenderAddress)
		    $RecAdd.Add($ruledata.RecipientAddress)
		    $UniqSen.Add($ruledata.EventType,$SndAdd)
		    $UniqRec.Add($ruledata.EventType,$RecAdd)
		}
            }
	    }

	 clear
	    
	     foreach($keys in $evntarr){
                $inevncnt=0
                $outevncnt=0
				$evntlist=$InEvnType[$keys]
		        $Outevntlist=$OutEvnType[$keys]
		#$sendlist=$UniqSen[$keys]
		#$recvlist=$UniqRec[$keys]
        if($evntlist -ne $null){
            $inevncnt=$evntlist.Count
		    For ($i=0; $i -lt 10; $i++) {
			        $evntdata=$evntlist[$i]
			        if($evntdata -ne $null){
			         Write-Host '# DDrule In'$keys '!' $evntdata '<!>'
			        }
		    }
        }
        if($Outevntlist -ne $null){
            $outevncnt=$Outevntlist.Count
		    For ($i1=0; $i1 -lt 10; $i1++) {
			        $outevntdata=$Outevntlist[$i1]
			        if($outevntdata -ne $null){
			         Write-Host '# DDrule Out'$keys '!' $outevntdata '<!>'
			        }
		    }
        }
        Write-Host '#Measure' $keys '~' $inevncnt '~' $outevncnt '~' $UniqSen[$keys].Count'~'$UniqRec[$keys].Count '<!>'
		<#foreach($senddata in $sendlist){
		    Write-Host '# UniqueSend'$keys '!' $senddata '<!>'
		}
		foreach($recvdata in $recvlist){
		    Write-Host '# UniqueRecv'$keys '!' $recvdata '<!>'
		}#>
Write-Host 'LastDate:'$LastDaterule.Date.Replace(' ','_')
     }

