[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$Global:ErrorActionPreference="SilentlyContinue"
$bInactiveMailboxUsage = "false"
$bIsOverWarningQuota = "false"
$pastDays = 1
if($args.count -ne 2)
{
	Write-Host("Please pass the password admin's role username and password as arguments")
	return
}
$username = $args[0] 
$pwd = $args[1]
$password = $args[1]  | ConvertTo-SecureString -asPlainText -Force 
$cred = New-Object System.Management.Automation.PSCredential($username,$password) # Encrypt creds for use 
# Report Root URL 
$D = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
Write-Host("MailboxActivityReport")
Write-Host("-----------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxActivityDaily?`$orderby=Date desc&`$top=1&`$format=json"
$entry = (Invoke-RestMethod -Credential $cred -Uri $url)
#$Date = $entry.d.Date.ToString("yyyy-MM-dd") # don't enable this 
$TenantName = $entry.d.TenantName
$TotalNumberOfActiveMailboxes = $entry.d.TotalNumberOfActiveMailboxes
$AccountCreated = $entry.d.AccountCreated
$AccountDeleted = $entry.d.AccountDeleted
Write-Host($TotalNumberOfActiveMailboxes,$AccountCreated,$AccountDeleted) -Separator ";"


Write-Host("StateMailboxReport")
Write-Host("--------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/StaleMailbox?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
foreach($entry in $entries)
{
	$Date = $entry.Date.ToString("yyyy-MM-dd")
	$TenantName = $entry.TenantName
	$ActiveMailboxes = $entry.ActiveMailboxes
	$InactiveMailboxes31To60Days = $entry.InactiveMailboxes31To60Days
	$InactiveMailboxes61To90Days = $entry.InactiveMailboxes61To90Days
	$InactiveMailboxes91To1460Days = $entry.InactiveMailboxes91To1460Days
	Write-Host($ActiveMailboxes,$InactiveMailboxes31To60Days,$InactiveMailboxes61To90Days,$InactiveMailboxes91To1460Days) -Separator ";"
}

$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/StaleMailboxDetail?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
foreach($entry in $entries)
{
	$UserName = $entry.UserName
	$WindowsLiveID = $entry.WindowsLiveID
	$LastLogin = $entry.LastLogin
	$DaysInactive = $entry.DaysInactive 
	Write-Host ($UserName,$WindowsLiveID,$LastLogin,$DaysInactive) -separator ";"
}

Write-Host("MailboxUsageReport")
Write-Host("----------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxUsage?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
foreach($entry in $entries)
{
	$Date = $entry.Date.ToString("yyyy-MM-dd")
	$TenantName = $entry.TenantName
	$TotalMailboxCount = $entry.TotalMailboxCount
	$TotalInactiveMailboxCount = $entry.TotalInactiveMailboxCount
	$MailboxesOverWarningSize = $entry.MailboxesOverWarningSize
	$MailboxesUsedLessthan25Percent = $entry.MailboxesUsedLessthan25Percent
	Write-Host($TotalMailboxCount,$TotalInactiveMailboxCount,$MailboxesOverWarningSize,$MailboxesUsedLessthan25Percent) -Separator ";"
}
Write-Host("MailboxUsageDetailReport")
Write-Host("--------------------------")
if($bIsOverWarningQuota -eq "true")
{
	$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxUsageDetail?`$filter=Date eq datetime'"+$D + "' and IsOverWarningQuota eq "+$bIsOverWarningQuota + "&`$format=json"
}
else
{
	$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxUsageDetail?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
}
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
foreach($entry in $entries)
{
	$UserName = $entry.UserName
	$WindowsLiveID = $entry.WindowsLiveID
	$MailboxSize = $entry.MailboxSize
	$CurrentMailboxSize = $entry.CurrentMailboxSize
	$PercentUsed = $entry.PercentUsed
	$IsInactive = $entry.IsInactive
	$IssueWarningQuota = $entry.IssueWarningQuota
	$IsOverWarningQuota = $entry.IsOverWarningQuota
	Write-Host ($UserName,$WindowsLiveID,$MailboxSize,$CurrentMailboxSize,$PercentUsed,$IsInactive,$IssueWarningQuota,$IsOverWarningQuota) -separator ";"
}

Write-Host ("ConnectionbyClientTypeDaily")
Write-Host("--------------------------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/ConnectionbyClientTypeDaily?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
foreach($entry in $entries)
{
	$Date = $entry.Date
	$ClientType = $entry.ClientType
	$Count = $entry.Count
	$TenantName = $entry.TenantName
	Write-Host ($ClientType,$Count) -separator ";"
}
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/ConnectionbyClientTypeDetailDaily?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
foreach($entry in $entries)
{
	$Date = $entry.Date
	$ClientType = $entry.ClientType
	$Count = $entry.Count
	$TenantName = $entry.TenantName
	$UserName = $entry.UserName
	$WindowsLiveID = $entry.WindowsLiveID
	Write-Host ($UserName,$WindowsLiveID,$ClientType,$Count) -separator ";"
}

Write-Host("MailTraffic send and receive")
Write-Host("--------------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTraffic?`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
foreach($entry in $entries)
{
	$Organization = $entry.Organization
	$Domain = $entry.Domain
	$Date = $entry.Date
	$EventType = $entry.EventType
	$Direction = $entry.Direction
	$Action = $entry.Action
	$MessageCount = $entry.MessageCount
	#Write-Host ($Organization,$Domain,$Date,$EventType,$Direction,$Action,$MessageCount) -separator ";"
	Write-Host ($Direction,$EventType,$MessageCount) -separator ";"
}

Write-Host("TopRecipientsSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopMailRecipient'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("TopSendersSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopMailSender'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("TopSpamRecipientsSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopSpamRecipient'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("TopMalwareRecipientsSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopMalwareRecipient'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("License Usage")
Write-Host("---------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/LicenseVsUsageSummary?`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
foreach($entry in $entries)
{
	$Date = $entry.Date.ToString("yyyy-MM-dd")
	$Workload = $entry.Workload
	$TrailLicenses = $entry.TrialEntitlements
	$PaidLicenses = $entry.NonTrialEntitlements
	$ActiveUsers = $entry.ActiveUsers
	Write-Host($Workload,$TrailLicenses,$PaidLicenses,$ActiveUsers) -Separator ";"
}

Write-Host("Service Status Report")
Write-Host("-----------------------")
$json = (@{userName=$username;password=$pwd;} | convertto-json).tostring()
$cookie = (invoke-restmethod -contenttype "application/json" -method Post -uri "https://api.admin.microsoftonline.com/shdtenantcommunications.svc/Register" -body $json).RegistrationCookie
#preferredEventType -- "0" to represents a Service Incident, "1" to represent a Maintenance Event, and "2" to represent a Message Center communication 
$load = (@{lastCookie=$cookie;locale="en-US";preferredEventTypes=@(0);pastDays=$pastDays} | convertto-json).tostring()
$events = (invoke-restmethod -contenttype "application/json" -method Post -uri "https://api.admin.microsoftonline.com/shdtenantcommunications.svc/GetEvents" -body $load)
foreach($evnt in $events.events)
{
	$ID = $evnt.ID
	$Title = $evnt.Title
	$SVCNames = $evnt.AffectedServiceHealthStatus
	$Status = $evnt.Status
	$StrTime = $evnt.starttime
	$UpTime = $evnt.LastUpdatedTime
	foreach($SVCName in $SVCNames)
	{
		$features = $SVCName.ServiceFeatureStatus
		foreach($feature in $features)
		{
			Write-Host($SVCName.ServiceName+"\"+$feature.FeatureName+";"+$ID+";"+$Title+";"+$Status+";"+$StrTime+";"+$UpTime)
		}
	}
}



# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUiNjEaDpCzYNGqWwg0TyMS0Fx
# 2LWggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQU1HoxhIjpjhngzW44x5HmLX7P
# 4PAwDQYJKoZIhvcNAQEBBQAEggEAfRI0wbA1lAyzcjaHXxJ6JfUdHwf5wmYLpMZe
# rF/2AxxMSh6u2HC9OdVzYsv7Or8738Rv1kxAJmsZoXpwWXGufQZvXK4CP/OnnRJJ
# lcbrA4joCcC/P8mVjUPbsZuuBjXUrx+K6WgGwPoXWWeTvGzP1PVhfHngNSr8f4I6
# 85zGPNW0lvyWt9gzt6wr2y2qpk2hwjWEXoJfQZQQ47/6NK4DvQ8DpwElCoaYQTaI
# GxuEobF7c8aHSviGBZUQzjWsMzYHSt8hKVA8u02VxLfSZ8bq97n2nvp/LXxISz4B
# CcI9XUQ6tmj/weDsmdJDXW84aRpwSS0yXz/FdAZ3s8Tg6VOB6qGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwNzIzMDIwNDA5WjAjBgkqhkiG9w0BCQQxFgQUJHinKlYKufuMjR1D57zX
# 0ZD62PowDQYJKoZIhvcNAQEBBQAEggEATHQG7Blv0kQKInGtk3LU9jH3TyfOXF+S
# Pu95ztiDLZ9NkqbgvRC5Y0NV813EUx3t4vDX8YTXCF3n3J7atzEno7e/j3tyXMpC
# ygrL8GVTuvB9Ct11crNzysaV/SZcAoCuv8aA78NYzta3s5+NMMEx/3Gzn1YYOgdk
# vKm7uM9ZrtycYO0NhlnqlrjdQH9G4YqibW3+iZOcSfzO4+Ofg+VfTr18Hf8+29z+
# XfAKo7TwxeFwwDkU2iMIt9HdxdBQQJv5BDc/7rPTcNswsaNU8sjaZMj6zYgb/kLF
# 8qliXFYfKJKggQbqHGw5r6dvpzjJtFX50KLc+oZla+t+s/oDrbMNlw==
# SIG # End signature block
