/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.egurkha.util.EgJNIUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

class SystemTest
extends EgTest {
    private ArrayList processorRes = new ArrayList();
    private int repeat = 2;
    private int period;
    private String index;
    public double cpuUtil = 0.0;
    private double run = 0.0;
    private double block = 0.0;
    private double swap = 0.0;
    private double free = 0.0;
    private double scan = 0.0;
    private double sysCpu = 0.0;
    private double stealTime = -5.0;
    private double mpSteal = -5.0;
    String targetHost;
    SystemTestHelper helper;
    public String comp = "";
    private String method;
    String[] prcrinst = null;
    public boolean isEnabledFreeMemDD = false;
    public boolean isDoneCpuDD = false;
    public boolean isDoneMemDD = false;
    private int index_proc = 0;
    private boolean isMultiProcessor = false;
    private static int cpuUtilIndex = 0;
    private static int sysCpuIndex = 1;
    private static int runIndex = 2;
    private static int blockIndex = 3;
    private static int swapIndex = 4;
    private static int freeIndex = 5;
    private static int scanIndex = 6;
    private static int stealIndex = 7;
    private static int totalMemMeasures = 4;
    private static int totalProcMeasures = 2;
    private int numProcessors = -1;
    private double[] memResults;
    private double[] procResults;
    public Boolean lock;
    private boolean summary = false;
    private String sindex;
    private boolean useiostat = false;
    String myos = null;
    public ArrayList System_dd = null;
    public ArrayList process_list_linux = null;
    public ArrayList cpu_list_linux = null;
    public ArrayList mem_list_linux = null;
    public static Hashtable systemHash = new Hashtable();
    public static Hashtable systemLastRunHash = new Hashtable();
    private static String lparstatcmd = "uname -L";
    public boolean isLpar = false;
    public boolean isRealLpar = false;
    private boolean firstTime = true;
    public Hashtable topCpu = null;
    private boolean hpuxFirstTime = true;
    public int hpuxRamSize = -1;
    public int hpuxPageSize = -1;
    public boolean isCpuFromIdle = false;
    public boolean usePs = false;
    public boolean realUsePs = false;
    public boolean aixUsePs = false;
    private boolean isNuma = true;
    private boolean use_top_forDD = false;
    private boolean showStealTime = false;
    private boolean highSecure = false;

    public void freeTest() {
        this.System_dd = null;
        this.process_list_linux = null;
        this.cpu_list_linux = null;
        this.mem_list_linux = null;
        this.topCpu = null;
        this.isDoneCpuDD = false;
        this.isDoneMemDD = false;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.73", "-duration", "5", "-ddFreq", "1:1", "-summary", "yes", "-useiostat", "no", "-agentless", "n"};
        SystemTest systemTest = new SystemTest(stringArray2);
        while (true) {
            try {
                systemTest.executeTest();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
            }
        }
    }

    public SystemTest(String[] stringArray) {
        super(stringArray);
        String string;
        this.numOutputFields = 8;
        if (stringArray.length < 4 || !stringArray[0].equalsIgnoreCase("-host") || !stringArray[2].equalsIgnoreCase("-duration")) {
            System.err.println("Usage: SystemTest -host <hostName> -duration <period> -method <perfmon/none> -summary <yes/no>");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-host")) {
                if (++i < stringArray.length) {
                    this.targetHost = new String(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: SystemTest -host <host> -user <userName> -pwd <passWords> -method <perfmon/none>");
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-duration")) {
                if (++i < stringArray.length) {
                    this.period = Integer.parseInt(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: SystemTest -host <host> -user <userName> -pwd <passWords> -method <perfmon/none>");
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-summary")) {
                if (++i < stringArray.length) {
                    this.summary = false;
                    if (!stringArray[i].equalsIgnoreCase("yes") && !stringArray[i].equalsIgnoreCase("y")) continue;
                    this.summary = true;
                    continue;
                }
                System.err.println("Usage: SystemTest -host <host> -user <userName> -pwd <passWords> -method <perfmon/none>");
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-useiostat")) {
                if (!stringArray[++i].equalsIgnoreCase("yes") && !stringArray[i].equalsIgnoreCase("y")) continue;
                this.useiostat = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-enable_memory_diagnosis")) {
                if ((string = stringArray[++i].trim()).equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("Y")) {
                    this.isEnabledFreeMemDD = true;
                    continue;
                }
                this.isEnabledFreeMemDD = false;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-include_wait")) {
                if ((string = stringArray[++i].trim()) != null && (string.equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("Y"))) {
                    this.isCpuFromIdle = true;
                    continue;
                }
                this.isCpuFromIdle = false;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-usePS")) {
                if ((string = stringArray[++i].trim()) != null && (string.equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("Y"))) {
                    this.usePs = true;
                    continue;
                }
                this.usePs = false;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-isQVD")) {
                if (!stringArray[++i].equalsIgnoreCase("yes") && !stringArray[i].equalsIgnoreCase("true")) continue;
                this.needAgentlessDD = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-use_top_for_DD")) {
                if ((string = stringArray[++i].trim()) != null && (string.equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("Y"))) {
                    this.use_top_forDD = true;
                    continue;
                }
                this.use_top_forDD = false;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-Show_steal_time")) {
                if ((string = stringArray[++i].trim()) != null && (string.equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("Y"))) {
                    this.showStealTime = true;
                    continue;
                }
                this.showStealTime = false;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-high_security")) continue;
            this.highSecure = (string = stringArray[++i].trim()) != null && (string.equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("Y"));
        }
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
        string = iniFile.getValue("AGENT_SETTINGS", "AIXusePS");
        this.aixUsePs = string != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true"));
        this.memResults = new double[totalMemMeasures];
        if (!this.meAgentless) {
            String string2 = System.getProperty("os.name");
            WindowsOsHelper windowsOsHelper = new WindowsOsHelper(this.reportingName, this.meAgentless);
            String string3 = windowsOsHelper.setOs();
            if (string3 != null && string3.trim().length() > 0) {
                string2 = string3.trim();
            }
            if (string2.indexOf("2008") > -1 || string2.indexOf("Vista") > -1 || string2.indexOf("Windows 7") > -1) {
                this.myos = "2008";
            } else if (string2.indexOf("Windows 8") > -1 || string2.indexOf("2012") > -1 || string2.indexOf("Windows 10") > -1) {
                this.myos = "2012";
            } else if (string2.indexOf("2016") > -1) {
                this.myos = "2016";
            } else if (string2.indexOf("2019") > -1) {
                this.myos = "2019";
            } else if (string2.equalsIgnoreCase("Windows XP") || string2.equalsIgnoreCase("Windows 2003")) {
                this.myos = "2003";
            } else if (string2.equalsIgnoreCase("Windows 2000")) {
                this.myos = "2000";
            } else if (string2.equalsIgnoreCase("Windows NT")) {
                this.myos = "nt";
            } else if (string2.indexOf("Windows") > -1) {
                this.myos = "2012";
            }
        }
        this.isNuma = this.getNuma();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeTest() {
        this.initTest();
        if (!this.meAgentless) {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            double[][] dArray;
            if (this.helper == null) {
                this.helper = new SystemTestHelper(this.myos);
                this.discCount = 0;
            }
            if (this.discCount >= this.maxDiscCount) {
                this.discCount = 0;
            }
            if (this.discCount == 0) {
                this.numProcessors = this.helper.getLocalProcessors();
                if (this.numProcessors <= 0) {
                    this.errorMsg = "SystemTest failed to determine the no of processors in  " + this.targetHost;
                    this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                    this.updateAllResultSets();
                    this.removeJNIFromMemory();
                    this.helper = null;
                    return false;
                }
                if (this.numProcessors >= 1) {
                    this.sindex = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Summary");
                }
                this.prcrinst = new String[this.numProcessors];
                for (int i = 0; i < this.numProcessors; ++i) {
                    this.prcrinst[i] = "" + i;
                }
            }
            ++this.discCount;
            double[] dArray2 = null;
            double[] dArray3 = null;
            double[][] dArray4 = new double[this.numProcessors][totalProcMeasures];
            boolean bl = false;
            for (int i = 0; i < this.memResults.length; ++i) {
                this.memResults[i] = -5.0;
            }
            dArray3 = this.helper.getMemMeasures();
            if (dArray3 == null) {
                this.errorMsg = "SystemTest failed to get the memory values for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
            }
            if ((dArray2 = this.helper.getSysMeasures()) == null) {
                this.errorMsg = "SystemTest failed to get the system values for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
            }
            if (dArray2 != null) {
                if (dArray2[0] < 0.0) {
                    dArray2[0] = -5.0;
                }
                this.memResults[0] = dArray2[0];
            }
            if (dArray3 != null) {
                if (dArray3[0] < 0.0) {
                    dArray3[0] = -5.0;
                }
                this.memResults[1] = dArray3[0] / 1048576.0;
                if (dArray3[1] < 0.0) {
                    dArray3[1] = -5.0;
                }
                this.memResults[2] = dArray3[1] / 1048576.0;
                if (dArray3[2] < 0.0) {
                    dArray3[2] = -5.0;
                }
                this.memResults[3] = dArray3[2];
            }
            if (this.showStealTime && (dArray = this.helper.getVMMeasures(stringArray3 = new String[]{"_Total"})) != null) {
                this.stealTime = dArray[0][0] / 1000.0 * 100.0;
                if (this.stealTime > 0.0 && this.numProcessors > 0) {
                    this.stealTime /= (double)this.numProcessors;
                }
            }
            this.System_dd = this.getProcessInfo();
            ArrayList<String> arrayList = null;
            if (this.processorRes == null || this.processorRes.size() == 0) {
                this.errorMsg = "SystemTest failed to get the Processor measures for  " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                if (this.numProcessors != 1) {
                    this.updateAllResultSets();
                    this.removeJNIFromMemory();
                    this.helper = null;
                    return false;
                }
                EgJNIUtil egJNIUtil = new EgJNIUtil();
                stringArray2 = new String[]{"System", "Idle"};
                stringArray = new String[]{"% Processor Time"};
                double[][] dArray5 = egJNIUtil.getCounterValue("Process", stringArray2, stringArray);
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                dArray5 = egJNIUtil.getCounterValue("Process", stringArray2, stringArray);
                if (dArray5 != null) {
                    bl = true;
                    double d = 100.0 - dArray5[1][0];
                    double d2 = dArray5[0][0];
                    dArray4 = new double[this.numProcessors][2];
                    for (int i = 0; i < this.numProcessors; ++i) {
                        dArray4[i][0] = d;
                        dArray4[i][1] = d2;
                    }
                }
            } else {
                void var6_54;
                arrayList = new ArrayList<String>();
                dArray4 = new double[this.processorRes.size()][2];
                boolean bl2 = false;
                while (var6_54 < this.processorRes.size()) {
                    stringArray2 = (String[])this.processorRes.get((int)var6_54);
                    stringArray = new StringTokenizer((String)stringArray2, "@");
                    if (stringArray.countTokens() >= 4) {
                        stringArray.nextToken();
                        arrayList.add(stringArray.nextToken());
                        double d = -5.0;
                        double d3 = -5.0;
                        try {
                            d = Double.parseDouble(stringArray.nextToken());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            d3 = Double.parseDouble(stringArray.nextToken());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (d < 0.0) {
                            d = -5.0;
                        }
                        if (d3 < 0.0) {
                            d3 = -5.0;
                        }
                        dArray4[var6_54][0] = d;
                        dArray4[var6_54][1] = d3;
                    }
                    ++var6_54;
                }
            }
            this.memResults[0] = this.memResults[0] >= 0.0 ? this.memResults[0] : -5.0;
            this.memResults[1] = this.memResults[1] >= 0.0 ? this.memResults[1] : -5.0;
            this.memResults[2] = this.memResults[2] >= 0.0 ? this.memResults[2] : -5.0;
            this.memResults[3] = this.memResults[3] >= 0.0 ? this.memResults[3] : -5.0;
            double d = 0.0;
            double d4 = 0.0;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.numProcessors; ++i) {
                if (dArray4[i][cpuUtilIndex] < 0.0) {
                    dArray4[i][SystemTest.cpuUtilIndex] = -5.0;
                } else {
                    d += dArray4[i][cpuUtilIndex];
                    ++n;
                }
                if (dArray4[i][sysCpuIndex] < 0.0) {
                    dArray4[i][SystemTest.sysCpuIndex] = -5.0;
                }
                if (dArray4[i][cpuUtilIndex] >= 0.0 && dArray4[i][sysCpuIndex] >= 0.0 && !bl) {
                    dArray4[i][SystemTest.sysCpuIndex] = dArray4[i][cpuUtilIndex] - dArray4[i][sysCpuIndex];
                }
                if (dArray4[i][sysCpuIndex] < 0.0) {
                    dArray4[i][SystemTest.sysCpuIndex] = -5.0;
                } else {
                    d4 += dArray4[i][sysCpuIndex];
                    ++n2;
                }
                if (arrayList == null) {
                    this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Processor_" + i);
                } else {
                    String string = (String)arrayList.get(i);
                    if (this.isNuma) {
                        string = string.replace(',', '_');
                    }
                    this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Processor_" + string);
                }
                if (dArray4[i][cpuUtilIndex] > 100.0) {
                    dArray4[i][SystemTest.cpuUtilIndex] = 100.0;
                }
                if (dArray4[i][sysCpuIndex] > 100.0) {
                    dArray4[i][SystemTest.sysCpuIndex] = 100.0;
                }
                this.addValueToResultSet(this.index, cpuUtilIndex, dArray4[i][cpuUtilIndex]);
                this.addValueToResultSet(this.index, sysCpuIndex, dArray4[i][sysCpuIndex]);
                if (this.numProcessors >= 1 && this.summary) {
                    this.addValueToResultSet(this.index, runIndex, -5.0);
                    this.addValueToResultSet(this.index, freeIndex, -5.0);
                    this.addValueToResultSet(this.index, scanIndex, -5.0);
                    this.addValueToResultSet(this.index, blockIndex, -5.0);
                    this.addValueToResultSet(this.index, swapIndex, -5.0);
                    this.addValueToResultSet(this.index, stealIndex, -5.0);
                    continue;
                }
                this.addValueToResultSet(this.index, runIndex, this.memResults[0]);
                this.addValueToResultSet(this.index, freeIndex, this.memResults[2]);
                this.addValueToResultSet(this.index, scanIndex, this.memResults[3]);
                this.addValueToResultSet(this.index, blockIndex, 0.0);
                this.addValueToResultSet(this.index, swapIndex, this.memResults[1]);
                this.addValueToResultSet(this.index, stealIndex, this.stealTime);
            }
            if (this.numProcessors >= 1 && this.summary) {
                if (n > 0 && (d /= (double)n) > 100.0) {
                    d = 100.0;
                }
                if (n2 > 0 && (d4 /= (double)n2) > 100.0) {
                    d4 = 100.0;
                }
                this.index = this.sindex;
                this.addValueToResultSet(this.index, cpuUtilIndex, d);
                this.addValueToResultSet(this.index, sysCpuIndex, d4);
                this.addValueToResultSet(this.index, runIndex, this.memResults[0]);
                this.addValueToResultSet(this.index, freeIndex, this.memResults[2]);
                this.addValueToResultSet(this.index, scanIndex, this.memResults[3]);
                this.addValueToResultSet(this.index, blockIndex, 0.0);
                this.addValueToResultSet(this.index, swapIndex, this.memResults[1]);
                this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                systemHash.put(this.reportingName, new Double(d));
                systemLastRunHash.put(this.reportingName, new Long(System.currentTimeMillis()));
            }
            this.updateAllResultSets();
            this.stopTest();
            return true;
        }
        if (this.isPerfmon) {
            try {
                this.checkNbt();
                if (this.nbtName == null) {
                    this.errorMsg = "Failed to get the NETBios name for  " + this.targetHost;
                    this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                    this.removeJNIFromMemory();
                    this.helper = null;
                    this.updateAllResultSets();
                    return false;
                }
                if (this.helper == null) {
                    this.helper = new SystemTestHelper(this.nbtName, this.alos);
                    this.discCount = 0;
                }
                if (this.discCount >= this.maxDiscCount) {
                    this.discCount = 0;
                }
                if (this.discCount == 0) {
                    this.prcrinst = this.helper.getListOfProcessors();
                    if (this.prcrinst == null) {
                        this.errorMsg = "SystemTest failed to find the list of processor for " + this.targetHost;
                        this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                        this.updateAllResultSets();
                        this.removeJNIFromMemory();
                        this.helper = null;
                        return false;
                    }
                    this.numProcessors = this.prcrinst.length;
                    if (this.numProcessors <= 0) {
                        this.errorMsg = "SystemTest failed to determine the no of processors in  " + this.targetHost;
                        this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                        this.updateAllResultSets();
                        this.removeJNIFromMemory();
                        this.helper = null;
                        return false;
                    }
                    if (this.numProcessors >= 1) {
                        this.sindex = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Summary");
                    }
                }
                ++this.discCount;
                double[] dArray = null;
                double[] dArray6 = null;
                double[][] dArray7 = new double[this.numProcessors][totalProcMeasures];
                for (int i = 0; i < this.memResults.length; ++i) {
                    this.memResults[i] = -1.0;
                }
                dArray6 = this.helper.getMemMeasures();
                if (dArray6 == null) {
                    this.errorMsg = "SystemTest failed to get the memory values for " + this.targetHost;
                    this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                    this.updateAllResultSets();
                    this.removeJNIFromMemory();
                    this.helper = null;
                    return false;
                }
                String[] stringArray = new String[]{"_Total"};
                double[][] dArray8 = this.helper.getVMMeasures(stringArray);
                if (dArray8 != null) {
                    this.stealTime = dArray8[0][0] / 1000.0 * 100.0;
                    if (this.stealTime > 0.0 && this.numProcessors > 0) {
                        this.stealTime /= (double)this.numProcessors;
                    }
                }
                if ((dArray = this.helper.getSysMeasures()) == null) {
                    this.errorMsg = "SystemTest failed to get the system values for " + this.targetHost;
                    this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                    this.updateAllResultSets();
                    this.removeJNIFromMemory();
                    this.helper = null;
                    return false;
                }
                if (dArray[0] < 0.0) {
                    dArray[0] = -5.0;
                }
                this.memResults[0] = dArray[0];
                if (dArray6[0] < 0.0) {
                    dArray6[0] = -5.0;
                }
                this.memResults[1] = dArray6[0] / 1048576.0;
                if (dArray6[1] < 0.0) {
                    dArray6[1] = -5.0;
                }
                this.memResults[2] = dArray6[1] / 1048576.0;
                if (dArray6[2] < 0.0) {
                    dArray6[2] = -5.0;
                }
                this.memResults[3] = dArray6[2];
                this.System_dd = this.getProcessInfo(this.nbtName, this.alos);
                Object var6_56 = null;
                if (this.processorRes != null && this.processorRes.size() > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    dArray7 = new double[this.processorRes.size()][2];
                    this.numProcessors = this.processorRes.size();
                    for (int i = 0; i < this.processorRes.size(); ++i) {
                        String string = (String)this.processorRes.get(i);
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "@");
                        if (stringTokenizer.countTokens() < 4) continue;
                        stringTokenizer.nextToken();
                        arrayList.add(stringTokenizer.nextToken());
                        double d = -5.0;
                        double d5 = -5.0;
                        try {
                            d = Double.parseDouble(stringTokenizer.nextToken());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            d5 = Double.parseDouble(stringTokenizer.nextToken());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (d < 0.0) {
                            d = -5.0;
                        }
                        if (d5 < 0.0) {
                            d5 = -5.0;
                        }
                        dArray7[i][0] = d;
                        dArray7[i][1] = d5;
                    }
                }
                if (dArray7 == null) {
                    this.errorMsg = "SystemTest failed to get the Processor measures for  " + this.targetHost;
                    this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                    this.updateAllResultSets();
                    this.removeJNIFromMemory();
                    this.helper = null;
                    return false;
                }
                this.memResults[0] = this.memResults[0] >= 0.0 ? this.memResults[0] : -5.0;
                this.memResults[1] = this.memResults[1] >= 0.0 ? this.memResults[1] : -5.0;
                this.memResults[2] = this.memResults[2] >= 0.0 ? this.memResults[2] : -5.0;
                this.memResults[3] = this.memResults[3] >= 0.0 ? this.memResults[3] : -5.0;
                double d = 0.0;
                double d6 = 0.0;
                int n = 0;
                int n3 = 0;
                for (int i = 0; i < this.numProcessors; ++i) {
                    void var6_58;
                    if (dArray7[i][cpuUtilIndex] < 0.0) {
                        dArray7[i][SystemTest.cpuUtilIndex] = -5.0;
                    } else {
                        d += dArray7[i][cpuUtilIndex];
                        ++n;
                    }
                    if (dArray7[i][sysCpuIndex] < 0.0) {
                        dArray7[i][SystemTest.sysCpuIndex] = -5.0;
                    }
                    if (dArray7[i][cpuUtilIndex] >= 0.0 && dArray7[i][sysCpuIndex] >= 0.0) {
                        dArray7[i][SystemTest.sysCpuIndex] = dArray7[i][cpuUtilIndex] - dArray7[i][sysCpuIndex];
                    }
                    if (dArray7[i][sysCpuIndex] < 0.0) {
                        dArray7[i][SystemTest.sysCpuIndex] = -5.0;
                    } else {
                        d6 += dArray7[i][sysCpuIndex];
                        ++n3;
                    }
                    if (var6_58 == null) {
                        this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Processor_" + i);
                    } else {
                        String string = (String)var6_58.get(i);
                        if (this.isNuma) {
                            string = string.replace(',', '_');
                        }
                        this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Processor_" + string);
                    }
                    if (dArray7[i][cpuUtilIndex] > 100.0) {
                        dArray7[i][SystemTest.cpuUtilIndex] = 100.0;
                    }
                    if (dArray7[i][sysCpuIndex] > 100.0) {
                        dArray7[i][SystemTest.sysCpuIndex] = 100.0;
                    }
                    this.addValueToResultSet(this.index, cpuUtilIndex, dArray7[i][cpuUtilIndex]);
                    this.addValueToResultSet(this.index, sysCpuIndex, dArray7[i][sysCpuIndex]);
                    if (this.numProcessors >= 1 && this.summary) {
                        this.addValueToResultSet(this.index, runIndex, -5.0);
                        this.addValueToResultSet(this.index, freeIndex, -5.0);
                        this.addValueToResultSet(this.index, scanIndex, -5.0);
                        this.addValueToResultSet(this.index, blockIndex, -5.0);
                        this.addValueToResultSet(this.index, swapIndex, -5.0);
                        this.addValueToResultSet(this.index, stealIndex, -5.0);
                        continue;
                    }
                    this.addValueToResultSet(this.index, runIndex, this.memResults[0]);
                    this.addValueToResultSet(this.index, freeIndex, this.memResults[2]);
                    this.addValueToResultSet(this.index, scanIndex, this.memResults[3]);
                    this.addValueToResultSet(this.index, blockIndex, 0.0);
                    this.addValueToResultSet(this.index, swapIndex, this.memResults[1]);
                    this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                }
                if (this.numProcessors >= 1 && this.summary) {
                    if (n > 0 && (d /= (double)n) > 100.0) {
                        d = 100.0;
                    }
                    if (n3 > 0 && (d6 /= (double)n3) > 100.0) {
                        d6 = 100.0;
                    }
                    this.index = this.sindex;
                    this.addValueToResultSet(this.index, cpuUtilIndex, d);
                    this.addValueToResultSet(this.index, sysCpuIndex, d6);
                    this.addValueToResultSet(this.index, runIndex, this.memResults[0]);
                    this.addValueToResultSet(this.index, freeIndex, this.memResults[2]);
                    this.addValueToResultSet(this.index, scanIndex, this.memResults[3]);
                    this.addValueToResultSet(this.index, blockIndex, 0.0);
                    this.addValueToResultSet(this.index, swapIndex, this.memResults[1]);
                    this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                    systemHash.put(this.reportingName, new Double(d));
                    systemLastRunHash.put(this.reportingName, new Long(System.currentTimeMillis()));
                }
                this.updateAllResultSets();
                this.stopTest();
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.errorMsg = new String("Exception in SystemTest " + this.targetHost);
                this.updateAllResultSets();
                this.removeJNIFromMemory();
                this.helper = null;
                return false;
            }
        }
        if ((this.isSSH || this.isRexec) && this.alos.equalsIgnoreCase("solaris")) {
            if (this.alpassword.equalsIgnoreCase("none") || this.aluser.equalsIgnoreCase("NONE")) {
                this.errorMsg = "SystemTest is configured in Agentless and os/aluser can't  be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.updateAllResultSets();
                return false;
            }
            String string = "";
            if (this.isSSH) {
                string = "ssh";
            } else if (this.isRexec) {
                string = "rexec";
            }
            SystemGeneric systemGeneric = new SystemGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword, this.isCpuFromIdle);
            try {
                this.isMultiProcessor = systemGeneric.checkForMultiProcs();
                if (!this.isMultiProcessor) {
                    this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator);
                } else {
                    this.index = "";
                    this.sindex = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Summary");
                }
                String string2 = null;
                string2 = systemGeneric.getActualResultsOnSolaris(this.period);
                StringTokenizer stringTokenizer = null;
                if (string2 == null) {
                    this.updateAllResultSets();
                    return true;
                }
                stringTokenizer = new StringTokenizer(string2, "#");
                if (stringTokenizer.countTokens() <= 0) {
                    this.updateAllResultSets();
                    return true;
                }
                Double d = new Double(stringTokenizer.nextToken());
                this.cpuUtil = d;
                d = new Double(stringTokenizer.nextToken());
                this.sysCpu = d;
                d = new Double(stringTokenizer.nextToken());
                this.run = d;
                d = new Double(stringTokenizer.nextToken());
                this.block = d;
                d = new Double(stringTokenizer.nextToken());
                this.swap = d;
                d = new Double(stringTokenizer.nextToken());
                this.free = d;
                d = new Double(stringTokenizer.nextToken());
                this.scan = d;
                if (!this.isMultiProcessor) {
                    if (!this.useiostat) {
                        if (this.cpuUtil > 100.0) {
                            this.cpuUtil = 100.0;
                        }
                        if (this.sysCpu > 100.0) {
                            this.sysCpu = 100.0;
                        }
                        this.addValueToResultSet(this.index, cpuUtilIndex, this.cpuUtil);
                        this.addValueToResultSet(this.index, sysCpuIndex, this.sysCpu);
                        this.addValueToResultSet(this.index, runIndex, this.run);
                        this.addValueToResultSet(this.index, freeIndex, this.free);
                        this.addValueToResultSet(this.index, scanIndex, this.scan);
                        this.addValueToResultSet(this.index, blockIndex, this.block);
                        this.addValueToResultSet(this.index, swapIndex, this.swap);
                        this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                    } else {
                        systemGeneric.executeiostat();
                        double d7 = systemGeneric.getIoStatCpu();
                        double d8 = systemGeneric.getIoStatSysCpu();
                        if (d7 > 100.0) {
                            d7 = 100.0;
                        }
                        if (d8 > 100.0) {
                            d8 = 100.0;
                        }
                        this.addValueToResultSet(this.index, cpuUtilIndex, d7);
                        this.addValueToResultSet(this.index, sysCpuIndex, d8);
                        this.addValueToResultSet(this.index, runIndex, this.run);
                        this.addValueToResultSet(this.index, freeIndex, this.free);
                        this.addValueToResultSet(this.index, scanIndex, this.scan);
                        this.addValueToResultSet(this.index, blockIndex, this.block);
                        this.addValueToResultSet(this.index, swapIndex, this.swap);
                        this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                    }
                } else if (this.isMultiProcessor) {
                    ArrayList arrayList = systemGeneric.runMultiProcsTest(this.run, this.block, this.swap, this.free, this.scan, this.useiostat);
                    if (arrayList == null) {
                        this.updateAllResultSets();
                        return true;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string3 = (String)arrayList.get(i);
                        if (string3 == null) {
                            return true;
                        }
                        stringTokenizer = new StringTokenizer(string3, "#");
                        if (stringTokenizer.countTokens() < 7) {
                            this.updateAllResultSets();
                            return true;
                        }
                        String string4 = stringTokenizer.nextToken();
                        this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + string4);
                        d = new Double(stringTokenizer.nextToken());
                        this.cpuUtil = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.sysCpu = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.run = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.block = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.swap = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.free = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.scan = d;
                        if (this.useiostat) continue;
                        if (this.cpuUtil > 100.0) {
                            this.cpuUtil = 100.0;
                        }
                        if (this.sysCpu > 100.0) {
                            this.sysCpu = 100.0;
                        }
                        if (this.summary) {
                            this.addValueToResultSet(this.index, cpuUtilIndex, this.cpuUtil);
                            this.addValueToResultSet(this.index, sysCpuIndex, this.sysCpu);
                            this.addValueToResultSet(this.index, runIndex, -5.0);
                            this.addValueToResultSet(this.index, freeIndex, -5.0);
                            this.addValueToResultSet(this.index, scanIndex, -5.0);
                            this.addValueToResultSet(this.index, blockIndex, -5.0);
                            this.addValueToResultSet(this.index, swapIndex, -5.0);
                            this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                            continue;
                        }
                        this.addValueToResultSet(this.index, cpuUtilIndex, this.cpuUtil);
                        this.addValueToResultSet(this.index, sysCpuIndex, this.sysCpu);
                        this.addValueToResultSet(this.index, runIndex, this.run);
                        this.addValueToResultSet(this.index, freeIndex, this.free);
                        this.addValueToResultSet(this.index, scanIndex, this.scan);
                        this.addValueToResultSet(this.index, blockIndex, this.block);
                        this.addValueToResultSet(this.index, swapIndex, this.swap);
                        this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                    }
                    if (this.summary && arrayList.size() > 0) {
                        String string5 = systemGeneric.getSummaryInfo();
                        if (string5 == null) {
                            this.updateAllResultSets();
                            return true;
                        }
                        stringTokenizer = new StringTokenizer(string5, "#");
                        if (stringTokenizer.countTokens() < 6) {
                            this.updateAllResultSets();
                            return true;
                        }
                        d = new Double(stringTokenizer.nextToken());
                        this.cpuUtil = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.sysCpu = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.run = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.block = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.swap = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.free = d;
                        d = new Double(stringTokenizer.nextToken());
                        this.scan = d;
                        if (this.cpuUtil > 100.0) {
                            this.cpuUtil = 100.0;
                        }
                        if (this.sysCpu > 100.0) {
                            this.sysCpu = 100.0;
                        }
                        this.addValueToResultSet(this.sindex, cpuUtilIndex, this.cpuUtil);
                        this.addValueToResultSet(this.sindex, sysCpuIndex, this.sysCpu);
                        this.addValueToResultSet(this.sindex, runIndex, this.run);
                        this.addValueToResultSet(this.sindex, freeIndex, this.free);
                        this.addValueToResultSet(this.sindex, scanIndex, this.scan);
                        this.addValueToResultSet(this.sindex, blockIndex, this.block);
                        this.addValueToResultSet(this.sindex, swapIndex, this.swap);
                        this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                    }
                }
                this.getLinuxprocess(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
                this.updateAllResultSets();
                return true;
            }
            catch (Exception exception) {
                this.updateAllResultSets();
                exception.printStackTrace();
                return true;
            }
        }
        if ((this.isSSH || this.isRexec) && this.alos.equalsIgnoreCase("aix")) {
            if (this.alpassword.equalsIgnoreCase("none") || this.aluser.equalsIgnoreCase("NONE")) {
                this.errorMsg = "SystemTest is configured in Agentless and os/aluser can't  be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.updateAllResultSets();
                return false;
            }
            String string = "";
            if (this.isSSH) {
                string = "ssh";
            } else if (this.isRexec) {
                string = "rexec";
            }
            SystemGeneric systemGeneric = new SystemGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword, this.isCpuFromIdle);
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
            String string6 = iniFile.getValue("AGENT_SETTINGS", "AIXusePS");
            this.aixUsePs = string6 != null && (string6.equalsIgnoreCase("yes") || string6.equalsIgnoreCase("true"));
            this.realUsePs = this.usePs || this.aixUsePs;
            try {
                Object object;
                if (this.firstTime) {
                    String string7;
                    object = this.getRemoteValues(string, this.targetHost, this.sshPort, this.aluser, this.alpassword, lparstatcmd);
                    if (object != null && ((ArrayList)object).size() > 0 && (string7 = (String)((ArrayList)object).get(0)) != null && string7.length() > 0) {
                        this.isRealLpar = string7.indexOf("-1") <= -1 || string7.indexOf("NULL") <= -1;
                    }
                    this.firstTime = false;
                }
                this.isLpar = this.realUsePs ? false : this.isRealLpar;
                object = systemGeneric.getActualResultsOnAix(this.period);
                if (object == null) {
                    this.updateAllResultSets();
                    return true;
                }
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, "#");
                if (stringTokenizer.countTokens() < 6) {
                    this.updateAllResultSets();
                    return true;
                }
                this.getLinuxprocess(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
                this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Summary");
                Double d = new Double(stringTokenizer.nextToken());
                this.cpuUtil = d;
                d = new Double(stringTokenizer.nextToken());
                this.sysCpu = d;
                d = new Double(stringTokenizer.nextToken());
                this.run = d;
                d = new Double(stringTokenizer.nextToken());
                this.block = d;
                d = new Double(stringTokenizer.nextToken());
                this.swap = d;
                d = new Double(stringTokenizer.nextToken());
                this.free = d;
                d = new Double(stringTokenizer.nextToken());
                this.scan = d;
                if (this.cpuUtil > 0.0 && this.isLpar) {
                    GetTprofRemote getTprofRemote = new GetTprofRemote(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
                    Hashtable hashtable = getTprofRemote.runTprof();
                    this.topCpu = (Hashtable)hashtable.get("topcpu");
                }
                if (this.cpuUtil > 100.0) {
                    this.cpuUtil = 100.0;
                }
                if (this.sysCpu > 100.0) {
                    this.sysCpu = 100.0;
                }
                this.addValueToResultSet(this.index, cpuUtilIndex, this.cpuUtil);
                this.addValueToResultSet(this.index, sysCpuIndex, this.sysCpu);
                this.addValueToResultSet(this.index, runIndex, this.run);
                this.addValueToResultSet(this.index, freeIndex, this.free);
                this.addValueToResultSet(this.index, scanIndex, this.scan);
                this.addValueToResultSet(this.index, blockIndex, this.block);
                this.addValueToResultSet(this.index, swapIndex, this.swap);
                this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                this.updateAllResultSets();
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.updateAllResultSets();
                return true;
            }
        }
        if ((this.isSSH || this.isRexec) && this.alos.equalsIgnoreCase("hpux")) {
            if (this.alpassword.equalsIgnoreCase("none") || this.aluser.equalsIgnoreCase("NONE")) {
                this.errorMsg = "SystemTest is configured in Agentless and os/aluser can't  be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.updateAllResultSets();
                return false;
            }
            try {
                String string = "";
                if (this.isSSH) {
                    string = "ssh";
                } else if (this.isRexec) {
                    string = "rexec";
                }
                SystemGeneric systemGeneric = new SystemGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword, this.isCpuFromIdle);
                String string8 = null;
                string8 = systemGeneric.getActualResultsOnHPUnix(this.period);
                StringTokenizer stringTokenizer = null;
                if (string8 == null) {
                    this.updateAllResultSets();
                    return true;
                }
                stringTokenizer = new StringTokenizer(string8, "#");
                if (stringTokenizer.countTokens() <= 0) {
                    this.updateAllResultSets();
                    return true;
                }
                this.getLinuxprocess(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
                this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Summary");
                Double d = new Double(stringTokenizer.nextToken());
                this.cpuUtil = d;
                d = new Double(stringTokenizer.nextToken());
                this.sysCpu = d;
                d = new Double(stringTokenizer.nextToken());
                this.run = d;
                d = new Double(stringTokenizer.nextToken());
                this.block = d;
                d = new Double(stringTokenizer.nextToken());
                this.swap = d;
                d = new Double(stringTokenizer.nextToken());
                double d9 = d;
                if (d9 > 0.0 && this.hpuxPageSize > 0) {
                    int n = this.hpuxPageSize / 1024;
                    this.free = d9 * (double)n / 1024.0;
                }
                d = new Double(stringTokenizer.nextToken());
                this.scan = d;
                if (this.cpuUtil > 100.0) {
                    this.cpuUtil = 100.0;
                }
                if (this.sysCpu > 100.0) {
                    this.sysCpu = 100.0;
                }
                this.addValueToResultSet(this.index, cpuUtilIndex, this.cpuUtil);
                this.addValueToResultSet(this.index, sysCpuIndex, this.sysCpu);
                this.addValueToResultSet(this.index, runIndex, this.run);
                this.addValueToResultSet(this.index, freeIndex, this.free);
                this.addValueToResultSet(this.index, scanIndex, this.scan);
                this.addValueToResultSet(this.index, blockIndex, this.block);
                this.addValueToResultSet(this.index, swapIndex, this.swap);
                this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                this.updateAllResultSets();
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.updateAllResultSets();
                return true;
            }
        }
        if ((this.isSSH || this.isRexec) && this.alos.equalsIgnoreCase("linux")) {
            if (this.alpassword.equalsIgnoreCase("none") || this.aluser.equalsIgnoreCase("NONE")) {
                this.errorMsg = "SystemTest is configured in Agentless and os/aluser can't  be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.updateAllResultSets();
                return false;
            }
            String string = "";
            if (this.isSSH) {
                string = "ssh";
            } else if (this.isRexec) {
                string = "rexec";
            }
            SystemGeneric systemGeneric = null;
            systemGeneric = this.highSecure ? new SystemGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword, this.isCpuFromIdle, this.highSecure) : new SystemGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword, this.isCpuFromIdle);
            try {
                this.isMultiProcessor = systemGeneric.checkForMultiProcs();
                if (!this.isMultiProcessor) {
                    systemGeneric.getActualResultOnLinuxMpStat(this.period);
                    this.mpSteal = systemGeneric.mpSteal;
                    String string9 = systemGeneric.getActualResultsOnLinux(this.period);
                    if (string9 == null) {
                        this.updateAllResultSets();
                        return true;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string9, "#");
                    if (stringTokenizer.countTokens() < 6) {
                        this.updateAllResultSets();
                        return true;
                    }
                    this.getLinuxprocess(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
                    this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Summary");
                    Double d = new Double(stringTokenizer.nextToken());
                    this.cpuUtil = d;
                    d = new Double(stringTokenizer.nextToken());
                    this.sysCpu = d;
                    d = new Double(stringTokenizer.nextToken());
                    this.run = d;
                    d = new Double(stringTokenizer.nextToken());
                    this.block = d;
                    d = new Double(stringTokenizer.nextToken());
                    this.swap = d;
                    d = new Double(stringTokenizer.nextToken());
                    this.free = d;
                    d = new Double(stringTokenizer.nextToken());
                    this.scan = d;
                    d = new Double(stringTokenizer.nextToken());
                    this.stealTime = d;
                    if (this.cpuUtil > 100.0) {
                        this.cpuUtil = 100.0;
                    }
                    if (this.sysCpu > 100.0) {
                        this.sysCpu = 100.0;
                    }
                    this.addValueToResultSet(this.index, cpuUtilIndex, this.cpuUtil);
                    this.addValueToResultSet(this.index, sysCpuIndex, this.sysCpu);
                    this.addValueToResultSet(this.index, runIndex, this.run);
                    this.addValueToResultSet(this.index, freeIndex, this.free);
                    this.addValueToResultSet(this.index, scanIndex, this.scan);
                    this.addValueToResultSet(this.index, blockIndex, this.block);
                    this.addValueToResultSet(this.index, swapIndex, this.swap);
                    if (this.mpSteal > -5.0 && this.index.indexOf("Summary") > -1) {
                        this.addValueToResultSet(this.index, stealIndex, this.mpSteal);
                    } else {
                        this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                    }
                    this.updateAllResultSets();
                    return true;
                }
                if (!this.isMultiProcessor) return true;
                Hashtable hashtable = systemGeneric.getActualResultOnLinuxMpStat(this.period);
                this.mpSteal = systemGeneric.mpSteal;
                if (hashtable == null || hashtable.size() == 0) {
                    String string10 = systemGeneric.getActualResultsOnLinux(this.period);
                    if (string10 == null) {
                        this.updateAllResultSets();
                        return true;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string10, "#");
                    if (stringTokenizer.countTokens() < 6) {
                        this.updateAllResultSets();
                        return true;
                    }
                    this.getLinuxprocess(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
                    this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Summary");
                    Double d = new Double(stringTokenizer.nextToken());
                    this.cpuUtil = d;
                    Double d10 = new Double(stringTokenizer.nextToken());
                    this.sysCpu = d10;
                    Double d11 = new Double(stringTokenizer.nextToken());
                    this.run = d11;
                    Double d12 = new Double(stringTokenizer.nextToken());
                    this.block = d12;
                    Double d13 = new Double(stringTokenizer.nextToken());
                    this.swap = d13;
                    Double d14 = new Double(stringTokenizer.nextToken());
                    this.free = d14;
                    Double d15 = new Double(stringTokenizer.nextToken());
                    this.scan = d15;
                    Double d16 = new Double(stringTokenizer.nextToken());
                    this.stealTime = d16;
                    if (this.cpuUtil > 100.0) {
                        this.cpuUtil = 100.0;
                    }
                    if (this.sysCpu > 100.0) {
                        this.sysCpu = 100.0;
                    }
                    this.addValueToResultSet(this.index, cpuUtilIndex, this.cpuUtil);
                    this.addValueToResultSet(this.index, sysCpuIndex, this.sysCpu);
                    this.addValueToResultSet(this.index, runIndex, this.run);
                    this.addValueToResultSet(this.index, freeIndex, this.free);
                    this.addValueToResultSet(this.index, scanIndex, this.scan);
                    this.addValueToResultSet(this.index, blockIndex, this.block);
                    this.addValueToResultSet(this.index, swapIndex, this.swap);
                    this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                    this.updateAllResultSets();
                    return true;
                }
                this.getLinuxprocess(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string11 = (String)enumeration.nextElement();
                    ArrayList arrayList = (ArrayList)hashtable.get(string11);
                    if (arrayList == null || arrayList.size() < 7) continue;
                    this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + string11);
                    this.cpuUtil = (Double)arrayList.get(0);
                    this.sysCpu = (Double)arrayList.get(1);
                    this.run = (Double)arrayList.get(2);
                    this.block = (Double)arrayList.get(3);
                    this.swap = (Double)arrayList.get(4);
                    this.free = (Double)arrayList.get(5);
                    this.scan = (Double)arrayList.get(6);
                    this.stealTime = (Double)arrayList.get(7);
                    if (this.cpuUtil > 100.0) {
                        this.cpuUtil = 100.0;
                    }
                    if (this.sysCpu > 100.0) {
                        this.sysCpu = 100.0;
                    }
                    this.addValueToResultSet(this.index, cpuUtilIndex, this.cpuUtil);
                    this.addValueToResultSet(this.index, sysCpuIndex, this.sysCpu);
                    this.addValueToResultSet(this.index, runIndex, this.run);
                    this.addValueToResultSet(this.index, freeIndex, this.free);
                    this.addValueToResultSet(this.index, scanIndex, this.scan);
                    this.addValueToResultSet(this.index, blockIndex, this.block);
                    this.addValueToResultSet(this.index, swapIndex, this.swap);
                    if (this.mpSteal > -5.0 && this.index.indexOf("Summary") > -1) {
                        this.addValueToResultSet(this.index, stealIndex, this.mpSteal);
                        continue;
                    }
                    this.addValueToResultSet(this.index, stealIndex, this.stealTime);
                }
                this.updateAllResultSets();
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.updateAllResultSets();
                return true;
            }
        }
        if (!this.isSSH && !this.isRexec || !this.alos.equalsIgnoreCase("tru64")) return true;
        if (this.alpassword.equalsIgnoreCase("none") || this.aluser.equalsIgnoreCase("NONE")) {
            this.errorMsg = "SystemTest is configured in Agentless and os/aluser can't  be NONE for " + this.targetHost;
            this.logToErrorFile("ERROR", this.entity, this.errorMsg);
            this.updateAllResultSets();
            return false;
        }
        String string = "";
        if (this.isSSH) {
            string = "ssh";
        } else if (this.isRexec) {
            string = "rexec";
        }
        SystemGeneric systemGeneric = new SystemGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword, this.isCpuFromIdle);
        try {
            String string12 = systemGeneric.getActualResultsOnTru64(this.period);
            if (string12 == null) {
                this.updateAllResultSets();
                return true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string12, "#");
            if (stringTokenizer.countTokens() < 6) {
                this.updateAllResultSets();
                return true;
            }
            this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator + "Summary");
            Double d = new Double(stringTokenizer.nextToken());
            this.cpuUtil = d;
            d = new Double(stringTokenizer.nextToken());
            this.sysCpu = d;
            d = new Double(stringTokenizer.nextToken());
            this.run = d;
            d = new Double(stringTokenizer.nextToken());
            this.block = d;
            d = new Double(stringTokenizer.nextToken());
            this.swap = d;
            d = new Double(stringTokenizer.nextToken());
            this.free = d;
            d = new Double(stringTokenizer.nextToken());
            this.scan = d;
            if (this.cpuUtil > 100.0) {
                this.cpuUtil = 100.0;
            }
            if (this.sysCpu > 100.0) {
                this.sysCpu = 100.0;
            }
            this.addValueToResultSet(this.index, cpuUtilIndex, this.cpuUtil);
            this.addValueToResultSet(this.index, sysCpuIndex, this.sysCpu);
            this.addValueToResultSet(this.index, runIndex, this.run);
            this.addValueToResultSet(this.index, freeIndex, this.free);
            this.addValueToResultSet(this.index, scanIndex, this.scan);
            this.addValueToResultSet(this.index, blockIndex, this.block);
            this.addValueToResultSet(this.index, swapIndex, this.swap);
            this.addValueToResultSet(this.index, stealIndex, this.stealTime);
            this.updateAllResultSets();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.updateAllResultSets();
            return true;
        }
    }

    public void stopTest() {
        this.removeJNIFromMemory();
    }

    public void removeJNIFromMemory() {
        if (this.isPerfmon || !this.meAgentless) {
            if (this.helper != null) {
                this.helper.removeHandles();
            }
            this.helper = null;
        }
    }

    private ArrayList getRemoteValues(String string, String string2, int n, String string3, String string4, String string5) {
        ArrayList arrayList = null;
        try {
            if (string.equalsIgnoreCase("ssh")) {
                if (EgMainAgent.bUseJavaSshForRemoteAgent) {
                    EgJavaSSH egJavaSSH = new EgJavaSSH(string2, n, string3, string4, this.alencrypt, this.alkeyfile, EgMainAgent.TIME_OUT_JavaSsh);
                    ArrayList arrayList2 = egJavaSSH.executeCommand(string5);
                    if (arrayList2 != null && arrayList2.size() == 2) {
                        arrayList = (ArrayList)arrayList2.get(0);
                    }
                } else {
                    arrayList = EgSSHUtil.getExecResults((String)string2, (int)n, (String)string3, (String)string4, (String)string5);
                }
            } else if (string.equalsIgnoreCase("rexec")) {
                arrayList = EgRexecUtil.getExecResults((String)string2, (int)n, (String)string3, (String)string4, (String)string5);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private ArrayList getProcessInfo() {
        CpuUtil cpuUtil = null;
        ArrayList arrayList = null;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        cpuUtil = new CpuUtil(true);
        cpuUtil.setOS(this.myos);
        arrayList = cpuUtil.execute(false, true);
        this.processorRes = cpuUtil.getProcResult();
        hashtable2 = CpuUtil.getPidMap((String)"localhost");
        hashtable = CpuUtil.getUserMap((String)"localhost");
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = null;
        boolean bl = false;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            Object object;
            String string2;
            String string3;
            Long l;
            String string4;
            double d;
            double d2;
            String string5;
            block9: {
                String string6;
                int n;
                String string7 = (String)arrayList.get(i);
                if (arrayList == null || string7.length() <= 0 || (n = (stringTokenizer = new StringTokenizer(string7, "|")).countTokens()) < 4 || (string5 = stringTokenizer.nextToken()) == null || (string5 = string5.toLowerCase()).startsWith("_total") || string5.startsWith("idle") || (string6 = stringTokenizer.nextToken()) == null) continue;
                Double d3 = new Double(string6);
                d2 = d3;
                if (d2 > 100.0) {
                    d2 = 100.0;
                }
                if ((string6 = stringTokenizer.nextToken()) == null) continue;
                d3 = new Double(string6);
                d = d3;
                string4 = stringTokenizer.nextToken();
                l = null;
                string3 = null;
                string2 = (String)EgMainAgent.processNameDescHash.get(string5);
                if (string2 == null || string2.trim().length() == 0) {
                    string2 = string5;
                }
                try {
                    l = new Long(string4);
                    object = (String)hashtable2.get("" + l);
                    string = (String)hashtable.get("" + l);
                    if (object != null && ((String)object).length() > 0) {
                        string5 = object;
                    }
                    if (string == null || string.length() <= 0) break block9;
                    string3 = string;
                }
                catch (Exception exception) {
                    System.err.println("Error in SystemTest_DD $$$$$$$ " + string7 + " " + exception.toString());
                    System.err.println("Process is " + string5);
                    System.err.println("CPU is " + d2);
                    System.err.println("Mem " + d);
                    System.err.println("User is " + string3);
                    System.err.println("processDesc is " + string2);
                    System.err.println("PID is " + string4);
                    continue;
                }
            }
            object = new ArrayList();
            ((ArrayList)object).add(l);
            ((ArrayList)object).add(string5);
            ((ArrayList)object).add(new Double(d2));
            ((ArrayList)object).add(new Double(d));
            ((ArrayList)object).add(string3);
            ((ArrayList)object).add(string2);
            string = string4 + ";" + string5 + ";" + d2 + ";" + d + ";" + string3 + ";" + string2;
            arrayList2.add(object);
        }
        return arrayList2;
    }

    private ArrayList getProcessInfo(String string, String string2) {
        CpuUtil cpuUtil = null;
        ArrayList arrayList = null;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        cpuUtil = new CpuUtil(string, true);
        cpuUtil.setOS(string2);
        arrayList = cpuUtil.execute(true, true);
        this.processorRes = cpuUtil.getProcResult();
        hashtable = CpuUtil.getPidMap((String)string);
        hashtable2 = CpuUtil.getUserMap((String)string);
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = null;
        boolean bl = false;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3;
            Object object;
            String string4;
            String string5;
            Long l;
            String string6;
            double d;
            double d2;
            String string7;
            block9: {
                String string8;
                int n;
                String string9 = (String)arrayList.get(i);
                if (arrayList == null || string9.length() <= 0 || (n = (stringTokenizer = new StringTokenizer(string9, "|")).countTokens()) < 4 || (string7 = stringTokenizer.nextToken()) == null || (string7 = string7.toLowerCase()).startsWith("_total") || string7.startsWith("idle") || (string8 = stringTokenizer.nextToken()) == null) continue;
                Double d3 = new Double(string8);
                d2 = d3;
                if (d2 > 100.0) {
                    d2 = 100.0;
                }
                if ((string8 = stringTokenizer.nextToken()) == null) continue;
                d3 = new Double(string8);
                d = d3;
                string6 = stringTokenizer.nextToken();
                l = null;
                string5 = null;
                string4 = (String)EgMainAgent.processNameDescHash.get(string7);
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = string7;
                }
                try {
                    l = new Long(string6);
                    object = (String)hashtable.get("" + l);
                    if (object != null && ((String)object).length() > 0) {
                        string7 = object;
                    }
                    if ((string3 = (String)hashtable2.get("" + l)) == null || string3.length() <= 0) break block9;
                    string5 = string3;
                }
                catch (Exception exception) {
                    System.err.println("Error in SystemTest_DD $$$$$$$ " + string9 + " " + exception.toString());
                    System.err.println("Process is " + string7);
                    System.err.println("CPU is " + d2);
                    System.err.println("Mem " + d);
                    System.err.println("PID is " + string6);
                    System.err.println("User is " + string5);
                    System.err.println("processDesc is " + string4);
                    continue;
                }
            }
            object = new ArrayList();
            ((ArrayList)object).add(l);
            ((ArrayList)object).add(string7);
            ((ArrayList)object).add(new Double(d2));
            ((ArrayList)object).add(new Double(d));
            ((ArrayList)object).add(string5);
            ((ArrayList)object).add(string4);
            string3 = string6 + ";" + string7 + ";" + d2 + ";" + d + ";" + string5 + ";" + string4;
            arrayList2.add(object);
        }
        return arrayList2;
    }

    private void getLinuxprocess(String string, String string2, int n, String string3, String string4) {
        Object object;
        Object object2;
        ArrayList arrayList;
        int n2 = 1;
        n2 = this.getLinuxNumProcessors(string, string2, n, string3, string4);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(new Integer(n2));
        this.process_list_linux = arrayList2;
        ArrayList arrayList3 = new ArrayList();
        string = this.isSSH ? "ssh" : "rexec";
        String string5 = "\"";
        String string6 = string5 + "ps -e -o pid,pcpu,user,args | sort +1nr | head" + string5;
        if (this.alos.equalsIgnoreCase("hpux")) {
            string6 = string5 + "UNIX95= ps -aef -o pid,pcpu,user,args | sort +1nr  | head" + string5;
            arrayList3 = this.getRemoteValues(string, string2, n, string3, string4, string6);
        } else {
            arrayList3 = this.getRemoteValues(string, string2, n, string3, string4, string6);
        }
        if (this.alos.equalsIgnoreCase("linux") && (arrayList3 == null || arrayList3.size() == 0)) {
            string6 = string5 + "ps -e -o pid,pcpu,user,args | grep -v \"" + "\\%PCPU\"" + " |  grep -v \"" + "\\%CPU\"" + " | sort -k 2 -nr | head" + string5;
            arrayList3 = this.getRemoteValues(string, string2, n, string3, string4, string6);
            if (this.use_top_forDD && (arrayList = this.getRemoteValues(string, string2, n, string3, string4, (String)(object2 = "top -b -n 1"))) != null && arrayList.size() > 0 && (object = this.parseOutputForPsCommand(arrayList3)) != null && ((Hashtable)object).size() > 0) {
                arrayList3 = this.parseOutputForTopCommand((Hashtable)object, arrayList);
            }
        }
        this.cpu_list_linux = arrayList3;
        object2 = new ArrayList();
        string5 = "\"";
        if (this.alos.equalsIgnoreCase("linux")) {
            string6 = string5 + "ps -e -o pid,pmem,user,args | grep -v \"" + "\\%PMEM\"" + " |  grep -v \"" + "\\%MEM\"" + " | sort -k 2 -nr | head" + string5;
            object2 = this.getRemoteValues(string, string2, n, string3, string4, string6);
        } else if (this.alos.equalsIgnoreCase("solaris") || this.alos.equalsIgnoreCase("aix")) {
            string6 = string5 + "ps -e -o pid,pmem,user,args | sort +1nr | head" + string5;
            object2 = this.getRemoteValues(string, string2, n, string3, string4, string6);
        } else if (this.alos.equalsIgnoreCase("hpux")) {
            if (this.hpuxFirstTime) {
                String string7;
                string6 = "cat /var/adm/syslog/syslog.log | grep Physical: | cut -d':' -f 5 | cut -d',' -f 1 | cut -d' ' -f 2";
                arrayList = this.getRemoteValues(string, string2, n, string3, string4, string6);
                this.hpuxFirstTime = false;
                if (arrayList != null && arrayList.size() > 0 && (object = (String)arrayList.get(0)) != null) {
                    if (((String)(object = ((String)object).trim())).equalsIgnoreCase("cat: Cannot open /var/adm/syslog/syslog.log: No such file or directory") || ((String)object).startsWith("cat: Cannot open") || ((String)object).indexOf("cannot open") > 0 || ((String)object).indexOf("can't open") > 0) {
                        this.hpuxRamSize = -5;
                    } else {
                        try {
                            this.hpuxRamSize = Integer.parseInt((String)object);
                        }
                        catch (Exception exception) {
                            String string8 = EgInstallInfo.getStackTraceAsString((Exception)exception);
                            this.logToErrorFile("Error", this.entity, string8);
                        }
                    }
                }
                if (arrayList == null || arrayList.size() == 0 || this.hpuxRamSize < 0) {
                    string6 = "/sbin/dmesg | grep Physical";
                    arrayList = this.getRemoteValues(string, string2, n, string3, string4, string6);
                    this.hpuxRamSize = this.hpuxOutputDataForDD(arrayList);
                }
                if (arrayList == null || arrayList.size() == 0 || this.hpuxRamSize < 0) {
                    string6 = "machinfo | grep -i memory";
                    arrayList = this.getRemoteValues(string, string2, n, string3, string4, string6);
                    this.hpuxRamSize = this.hpuxOutputDataForDD(arrayList);
                }
                if ((object = this.getRemoteValues(string, string2, n, string3, string4, string6 = "getconf SC_PAGE_SIZE")) != null && ((ArrayList)object).size() > 0 && (string7 = (String)((ArrayList)object).get(0)) != null) {
                    string7 = string7.trim();
                    try {
                        this.hpuxPageSize = Integer.parseInt(string7);
                    }
                    catch (Exception exception) {
                        String string9 = EgInstallInfo.getStackTraceAsString((Exception)exception);
                        this.logToErrorFile("Error", this.entity, string9);
                        this.hpuxPageSize = 4096;
                    }
                }
            }
            string6 = string5 + "UNIX95= ps -e -o pid,sz,user,args | sort +1nr  | head" + string5;
            object2 = this.getRemoteValues(string, string2, n, string3, string4, string6);
        }
        this.mem_list_linux = object2;
    }

    private int hpuxOutputDataForDD(ArrayList arrayList) {
        int n = -5;
        try {
            if (arrayList != null && arrayList.size() > 0) {
                int n2 = arrayList.size();
                for (int i = 0; i < n2; ++i) {
                    int n3;
                    Object object;
                    String string = (String)arrayList.get(i);
                    if (string == null || string.length() == 0) continue;
                    if ((string = string.trim()).startsWith("Memory") || string.startsWith("memory")) {
                        int n4 = string.indexOf("=");
                        if (n4 < 0) {
                            n4 = string.indexOf(":");
                        }
                        string = n4 >= 0 ? string.substring(n4 + 1).trim() : string.substring(7).trim();
                        object = new StringTokenizer(string);
                        String string2 = "";
                        string2 = ((StringTokenizer)object).nextToken().trim();
                        try {
                            n = Integer.parseInt(string2) * 1024;
                        }
                        catch (Exception exception) {
                            n = -5;
                        }
                        continue;
                    }
                    if (!string.startsWith("Physical") && string.indexOf("Physical") <= 0) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    object = "";
                    if (!stringTokenizer.hasMoreTokens() || (object = stringTokenizer.nextToken()) == null || ((String)object).length() < 0 || ((String)object).indexOf("Physical:") <= -1 || (n3 = ((String)object).lastIndexOf(":")) <= 0 || ((String)(object = ((String)object).substring(n3 + 1).trim())).indexOf("Kbytes") <= -1) continue;
                    object = ((String)object).substring(0, ((String)object).indexOf("Kbytes"));
                    object = ((String)object).trim();
                    try {
                        n = Integer.parseInt((String)object);
                        continue;
                    }
                    catch (Exception exception) {
                        n = -1;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private Hashtable parseOutputForPsCommand(ArrayList arrayList) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            if (arrayList != null && arrayList.size() > 0) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    StringTokenizer stringTokenizer;
                    int n2;
                    String string = (String)arrayList.get(i);
                    if (string == null || string.length() == 0 || (n2 = (stringTokenizer = new StringTokenizer(string = string.trim())).countTokens()) < 4) continue;
                    String string2 = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = string3 + stringTokenizer.nextToken();
                    }
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return hashtable;
        }
        return hashtable;
    }

    private ArrayList parseOutputForTopCommand(Hashtable hashtable, ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = arrayList.size();
        try {
            for (int i = 0; i < n; ++i) {
                String string = (String)arrayList.get(i);
                if (string == null || string.length() == 0 || (string = string.trim()).startsWith("top") || string.startsWith("Tasks") || string.startsWith("Cpu(s)") || string.startsWith("Mem") || string.startsWith("Swap") || string.startsWith("PID")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                int n2 = stringTokenizer.countTokens();
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (!hashtable.containsKey(string2)) continue;
                String string5 = (String)hashtable.get(string2);
                String string6 = string2 + " " + string4 + " " + string3 + " " + string5;
                arrayList2.add(string6);
            }
            return arrayList2;
        }
        catch (Exception exception) {
            return arrayList2;
        }
    }

    private int getLinuxNumProcessors(String string, String string2, int n, String string3, String string4) {
        int n2 = 1;
        String string5 = "\"";
        String string6 = string5 + "cat /proc/cpuinfo | grep processor | wc -l" + string5;
        ArrayList arrayList = null;
        try {
            arrayList = this.getRemoteValues(string, string2, n, string3, string4, string6);
            if (arrayList == null) {
                return n2;
            }
            int n3 = arrayList.size();
            if (n3 <= 0) {
                System.out.println("Problem while executing the command " + string6 + " for " + string2);
                return n2;
            }
            n2 = Integer.parseInt((String)arrayList.get(0));
            if (n2 < 1) {
                n2 = 1;
            }
        }
        catch (Exception exception) {
            n2 = 1;
        }
        return n2;
    }

    boolean getNuma() {
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
        String string = iniFile.getValue("AGENT_SETTINGS", "SystemTestWithNuma");
        return string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
    }
}

