/*
 * Decompiled with CFR 0.152.
 */
import com.eg.ConnectionThread;
import com.egurkha.util.EgUtilities;
import com.sun.net.ssl.internal.ssl.Provider;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MerakiDevUplinkBase
extends GenericTest {
    protected String apiKey = "";
    protected boolean isSSL = false;
    private boolean ssl_enabled = false;
    protected String url_string = "";
    private static final String ORGANIZATIONS_URI = "organizations";
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    protected static Hashtable totalUplinkHash = new Hashtable();
    private static Hashtable lastTimeHash = new Hashtable();
    private long lastTime = 0L;
    EgUtilities egutil = EgUtilities.createInstance();

    public MerakiDevUplinkBase(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        try {
            this.apiKey = this.getValueForParam("api_key");
            String string = this.getValueForParam("ssl");
            if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
                this.isSSL = true;
            }
            this.url_string = this.isSSL ? "https://" + this.targetHost + "/api/v0/" : "http://" + this.targetHost + "/api/v0/";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setLastExectionTime();
    }

    private void setLastExectionTime() {
        lastTimeHash.put(this.reportingName, new Long(this.lastTime));
    }

    private void getLastExectionTime() {
        Long l = (Long)lastTimeHash.get(this.reportingName);
        this.lastTime = l;
    }

    public void collectUplinkMetrics() {
        this.getLastExectionTime();
        long l = System.currentTimeMillis();
        long l2 = l - this.lastTime;
        long l3 = (long)(0.9 * (double)this.measurePeriod);
        boolean bl = false;
        if (l2 >= l3) {
            bl = true;
            this.lastTime = l;
            this.setLastExectionTime();
        } else {
            bl = false;
        }
        if (bl) {
            this.getUplinkHash();
            this.lastTime = System.currentTimeMillis();
            this.setLastExectionTime();
        }
    }

    public void getUplinkHash() {
        Hashtable hashtable = new Hashtable();
        try {
            Hashtable hashtable2 = this.deviceHash();
            if (hashtable2 != null && hashtable2.size() > 0) {
                Hashtable hashtable3 = (Hashtable)hashtable2.get("devices");
                String string = "";
                Hashtable hashtable4 = new Hashtable();
                Enumeration enumeration = hashtable3.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    ArrayList arrayList = (ArrayList)hashtable3.get(string2);
                    String string3 = (String)arrayList.get(0);
                    String string4 = (String)arrayList.get(1);
                    String string5 = (String)arrayList.get(2);
                    String string6 = (String)arrayList.get(3);
                    String string7 = "";
                    if (string4 == null || string4.equals("-")) {
                        string4 = string5;
                    }
                    if (string2.indexOf("^") > -1) {
                        string7 = string2.substring(0, string2.indexOf("^"));
                    }
                    String string8 = string7 + ":" + string4;
                    if (string2 != null && string2.indexOf("^") > -1) {
                        string = string2.substring(string2.indexOf("^") + 1, string2.trim().length());
                    }
                    if (!string3.startsWith("MR")) continue;
                    String string9 = this.getJSONDataFromURL("networks/" + string6 + "/devices/" + string + "/uplink", true);
                    JSONArray jSONArray = null;
                    try {
                        jSONArray = new JSONArray(string9);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    String string10 = "";
                    String string11 = "";
                    String string12 = "";
                    String string13 = "";
                    String string14 = "";
                    String string15 = "";
                    JSONObject jSONObject = null;
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        jSONObject = jSONArray.getJSONObject(i);
                        string10 = this.getValueFromJSONObject(jSONObject, "interface");
                        string11 = this.getValueFromJSONObject(jSONObject, "status");
                        string12 = this.getValueFromJSONObject(jSONObject, "ip");
                        string13 = this.getValueFromJSONObject(jSONObject, "gateway");
                        string14 = this.getValueFromJSONObject(jSONObject, "publicIp");
                        string15 = this.getValueFromJSONObject(jSONObject, "usingStaticIp");
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        arrayList2.add(string11);
                        arrayList2.add(string12);
                        arrayList2.add(string13);
                        arrayList2.add(string14);
                        arrayList2.add(string15);
                        String string16 = string8 + "/" + string10;
                        if (string10 == null) continue;
                        hashtable4.put(string16, arrayList2);
                    }
                }
                hashtable.put("Uplink", hashtable4);
            }
            totalUplinkHash.put(this.reportingName, hashtable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Hashtable deviceHash() {
        String string = "deviceList";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = null;
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        try {
            String string7;
            Object object;
            String string8;
            String string9;
            String string10;
            string6 = this.getJSONDataFromURL(ORGANIZATIONS_URI, true);
            if (string6 == null) {
                return null;
            }
            JSONArray jSONArray = null;
            try {
                jSONArray = new JSONArray(string6);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            JSONObject jSONObject = null;
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    jSONObject = jSONArray.getJSONObject(i);
                    string2 = this.getValueFromJSONObject(jSONObject, "id");
                    string3 = this.getValueFromJSONObject(jSONObject, "name");
                    string10 = this.getJSONDataFromURL("organizations/" + string2 + "/networks", true);
                    if (string10 == null) {
                        return null;
                    }
                    string9 = null;
                    try {
                        string9 = new JSONArray(string10);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    string8 = null;
                    for (int j = 0; j < string9.length(); ++j) {
                        string8 = string9.getJSONObject(j);
                        string5 = this.getValueFromJSONObject((JSONObject)string8, "id");
                        string4 = this.getValueFromJSONObject((JSONObject)string8, "name");
                        object = string2 + ":" + string5;
                        string7 = "NETWORK_ID:" + string5 + " NETWORK_NAME:" + string4;
                        hashtable.put(object, string4);
                    }
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            String string11 = "";
            string10 = "";
            string9 = "";
            string8 = "";
            String string12 = "";
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                string7 = (String)object.nextElement();
                String string13 = (String)hashtable.get(string7);
                if (string7 == null || string7.indexOf(":") <= -1 || (string11 = string7.substring(string7.indexOf(":") + 1, string7.trim().length())) == null) continue;
                String string14 = this.getJSONDataFromURL("networks/" + string11 + "/devices", true);
                if (string14 == null) {
                    return null;
                }
                JSONArray jSONArray2 = null;
                try {
                    jSONArray2 = new JSONArray(string14);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                JSONObject jSONObject2 = null;
                for (int i = 0; i < jSONArray2.length(); ++i) {
                    jSONObject2 = jSONArray2.getJSONObject(i);
                    string10 = this.getValueFromJSONObject(jSONObject2, "serial");
                    string9 = this.getValueFromJSONObject(jSONObject2, "name");
                    string12 = this.getValueFromJSONObject(jSONObject2, "model");
                    string8 = this.getValueFromJSONObject(jSONObject2, "mac");
                    string11 = this.getValueFromJSONObject(jSONObject2, "networkId");
                    String string15 = string13 + "^" + string10;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string12);
                    arrayList.add(string9);
                    arrayList.add(string8);
                    arrayList.add(string11);
                    hashtable2.put(string15, arrayList);
                }
            }
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable3.put("devices", hashtable2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable3;
    }

    private String getJSONDataFromURL(String string, boolean bl) {
        String string2 = this.url_string + string;
        return this.getJSONDataFromURL(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJSONDataFromURL(String string) {
        HttpURLConnection httpURLConnection = null;
        String string2 = null;
        try {
            Object object;
            Object object2;
            ConnectionThread connectionThread;
            Object object3;
            if (this.isSSL && !this.ssl_enabled) {
                Security.addProvider((java.security.Provider)new Provider());
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                object3 = (SSLSocketFactory)SSLSocketFactory.getDefault();
                connectionThread = null;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                object2 = new TrustManager[]{myX509TrustManager};
                object = SSLContext.getInstance("SSL");
                ((SSLContext)object).init(keyManagerArray, (TrustManager[])object2, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = ((SSLContext)object).getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
                this.ssl_enabled = true;
            }
            object3 = new URL(string);
            httpURLConnection = (HttpURLConnection)((URL)object3).openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setConnectTimeout(500);
            httpURLConnection.addRequestProperty("X-Cisco-Meraki-API-Key", this.apiKey);
            httpURLConnection.addRequestProperty("Content-Type", "application/json");
            httpURLConnection.addRequestProperty("Cache-Control", "no-cache");
            httpURLConnection.connect();
            connectionThread = new ConnectionThread(httpURLConnection, false);
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            object2 = new StringBuilder();
            if (bl) {
                n = connectionThread.code;
                if (n != 200) {
                    this.putErrorMessageToLogfile("Error in getJSONDataFromURL method REST url connection ..." + n);
                }
                if ((object = connectionThread.data) == null || ((ArrayList)object).isEmpty() || ((ArrayList)object).size() == 0) {
                    this.putWarningMessageToLogfile(" Data null or empty data");
                }
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    ((StringBuilder)object2).append((String)((ArrayList)object).get(i));
                }
            }
            if (!bl || n != 200) {
                this.putWarningMessageToLogfile(" Timing out or invalid response code:" + n);
            }
            string2 = ((StringBuilder)object2).toString();
        }
        catch (Exception exception) {
            this.putErrorMessageToLogfile("Error in getJSONDataFromURL " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            httpURLConnection = null;
        }
        return string2;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        String string3 = "[getValueFromJSONObject] :";
        try {
            if (jSONObject == null) {
                this.printOut("jsonObject is  null or empty for the parameter :" + string);
                return string2;
            }
            String string4 = "" + jSONObject.get(string);
            string2 = string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase("null") || string4.equalsIgnoreCase("none") ? "-" : string4.trim();
        }
        catch (JSONException jSONException) {
            string2 = "-";
            jSONException.printStackTrace();
        }
        return string2;
    }
}

