/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgJNIUtil;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class OSMemoryTest
extends GenericTest {
    private static final String object = "Memory";
    private static final String[] counter = new String[]{"Available MBytes"};
    private EgJNIUtil egPerfUtil = null;
    private EgJNIUtil egPerfUtilHv = null;
    ArrayList osMemList_dd = new ArrayList();
    ArrayList otherOSddOutput = new ArrayList();
    public int hpuxRamSize = -1;
    private boolean firstTime = true;
    public int hpuxPageSize = -1;
    private boolean isUseExe = false;
    public static Hashtable memoryHash = new Hashtable();
    public static Hashtable memoryLastRunHash = new Hashtable();
    private static final String[] counters = new String[]{"Available MBytes", "Modified Page List Bytes", "Standby Cache Core Bytes", "Standby Cache Normal Priority Bytes", "Standby Cache Reserve Bytes"};
    private static final String maxDynMemObj = "Hyper-V Dynamic Memory Integration Service";
    private static final String[] maxDynMemCounters = new String[]{"Maximum Memory, Mbytes"};
    private boolean isMaxMemEnabled = false;
    private boolean highSecure = false;

    public OSMemoryTest(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        this.setMeasureCount(this.measureCount);
        String string3 = this.getValueForParam("Hyperv");
        if (string3 != null && (string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("true"))) {
            this.needAgentlessDD = true;
        }
        if ((string2 = this.getValueForParam("isQVD")) != null && (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true"))) {
            this.needAgentlessDD = true;
        }
        this.isUseExe = (string = this.getValueForParam("use_exe")) != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true"));
        String string4 = this.getValueForParam("dynamic_memory_enabled");
        this.isMaxMemEnabled = string4 != null && (string4.equalsIgnoreCase("yes") || string4.equalsIgnoreCase("true"));
        String string5 = this.getValueForParam("high_security");
        this.highSecure = string5 != null && (string5.equalsIgnoreCase("yes") || string5.equalsIgnoreCase("true"));
    }

    public void freeTest() {
        this.osMemList_dd = new ArrayList();
        this.otherOSddOutput = new ArrayList();
    }

    public void computeMeasures(Hashtable hashtable) {
        double[] dArray = null;
        double[] dArray2 = null;
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        ArrayList<Double> arrayList = null;
        if (!this.meAgentless || this.isPerfmon) {
            WindowsOsHelper windowsOsHelper;
            boolean bl = false;
            String string = "";
            if (!this.meAgentless) {
                windowsOsHelper = new WindowsOsHelper(this.reportingName, this.meAgentless);
                string = windowsOsHelper.setOs();
            } else {
                this.checkNbt();
                bl = true;
                if (this.nbtName == null) {
                    System.out.println("Failed to get NbtName for " + this.targetHost);
                    WindowsOsHelper.osNameHash.remove(this.reportingName);
                    this.stopTest();
                    return;
                }
                windowsOsHelper = new WindowsOsHelper(this.nbtName, this.reportingName, this.meAgentless);
                string = windowsOsHelper.setOs();
            }
            if (string != null) {
                string = string.toLowerCase();
            }
            if (string != null && (string.indexOf("vista") > -1 || string.indexOf("windows 7") > -1 || string.indexOf("2008") > -1 || string.indexOf("windows 8") > -1 || string.indexOf("2012") > -1 || string.indexOf("windows 10") > -1) || string.indexOf("2016") > -1 || string.indexOf("2019") > -1) {
                double[] dArray3;
                double d5;
                double d6;
                if (!this.meAgentless) {
                    if (this.egPerfUtil == null) {
                        this.egPerfUtil = new EgJNIUtil();
                    }
                    dArray = this.egPerfUtil.getCounterValue(object, counters);
                    d2 = this.getTotalPhyMem(false);
                    if (this.isMaxMemEnabled) {
                        if (this.egPerfUtilHv == null) {
                            this.egPerfUtilHv = new EgJNIUtil();
                        }
                        dArray2 = this.egPerfUtilHv.getCounterValue(maxDynMemObj, maxDynMemCounters);
                    }
                } else if (this.isPerfmon) {
                    if (!bl) {
                        this.checkNbt();
                        if (this.nbtName == null) {
                            System.out.println("Failed to get NbtName for " + this.targetHost);
                            this.stopTest();
                            return;
                        }
                    }
                    if (this.egPerfUtil == null) {
                        EgJNIUtil.isHostAvailable((String)this.nbtName);
                        this.egPerfUtil = new EgJNIUtil();
                    }
                    dArray = this.egPerfUtil.getCounterValue(object, counters, this.targetHost, "perfmon");
                    d2 = this.getTotalPhyMem(true);
                    if (this.isMaxMemEnabled) {
                        if (this.egPerfUtilHv == null) {
                            this.egPerfUtilHv = new EgJNIUtil();
                        }
                        dArray2 = this.egPerfUtilHv.getCounterValue(maxDynMemObj, maxDynMemCounters, this.targetHost, "perfmon");
                    }
                }
                if (dArray == null) {
                    this.stopTest();
                    return;
                }
                double d7 = -5.0;
                double d8 = -5.0;
                double d9 = -5.0;
                double d10 = -5.0;
                double d11 = -5.0;
                int n = dArray.length;
                if (n >= 5) {
                    d7 = dArray[0];
                    d8 = dArray[1];
                    if (d8 >= 0.0) {
                        d8 /= 1048576.0;
                    }
                    d6 = dArray[2];
                    d5 = dArray[3];
                    double d12 = dArray[4];
                    double d13 = 0.0;
                    if (d6 >= 0.0) {
                        d13 += d6;
                    }
                    if (d5 >= 0.0) {
                        d13 += d5;
                    }
                    if (d12 >= 0.0) {
                        d13 += d12;
                    }
                    if (d13 >= 0.0) {
                        d9 = d13 / 1048576.0;
                    }
                    if (d2 >= 0.0) {
                        if (d7 >= 0.0 && d8 >= 0.0) {
                            d10 = d2 - (d7 + d8);
                        } else if (d7 >= 0.0) {
                            d10 = d2 - d7;
                        } else if (d8 >= 0.0) {
                            d10 = d2 - d8;
                        }
                    }
                    if (d7 >= 0.0 && d9 >= 0.0 && (d = d7 - d9) < 0.0) {
                        d = 0.0;
                    }
                    if (d9 >= 0.0 && d8 >= 0.0) {
                        d11 = d9 + d8;
                    } else if (d9 >= 0.0) {
                        d11 = d9;
                    } else if (d8 >= 0.0) {
                        d11 = d9;
                    }
                    d4 = d10 * 100.0 / d2;
                    if (d4 > 0.0) {
                        this.osMemList_dd = this.getDDforFreeMemory();
                    }
                    if (d4 > 100.0) {
                        d4 = 100.0;
                    }
                }
                d6 = -5.0;
                d5 = -5.0;
                if (this.isMaxMemEnabled && (dArray3 = this.getMaxMemoryMeasures(dArray2, d10)) != null && dArray3.length >= 2) {
                    d6 = dArray3[0];
                    d5 = dArray3[1];
                }
                arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d10));
                arrayList.add(new Double(d));
                arrayList.add(new Double(d4));
                if (this.measureCount > 4) {
                    arrayList.add(new Double(d7));
                    arrayList.add(new Double(d8));
                    arrayList.add(new Double(d9));
                    arrayList.add(new Double(d11));
                    if (this.measureCount > 8) {
                        arrayList.add(new Double(d6));
                        arrayList.add(new Double(d5));
                    }
                }
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                arrayList2.add(new Double(d2));
                arrayList2.add(new Double(d10));
                arrayList2.add(new Double(d4));
                memoryHash.put(this.reportingName, arrayList2);
                memoryLastRunHash.put(this.reportingName, new Long(System.currentTimeMillis()));
                this.addNewMeasure(arrayList);
            } else {
                Object object;
                if (!this.meAgentless) {
                    if (this.egPerfUtil == null) {
                        this.egPerfUtil = new EgJNIUtil();
                    }
                    dArray = this.egPerfUtil.getCounterValue(object, counter);
                    d2 = this.getTotalPhyMem(false);
                    if (this.isMaxMemEnabled) {
                        if (this.egPerfUtilHv == null) {
                            this.egPerfUtilHv = new EgJNIUtil();
                        }
                        dArray2 = this.egPerfUtilHv.getCounterValue(maxDynMemObj, maxDynMemCounters);
                    }
                } else if (this.isPerfmon) {
                    if (!bl) {
                        this.checkNbt();
                        if (this.nbtName == null) {
                            System.out.println("Failed to get NbtName for " + this.targetHost);
                            this.stopTest();
                            return;
                        }
                    }
                    if (this.egPerfUtil == null) {
                        EgJNIUtil.isHostAvailable((String)this.nbtName);
                        this.egPerfUtil = new EgJNIUtil();
                    }
                    dArray = this.egPerfUtil.getCounterValue(object, counter, this.targetHost, "perfmon");
                    d2 = this.getTotalPhyMem(true);
                    if (this.isMaxMemEnabled) {
                        if (this.egPerfUtilHv == null) {
                            this.egPerfUtilHv = new EgJNIUtil();
                        }
                        dArray2 = this.egPerfUtilHv.getCounterValue(maxDynMemObj, maxDynMemCounters, this.targetHost, "perfmon");
                    }
                }
                if (dArray == null) {
                    this.stopTest();
                    return;
                }
                d = dArray[0];
                if (d2 > 0.0 && d2 > d && (d4 = (d3 = d2 - d) * 100.0 / d2) > 0.0) {
                    this.osMemList_dd = this.getDDforFreeMemory();
                }
                if (d4 > 100.0) {
                    d4 = 100.0;
                }
                double d14 = -5.0;
                double d15 = -5.0;
                if (this.isMaxMemEnabled && (object = this.getMaxMemoryMeasures(dArray2, d3)) != null && ((double[])object).length >= 2) {
                    d14 = object[0];
                    d15 = object[1];
                }
                arrayList = new ArrayList();
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d));
                arrayList.add(new Double(d4));
                if (this.measureCount > 4) {
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    if (this.measureCount > 8) {
                        arrayList.add(new Double(d14));
                        arrayList.add(new Double(d15));
                    }
                }
                object = new ArrayList();
                ((ArrayList)object).add(new Double(d2));
                ((ArrayList)object).add(new Double(d3));
                ((ArrayList)object).add(new Double(d4));
                memoryHash.put(this.reportingName, object);
                memoryLastRunHash.put(this.reportingName, new Long(System.currentTimeMillis()));
                this.addNewMeasure(arrayList);
            }
        } else if (this.isSSH || this.isRexec) {
            if (this.aluser.equalsIgnoreCase("NONE") || this.alpassword.equalsIgnoreCase("none")) {
                this.errorMsg = "OSMemoryTest is configured in Agentless and os/aluser can't  be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                return;
            }
            String string = "";
            if (this.isSSH) {
                string = "ssh";
            } else if (this.isRexec) {
                string = "rexec";
            }
            PhysicalMemGeneric physicalMemGeneric = null;
            physicalMemGeneric = this.highSecure ? new PhysicalMemGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword, this.alencrypt, this.alkeyfile, this.highSecure) : new PhysicalMemGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword, this.alencrypt, this.alkeyfile);
            ArrayList arrayList3 = null;
            StringTokenizer stringTokenizer = null;
            try {
                String string2;
                String string3;
                if (this.alos.equalsIgnoreCase("solaris")) {
                    arrayList3 = physicalMemGeneric.getActualResultsOnSolaris();
                } else if (this.alos.equalsIgnoreCase("linux")) {
                    arrayList3 = physicalMemGeneric.getActualResultsOnLinux();
                } else if (this.alos.equalsIgnoreCase("aix")) {
                    arrayList3 = physicalMemGeneric.getActualResultsOnAix();
                } else if (this.alos.equalsIgnoreCase("hpux")) {
                    string3 = "\"";
                    if (this.firstTime) {
                        String string4;
                        this.firstTime = false;
                        string2 = string3 + "getconf SC_PAGE_SIZE" + string3;
                        ArrayList arrayList4 = this.getRemoteValues(string, this.targetHost, this.sshPort, this.aluser, this.alpassword, string2);
                        if (arrayList4 != null && arrayList4.size() > 0 && (string4 = (String)arrayList4.get(0)) != null && string4.length() > 0) {
                            string4 = string4.trim();
                            try {
                                this.hpuxPageSize = Integer.parseInt(string4);
                            }
                            catch (Exception exception) {
                                String string5 = EgInstallInfo.getStackTraceAsString((Exception)exception);
                                this.logToErrorFile("Error", this.entity, string5);
                                this.hpuxPageSize = 4096;
                            }
                        }
                    }
                    arrayList3 = physicalMemGeneric.getActualResultsOnHPUnix(this.hpuxPageSize);
                }
                if (arrayList3 == null || arrayList3.size() == 0) {
                    return;
                }
                string3 = (String)arrayList3.get(0);
                if (string3 != null && string3.length() > 0) {
                    stringTokenizer = new StringTokenizer(string3, "#");
                    if (stringTokenizer.countTokens() == 4) {
                        Double d16 = new Double(stringTokenizer.nextToken());
                        d2 = d16;
                        d16 = new Double(stringTokenizer.nextToken());
                        d3 = d16;
                        d16 = new Double(stringTokenizer.nextToken());
                        d = d16;
                        d16 = new Double(stringTokenizer.nextToken());
                        d4 = d16;
                        if (d4 > 0.0 && (this.alos.equalsIgnoreCase("aix") || this.alos.equalsIgnoreCase("solaris"))) {
                            string2 = "ps -e -o pid,pmem,user,args | sort +1nr | head";
                            this.otherOSddOutput = physicalMemGeneric.getLinuxDD(string2);
                        } else if (d4 > 0.0 && this.alos.equalsIgnoreCase("linux")) {
                            string2 = "ps -e -o pid,pmem,user,args | grep -v \"\\%PMEM\" |  grep -v \"\\%MEM\" | sort -k 2 -nr | head";
                            this.otherOSddOutput = physicalMemGeneric.getLinuxDD(string2);
                        } else if (d4 > 0.0 && this.alos.equalsIgnoreCase("hpux")) {
                            this.hpuxRamSize = (int)d2;
                            string2 = "UNIX95= ps -e -o pid,sz,user,args | sort +1nr  | head";
                            this.otherOSddOutput = physicalMemGeneric.getLinuxDD(string2);
                        }
                    }
                    if (d4 > 100.0) {
                        d4 = 100.0;
                    }
                    arrayList = new ArrayList();
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d4));
                    if (this.measureCount > 4) {
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        arrayList.add(new Double(-5.0));
                        if (this.measureCount > 8) {
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                        }
                    }
                    this.addNewMeasure(arrayList);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    private double[] getMaxMemoryMeasures(double[] dArray, double d) {
        double[] dArray2 = new double[2];
        try {
            double d2 = -5.0;
            double d3 = -5.0;
            if (dArray != null && dArray.length >= 0) {
                d2 = dArray[0];
                if (d2 < 0.0) {
                    d2 = -5.0;
                }
                if (d2 > 0.0) {
                    d3 = d * 100.0 / d2;
                }
                if (d3 > 100.0) {
                    d3 = 100.0;
                }
            }
            dArray2[0] = d2;
            dArray2[1] = d3;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dArray2;
    }

    public void stopTest() {
        if (this.egPerfUtil != null) {
            this.egPerfUtil.stop();
            this.egPerfUtil = null;
        }
    }

    private ArrayList executescript() {
        String string = "cscript.exe " + EgInstallInfo.getInstallDir() + "/bin/FindMemory.vbs";
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines(string);
        return arrayList;
    }

    private ArrayList executescriptRemotely() {
        XCmdGeneric xCmdGeneric = null;
        if (xCmdGeneric == null) {
            xCmdGeneric = new XCmdGeneric(this.nbtName);
        }
        String string = EgInstallInfo.getInstallDir() + "/bin/findmemory.vbs";
        boolean bl = xCmdGeneric.checkForExeOnRemote("findmemory.vbs");
        if (!bl) {
            xCmdGeneric.copyExeToRemote(string, true);
        }
        String string2 = "cscript.exe " + EgInstallInfo.getXCmdRemoteDirectory() + "findmemory.vbs //NoLogo";
        ArrayList arrayList = xCmdGeneric.executeRemoteCommand(string2);
        return arrayList;
    }

    public double getTotalPhyMem(boolean bl) {
        FindMemory findMemory = new FindMemory();
        if (bl) {
            return findMemory.execute(bl, this.nbtName);
        }
        return findMemory.execute(bl, "localhost");
    }

    private ArrayList getDDforFreeMemory() {
        Object object;
        CpuUtil cpuUtil = null;
        ArrayList arrayList = null;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        if (!this.meAgentless) {
            object = System.getProperty("os.name");
            cpuUtil = new CpuUtil(true);
            cpuUtil.setOS((String)object);
            arrayList = cpuUtil.execute(false, true);
            hashtable = CpuUtil.getPidMap((String)"localhost");
            hashtable2 = CpuUtil.getUserMap((String)"localhost");
        } else {
            cpuUtil = new CpuUtil(this.targetHost, true);
            cpuUtil.setOS(this.alos);
            arrayList = cpuUtil.execute(true, true);
            hashtable = CpuUtil.getPidMap((String)this.targetHost);
            hashtable2 = CpuUtil.getUserMap((String)this.targetHost);
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        object = null;
        boolean bl = false;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string;
            Object object2;
            String string2;
            String string3;
            Long l;
            String string4;
            double d;
            String string5;
            block10: {
                String string6;
                int n2;
                String string7 = (String)arrayList.get(i);
                if (arrayList == null || string7.length() <= 0 || (n2 = ((StringTokenizer)(object = new StringTokenizer(string7, "|"))).countTokens()) < 4 || (string5 = ((StringTokenizer)object).nextToken()) == null || (string5 = string5.toLowerCase()).startsWith("_total") || string5.startsWith("idle") || (string6 = ((StringTokenizer)object).nextToken()) == null || (string6 = ((StringTokenizer)object).nextToken()) == null) continue;
                Double d2 = new Double(string6);
                d = d2;
                string4 = ((StringTokenizer)object).nextToken();
                l = null;
                string3 = null;
                string2 = (String)EgMainAgent.processNameDescHash.get(string5);
                if (string2 == null || string2.trim().length() == 0) {
                    string2 = string5;
                }
                try {
                    l = new Long(string4);
                    object2 = (String)hashtable.get("" + l);
                    string = (String)hashtable2.get("" + l);
                    if (object2 != null && ((String)object2).length() > 0) {
                        string5 = object2;
                    }
                    if (string == null || string.length() <= 0) break block10;
                    string3 = string;
                }
                catch (Exception exception) {
                    System.err.println("Error in SystemTest_DD $$$$$$$ " + string7 + " " + exception.toString());
                    System.err.println("Process is " + string5);
                    System.err.println("Mem " + d);
                    System.err.println("User is " + string3);
                    System.err.println("processDesc is " + string2);
                    System.err.println("PID is " + string4);
                    continue;
                }
            }
            object2 = new ArrayList();
            ((ArrayList)object2).add(l);
            ((ArrayList)object2).add(string5);
            ((ArrayList)object2).add(new Double(d));
            ((ArrayList)object2).add(string3);
            ((ArrayList)object2).add(string2);
            string = string4 + ";" + string5 + ";" + d + ";" + string3 + ";" + string2;
            arrayList2.add(object2);
        }
        return arrayList2;
    }

    private ArrayList getRemoteValues(String string, String string2, int n, String string3, String string4, String string5) {
        ArrayList arrayList = null;
        try {
            if (string.equalsIgnoreCase("ssh")) {
                if (EgMainAgent.bUseJavaSshForRemoteAgent) {
                    EgJavaSSH egJavaSSH = new EgJavaSSH(string2, n, string3, string4, this.alencrypt, this.alkeyfile, EgMainAgent.TIME_OUT_JavaSsh);
                    ArrayList arrayList2 = egJavaSSH.executeCommand(string5);
                    if (arrayList2 != null && arrayList2.size() == 2) {
                        arrayList = (ArrayList)arrayList2.get(0);
                    }
                } else {
                    arrayList = EgSSHUtil.getExecResults((String)string2, (int)n, (String)string3, (String)string4, (String)string5);
                }
            } else if (string.equalsIgnoreCase("rexec")) {
                arrayList = EgRexecUtil.getExecResults((String)string2, (int)n, (String)string3, (String)string4, (String)string5);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private ArrayList executeExe() {
        String string = EgInstallInfo.getInstallDir() + "/bin/FindMemory.exe";
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines(string);
        return arrayList;
    }

    private ArrayList executeExeRemotely() {
        XCmdGeneric xCmdGeneric = null;
        if (xCmdGeneric == null) {
            xCmdGeneric = new XCmdGeneric(this.nbtName);
        }
        String string = EgInstallInfo.getInstallDir() + "/bin/findmemory.exe";
        boolean bl = xCmdGeneric.checkForExeOnRemote("findmemory.exe");
        if (!bl) {
            xCmdGeneric.copyExeToRemote(string, true);
        }
        String string2 = EgInstallInfo.getXCmdRemoteDirectory() + "findmemory.exe";
        ArrayList arrayList = xCmdGeneric.executeRemoteCommand(string2);
        return arrayList;
    }
}

