/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class NetworkTrafficGeneric
extends TestGeneric {
    private long[] prevIpkts;
    private long[] prevOpkts;
    private String[] interfaceNames = new String[0];
    private long[] diffIpkts;
    private long[] diffOpkts;
    Hashtable prevIpktsLn = new Hashtable();
    Hashtable prevOpktsLn = new Hashtable();
    ArrayList interfaceNamesLn = new ArrayList();
    Hashtable diffIpktsLn = new Hashtable();
    Hashtable diffOpktsLn = new Hashtable();
    Hashtable rxPkts = new Hashtable();
    Hashtable txPkts = new Hashtable();

    public NetworkTrafficGeneric(String string, String string2, int n, String string3, String string4) {
        super(string, string2, n, string3, string4);
    }

    public NetworkTrafficGeneric(String string, String string2, int n, String string3, String string4, boolean bl) {
        super(string, string2, n, string3, string4, bl);
    }

    public ArrayList getActualResultsOnSolaris(double d) {
        this.cmdToExec = "netstat -in -f inet";
        ArrayList arrayList = this.execCommand(this.cmdToExec);
        return this.getActualResultsOnSolaris(arrayList, d);
    }

    public ArrayList getActualResultsOnTru64(double d) {
        this.cmdToExec = "/usr/sbin/netstat -in -f inet";
        ArrayList arrayList = this.execCommand(this.cmdToExec);
        return this.getActualResultsOnSolaris(arrayList, d);
    }

    public ArrayList getActualResultsOnSolaris(ArrayList arrayList, double d) {
        int n = 0;
        if (arrayList == null) {
            return null;
        }
        n = arrayList.size();
        try {
            for (int i = 0; i < n; ++i) {
                int n2;
                String string = (String)arrayList.get(i);
                if (string.startsWith("Name") || string.indexOf("127.0.0.1") != -1 || string.startsWith("lo0")) continue;
                string.trim();
                if (string.equals("")) continue;
                int n3 = this.interfaceNames.length;
                int n4 = -1;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() <= 0) continue;
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n5 = stringTokenizer.countTokens();
                for (n2 = 0; n2 < n5; ++n2) {
                    stringArray[n2] = stringTokenizer.nextToken();
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!stringArray[0].equals(this.interfaceNames[n2])) continue;
                    n4 = n2;
                    break;
                }
                if (n4 < 0) {
                    int n6;
                    String[] stringArray2 = new String[n3];
                    long[] lArray = new long[n3];
                    long[] lArray2 = new long[n3];
                    long[] lArray3 = new long[n3];
                    long[] lArray4 = new long[n3];
                    for (n6 = 0; n6 < n3; ++n6) {
                        stringArray2[n6] = this.interfaceNames[n6];
                        lArray[n6] = this.prevIpkts[n6];
                        lArray2[n6] = this.prevOpkts[n6];
                        lArray3[n6] = this.diffIpkts[n6];
                        lArray4[n6] = this.diffOpkts[n6];
                    }
                    this.interfaceNames = new String[n3 + 1];
                    this.prevIpkts = new long[n3 + 1];
                    this.prevOpkts = new long[n3 + 1];
                    this.diffIpkts = new long[n3 + 1];
                    this.diffOpkts = new long[n3 + 1];
                    for (n6 = 0; n6 < n3; ++n6) {
                        this.interfaceNames[n6] = stringArray2[n6];
                        this.prevIpkts[n6] = lArray[n6];
                        this.prevOpkts[n6] = lArray2[n6];
                        this.diffIpkts[n6] = lArray3[n6];
                        this.diffOpkts[n6] = lArray4[n6];
                    }
                    n4 = n3++;
                    this.interfaceNames[n4] = stringArray[0];
                    this.prevIpkts[n4] = Long.parseLong(stringArray[4]);
                    this.prevOpkts[n4] = Long.parseLong(stringArray[6]);
                    this.diffIpkts[n4] = -5L;
                    this.diffOpkts[n4] = -5L;
                    continue;
                }
                this.diffIpkts[n4] = Long.parseLong(stringArray[4]) - this.prevIpkts[n4];
                this.diffOpkts[n4] = Long.parseLong(stringArray[6]) - this.prevOpkts[n4];
                this.prevIpkts[n4] = Long.parseLong(stringArray[4]);
                this.prevOpkts[n4] = Long.parseLong(stringArray[6]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return this.computeResultsOnSolaris(d);
    }

    public ArrayList computeResultsOnSolaris(double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.interfaceNames.length; ++i) {
            double d2 = d < 0.0 || this.diffIpkts[i] < 0L ? -5.0 : (double)this.diffIpkts[i] / d;
            double d3 = d < 0.0 || this.diffOpkts[i] < 0L ? -5.0 : (double)this.diffOpkts[i] / d;
            String string = this.interfaceNames[i] + "#" + d2 + "#" + d3;
            arrayList.add(string);
        }
        return arrayList;
    }

    public ArrayList getActualResultsOnLinux(double d, EgTest egTest) {
        this.cmdToExec = "/sbin/ifconfig";
        ArrayList arrayList = null;
        NetworkTrafficTest networkTrafficTest = (NetworkTrafficTest)egTest;
        if (networkTrafficTest.isIfconfigCmd) {
            arrayList = this.execCommand(this.cmdToExec);
        }
        return this.getActualResultsOnLinux(arrayList, d, networkTrafficTest);
    }

    public ArrayList getActualResultsOnLinux(ArrayList arrayList, double d, NetworkTrafficTest networkTrafficTest) {
        boolean bl = false;
        String string = null;
        int n = 0;
        this.rxPkts = new Hashtable();
        this.txPkts = new Hashtable();
        this.diffIpktsLn = new Hashtable();
        this.diffOpktsLn = new Hashtable();
        if (arrayList == null) {
            networkTrafficTest.isIfconfigCmd = false;
            this.cmdToExec = "ip -s link";
            ArrayList arrayList2 = this.execCommand(this.cmdToExec);
            if (arrayList2 == null || arrayList2.size() == 0) {
                return null;
            }
            this.getIpAddressOutput(arrayList2);
            return this.computeResultsOnLinux(d);
        }
        n = arrayList.size();
        try {
            Object object;
            Object object2;
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                long l;
                int n3;
                String string2 = (String)arrayList.get(n2);
                if (string2.equals("")) continue;
                if (string2.indexOf("Link encap") >= 0 || string2.indexOf("flags=") >= 0) {
                    if (string2.indexOf("Local Loopback") >= 0 || string2.indexOf("LOOPBACK") > 0) {
                        bl = false;
                        continue;
                    }
                    bl = true;
                    object2 = new StringTokenizer(string2);
                    if (((StringTokenizer)object2).countTokens() < 1) {
                        bl = false;
                        string = null;
                    }
                    if ((string = ((StringTokenizer)object2).nextToken()) != null && string.endsWith(":")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    if (this.interfaceNamesLn.indexOf(string) >= 0) continue;
                    this.interfaceNamesLn.add(string);
                    continue;
                }
                if ((string2.indexOf("RX packets:") >= 0 || string2.indexOf("RX packets") >= 0) && bl && string != null) {
                    object2 = new StringTokenizer(string2);
                    if (((StringTokenizer)object2).countTokens() < 2) {
                        bl = false;
                        string = null;
                    }
                    if (!((String)(object = ((StringTokenizer)object2).nextToken())).equals("RX")) {
                        bl = false;
                        string = null;
                    }
                    if ((n3 = ((String)(object = ((StringTokenizer)object2).nextToken())).indexOf(":")) < 0) {
                        if (!((String)object).equals("packets")) {
                            bl = false;
                            string = null;
                        } else {
                            object = ((StringTokenizer)object2).nextToken();
                        }
                    } else {
                        object = ((String)object).substring(n3 + 1);
                    }
                    l = Long.parseLong((String)object);
                    this.rxPkts.put(string, new Long(l));
                    continue;
                }
                if (string2.indexOf("TX packets:") < 0 && string2.indexOf("TX packets") < 0 || !bl || string == null) continue;
                bl = false;
                object2 = new StringTokenizer(string2);
                if (((StringTokenizer)object2).countTokens() < 1) {
                    bl = false;
                    string = null;
                }
                if (!((String)(object = ((StringTokenizer)object2).nextToken())).equals("TX")) {
                    bl = false;
                    string = null;
                }
                if ((n3 = ((String)(object = ((StringTokenizer)object2).nextToken())).indexOf(":")) < 0) {
                    if (!((String)object).equals("packets")) {
                        string = null;
                    } else {
                        object = ((StringTokenizer)object2).nextToken();
                    }
                } else {
                    object = ((String)object).substring(n3 + 1);
                }
                l = Long.parseLong((String)object);
                this.txPkts.put(string, new Long(l));
            }
            for (n2 = 0; n2 < this.interfaceNamesLn.size(); ++n2) {
                object2 = (String)this.interfaceNamesLn.get(n2);
                if (this.rxPkts.containsKey(object2) && this.txPkts.containsKey(object2)) {
                    object = (Long)this.rxPkts.get(object2);
                    Long l = (Long)this.txPkts.get(object2);
                    if (!this.prevIpktsLn.containsKey(object2)) {
                        this.prevIpktsLn.put(object2, object);
                        this.prevOpktsLn.put(object2, l);
                        this.diffIpktsLn.put(object2, new Long(-5L));
                        this.diffOpktsLn.put(object2, new Long(-5L));
                        continue;
                    }
                    Long l2 = (Long)this.prevIpktsLn.get(object2);
                    Long l3 = (Long)this.prevOpktsLn.get(object2);
                    if (l2 > (Long)object || l3 > l) {
                        this.prevIpktsLn.put(object2, object);
                        this.prevOpktsLn.put(object2, l);
                        this.diffIpktsLn.put(object2, new Long(-5L));
                        this.diffOpktsLn.put(object2, new Long(-5L));
                        continue;
                    }
                    Long l4 = new Long((Long)object - l2);
                    Long l5 = new Long(l - l3);
                    this.prevIpktsLn.put(object2, object);
                    this.prevOpktsLn.put(object2, l);
                    this.diffIpktsLn.put(object2, l4);
                    this.diffOpktsLn.put(object2, l5);
                    continue;
                }
                this.diffIpktsLn.put(object2, new Long(-5L));
                this.diffOpktsLn.put(object2, new Long(-5L));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.rxPkts = null;
            this.txPkts = null;
            this.diffIpktsLn = null;
            this.diffOpktsLn = null;
            return null;
        }
        return this.computeResultsOnLinux(d);
    }

    public ArrayList computeResultsOnLinux(double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.interfaceNamesLn == null) {
            return null;
        }
        for (int i = 0; i < this.interfaceNamesLn.size(); ++i) {
            String string = (String)this.interfaceNamesLn.get(i);
            if (!this.rxPkts.containsKey(string) || !this.txPkts.containsKey(string)) continue;
            double d2 = d < 0.0 || (Long)this.diffIpktsLn.get(string) < 0L ? -5.0 : (double)((Long)this.diffIpktsLn.get(string)).longValue() / d;
            double d3 = d < 0.0 || (Long)this.diffOpktsLn.get(string) < 0L ? -5.0 : (double)((Long)this.diffOpktsLn.get(string)).longValue() / d;
            String string2 = (String)this.interfaceNamesLn.get(i) + "#" + d2 + "#" + d3;
            arrayList.add(string2);
        }
        this.rxPkts = null;
        this.txPkts = null;
        this.diffIpktsLn = null;
        this.diffOpktsLn = null;
        return arrayList;
    }

    public ArrayList getActualResultsOnAix(double d) {
        this.cmdToExec = "netstat -in -f inet";
        ArrayList arrayList = this.execCommand(this.cmdToExec);
        return this.getActualResultsOnAix(arrayList, d);
    }

    public ArrayList getActualResultsOnAix(ArrayList arrayList, double d) {
        String string = "";
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        try {
            for (int i = 0; i < n; ++i) {
                int n2;
                Object object;
                string = (String)arrayList.get(i);
                if (string.startsWith("Name") || string.indexOf("127.0.0.1") != -1 || string.startsWith("lo0") || (string = string.trim()).equals("")) continue;
                int n3 = this.interfaceNames.length;
                int n4 = -1;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() == 10) {
                    object = "";
                    for (int j = 0; j < 10; ++j) {
                        if (j == 4) {
                            stringTokenizer.nextToken();
                            continue;
                        }
                        object = (String)object + stringTokenizer.nextToken() + "   ";
                    }
                    string = ((String)object).trim();
                }
                if (((StringTokenizer)(object = new StringTokenizer(string))).countTokens() <= 0) continue;
                String[] stringArray = new String[((StringTokenizer)object).countTokens()];
                int n5 = ((StringTokenizer)object).countTokens();
                for (n2 = 0; n2 < n5; ++n2) {
                    stringArray[n2] = ((StringTokenizer)object).nextToken();
                }
                if (arrayList2.indexOf(stringArray[0]) >= 0) continue;
                arrayList2.add(stringArray[0]);
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!stringArray[0].equals(this.interfaceNames[n2])) continue;
                    n4 = n2;
                    break;
                }
                if (n4 < 0) {
                    int n6;
                    String[] stringArray2 = new String[n3];
                    long[] lArray = new long[n3];
                    long[] lArray2 = new long[n3];
                    long[] lArray3 = new long[n3];
                    long[] lArray4 = new long[n3];
                    for (n6 = 0; n6 < n3; ++n6) {
                        stringArray2[n6] = this.interfaceNames[n6];
                        lArray[n6] = this.prevIpkts[n6];
                        lArray2[n6] = this.prevOpkts[n6];
                        lArray3[n6] = this.diffIpkts[n6];
                        lArray4[n6] = this.diffOpkts[n6];
                    }
                    this.interfaceNames = new String[n3 + 1];
                    this.prevIpkts = new long[n3 + 1];
                    this.prevOpkts = new long[n3 + 1];
                    this.diffIpkts = new long[n3 + 1];
                    this.diffOpkts = new long[n3 + 1];
                    for (n6 = 0; n6 < n3; ++n6) {
                        this.interfaceNames[n6] = stringArray2[n6];
                        this.prevIpkts[n6] = lArray[n6];
                        this.prevOpkts[n6] = lArray2[n6];
                        this.diffIpkts[n6] = lArray3[n6];
                        this.diffOpkts[n6] = lArray4[n6];
                    }
                    n4 = n3++;
                    this.interfaceNames[n4] = stringArray[0];
                    this.prevIpkts[n4] = Long.parseLong(stringArray[4]);
                    this.prevOpkts[n4] = Long.parseLong(stringArray[6]);
                    this.diffIpkts[n4] = -5L;
                    this.diffOpkts[n4] = -5L;
                    continue;
                }
                this.diffIpkts[n4] = Long.parseLong(stringArray[4]) - this.prevIpkts[n4];
                this.diffOpkts[n4] = Long.parseLong(stringArray[6]) - this.prevOpkts[n4];
                this.prevIpkts[n4] = Long.parseLong(stringArray[4]);
                this.prevOpkts[n4] = Long.parseLong(stringArray[6]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return this.computeResultsOnAix(d);
    }

    public ArrayList computeResultsOnAix(double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.interfaceNames.length; ++i) {
            double d2 = d < 0.0 || this.diffIpkts[i] < 0L ? -5.0 : (double)this.diffIpkts[i] / d;
            double d3 = d < 0.0 || this.diffOpkts[i] < 0L ? -5.0 : (double)this.diffOpkts[i] / d;
            String string = this.interfaceNames[i] + "#" + d2 + "#" + d3;
            arrayList.add(string);
        }
        return arrayList;
    }

    public ArrayList getActualResultsOnHPUnix(double d) {
        this.cmdToExec = new String("netstat -in -f inet");
        ArrayList arrayList = this.execCommand(this.cmdToExec);
        return this.getActualResultsOnHPUnix(arrayList, d);
    }

    public ArrayList getActualResultsOnHPUnix(ArrayList arrayList, double d) {
        String string = "";
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            for (int i = 0; i < n; ++i) {
                int n2;
                string = (String)arrayList.get(i);
                if (string.startsWith("Warning:") || string.startsWith("Name") || string.indexOf("127.0.0.1") != -1 || string.startsWith("lo0") || (string = string.trim()).equals("")) continue;
                int n3 = this.interfaceNames.length;
                int n4 = -1;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() < 7) continue;
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n5 = stringTokenizer.countTokens();
                for (n2 = 0; n2 < n5; ++n2) {
                    stringArray[n2] = stringTokenizer.nextToken();
                }
                if (arrayList2.indexOf(stringArray[0]) >= 0) continue;
                arrayList2.add(stringArray[0]);
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!stringArray[0].equals(this.interfaceNames[n2])) continue;
                    n4 = n2;
                    break;
                }
                if (n4 < 0) {
                    int n6;
                    String[] stringArray2 = new String[n3];
                    long[] lArray = new long[n3];
                    long[] lArray2 = new long[n3];
                    long[] lArray3 = new long[n3];
                    long[] lArray4 = new long[n3];
                    for (n6 = 0; n6 < n3; ++n6) {
                        stringArray2[n6] = this.interfaceNames[n6];
                        lArray[n6] = this.prevIpkts[n6];
                        lArray2[n6] = this.prevOpkts[n6];
                        lArray3[n6] = this.diffIpkts[n6];
                        lArray4[n6] = this.diffOpkts[n6];
                    }
                    this.interfaceNames = new String[n3 + 1];
                    this.prevIpkts = new long[n3 + 1];
                    this.prevOpkts = new long[n3 + 1];
                    this.diffIpkts = new long[n3 + 1];
                    this.diffOpkts = new long[n3 + 1];
                    for (n6 = 0; n6 < n3; ++n6) {
                        this.interfaceNames[n6] = stringArray2[n6];
                        this.prevIpkts[n6] = lArray[n6];
                        this.prevOpkts[n6] = lArray2[n6];
                        this.diffIpkts[n6] = lArray3[n6];
                        this.diffOpkts[n6] = lArray4[n6];
                    }
                    n4 = n3++;
                    this.interfaceNames[n4] = stringArray[0];
                    this.prevIpkts[n4] = Long.parseLong(stringArray[4]);
                    this.prevOpkts[n4] = Long.parseLong(stringArray[6]);
                    this.diffIpkts[n4] = -5L;
                    this.diffOpkts[n4] = -5L;
                    continue;
                }
                this.diffIpkts[n4] = Long.parseLong(stringArray[4]) - this.prevIpkts[n4];
                this.diffOpkts[n4] = Long.parseLong(stringArray[6]) - this.prevOpkts[n4];
                this.prevIpkts[n4] = Long.parseLong(stringArray[4]);
                this.prevOpkts[n4] = Long.parseLong(stringArray[6]);
                for (n2 = 0; n2 < this.diffIpkts.length; ++n2) {
                    System.out.println(n2 + " = " + this.diffIpkts[n2]);
                }
                for (n2 = 0; n2 < this.diffOpkts.length; ++n2) {
                    System.out.println(n2 + " = " + this.diffOpkts[n2]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return this.computeResultsOnHPUnix(d);
    }

    private ArrayList computeResultsOnHPUnix(double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.interfaceNames.length; ++i) {
            double d2 = d < 0.0 || this.diffIpkts[i] < 0L ? -5.0 : (double)this.diffIpkts[i] / d;
            double d3 = d < 0.0 || this.diffOpkts[i] < 0L ? -5.0 : (double)this.diffOpkts[i] / d;
            String string = this.interfaceNames[i] + "#" + d2 + "#" + d3;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void getIpAddressOutput(ArrayList arrayList) {
        boolean bl = false;
        String string = null;
        try {
            Object object;
            Object object2;
            int n;
            for (n = 0; n < arrayList.size(); ++n) {
                long l;
                String string2 = (String)arrayList.get(n);
                if (string2 == null || string2.length() == 0) continue;
                if ((string2 = string2.trim()).indexOf("LOOPBACK") > 0 || string2.indexOf("MULTICAST") > 0 || string2.indexOf("BROADCAST") > 0 || string2.indexOf("mtu") > 0) {
                    if (string2.indexOf("LOOPBACK") > 0) {
                        bl = false;
                        string = null;
                        continue;
                    }
                    bl = true;
                    object2 = new StringTokenizer(string2, ":");
                    if (((StringTokenizer)object2).countTokens() < 2) continue;
                    ((StringTokenizer)object2).nextToken();
                    string = ((StringTokenizer)object2).nextToken();
                    if (string == null || string.trim().length() == 0 || this.interfaceNamesLn.indexOf(string = string.trim()) >= 0) continue;
                    this.interfaceNamesLn.add(string);
                    continue;
                }
                if (string2.indexOf("RX:") >= 0 && string2.indexOf("packets") >= 0 && bl && string != null) {
                    object2 = new StringTokenizer(string2);
                    if (((StringTokenizer)object2).countTokens() < 3) {
                        bl = false;
                        string = null;
                        continue;
                    }
                    ((StringTokenizer)object2).nextToken();
                    ((StringTokenizer)object2).nextToken();
                    object = ((StringTokenizer)object2).nextToken();
                    if (!((String)object).equals("packets")) continue;
                    string2 = (String)arrayList.get(++n);
                    l = this.getPacketDetail(string2);
                    this.rxPkts.put(string, new Long(l));
                    continue;
                }
                if (string2.indexOf("TX:") < 0 || string2.indexOf("packets") < 0 || !bl || string == null) continue;
                object2 = new StringTokenizer(string2);
                if (((StringTokenizer)object2).countTokens() < 3) {
                    bl = false;
                    string = null;
                    continue;
                }
                ((StringTokenizer)object2).nextToken();
                ((StringTokenizer)object2).nextToken();
                object = ((StringTokenizer)object2).nextToken();
                if (!((String)object).equals("packets")) continue;
                string2 = (String)arrayList.get(++n);
                l = this.getPacketDetail(string2);
                this.txPkts.put(string, new Long(l));
            }
            for (n = 0; n < this.interfaceNamesLn.size(); ++n) {
                object2 = (String)this.interfaceNamesLn.get(n);
                if (this.rxPkts.containsKey(object2) && this.txPkts.containsKey(object2)) {
                    object = (Long)this.rxPkts.get(object2);
                    Long l = (Long)this.txPkts.get(object2);
                    if (!this.prevIpktsLn.containsKey(object2)) {
                        this.prevIpktsLn.put(object2, object);
                        this.prevOpktsLn.put(object2, l);
                        this.diffIpktsLn.put(object2, new Long(-5L));
                        this.diffOpktsLn.put(object2, new Long(-5L));
                        continue;
                    }
                    Long l2 = (Long)this.prevIpktsLn.get(object2);
                    Long l3 = (Long)this.prevOpktsLn.get(object2);
                    if (l2 > (Long)object || l3 > l) {
                        this.prevIpktsLn.put(object2, object);
                        this.prevOpktsLn.put(object2, l);
                        this.diffIpktsLn.put(object2, new Long(-5L));
                        this.diffOpktsLn.put(object2, new Long(-5L));
                        continue;
                    }
                    Long l4 = new Long((Long)object - l2);
                    Long l5 = new Long(l - l3);
                    this.prevIpktsLn.put(object2, object);
                    this.prevOpktsLn.put(object2, l);
                    this.diffIpktsLn.put(object2, l4);
                    this.diffOpktsLn.put(object2, l5);
                    continue;
                }
                this.diffIpktsLn.put(object2, new Long(-5L));
                this.diffOpktsLn.put(object2, new Long(-5L));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.rxPkts = null;
            this.txPkts = null;
            this.diffIpktsLn = null;
            this.diffOpktsLn = null;
        }
    }

    public long getPacketDetail(String string) {
        long l = 0L;
        if (string == null || string.trim().length() == 0) {
            return l;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.trim());
        if (stringTokenizer.countTokens() < 2) {
            return l;
        }
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        if (string2 == null || string2.trim().length() == 0) {
            return l;
        }
        string2 = string2.trim();
        l = Long.parseLong(string2);
        return l;
    }

    public static void main(String[] stringArray) {
    }
}

