/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class EgSapGenericJco3Test
extends AsAbapTblJco3Base {
    private boolean isBapiLoggedIn = false;
    private boolean isAbapSystemComp = false;
    public final SimpleDateFormat MTETimeStampSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Hashtable ht_lastTime = new Hashtable();
    private static Hashtable ht_confLastTime = new Hashtable();
    private static Hashtable ht_minConfTestFreq = new Hashtable();
    protected static Hashtable ht_ht_monValues = new Hashtable();
    protected static Hashtable ht_ht_confValues = new Hashtable();
    protected static Hashtable ht_ht_StatusValues = new Hashtable();
    protected static Hashtable ht_sapVersion = new Hashtable();
    protected static Hashtable ht_testStatus = new Hashtable();
    protected static Hashtable ht_ht_mteTimeStamps = new Hashtable();
    protected static Hashtable errCodeTbl;
    private static Hashtable syncHash;
    private static final String syncString;
    private static final String syncString2;
    private static final String syncString3;
    private static final ArrayList perfAttrList;
    private String sapVersion = "";
    private static final String MON_SET_NAME = "SAP CCMS Monitor Templates";
    private static String myDatePattern;
    private static SimpleDateFormat mySDF;
    private Properties connProps;
    String SID = null;
    private long perfCutoff = 0L;
    protected boolean isSapCCMSConfigTest = false;

    public EgSapGenericJco3Test(String[] stringArray) {
        super(stringArray);
        this.fixedTestPeriod = true;
        this.printOut("INFO : SAP connection identifying string, thisServer = " + this.thisServer);
        this.printOut("INFO : Log name of eG user in SAP, eGSapXMIUser = " + this.eGSapXMIUser);
        this.instanceName = this.getInstanceName();
        this.perfCutoff = (long)(0.9 * (double)this.measurePeriod);
        this.SID = this.getSID();
    }

    protected void setIsSapCCMSConfigTest() {
        this.isSapCCMSConfigTest = true;
    }

    boolean logonToXMI() {
        JCoDestination jCoDestination = EgSapGenericJco3Test.getDestination((String)this.destName);
        if (jCoDestination == null) {
            return false;
        }
        JCoFunction jCoFunction = this.getFunction("BAPI_XMI_LOGON");
        if (jCoFunction == null) {
            return false;
        }
        try {
            jCoFunction.getImportParameterList().setValue("EXTCOMPANY", "eGInnovations");
            jCoFunction.getImportParameterList().setValue("EXTPRODUCT", "eG");
            jCoFunction.getImportParameterList().setValue("INTERFACE", "XAL");
            jCoFunction.getImportParameterList().setValue("VERSION", "1.0");
            this.executeFunction(jCoFunction, true);
            this.printOut("INFO : Logged onto XAL interface");
            return true;
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to logon to XMI interface : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while trying to logon to XMI interface : " + exception.toString());
            this.printOut(EgInstallInfo.getStackTraceAsString(exception));
            return false;
        }
    }

    protected void setDataForSystem(boolean bl) {
        this.isAbapSystemComp = true;
        this.setData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setData() {
        String string;
        Object object;
        long l = 0L;
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Hashtable hashtable3 = null;
        if (this.isSapCCMSConfigTest) {
            this.printOut("CONF_DEBUG : Config test with measure period " + this.measurePeriod);
            object = (Long)ht_minConfTestFreq.get(this.thisServer);
            if (object == null) {
                string = syncString3;
                synchronized (string) {
                    object = (Long)ht_minConfTestFreq.get(this.thisServer);
                    if (object == null) {
                        this.printOut("CONF_DEBUG : Setting min conf test freq for first time for " + this.thisServer);
                        object = new Long(0L);
                        ht_minConfTestFreq.put(this.thisServer, new Long(this.measurePeriod));
                        this.printOut("CONF_DEBUG : Initialized minConfTestFreq for " + this.thisServer + " to " + ((Long)object).toString());
                    }
                }
            }
            this.printOut("CONF_DEBUG : comparing measurePeriod " + this.measurePeriod + " for " + this.thisServer + " with minConfTestFreq " + ((Long)object).toString());
            if (this.measurePeriod < (Long)object) {
                string = syncString3;
                synchronized (string) {
                    if (this.measurePeriod < (Long)object) {
                        this.printOut("CONF_DEBUG : Updating minConfTestFreq to " + this.measurePeriod + " for " + this.thisServer);
                        object = new Long(this.measurePeriod);
                        ht_minConfTestFreq.put(this.thisServer, object);
                    }
                }
            }
        }
        object = null;
        object = (String)syncHash.get(this.targetHost);
        if (object == null) {
            string = syncString;
            synchronized (string) {
                object = (String)syncHash.get(this.targetHost);
                if (object == null) {
                    syncHash.put(this.targetHost, new String(this.targetHost));
                    object = (String)syncHash.get(this.targetHost);
                }
            }
        }
        string = object;
        synchronized (string) {
            Object object2;
            this.isDynamicInfoTest = false;
            long l3 = System.currentTimeMillis();
            Long l4 = null;
            try {
                l4 = (Long)ht_lastTime.get(this.thisServer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            long l5 = 0L;
            if (l4 != null) {
                l5 = l4;
            }
            long l6 = l3 - l5;
            if (this.isDebugOn) {
                this.printOut(this.entity + " diff " + l6 + " perfCutoff " + this.perfCutoff);
            }
            if (l6 >= this.perfCutoff) {
                bl = true;
                l5 = l3;
                object2 = syncString2;
                synchronized (object2) {
                    try {
                        ht_lastTime.put(this.thisServer, new Long(l5));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.printOut("ERROR : ht_lasttime put exception " + exception.toString());
                        return;
                    }
                }
            }
            bl = false;
            this.printOut("getDataFromSAP = " + bl);
            if (bl) {
                try {
                    l4 = (Long)ht_confLastTime.get(this.thisServer);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                l5 = 0L;
                if (l4 != null) {
                    l5 = l4;
                }
                l6 = l3 - l5;
                if (this.isDebugOn) {
                    this.printOut(this.entity + " diff " + l6 + " perfCutoff " + this.perfCutoff);
                }
                object2 = (Long)ht_minConfTestFreq.get(this.thisServer);
                long l7 = 0L;
                if (object2 != null) {
                    l7 = (Long)object2;
                }
                if ((double)l6 >= 0.9 * (double)l7) {
                    bl2 = true;
                    this.printOut("CONF_DEBUG : get Conf Data From SAP = true");
                }
                long l8 = System.currentTimeMillis();
                hashtable = new Hashtable();
                if (bl2) {
                    this.printOut("CONF_DEBUG: initializing conf HT");
                    hashtable3 = new Hashtable();
                }
                hashtable2 = new Hashtable();
                try {
                    Object object3;
                    Hashtable hashtable4;
                    Hashtable hashtable5;
                    Object object4;
                    this.isBapiLoggedIn = false;
                    l = System.currentTimeMillis();
                    this.setSessID();
                    this.runThread((AsAbapJco3Base)((Object)this).new AsAbapJco3Base.ContextManager(this.sessID, this.destName, 1), "Begin Context");
                    if (!this.logonToXMI()) {
                        String string2 = syncString2;
                        synchronized (string2) {
                            try {
                                ht_ht_monValues.put(this.thisServer, hashtable);
                                if (bl2) {
                                    ht_ht_confValues.put(this.thisServer, hashtable3);
                                }
                                ht_ht_StatusValues.put(this.thisServer, hashtable2);
                                ht_sapVersion.put(this.thisServer, new String(this.sapVersion));
                                ht_lastTime.put(this.thisServer, new Long(System.currentTimeMillis()));
                            }
                            catch (Exception exception) {
                                this.printOut("Exception while setting data values (after logon error) : " + exception.toString());
                                this.logToErrorFile("ERROR", this.entity, "Exception while setting data values (after logon error) : " + exception.toString());
                            }
                        }
                        ht_testStatus.put(this.thisServer, new Boolean(false));
                        this.runThread((AsAbapJco3Base)((Object)this).new AsAbapJco3Base.ContextManager(this.sessID, this.destName, 2), "End Context");
                        this.endSession();
                        return;
                    }
                    ht_testStatus.put(this.thisServer, new Boolean(true));
                    if (this.isDebugOn) {
                        this.printOut("Tracing - - after export param list " + (System.currentTimeMillis() - l8) + " ms.");
                        this.printOut("Repository creation and BAPI_XMI_LOGON took " + (System.currentTimeMillis() - l) + "ms.");
                    }
                    JCoTable jCoTable = this.getMonitors();
                    this.printOut("Tracing - - after getMonitors CCMS Monitor set " + (System.currentTimeMillis() - l8) + " ms.");
                    if (jCoTable != null) {
                        int n = jCoTable.getNumRows();
                        for (int i = 0; i < n; ++i) {
                            object4 = jCoTable.getString("MONI_NAME");
                            if (object4 == null || ((String)object4).length() <= 0) continue;
                            if (this.isDebugOn) {
                                this.printOut("Trying to get data from monitor  tree root : " + (String)object4);
                            }
                            this.populateMonValuesFromTree((String)object4, bl2);
                            jCoTable.nextRow();
                        }
                    }
                    this.printOut("Logging off from XMI status : " + this.logoffFromXMI());
                    this.runThread((AsAbapJco3Base)((Object)this).new AsAbapJco3Base.ContextManager(this.sessID, this.destName, 2), "End Context");
                    this.endSession();
                    if (this.isDebugOn) {
                        this.printOut("Tracing - - after CCMS Monitor set " + (System.currentTimeMillis() - l8));
                    }
                    if (this.isDebugOn) {
                        this.printOut("Tracing - - after release " + (System.currentTimeMillis() - l8));
                        this.printOut("Tracing printing mon values for instance ..." + this.thisServer + " " + this.instanceName);
                    }
                    if ((hashtable5 = (Hashtable)ht_ht_monValues.get(this.thisServer)) != null) {
                        Enumeration enumeration = hashtable5.keys();
                        while (enumeration.hasMoreElements()) {
                            object4 = (String)enumeration.nextElement();
                            this.printOut("Monitor Values. key ( " + (String)object4 + " ) Value = " + (ArrayList)hashtable5.get(object4));
                        }
                    }
                    if ((hashtable4 = (Hashtable)ht_ht_StatusValues.get(this.thisServer)) != null) {
                        object4 = hashtable4.keys();
                        while (object4.hasMoreElements()) {
                            object3 = (String)object4.nextElement();
                            this.printOut("Status Values. key ( " + (String)object3 + " ) Value =  " + (ArrayList)hashtable4.get(object3));
                        }
                    }
                    if (bl2 && (object4 = (Hashtable)ht_ht_confValues.get(this.thisServer)) != null) {
                        object3 = ((Hashtable)object4).keys();
                        while (object3.hasMoreElements()) {
                            String string3 = (String)object3.nextElement();
                            this.printOut("Config Values. key ( " + string3 + " ) Value = " + (ArrayList)((Hashtable)object4).get(string3));
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string4 = syncString2;
                synchronized (string4) {
                    try {
                        ht_lastTime.put(this.thisServer, new Long(System.currentTimeMillis()));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
            }
            if ((object2 = (Boolean)ht_testStatus.get(this.thisServer)) != null && ((Boolean)object2).booleanValue()) {
                this.isDynamicInfoTest = true;
            }
        }
        if (this.isDebugOn) {
            this.printOut("setData took " + (System.currentTimeMillis() - l2) + "ms.");
        }
    }

    private JCoTable getMonitors() {
        long l = System.currentTimeMillis();
        JCoFunction jCoFunction = null;
        try {
            jCoFunction = this.getFunction("BAPI_SYSTEM_MON_GETLIST");
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MON_GETLIST not found in SAP.");
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MON_GETLIST not found in SAP " + exception.toString());
            exception.printStackTrace();
            return null;
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
        JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("MONI_SET_NAME");
        if (jCoStructure == null) {
            this.printOut("ERROR : MONI_SET_NAME structure null");
            return null;
        }
        jCoStructure.setValue("NAME", MON_SET_NAME);
        try {
            this.executeFunction(jCoFunction, true);
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("MONITOR_NAMES");
            if (jCoTable == null) {
                this.printOut("Could not obtain monitor_names table");
                return null;
            }
            jCoTable.setRow(0);
            if (this.isDebugOn) {
                this.printOut("getMonitorsForSet [MON_GETLIST] for set 'SAP CCMS Monitor Templates' took " + (System.currentTimeMillis() - l) + "ms.");
            }
            this.printOut("got monitor list table");
            return jCoTable;
        }
        catch (Exception exception) {
            this.printOut("Error getting monitors : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Error getting monitors : " + exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateMonValuesFromTree(String string, boolean bl) {
        String string2;
        Hashtable<String, ArrayList<String>> hashtable;
        Hashtable<String, ArrayList<String>> hashtable2;
        int n;
        long l = System.currentTimeMillis();
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        String string3 = "BAPI_SYSTEM_MON_GETTREE not found in SAP.";
        JCoFunction jCoFunction = null;
        try {
            jCoFunction = this.getFunction("BAPI_SYSTEM_MON_GETTREE");
        }
        catch (Exception exception) {
            this.printOut("Error while executing BAPI_SYSTEM_MON_GETTREE : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Error while executing BAPI_SYSTEM_MON_GETTREE : " + exception.toString());
            exception.printStackTrace();
            return;
        }
        if (jCoFunction == null) {
            this.printOut("Error : Could not create function BAPI_SYSTEM_MON_GETTREE");
            return;
        }
        arrayList = new ArrayList<String>();
        if (bl) {
            arrayList2 = new ArrayList<String>();
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        JCoTable jCoTable = null;
        Object var12_12 = null;
        String string4 = new String();
        String string5 = "";
        String string6 = "";
        boolean bl2 = false;
        try {
            jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
            JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("MONITOR_NAME");
            jCoStructure.setValue("MONI_NAME", string);
            jCoStructure.setValue("MS_NAME", MON_SET_NAME);
            this.executeFunction(jCoFunction, true);
            jCoTable = jCoFunction.getTableParameterList().getTable("TREE_NODES");
            this.printOut("Time taken to get monitor tree [MON_GETTREE] for monitor " + string + " is " + (System.currentTimeMillis() - l) + "ms.");
            bl2 = perfAttrList.contains(string);
            n = jCoTable.getNumRows();
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to get monitor tree: " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while trying to get monitor tree: " + exception.toString());
            exception.printStackTrace();
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            String string7;
            string6 = jCoTable.getString("MSEGNAME");
            if (string6 == null) {
                jCoTable.nextRow();
                continue;
            }
            if ((string6 = string6.trim()) == null || string6.length() < 10) {
                jCoTable.nextRow();
                continue;
            }
            string5 = string6.substring(9);
            if (!this.isAbapSystemComp && !string5.equalsIgnoreCase(this.instanceName)) {
                jCoTable.nextRow();
                continue;
            }
            hashtable2 = jCoTable.getString("OBJECTNAME");
            hashtable = jCoTable.getString("MTCLASS");
            string2 = jCoTable.getString("MTNAMESHRT");
            String string8 = jCoTable.getString("MTMCNAME");
            if (this.isPerformanceAttribute((String)((Object)hashtable))) {
                if (bl2) {
                    string7 = this.getPerfValueForTID(jCoTable.getString("MTSYSID"), string8, jCoTable.getString("MTNUMRANGE"), jCoTable.getString("MTUID"), jCoTable.getString("MTCLASS"), jCoTable.getString("MTINDEX"), jCoTable.getString("EXTINDEX"), string2, string, (String)((Object)hashtable2));
                    arrayList.add(string5 + "#" + hashtable2 + "|" + jCoTable.getString("MTNAMESHRT") + "|" + string7);
                }
            } else if (this.isStatusMessageAttribute((String)((Object)hashtable))) {
                string7 = this.getStatusMessageValue(jCoTable.getString("MTSYSID"), string8, jCoTable.getString("MTNUMRANGE"), jCoTable.getString("MTUID"), jCoTable.getString("MTCLASS"), jCoTable.getString("MTINDEX"), jCoTable.getString("EXTINDEX"), string2, string);
                arrayList3.add(string5 + "#" + string7);
            } else if (bl && this.isTextAttribute((String)((Object)hashtable))) {
                string7 = this.getTxtPropMessageValue(jCoTable.getString("MTSYSID"), string8, jCoTable.getString("MTNUMRANGE"), jCoTable.getString("MTUID"), jCoTable.getString("MTCLASS"), jCoTable.getString("MTINDEX"), jCoTable.getString("EXTINDEX"), string2, string);
                arrayList2.add(string5 + "#" + hashtable2 + "|" + jCoTable.getString("MTNAMESHRT") + "|" + string7);
            }
            jCoTable.nextRow();
        }
        Hashtable<String, ArrayList<String>> hashtable3 = null;
        hashtable2 = null;
        hashtable = null;
        try {
            hashtable3 = (Hashtable<String, ArrayList<String>>)ht_ht_monValues.get(this.thisServer);
            hashtable = (Hashtable)ht_ht_StatusValues.get(this.thisServer);
            hashtable2 = (Hashtable)ht_ht_confValues.get(this.thisServer);
        }
        catch (Exception exception) {
            this.printOut("Exception while setting data values. Resetting to null and initialized shortly : " + exception.toString());
            hashtable3 = null;
            hashtable = null;
            hashtable2 = null;
        }
        if (hashtable3 == null) {
            hashtable3 = new Hashtable<String, ArrayList<String>>();
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, ArrayList<String>>();
        }
        if (hashtable2 == null) {
            this.printOut("CONF_DEBUG : Initialized config values for " + this.thisServer);
            hashtable2 = new Hashtable<String, ArrayList<String>>();
        }
        hashtable3.put(string, arrayList);
        hashtable.put(string, arrayList3);
        if (bl) {
            this.printOut("CONF_DEBUG : Setting confValues for monitor " + string);
            this.printOut("CONF_DEBUG : confValues = " + arrayList2);
            hashtable2.put(string, arrayList2);
        }
        string2 = syncString2;
        synchronized (string2) {
            try {
                ht_ht_monValues.put(this.thisServer, hashtable3);
                ht_ht_StatusValues.put(this.thisServer, hashtable);
                if (bl) {
                    ht_confLastTime.put(this.thisServer, new Long(System.currentTimeMillis()));
                    ht_ht_confValues.put(this.thisServer, hashtable2);
                    this.printOut("CONF_DEBUG : Updated config values for server " + this.thisServer);
                }
                this.printOut("Updated monitor, status values for server " + this.thisServer);
                if (this.sapVersion != null && this.sapVersion.length() > 0) {
                    ht_sapVersion.put(this.thisServer, this.sapVersion);
                }
            }
            catch (Exception exception) {
                this.printOut("Exception while storing measures for " + this.thisServer + " : " + exception.toString());
                this.logToErrorFile("ERROR", "Exception while storing measures for " + this.thisServer, exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getData(String string) {
        Hashtable hashtable = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_monValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_monValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No data for " + this.entity);
                    return null;
                }
                ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                if (arrayList3 == null) {
                    return null;
                }
                arrayList = (ArrayList)arrayList3.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getData : " + exception.toString());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            int n2 = string3.indexOf("#");
            if (n2 < 0) {
                arrayList2.add(string3);
                continue;
            }
            String string4 = string3.substring(0, n2);
            if (!this.instanceName.equalsIgnoreCase(string4)) continue;
            String string5 = string3.substring(n2 + 1);
            arrayList2.add(string5);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " Got data for monitor " + string + " : " + arrayList2);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getSystemWideData(String string) {
        Hashtable hashtable = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_monValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_monValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No data for " + this.entity);
                    return null;
                }
                ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                if (arrayList3 == null) {
                    this.printOut("No data for : " + string);
                    return null;
                }
                arrayList = (ArrayList)arrayList3.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getData : " + exception.toString());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            int n2 = string3.indexOf("#");
            if (n2 < 0) {
                arrayList2.add(string3);
                continue;
            }
            String string4 = string3.substring(0, n2);
            if (this.SID != null && !this.SID.equals("") && string4.indexOf("_" + this.SID + "_") == -1) continue;
            String string5 = string3.substring(n2 + 1);
            this.printOut(this.entity + " Instance is " + this.instanceName + " systemwide : Got rest '" + string5 + "' for monitor " + string);
            arrayList2.add(string5);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " Got systemwide data for monitor " + string + " : " + arrayList2);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getMonData4AllInst(String string, boolean bl) {
        Hashtable hashtable = null;
        Hashtable<String, Double> hashtable2 = null;
        Hashtable<String, Hashtable<String, Double>> hashtable3 = new Hashtable<String, Hashtable<String, Double>>();
        ArrayList arrayList = null;
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_monValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_monValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No data for " + this.entity);
                    return null;
                }
                ArrayList arrayList2 = (ArrayList)hashtable.get(string);
                if (arrayList2 == null) {
                    this.printOut("No data for : " + string);
                    return null;
                }
                arrayList = (ArrayList)arrayList2.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getData : " + exception.toString());
                this.logToErrorFile("ERROR", this.reportingName + ":" + this.entity, "Exception in getSystemWideDataByInst : " + exception.toString());
            }
        }
        int n = arrayList.size();
        hashtable2 = new Hashtable<String, Double>();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            String string3 = (String)arrayList.get(i);
            int n4 = string3.indexOf("#");
            if (n4 == -1) continue;
            String string4 = string3.substring(0, n4);
            if (this.SID != null && !this.SID.equals("") && string4.indexOf("_" + this.SID + "_") == -1 || (n3 = string3.lastIndexOf("|")) == -1) continue;
            String string5 = string3.substring(n4 + 1, n3);
            if (bl && (n2 = string5.indexOf("|")) != -1) {
                string5 = string5.substring(n2 + 1);
            }
            String string6 = string3.substring(n3 + 1);
            Double d = null;
            try {
                d = new Double(string6);
            }
            catch (NumberFormatException numberFormatException) {
                d = NaDbl;
            }
            hashtable2 = (Hashtable<String, Double>)hashtable3.get(string4);
            if (hashtable2 == null) {
                hashtable2 = new Hashtable<String, Double>();
                hashtable3.put(string4, hashtable2);
            }
            hashtable2.put(string5, d);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " getMonData4AllInst for monitor " + string + " : " + hashtable3);
        }
        return hashtable3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getSystemWideStatusMessage(String string) {
        Hashtable hashtable = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_StatusValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_StatusValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No data for " + this.entity);
                    return null;
                }
                ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                if (arrayList3 == null) {
                    return null;
                }
                arrayList = (ArrayList)arrayList3.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getData : " + exception.toString());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            int n2 = string3.indexOf("#");
            if (n2 < 0) {
                arrayList2.add(string3);
                continue;
            }
            String string4 = string3.substring(0, n2);
            if (this.SID != null && !this.SID.equals("") && string4.indexOf("_" + this.SID + "_") == -1) continue;
            String string5 = string3.substring(n2 + 1);
            arrayList2.add(string5);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " Got data for monitor " + string + " : " + arrayList2);
        }
        this.printOut("Got system specific values : " + arrayList2);
        return arrayList2;
    }

    public Hashtable cloneHashtable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable.get(string);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList.get(i);
                int n2 = string2.indexOf("#");
                if (n2 < 0) {
                    arrayList2.add(string2);
                    continue;
                }
                String string3 = string2.substring(0, n2);
                if (!this.instanceName.equalsIgnoreCase(string3)) continue;
                String string4 = string2.substring(n2 + 1);
                arrayList2.add(string4);
            }
            hashtable2.put(string, arrayList2);
        }
        return hashtable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getStatus() {
        String string = syncString2;
        synchronized (string) {
            if (ht_ht_StatusValues == null) {
                return null;
            }
            if (ht_ht_StatusValues.size() == 0) {
                return new Hashtable();
            }
            return this.cloneHashtable((Hashtable)ht_ht_StatusValues.get(this.thisServer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getValue(String string) {
        Object object;
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_StatusValues == null) {
                    return null;
                }
                Hashtable hashtable = (Hashtable)ht_ht_StatusValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No value");
                    return null;
                }
                object = null;
                try {
                    object = (ArrayList)hashtable.get(string);
                    if (object == null) {
                        return null;
                    }
                    arrayList = (ArrayList)((ArrayList)object).clone();
                }
                catch (Exception exception) {
                    this.printOut("Exception in getValue(): " + exception.toString());
                }
            }
            catch (Exception exception) {
                this.printOut("Exception in getValue() : " + exception.toString());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            object = (String)arrayList.get(i);
            int n2 = ((String)object).indexOf("#");
            if (n2 < 0) {
                arrayList2.add(object);
                continue;
            }
            String string3 = ((String)object).substring(0, n2);
            if (!this.instanceName.equalsIgnoreCase(string3)) continue;
            String string4 = ((String)object).substring(n2 + 1);
            arrayList2.add(string4);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getConfigData(String string) {
        Hashtable hashtable = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_confValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_confValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No config data for " + this.entity);
                    return null;
                }
                ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                if (arrayList3 == null) {
                    return null;
                }
                arrayList = (ArrayList)arrayList3.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getData : " + exception.toString());
                this.logToErrorFile("ERROR", this.reportingName + ":" + this.entity, "Exception in getData : " + exception.toString());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            int n2 = string3.indexOf("#");
            if (n2 < 0) {
                arrayList2.add(string3);
                continue;
            }
            String string4 = string3.substring(0, n2);
            if (!this.instanceName.equalsIgnoreCase(string4)) continue;
            String string5 = string3.substring(n2 + 1);
            arrayList2.add(string5);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " Got data for monitor " + string + " : " + arrayList2);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSapVersion() {
        String string = syncString2;
        synchronized (string) {
            this.printOut("htsapversion: '" + ht_sapVersion + "'");
            if (ht_sapVersion == null) {
                return null;
            }
            return (String)ht_sapVersion.get(this.thisServer);
        }
    }

    private String formatValue(String string, String string2) {
        String string3 = string;
        if (string == null || string2 == null) {
            return null;
        }
        int n = Integer.parseInt(string2);
        if (n > 0) {
            int n2;
            int n3 = string3.length();
            if (n > n3) {
                for (n2 = 0; n2 < n - n3; ++n2) {
                    string3 = "0" + string3;
                }
            }
            string3 = (n2 = string3.length() - n) == 0 ? "0." + string3 : string3.substring(0, n2) + "." + string3.substring(n2);
        }
        return string3;
    }

    private String getPerfValueForTID(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        String string11 = "";
        long l = System.currentTimeMillis();
        JCoFunction jCoFunction = this.getFunction("BAPI_SYSTEM_MTE_GETPERFCURVAL");
        if (jCoFunction == null) {
            this.printOut("BAPI_SYSTEM_MTE_GETPERFCURVAL not found in SAP.");
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETPERFCURVAL not found in SAP");
            return "";
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
        JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("TID");
        jCoStructure.setValue("MTSYSID", string);
        jCoStructure.setValue("MTMCNAME", string2);
        jCoStructure.setValue("MTNUMRANGE", string3);
        jCoStructure.setValue("MTUID", string4);
        jCoStructure.setValue("MTCLASS", string5);
        jCoStructure.setValue("MTINDEX", string6);
        jCoStructure.setValue("EXTINDEX", string7);
        try {
            this.executeFunction(jCoFunction, true);
        }
        catch (Exception exception) {
            this.printOut("Exception while executing getPerfValueForTID : " + exception.toString());
            return "";
        }
        try {
            String[] stringArray;
            JCoStructure jCoStructure2 = jCoFunction.getExportParameterList().getStructure("CURRENT_VALUE");
            string11 = jCoStructure2.getString("ALRELEVVAL");
            String string12 = jCoStructure2.getString("ALRELVALDT").trim();
            String string13 = jCoStructure2.getString("ALRELVALTI").trim();
            if (string12.length() != 0 && string13.length() != 0) {
                stringArray = string12 + " " + string13;
                String string14 = string9 + "|" + string10 + "|" + string2 + "|" + string8;
                Date date = null;
                try {
                    date = this.MTETimeStampSDF.parse((String)stringArray);
                }
                catch (Exception exception) {
                    this.printOut("Exception while parsing MTE timestamp " + (String)stringArray + " : " + exception.toString());
                }
                if (date != null) {
                    Date date2;
                    Hashtable<String, Date> hashtable = (Hashtable<String, Date>)ht_ht_mteTimeStamps.get(this.thisServer);
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, Date>();
                        ht_ht_mteTimeStamps.put(this.thisServer, hashtable);
                    }
                    if ((date2 = (Date)hashtable.get(string14)) != null) {
                        long l2;
                        long l3 = date2.getDate();
                        long l4 = date.getDate();
                        long l5 = l4 - l3;
                        if (l5 > 0L && (double)(l2 = l5 / 1000L) > 3.0 * this.timeSinceLastTest) {
                            this.printOut("Stale measure found " + string14 + ". prevDate " + date2.toString() + ", currDate " + date.toString());
                            return "";
                        }
                    }
                    hashtable.put(string14, date);
                }
            } else {
                return "";
            }
            stringArray = this.getPerfPropsForTID(string, string2, string3, string4, string5, string6, string7, string8);
            if (stringArray != null) {
                string11 = this.formatValue(string11, stringArray[9]);
            }
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MTE_GETPERFCURVAL : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETPERFCURVAL : " + exception.toString());
            exception.printStackTrace();
        }
        if (this.isDebugOn) {
            this.printOut("getPerfValueForTID for monitor name " + string9 + " and mtNameshrt " + string8 + "  returning " + string11 + " and took " + (System.currentTimeMillis() - l) + " ms.");
        }
        return string11;
    }

    private String[] getPerfPropsForTID(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        long l = System.currentTimeMillis();
        String[] stringArray = new String[10];
        JCoFunction jCoFunction = this.getFunction("BAPI_SYSTEM_MTE_GETPERFPROP");
        if (jCoFunction == null) {
            this.printOut("BAPI_SYSTEM_MTE_GETPERFPROP not found in SAP.");
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETPERFPROP not found in SAP");
            return null;
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
        JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("TID");
        jCoStructure.setValue("MTSYSID", string);
        jCoStructure.setValue("MTMCNAME", string2);
        jCoStructure.setValue("MTNUMRANGE", string3);
        jCoStructure.setValue("MTUID", string4);
        jCoStructure.setValue("MTCLASS", string5);
        jCoStructure.setValue("MTINDEX", string6);
        jCoStructure.setValue("EXTINDEX", string7);
        try {
            this.executeFunction(jCoFunction, true);
        }
        catch (Exception exception) {
            this.printOut("Exception while executing getPerfPropsForTID " + exception.toString());
            return null;
        }
        try {
            JCoStructure jCoStructure2 = jCoFunction.getExportParameterList().getStructure("PROPERTIES");
            stringArray[0] = jCoStructure2.getString("RELVALTYPE");
            stringArray[1] = jCoStructure2.getString("THRESHDIR");
            stringArray[2] = jCoStructure2.getString("TRESHG2Y");
            stringArray[3] = jCoStructure2.getString("TRESHY2R");
            stringArray[4] = jCoStructure2.getString("TRESHY2G");
            stringArray[5] = jCoStructure2.getString("TRESHR2Y");
            stringArray[6] = jCoStructure2.getString("MSGCLASS");
            stringArray[7] = jCoStructure2.getString("MSGID");
            stringArray[8] = jCoStructure2.getString("VALUNIT");
            stringArray[9] = jCoStructure2.getString("DECIMALS");
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MTE_GETPERFPROP : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETPERFPROP : " + exception.toString());
            exception.printStackTrace();
            return null;
        }
        return stringArray;
    }

    private String getStatusMessageValue(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        long l = System.currentTimeMillis();
        String string10 = "";
        JCoFunction jCoFunction = this.getFunction("BAPI_SYSTEM_MTE_GETSMVALUE");
        if (jCoFunction == null) {
            return "";
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
        JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("TID");
        if (jCoStructure == null) {
            return "";
        }
        jCoStructure.setValue("MTSYSID", string);
        jCoStructure.setValue("MTMCNAME", string2);
        jCoStructure.setValue("MTNUMRANGE", string3);
        jCoStructure.setValue("MTUID", string4);
        jCoStructure.setValue("MTCLASS", string5);
        jCoStructure.setValue("MTINDEX", string6);
        jCoStructure.setValue("EXTINDEX", string7);
        try {
            this.executeFunction(jCoFunction, true);
        }
        catch (Exception exception) {
            this.printOut("Exception while executing executeFunction : " + exception.toString());
            return "";
        }
        String string11 = "";
        String string12 = "";
        try {
            JCoStructure jCoStructure2 = jCoFunction.getExportParameterList().getStructure("VALUE");
            if (jCoStructure2 == null) {
                return "";
            }
            string12 = jCoStructure2.getString("SMSGVALUE");
            string11 = jCoStructure2.getString("MSG");
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MTE_GETSMVALUE : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETSMVALUE : " + exception.toString());
            exception.printStackTrace();
            return "";
        }
        if (string11.length() != 0 && string11 != null) {
            string10 = string11;
        }
        if (string12 != null && (string12.equals("1") || string12.equals("0"))) {
            string10 = string10 + "Ok";
        }
        if (this.isDebugOn) {
            this.printOut("getStatusMessageValue [MTE_GETSMVALUE] for monitor name " + string9 + " and mtNameShrt " + string8 + " returning " + string10 + " and took " + (System.currentTimeMillis() - l) + "ms.");
        }
        return string10;
    }

    private String getTxtPropMessageValue(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        long l = System.currentTimeMillis();
        String string10 = "";
        this.printOut("Starting getTxtPropMessageValue [BAPITXTPRP] for monitor name " + string9 + " and mtNameShrt " + string8);
        JCoFunction jCoFunction = this.getFunction("BAPI_SYSTEM_MTE_GETTXTPROP");
        if (jCoFunction == null) {
            return "";
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
        JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("TID");
        if (jCoStructure == null) {
            return "";
        }
        jCoStructure.setValue("MTSYSID", string);
        jCoStructure.setValue("MTMCNAME", string2);
        jCoStructure.setValue("MTNUMRANGE", string3);
        jCoStructure.setValue("MTUID", string4);
        jCoStructure.setValue("MTCLASS", string5);
        jCoStructure.setValue("MTINDEX", string6);
        jCoStructure.setValue("EXTINDEX", string7);
        try {
            this.executeFunction(jCoFunction, true);
        }
        catch (Exception exception) {
            this.printOut("Exception while executing executeFunction : " + exception.toString());
            return "";
        }
        String string11 = "";
        String string12 = "";
        try {
            JCoStructure jCoStructure2 = jCoFunction.getExportParameterList().getStructure("PROPERTIES");
            if (jCoStructure2 == null) {
                return "";
            }
            string12 = jCoStructure2.getString("TEXT");
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MTE_GETTXTPROP : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETTXTPROP : " + exception.toString());
            exception.printStackTrace();
            return "";
        }
        if (this.isDebugOn) {
            this.printOut("getTxtPropMessageValue [BAPITXTPRP] for monitor name " + string9 + " and mtNameShrt " + string8 + " returning " + string12 + " and took " + (System.currentTimeMillis() - l) + "ms.");
        }
        return string12;
    }

    private boolean isPerformanceAttribute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("100");
    }

    private boolean isMessageLogAttribute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("101");
    }

    private boolean isStatusMessageAttribute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("102");
    }

    private boolean isTextAttribute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("110") || string.equals("111");
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt((String)stringArray[i + 1]);
            break;
        }
        EgSapGenericJco3Test egSapGenericJco3Test = new EgSapGenericJco3Test(stringArray);
        egSapGenericJco3Test.setData();
        egSapGenericJco3Test.printOut("getMonData4AllInst(Entire System) = " + egSapGenericJco3Test.getMonData4AllInst("Entire System", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getSystemData(String string) {
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_monValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_monValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No System data for " + this.entity);
                    return null;
                }
                ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                if (arrayList3 == null) {
                    return null;
                }
                arrayList = (ArrayList)arrayList3.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getSystemData : " + exception.toString());
                this.logToErrorFile("ERROR", this.reportingName + ":" + this.entity, "Exception in getData : " + exception.toString());
            }
        }
        int n = arrayList.size();
        hashtable2 = new Hashtable();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            int n2 = string3.indexOf("#");
            if (n2 < 0) {
                arrayList2.add(string3);
                continue;
            }
            String string4 = string3.substring(0, n2);
            if (this.SID != null && !this.SID.equals("") && string4.indexOf("_" + this.SID + "_") == -1) continue;
            String string5 = string3.substring(n2 + 1);
            arrayList2.add(string5);
            this.addValue(hashtable2, string4, string5);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " Got data for monitor " + string + " : " + arrayList2);
        }
        return hashtable2;
    }

    public void addValue(Hashtable hashtable, String string, String string2) {
        ArrayList<String> arrayList = null;
        if (hashtable.containsKey(string)) {
            arrayList = (ArrayList<String>)hashtable.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string2);
        } else {
            arrayList = new ArrayList<String>();
            arrayList.add(string2);
        }
        hashtable.put(string, arrayList);
    }

    static {
        syncHash = new Hashtable();
        syncString = new String("SAP");
        syncString2 = new String("SAP2");
        syncString3 = new String("SAP3");
        perfAttrList = new ArrayList();
        myDatePattern = "dd/MM/yy hh:mm:ss a";
        mySDF = new SimpleDateFormat(myDatePattern);
        perfAttrList.add("Background Processing");
        perfAttrList.add("Buffers");
        perfAttrList.add("Communications");
        perfAttrList.add("Database");
        perfAttrList.add("Enqueue");
        perfAttrList.add("Entire System");
        perfAttrList.add("Spool System");
        perfAttrList.add("System Configuration");
    }
}

