/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgDateInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public class CtxNsUptimeTest
extends CtxNsTestBase {
    private double currSysuptime = 0.0;
    private double prevSysuptime = 0.0;
    private double maxUptimeTimeout = 3600.0;
    private DataOutputStream dos = null;
    private DataInputStream dis = null;
    private File f = null;
    private String installdir = EgInstallInfo.getInstallDir() + "/agent/logs/NetScalerUptime_" + this.reportingName + ".log";
    private static EgDateInfo dateInfo = new EgDateInfo();
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    private String reportMgrTime = new String("");
    private boolean isReportMgrTime = true;
    public String ddLine = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtxNsUptimeTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.f = new File(this.installdir);
        this.fixedTestPeriod = true;
        this.reportMgrTime = this.getValueForParam("reportmanagertime");
        this.isReportMgrTime = this.reportMgrTime == null || !this.reportMgrTime.equalsIgnoreCase("no") && !this.reportMgrTime.equalsIgnoreCase("false");
        String string = this.getValueForParam("Reboot_timeout_in_mins");
        if (string != null && string.trim().length() > 0) {
            double d = 60.0;
            try {
                d = Double.parseDouble(string.trim());
            }
            catch (Exception exception) {
                d = 60.0;
            }
            this.maxUptimeTimeout = d * 60.0;
        }
        if (fieldSep.length() == 0) {
            String string2 = sync0;
            synchronized (string2) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
        this.isNewDynamicInfoTest = true;
    }

    public void freeTest() {
        this.ddLine = new String();
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            this.collectMetrics();
            Hashtable hashtable2 = null;
            if (systemHash != null && systemHash.containsKey(this.reportingName)) {
                hashtable2 = (Hashtable)systemHash.get(this.reportingName);
            }
            if (hashtable2 == null || hashtable2.size() == 0) {
                return;
            }
            String string = (String)hashtable2.get("startTime");
            if (string == null || string.trim().length() == 0) {
                return;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            long l = this.f.lastModified();
            if (this.currSysuptime == 0.0 && !this.f.exists()) {
                this.currSysuptime = this.getNsUptime(string);
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(-5.0));
                double d = this.currSysuptime / 60.0;
                arrayList.add(new Double(d));
                this.addNewMeasure(arrayList);
                this.writeDoubleToFile(this.currSysuptime);
                return;
            }
            if (!this.f.exists()) {
                this.currSysuptime = this.getNsUptime(string);
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(-5.0));
                double d = this.currSysuptime / 60.0;
                arrayList.add(new Double(d));
                this.addNewMeasure(arrayList);
                this.writeDoubleToFile(this.currSysuptime);
                return;
            }
            this.currSysuptime = this.getNsUptime(string);
            this.prevSysuptime = this.readDoubleFromFile();
            if (this.currSysuptime < this.prevSysuptime && this.currSysuptime <= this.maxUptimeTimeout) {
                long l2;
                arrayList.add(new Double(1.0));
                arrayList.add(new Double(this.currSysuptime));
                double d = this.currSysuptime / 60.0;
                arrayList.add(new Double(d));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                Date date = null;
                long l3 = 0L;
                long l4 = 0L;
                String string2 = "";
                String string3 = "";
                long l5 = System.currentTimeMillis();
                if (this.isReportMgrTime) {
                    l2 = l5 - l;
                    l3 = dateInfo.egetUTCDate() - l2;
                    string2 = dateInfo.egetDate(l3);
                    l4 = dateInfo.egetUTCDate() - (long)this.currSysuptime * 1000L;
                    string3 = dateInfo.egetDate(l4);
                } else {
                    l3 = l;
                    date = new Date(l3);
                    string2 = simpleDateFormat.format(date);
                    l4 = l5 - (long)this.currSysuptime * 1000L;
                    date = new Date(l4);
                    string3 = simpleDateFormat.format(date);
                }
                l2 = l4 - l3;
                if (l2 > 0L) {
                    double d2 = (double)l2 / 1000.0 / 60.0;
                    String string4 = "No";
                    if (this.checkMaintenance()) {
                        string4 = "Yes";
                    }
                    this.ddLine = string2 + fieldSep + string3 + fieldSep + this.round(d2, 4) + fieldSep + string4;
                }
            } else if (this.currSysuptime == 0.0 && this.prevSysuptime == 0.0) {
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
            } else {
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(this.currSysuptime - this.prevSysuptime));
                double d = this.currSysuptime / 60.0;
                arrayList.add(new Double(d));
            }
            this.prevSysuptime = this.currSysuptime;
            this.writeDoubleToFile(this.currSysuptime);
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            System.out.println("[CtxNsUptimeTest] Exception occured while calling the computeMeasures method " + exception);
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", "CtxNsUptimeTest", string);
            exception.printStackTrace();
        }
    }

    private double getNsUptime(String string) {
        double d = 0.0;
        try {
            Locale locale = Locale.US;
            System.out.println("[CtxNsUptimeTest] getNsUptime method startTime is " + string);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", locale);
            Date date = simpleDateFormat.parse(string.trim());
            String string2 = Calendar.getInstance().getTimeZone().getID();
            Date date2 = new Date(date.getTime() + (long)TimeZone.getTimeZone(string2).getOffset(date.getTime()));
            System.out.println("[CtxNsUptimeTest] getNsUptime method startDateInLocalObj is " + date2);
            long l = date2.getTime();
            long l2 = System.currentTimeMillis();
            d = (l2 - l) / 1000L;
            System.out.println("[CtxNsUptimeTest] getNsUptime method currentTime " + l2 + " sysStartTime " + l + " sysUptime " + d);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDoubleToFile(double d) {
        try {
            this.dos = new DataOutputStream(new FileOutputStream(this.f));
            this.dos.writeDouble(d);
            this.dos.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.dos.close();
            }
            catch (Exception exception) {}
            this.dos = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readDoubleFromFile() {
        double d = 0.0;
        try {
            if (!this.f.exists()) {
                double d2 = -5.0;
                return d2;
            }
            this.dis = new DataInputStream(new FileInputStream(this.f));
            d = this.dis.readDouble();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.dis.close();
            }
            catch (Exception exception) {}
            this.dis = null;
        }
        return d;
    }
}

