/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.pattern.parser;

import com.eg.ch.qos.logback.core.pattern.parser.OptionTokenizer;
import com.eg.ch.qos.logback.core.pattern.parser.Token;
import com.eg.ch.qos.logback.core.pattern.util.IEscapeUtil;
import com.eg.ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import com.eg.ch.qos.logback.core.pattern.util.RestrictedEscapeUtil;
import com.eg.ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TokenStream {
    final String pattern;
    final int patternLength;
    final IEscapeUtil escapeUtil;
    final IEscapeUtil optionEscapeUtil = new RestrictedEscapeUtil();
    TokenizerState state = TokenizerState.LITERAL_STATE;
    int pointer = 0;

    TokenStream(String string) {
        this(string, new RegularEscapeUtil());
    }

    TokenStream(String string, IEscapeUtil iEscapeUtil) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty pattern string not allowed");
        }
        this.pattern = string;
        this.patternLength = string.length();
        this.escapeUtil = iEscapeUtil;
    }

    List tokenize() throws ScanException {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        StringBuffer stringBuffer = new StringBuffer();
        while (this.pointer < this.patternLength) {
            char c2 = this.pattern.charAt(this.pointer);
            ++this.pointer;
            switch (this.state) {
                case LITERAL_STATE: {
                    this.handleLiteralState(c2, arrayList, stringBuffer);
                    break;
                }
                case FORMAT_MODIFIER_STATE: {
                    this.handleFormatModifierState(c2, arrayList, stringBuffer);
                    break;
                }
                case OPTION_STATE: {
                    this.processOption(c2, arrayList, stringBuffer);
                    break;
                }
                case KEYWORD_STATE: {
                    this.handleKeywordState(c2, arrayList, stringBuffer);
                    break;
                }
                case RIGHT_PARENTHESIS_STATE: {
                    this.handleRightParenthesisState(c2, arrayList, stringBuffer);
                    break;
                }
            }
        }
        switch (this.state) {
            case LITERAL_STATE: {
                this.addValuedToken(1000, stringBuffer, arrayList);
                break;
            }
            case KEYWORD_STATE: {
                arrayList.add(new Token(1004, stringBuffer.toString()));
                break;
            }
            case RIGHT_PARENTHESIS_STATE: {
                arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
                break;
            }
            case FORMAT_MODIFIER_STATE: 
            case OPTION_STATE: {
                throw new ScanException("Unexpected end of pattern string");
            }
        }
        return arrayList;
    }

    private void handleRightParenthesisState(char c2, List<Token> list, StringBuffer stringBuffer) {
        list.add(Token.RIGHT_PARENTHESIS_TOKEN);
        switch (c2) {
            case ')': {
                break;
            }
            case '{': {
                this.state = TokenizerState.OPTION_STATE;
                break;
            }
            case '\\': {
                this.escape("%{}", stringBuffer);
                this.state = TokenizerState.LITERAL_STATE;
                break;
            }
            default: {
                stringBuffer.append(c2);
                this.state = TokenizerState.LITERAL_STATE;
            }
        }
    }

    private void processOption(char c2, List<Token> list, StringBuffer stringBuffer) throws ScanException {
        OptionTokenizer optionTokenizer = new OptionTokenizer(this);
        optionTokenizer.tokenize(c2, list);
    }

    private void handleFormatModifierState(char c2, List<Token> list, StringBuffer stringBuffer) {
        if (c2 == '(') {
            this.addValuedToken(1002, stringBuffer, list);
            list.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
            this.state = TokenizerState.LITERAL_STATE;
        } else if (Character.isJavaIdentifierStart(c2)) {
            this.addValuedToken(1002, stringBuffer, list);
            this.state = TokenizerState.KEYWORD_STATE;
            stringBuffer.append(c2);
        } else {
            stringBuffer.append(c2);
        }
    }

    private void handleLiteralState(char c2, List<Token> list, StringBuffer stringBuffer) {
        switch (c2) {
            case '\\': {
                this.escape("%()", stringBuffer);
                break;
            }
            case '%': {
                this.addValuedToken(1000, stringBuffer, list);
                list.add(Token.PERCENT_TOKEN);
                this.state = TokenizerState.FORMAT_MODIFIER_STATE;
                break;
            }
            case ')': {
                this.addValuedToken(1000, stringBuffer, list);
                this.state = TokenizerState.RIGHT_PARENTHESIS_STATE;
                break;
            }
            default: {
                stringBuffer.append(c2);
            }
        }
    }

    private void handleKeywordState(char c2, List<Token> list, StringBuffer stringBuffer) {
        if (Character.isJavaIdentifierPart(c2)) {
            stringBuffer.append(c2);
        } else if (c2 == '{') {
            this.addValuedToken(1004, stringBuffer, list);
            this.state = TokenizerState.OPTION_STATE;
        } else if (c2 == '(') {
            this.addValuedToken(1005, stringBuffer, list);
            this.state = TokenizerState.LITERAL_STATE;
        } else if (c2 == '%') {
            this.addValuedToken(1004, stringBuffer, list);
            list.add(Token.PERCENT_TOKEN);
            this.state = TokenizerState.FORMAT_MODIFIER_STATE;
        } else if (c2 == ')') {
            this.addValuedToken(1004, stringBuffer, list);
            this.state = TokenizerState.RIGHT_PARENTHESIS_STATE;
        } else {
            this.addValuedToken(1004, stringBuffer, list);
            if (c2 == '\\') {
                if (this.pointer < this.patternLength) {
                    char c3 = this.pattern.charAt(this.pointer++);
                    this.escapeUtil.escape("%()", stringBuffer, c3, this.pointer);
                }
            } else {
                stringBuffer.append(c2);
            }
            this.state = TokenizerState.LITERAL_STATE;
        }
    }

    void escape(String string, StringBuffer stringBuffer) {
        if (this.pointer < this.patternLength) {
            char c2 = this.pattern.charAt(this.pointer++);
            this.escapeUtil.escape(string, stringBuffer, c2, this.pointer);
        }
    }

    void optionEscape(String string, StringBuffer stringBuffer) {
        if (this.pointer < this.patternLength) {
            char c2 = this.pattern.charAt(this.pointer++);
            this.optionEscapeUtil.escape(string, stringBuffer, c2, this.pointer);
        }
    }

    private void addValuedToken(int n2, StringBuffer stringBuffer, List<Token> list) {
        if (stringBuffer.length() > 0) {
            list.add(new Token(n2, stringBuffer.toString()));
            stringBuffer.setLength(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TokenizerState {
        LITERAL_STATE,
        FORMAT_MODIFIER_STATE,
        KEYWORD_STATE,
        OPTION_STATE,
        RIGHT_PARENTHESIS_STATE;

    }
}

