/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexValidator
implements Serializable {
    private static final long serialVersionUID = -8832409930574867162L;
    private final Pattern[] patterns;

    public RegexValidator(String string) {
        this(string, true);
    }

    public RegexValidator(String string, boolean bl) {
        this(new String[]{string}, bl);
    }

    public RegexValidator(String[] stringArray) {
        this(stringArray, true);
    }

    public RegexValidator(String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Regular expressions are missing");
        }
        this.patterns = new Pattern[stringArray.length];
        int n = bl ? 0 : 2;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0) {
                throw new IllegalArgumentException("Regular expression[" + i + "] is missing");
            }
            this.patterns[i] = Pattern.compile(stringArray[i], n);
        }
    }

    public boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    public String[] match(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.patterns.length; ++i) {
            Matcher matcher = this.patterns[i].matcher(string);
            if (!matcher.matches()) continue;
            int n = matcher.groupCount();
            String[] stringArray = new String[n];
            for (int j = 0; j < n; ++j) {
                stringArray[j] = matcher.group(j + 1);
            }
            return stringArray;
        }
        return null;
    }

    public String validate(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.patterns.length; ++i) {
            Matcher matcher = this.patterns[i].matcher(string);
            if (!matcher.matches()) continue;
            int n = matcher.groupCount();
            if (n == 1) {
                return matcher.group(1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < n; ++j) {
                String string2 = matcher.group(j + 1);
                if (string2 == null) continue;
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RegexValidator{");
        for (int i = 0; i < this.patterns.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.patterns[i].pattern());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

