/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran.action;

import com.eg.ch.qos.logback.core.Appender;
import com.eg.ch.qos.logback.core.joran.action.Action;
import com.eg.ch.qos.logback.core.joran.spi.ActionException;
import com.eg.ch.qos.logback.core.joran.spi.InterpretationContext;
import com.eg.ch.qos.logback.core.spi.LifeCycle;
import com.eg.ch.qos.logback.core.util.OptionHelper;
import java.util.HashMap;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderAction<E>
extends Action {
    Appender<E> appender;
    private boolean inError = false;

    @Override
    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) throws ActionException {
        this.appender = null;
        this.inError = false;
        String string2 = attributes.getValue("class");
        if (OptionHelper.isEmpty(string2)) {
            this.addError("Missing class name for appender. Near [" + string + "] line " + this.getLineNumber(interpretationContext));
            this.inError = true;
            return;
        }
        try {
            this.addInfo("About to instantiate appender of type [" + string2 + "]");
            this.appender = (Appender)OptionHelper.instantiateByClassName(string2, Appender.class, this.context);
            this.appender.setContext(this.context);
            String string3 = interpretationContext.subst(attributes.getValue("name"));
            if (OptionHelper.isEmpty(string3)) {
                this.addWarn("No appender name given for appender of type " + string2 + "].");
            } else {
                this.appender.setName(string3);
                this.addInfo("Naming appender as [" + string3 + "]");
            }
            HashMap hashMap = (HashMap)interpretationContext.getObjectMap().get("APPENDER_BAG");
            hashMap.put(string3, this.appender);
            interpretationContext.pushObject(this.appender);
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create an Appender of type [" + string2 + "].", exception);
            throw new ActionException(exception);
        }
    }

    @Override
    public void end(InterpretationContext interpretationContext, String string) {
        Object object;
        if (this.inError) {
            return;
        }
        if (this.appender instanceof LifeCycle) {
            this.appender.start();
        }
        if ((object = interpretationContext.peekObject()) != this.appender) {
            this.addWarn("The object at the of the stack is not the appender named [" + this.appender.getName() + "] pushed earlier.");
        } else {
            interpretationContext.popObject();
        }
    }
}

