/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.helpers;

import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableToStringArray {
    public static String[] convert(Throwable throwable) {
        LinkedList<String> linkedList = new LinkedList<String>();
        ThrowableToStringArray.extract(linkedList, throwable, null);
        return linkedList.toArray(new String[0]);
    }

    private static void extract(List<String> list, Throwable throwable, StackTraceElement[] stackTraceElementArray) {
        Throwable throwable2;
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n2 = ThrowableToStringArray.findNumberOfCommonFrames(stackTraceElementArray2, stackTraceElementArray);
        list.add(ThrowableToStringArray.formatFirstLine(throwable, stackTraceElementArray));
        for (int i2 = 0; i2 < stackTraceElementArray2.length - n2; ++i2) {
            list.add("\tat " + stackTraceElementArray2[i2].toString());
        }
        if (n2 != 0) {
            list.add("\t... " + n2 + " common frames omitted");
        }
        if ((throwable2 = throwable.getCause()) != null) {
            ThrowableToStringArray.extract(list, throwable2, stackTraceElementArray2);
        }
    }

    private static String formatFirstLine(Throwable throwable, StackTraceElement[] stackTraceElementArray) {
        String string = "";
        if (stackTraceElementArray != null) {
            string = "Caused by: ";
        }
        String string2 = string + throwable.getClass().getName();
        if (throwable.getMessage() != null) {
            string2 = string2 + ": " + throwable.getMessage();
        }
        return string2;
    }

    private static int findNumberOfCommonFrames(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        if (stackTraceElementArray2 == null) {
            return 0;
        }
        int n2 = stackTraceElementArray.length - 1;
        int n3 = 0;
        for (int i2 = stackTraceElementArray2.length - 1; n2 >= 0 && i2 >= 0 && stackTraceElementArray[n2].equals(stackTraceElementArray2[i2]); --n2, --i2) {
            ++n3;
        }
        return n3;
    }
}

