/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.pattern;

import com.eg.ch.qos.logback.classic.pattern.ClassicConverter;
import com.eg.ch.qos.logback.classic.spi.CallerData;
import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.CoreConstants;
import com.eg.ch.qos.logback.core.boolex.EvaluationException;
import com.eg.ch.qos.logback.core.boolex.EventEvaluator;
import com.eg.ch.qos.logback.core.status.ErrorStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallerDataConverter
extends ClassicConverter {
    public static final String DEFAULT_CALLER_LINE_PREFIX = "Caller+";
    public static final String DEFAULT_RANGE_DELIMITER = "..";
    private int depthStart = 0;
    private int depthEnd = 5;
    List<EventEvaluator<ILoggingEvent>> evaluatorList = null;
    final int MAX_ERROR_COUNT = 4;
    int errorCount = 0;

    @Override
    public void start() {
        Object object;
        String string = this.getFirstOption();
        if (string == null) {
            return;
        }
        try {
            if (this.isRange(string)) {
                object = this.splitRange(string);
                if (((String[])object).length == 2) {
                    this.depthStart = Integer.parseInt(object[0]);
                    this.depthEnd = Integer.parseInt((String)object[1]);
                    this.checkRange();
                } else {
                    this.addError("Failed to parse depth option as range [" + string + "]");
                }
            } else {
                this.depthEnd = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.addError("Failed to parse depth option [" + string + "]", numberFormatException);
        }
        object = this.getOptionList();
        if (object != null && object.size() > 1) {
            int n2 = object.size();
            for (int i2 = 1; i2 < n2; ++i2) {
                String string2 = (String)object.get(i2);
                Context context = this.getContext();
                if (context == null) continue;
                Map map = (Map)context.getObject("EVALUATOR_MAP");
                EventEvaluator eventEvaluator = (EventEvaluator)map.get(string2);
                if (eventEvaluator == null) continue;
                this.addEvaluator(eventEvaluator);
            }
        }
    }

    private boolean isRange(String string) {
        return string.contains(this.getDefaultRangeDelimiter());
    }

    private String[] splitRange(String string) {
        return string.split(Pattern.quote(this.getDefaultRangeDelimiter()), 2);
    }

    private void checkRange() {
        if (this.depthStart < 0 || this.depthEnd < 0) {
            this.addError("Invalid depthStart/depthEnd range [" + this.depthStart + ", " + this.depthEnd + "] (negative values are not allowed)");
        } else if (this.depthStart >= this.depthEnd) {
            this.addError("Invalid depthEnd range [" + this.depthStart + ", " + this.depthEnd + "] (start greater or equal to end)");
        }
    }

    private void addEvaluator(EventEvaluator<ILoggingEvent> eventEvaluator) {
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator<ILoggingEvent>>();
        }
        this.evaluatorList.add(eventEvaluator);
    }

    @Override
    public String convert(ILoggingEvent iLoggingEvent) {
        StackTraceElement[] stackTraceElementArray;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.evaluatorList != null) {
            boolean bl2 = false;
            for (n2 = 0; n2 < this.evaluatorList.size(); ++n2) {
                EventEvaluator<ILoggingEvent> eventEvaluator = this.evaluatorList.get(n2);
                try {
                    if (!eventEvaluator.evaluate(iLoggingEvent)) continue;
                    bl2 = true;
                    break;
                }
                catch (EvaluationException evaluationException) {
                    ++this.errorCount;
                    if (this.errorCount < 4) {
                        this.addError("Exception thrown for evaluator named [" + eventEvaluator.getName() + "]", evaluationException);
                        continue;
                    }
                    if (this.errorCount != 4) continue;
                    ErrorStatus errorStatus = new ErrorStatus("Exception thrown for evaluator named [" + eventEvaluator.getName() + "].", this, evaluationException);
                    errorStatus.add(new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", this));
                    this.addStatus(errorStatus);
                }
            }
            if (!bl2) {
                return "";
            }
        }
        if ((stackTraceElementArray = iLoggingEvent.getCallerData()) != null && stackTraceElementArray.length > this.depthStart) {
            n2 = this.depthEnd < stackTraceElementArray.length ? this.depthEnd : stackTraceElementArray.length;
            for (int i2 = this.depthStart; i2 < n2; ++i2) {
                stringBuilder.append(this.getCallerLinePrefix());
                stringBuilder.append(i2);
                stringBuilder.append("\t at ");
                stringBuilder.append(stackTraceElementArray[i2]);
                stringBuilder.append(CoreConstants.LINE_SEPARATOR);
            }
            return stringBuilder.toString();
        }
        return CallerData.CALLER_DATA_NA;
    }

    protected String getCallerLinePrefix() {
        return DEFAULT_CALLER_LINE_PREFIX;
    }

    protected String getDefaultRangeDelimiter() {
        return DEFAULT_RANGE_DELIMITER;
    }
}

