/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.joran;

import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.gaffer.GafferUtil;
import com.eg.ch.qos.logback.classic.joran.JoranConfigurator;
import com.eg.ch.qos.logback.classic.joran.ReconfigureOnChangeTaskListener;
import com.eg.ch.qos.logback.classic.util.EnvUtil;
import com.eg.ch.qos.logback.core.joran.event.SaxEvent;
import com.eg.ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import com.eg.ch.qos.logback.core.joran.spi.JoranException;
import com.eg.ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import com.eg.ch.qos.logback.core.spi.ContextAwareBase;
import com.eg.ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReconfigureOnChangeTask
extends ContextAwareBase
implements Runnable {
    public static final String DETECTED_CHANGE_IN_CONFIGURATION_FILES = "Detected change in configuration files.";
    static final String RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION = "Re-registering previous fallback configuration once more as a fallback configuration point";
    static final String FALLING_BACK_TO_SAFE_CONFIGURATION = "Given previous errors, falling back to previously registered safe configuration.";
    long birthdate = System.currentTimeMillis();
    List<ReconfigureOnChangeTaskListener> listeners;

    void addListener(ReconfigureOnChangeTaskListener reconfigureOnChangeTaskListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ReconfigureOnChangeTaskListener>();
        }
        this.listeners.add(reconfigureOnChangeTaskListener);
    }

    @Override
    public void run() {
        ConfigurationWatchList configurationWatchList;
        block11: {
            block10: {
                this.fireEnteredRunMethod();
                configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList(this.context);
                if (configurationWatchList == null) {
                    this.addWarn("Empty ConfigurationWatchList in context");
                    return;
                }
                List<File> list = configurationWatchList.getCopyOfFileWatchList();
                if (list == null) break block10;
                if (!list.isEmpty()) break block11;
            }
            this.addInfo("Empty watch file list. Disabling ");
            return;
        }
        if (!configurationWatchList.changeDetected()) {
            return;
        }
        this.fireChangeDetected();
        URL uRL = configurationWatchList.getMainURL();
        this.addInfo(DETECTED_CHANGE_IN_CONFIGURATION_FILES);
        this.addInfo("Will reset and reconfigure context named [" + this.context.getName() + "]");
        LoggerContext loggerContext = (LoggerContext)this.context;
        if (uRL.toString().endsWith("xml")) {
            this.performXMLConfiguration(loggerContext, uRL);
        } else if (uRL.toString().endsWith("groovy")) {
            if (EnvUtil.isGroovyAvailable()) {
                loggerContext.reset();
                GafferUtil.runGafferConfiguratorOn(loggerContext, (Object)this, uRL);
            } else {
                this.addError("Groovy classes are not available on the class path. ABORTING INITIALIZATION.");
            }
        }
        this.fireDoneReconfiguring();
    }

    private void fireEnteredRunMethod() {
        if (this.listeners == null) {
            return;
        }
        for (ReconfigureOnChangeTaskListener reconfigureOnChangeTaskListener : this.listeners) {
            reconfigureOnChangeTaskListener.enteredRunMethod();
        }
    }

    private void fireChangeDetected() {
        if (this.listeners == null) {
            return;
        }
        for (ReconfigureOnChangeTaskListener reconfigureOnChangeTaskListener : this.listeners) {
            reconfigureOnChangeTaskListener.changeDetected();
        }
    }

    private void fireDoneReconfiguring() {
        if (this.listeners == null) {
            return;
        }
        for (ReconfigureOnChangeTaskListener reconfigureOnChangeTaskListener : this.listeners) {
            reconfigureOnChangeTaskListener.doneReconfiguring();
        }
    }

    private void performXMLConfiguration(LoggerContext loggerContext, URL uRL) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.context);
        StatusUtil statusUtil = new StatusUtil(this.context);
        List<SaxEvent> list = joranConfigurator.recallSafeConfiguration();
        URL uRL2 = ConfigurationWatchListUtil.getMainWatchURL(this.context);
        loggerContext.reset();
        long l2 = System.currentTimeMillis();
        try {
            joranConfigurator.doConfigure(uRL);
            if (statusUtil.hasXMLParsingErrors(l2)) {
                this.fallbackConfiguration(loggerContext, list, uRL2);
            }
        }
        catch (JoranException joranException) {
            this.fallbackConfiguration(loggerContext, list, uRL2);
        }
    }

    private List<SaxEvent> removeIncludeEvents(List<SaxEvent> list) {
        ArrayList<SaxEvent> arrayList = new ArrayList<SaxEvent>();
        if (list == null) {
            return arrayList;
        }
        for (SaxEvent saxEvent : list) {
            if ("include".equalsIgnoreCase(saxEvent.getLocalName())) continue;
            arrayList.add(saxEvent);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fallbackConfiguration(LoggerContext loggerContext, List<SaxEvent> list, URL uRL) {
        ConfigurationWatchList configurationWatchList;
        JoranConfigurator joranConfigurator;
        List<SaxEvent> list2;
        block4: {
            block3: {
                list2 = this.removeIncludeEvents(list);
                joranConfigurator = new JoranConfigurator();
                joranConfigurator.setContext(this.context);
                ConfigurationWatchList configurationWatchList2 = ConfigurationWatchListUtil.getConfigurationWatchList(this.context);
                configurationWatchList = configurationWatchList2.buildClone();
                if (list2 == null) break block3;
                if (!list2.isEmpty()) break block4;
            }
            this.addWarn("No previous configuration to fall back on.");
            return;
        }
        this.addWarn(FALLING_BACK_TO_SAFE_CONFIGURATION);
        try {
            loggerContext.reset();
            ConfigurationWatchListUtil.registerConfigurationWatchList(this.context, configurationWatchList);
            joranConfigurator.doConfigure(list2);
            this.addInfo(RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION);
            joranConfigurator.registerSafeConfiguration(list);
            this.addInfo("after registerSafeConfiguration: " + list);
            return;
        }
        catch (JoranException joranException) {
            this.addError("Unexpected exception thrown by a configuration considered safe.", joranException);
        }
    }

    public String toString() {
        return "ReconfigureOnChangeTask(born:" + this.birthdate + ")";
    }
}

