'use strict'
var os = require('os');
var fs = require('fs');
var log = require('./logger');

//Todo:- Need to add stop collecting specific metrics l

var DEFAULT_CONFIG = {};

try {
    DEFAULT_CONFIG = {

        //INFO
        language: 'NODEJS',

        node_version: process.versions ? process.versions.node : 'Not available',
        os_type: os.type ? os.type() : 'Not available', //'Windows_NT || Linux || Darwin' 
        pid: process.pid,
        os_architecture: os.arch ? os.arch() : 'Not available', //64 or 32 bit
        os_platform: os.platform ? os.platform() : 'Not available', //aix' 'darwin' 'freebsd' 'linux' 'openbsd' 'sunos' 'win32'

        component_id: '',

        //To capture unhandled exceptions
        capture_uncaught_exceptions: true,

        //Collector
        //To enable inframetrics to collect cpu,memory,gc,eventloop metrics
        inframetrics_enabled: true,
        inframetrics_interval: 300000,

        //Default offload Agent hostname, port 
        agent_port: '13700',
        agent_host: 'localhost',

        //Log level  options info, error, debug
        log_level: 'info',

        //Cluster api details
        isMaster: false,
        workerCount: 0,

        //http url patterns
        ignoredStatusCodes: [],
        ignoreFileTypes: '',
        ignoredURLs: [],
        ignoredUrlPatterns: [],
        includePatterns: [],
        includeURLs: [],

        //Socket and queue
        flushInterval: 10000,
        maxQueueSize: 1000,

        //Socket retry to send the data again interval
        retryInterval: 15000,

        pattern: "*.ttf,*.otf,*.woff,*.woff2,*.eot,*.cff,*.afm,*.lwfn,*.ffil,*.fon,*.pfm,*.pfb,*.std,*.pro,*.xsf,*.jpg,*.jpeg,*.jpe,*.jif,*.jfif,*.jfi,*.jp2,*.j2k,*.jpf,*.jpx,*.jpm,*.jxr,*.hdp,*.wdp,*.mj2,*.webp,*.gif,*.png,*.apng,*.mng,*.tiff,*.tif,*.xbm,*.bmp,*.dib,*.svg,*.svgz,*.mpg,*.mpeg,*.mpeg2,*.avi,*.wmv,*.mov,*.rm,*.ram,*.swf,*.flv,*.ogg,*.webm,*.mp4,*.ts,*.mid,*.midi,*.rm,*.ram,*.wma,*.aac,*.wav,*.ogg,*.mp3,*.mp4,*.css,*.js,*.ico,*.cur,/egurkha*",

        black_listed: {
            // urls : ['/admin', '/login', '/favicon.ico'],
            // status_codes : [500, 502, 503, 404],
            // file_types : (/\.(otf|woff|woff2|eot|cff|afm|lwfn|ffil|fon|pfm|pfb|std|pro|xsf|jpg|jpeg|jpe|jif|jfif|jfi|jp2|j2k|jpf|jpx|jpm|jxr|hdp|wdp|mj2|webp|gif|png|apng|mng|tiff|tif|xbm|bmp|dib|svg|svgz|mpg|mpeg|mpeg2|avi|wmv|mov|rm|ram|swf|flv|ogg|webm|mp4|ts|mid|midi|rm|ram|wma|aac|wav|ogg|mp3|mp4|css|js|ico|cur)$/i),
            // patterns : [new RegExp('^/egurkha')],
            // user_agent : [ /pingdom/i]

            startsWith: new RegExp('^(/egurkha)'),
            endsWith: new RegExp('(.ttf|.otf|.woff|.woff2|.eot|.cff|.afm|.lwfn|.ffil|.fon|.pfm|.pfb|.std|.pro|.xsf|.jpg|.jpeg|.jpe|.jif|.jfif|.jfi|.jp2|.j2k|.jpf|.jpx|.jpm|.jxr|.hdp|.wdp|.mj2|.webp|.gif|.png|.apng|.mng|.tiff|.tif|.xbm|.bmp|.dib|.svg|.svgz|.mpg|.mpeg|.mpeg2|.avi|.wmv|.mov|.rm|.ram|.swf|.flv|.ogg|.webm|.mp4|.ts|.mid|.midi|.rm|.ram|.wma|.aac|.wav|.ogg|.mp3|.mp4|.css|.js|.ico|.cur)$'),
            regexes: []
        },

        max_segment_per_transaction: 10,
        disable_libraries: [],
        disable_btm: false,
        max_queue_size: 1000,
        retry_interval: 1000,
        flush_interval: 15000,
        max_samples_per_minute: 10000,
        event_loop_stack_collection: false,
        event_stack_collection_threshold: 100,
        enable_cpu_profiling: false,
        cpu_dump_location: getTempDir(), //Get default location
        cpu_profiling_duration: 10000, //Max 3 mins
        enable_memory_profiling: false,
        memory_dump_location: getTempDir(), //Get default location,
        max_memory_dump_size: 25, //in mbs
        max_cpu_dump_size: 25,
        sql_cutoff_time: 10,
        show_http_headers: false,
        show_http_cookies: false,
        show_http_statuscode: false
    }

} catch (e) {
    log.error('Default config js', e)
}

module.exports = DEFAULT_CONFIG;



function getTempDir() {
    return fs.realpathSync(os.tmpdir())
}

