/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.nio.file.spi.FileTypeDetector;
import java.security.AccessController;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.GnomeFileTypeDetector;
import sun.nio.fs.HPUserDefinedFileAttributeView;
import sun.nio.fs.MimeTypesFileTypeDetector;
import sun.nio.fs.SolarisAclFileAttributeView;
import sun.nio.fs.SolarisFileStore;
import sun.nio.fs.SolarisFileSystem;
import sun.nio.fs.SolarisUserDefinedFileAttributeView;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;
import sun.security.action.GetPropertyAction;

public class SolarisFileSystemProvider
extends UnixFileSystemProvider {
    private static final boolean isHP;

    @Override
    SolarisFileSystem newFileSystem(String string) {
        return new SolarisFileSystem(this, string);
    }

    @Override
    SolarisFileStore getFileStore(UnixPath unixPath) throws IOException {
        return new SolarisFileStore(unixPath);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        if (clazz == AclFileAttributeView.class) {
            return (V)new SolarisAclFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        if (clazz == UserDefinedFileAttributeView.class) {
            if (isHP) {
                return (V)new HPUserDefinedFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
            }
            return (V)new SolarisUserDefinedFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        return super.getFileAttributeView(path, clazz, linkOptionArray);
    }

    @Override
    public DynamicFileAttributeView getFileAttributeView(Path path, String string, LinkOption ... linkOptionArray) {
        if (string.equals("acl")) {
            return new SolarisAclFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        if (string.equals("user")) {
            if (isHP) {
                return new HPUserDefinedFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
            }
            return new SolarisUserDefinedFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        return super.getFileAttributeView(path, string, linkOptionArray);
    }

    @Override
    FileTypeDetector getFileTypeDetector() {
        Path path = Paths.get(AccessController.doPrivileged(new GetPropertyAction("user.home")), ".mime.types");
        Path path2 = Paths.get("/etc/mime.types", new String[0]);
        return this.chain(new GnomeFileTypeDetector(), new MimeTypesFileTypeDetector(path), new MimeTypesFileTypeDetector(path2));
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        isHP = string.equals("HP-UX");
    }
}

