/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util.multipart;

import com.egurkha.util.multipart.FileRenamePolicy;
import com.egurkha.util.multipart.MacBinaryDecoderOutputStream;
import com.egurkha.util.multipart.Part;
import com.egurkha.util.multipart.PartInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;

public class FilePart
extends Part {
    private String fileName;
    private String filePath;
    private String contentType;
    private PartInputStream partInput;
    private FileRenamePolicy policy;

    FilePart(String string, ServletInputStream servletInputStream, String string2, String string3, String string4, String string5) throws IOException {
        super(string);
        this.fileName = string4;
        this.filePath = string5;
        this.contentType = string3;
        this.partInput = new PartInputStream(servletInputStream, string2);
    }

    public void setRenamePolicy(FileRenamePolicy fileRenamePolicy) {
        this.policy = fileRenamePolicy;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.partInput;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long writeTo(File file) throws IOException {
        long l = 0L;
        OutputStream outputStream = null;
        try {
            if (this.fileName != null) {
                File file2 = file.isDirectory() ? new File(file, this.fileName) : file;
                if (this.policy != null) {
                    file2 = this.policy.rename(file2);
                    this.fileName = file2.getName();
                }
                outputStream = new BufferedOutputStream(new FileOutputStream(file2));
                l = this.write(outputStream);
            }
            Object var7_5 = null;
            if (outputStream == null) return l;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (outputStream == null) throw throwable;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
        return l;
    }

    public long writeTo(OutputStream outputStream) throws IOException {
        long l = 0L;
        if (this.fileName != null) {
            l = this.write(outputStream);
        }
        return l;
    }

    long write(OutputStream outputStream) throws IOException {
        int n;
        if (this.contentType.equals("application/x-macbinary")) {
            outputStream = new MacBinaryDecoderOutputStream(outputStream);
        }
        long l = 0L;
        byte[] byArray = new byte[8192];
        while ((n = this.partInput.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean isFile() {
        return true;
    }
}

