/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxBblob
extends IfxLob
implements Blob {
    public IfxBblob() {
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    public IfxBblob(IfxLocator ifxLocator) {
        this.locatorPointer = ifxLocator;
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    public IfxBblob(IfxConnection ifxConnection, IfxLocator ifxLocator) throws SQLException {
        this.conn = ifxConnection;
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
        this.smb = new IfxSmartBlob(ifxConnection);
        this.smb.IfxLoOpen(ifxLocator, 8);
    }

    protected IfxBblob(byte[] byArray) {
        this.blobBuffer = byArray;
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
    }

    public IfxBblob(InputStream inputStream) {
        this.blobStream = inputStream;
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    protected IfxBblob(IfxTmpFile ifxTmpFile) {
        this.tempBlobFile = ifxTmpFile;
        this.tempBlobFile.incRefCount();
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
    }

    public IfxBblob(Connection connection, InputStream inputStream, int n) throws SQLException {
        super(connection, inputStream, n);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, InputStream inputStream, int n, String string) throws SQLException {
        super(connection, inputStream, n, string);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, InputStream inputStream, int n, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        super(connection, inputStream, n, ifxLobDescriptor);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, byte[] byArray) throws SQLException {
        super(connection, byArray);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, byte[] byArray, String string) throws SQLException {
        super(connection, byArray, string);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, byte[] byArray, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        super(connection, byArray, ifxLobDescriptor);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxLocator getLocator() throws SQLException {
        return super.getLocator();
    }

    public long length() throws SQLException {
        return this.blobSize;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        return super.getPortion(l, n);
    }

    public InputStream getBinaryStream() throws SQLException {
        return super.getStream();
    }

    public long position(byte[] byArray, long l) throws SQLException {
        long l2 = l - 1L;
        byte[] byArray2 = super.getPortion(1L, this.blobSize);
        if (byArray2 == null) {
            return -1L;
        }
        String string = new String(byArray2);
        long l3 = string.indexOf(new String(byArray), (int)l2);
        if (l3 >= 0L) {
            ++l3;
        }
        return l3;
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob.getBytes(1L, (int)blob.length()), l);
    }

    public void setBinaryStream(long l, InputStream inputStream, int n) throws SQLException {
        if (this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb == null || this.smb.getHandle() == -1) {
            if (this.smartBlobMode != 0) {
                throw IfxErrMsg.getSQLException(-79814, this.conn);
            }
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoOpen(this.smb.locator, 8);
        }
        this.smb.IfxLoSeek(this.smb.getHandle(), l, 0);
        super.setStream(inputStream, n);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb == null || this.smb.getHandle() == -1) {
            if (this.smartBlobMode != 0) {
                throw IfxErrMsg.getSQLException(-79814, this.conn);
            }
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoOpen(this.smb.locator, 8);
        }
        this.smb.IfxLoSeek(this.smb.getHandle(), l, 0);
        int n = super.setBuffer(byArray);
        return n;
    }

    public void close() throws SQLException {
        super.close();
    }

    public long seek(long l, int n) throws SQLException {
        return super.seek(l, n);
    }

    public long where() throws SQLException {
        return super.where();
    }

    public IfxLoStat getLoStat() throws SQLException {
        return super.getLoStat();
    }

    public void truncate(long l) throws SQLException {
        super.truncate(l);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Bblob.setBytes(long,byte[],int,int)", this.conn);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Bblob.setBinaryStream(long,byte[],int,int)", this.conn);
    }

    protected synchronized void finalize() {
        try {
            if (this.smb != null) {
                ((IfxSqliConnect)this.conn).addToBlobList(this.smb);
            }
        }
        catch (Exception exception) {}
    }
}

