/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.helpers;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicBuffer<E> {
    E[] ea;
    int first;
    int last;
    int numElems;
    int maxSize;

    public CyclicBuffer(int n2) throws IllegalArgumentException {
        if (n2 < 1) {
            throw new IllegalArgumentException("The maxSize argument (" + n2 + ") is not a positive integer.");
        }
        this.init(n2);
    }

    public CyclicBuffer(CyclicBuffer<E> cyclicBuffer) {
        this.maxSize = cyclicBuffer.maxSize;
        this.ea = new Object[this.maxSize];
        System.arraycopy(cyclicBuffer.ea, 0, this.ea, 0, this.maxSize);
        this.last = cyclicBuffer.last;
        this.first = cyclicBuffer.first;
        this.numElems = cyclicBuffer.numElems;
    }

    private void init(int n2) {
        this.maxSize = n2;
        this.ea = new Object[n2];
        this.first = 0;
        this.last = 0;
        this.numElems = 0;
    }

    public void clear() {
        this.init(this.maxSize);
    }

    public void add(E e2) {
        this.ea[this.last] = e2;
        if (++this.last == this.maxSize) {
            this.last = 0;
        }
        if (this.numElems < this.maxSize) {
            ++this.numElems;
        } else if (++this.first == this.maxSize) {
            this.first = 0;
        }
    }

    public E get(int n2) {
        if (n2 < 0 || n2 >= this.numElems) {
            return null;
        }
        return this.ea[(this.first + n2) % this.maxSize];
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public E get() {
        E e2 = null;
        if (this.numElems > 0) {
            --this.numElems;
            e2 = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first == this.maxSize) {
                this.first = 0;
            }
        }
        return e2;
    }

    public List<E> asList() {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (int i2 = 0; i2 < this.length(); ++i2) {
            arrayList.add(this.get(i2));
        }
        return arrayList;
    }

    public int length() {
        return this.numElems;
    }

    public void resize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative array size [" + n2 + "] not allowed.");
        }
        if (n2 == this.numElems) {
            return;
        }
        Object[] objectArray = new Object[n2];
        int n3 = n2 < this.numElems ? n2 : this.numElems;
        for (int i2 = 0; i2 < n3; ++i2) {
            objectArray[i2] = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first != this.numElems) continue;
            this.first = 0;
        }
        this.ea = objectArray;
        this.first = 0;
        this.numElems = n3;
        this.maxSize = n2;
        this.last = n3 == n2 ? 0 : n3;
    }
}

