/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class DDMSECCHKReplyDataStream
extends DDMDataStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";

    DDMSECCHKReplyDataStream() {
    }

    boolean checkReply() {
        if (this.getCodePoint() != 4633) {
            Trace.log(2, "DDM SECCHK failed with code point:", this.data_, 8, 2);
            return false;
        }
        if (this.get16bit(18) != 4516) {
            Trace.log(2, "DDM SECCHK failed with rc:", this.data_, 18, 2);
            return false;
        }
        if (this.data_.length < 21) {
            Trace.log(2, "DDM SECCHK failed with length < 21:", this.data_);
            return false;
        }
        if (this.data_[20] != 0) {
            Trace.log(2, "DDM SECCHK failed with bad SECCHKCD:", this.data_, 20, 1);
            return false;
        }
        return true;
    }

    void read(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving DDM SECCHK reply...");
        }
        if (DataStream.readFromStream(inputStream, byArray = new byte[6], 0, 6) < 6) {
            Trace.log(2, "Failed to read all of the DDM SECCHK Reply header.");
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToUnsignedShort(byArray, 0)];
        System.arraycopy(byArray, 0, this.data_, 0, 6);
        this.readAfterHeader(inputStream);
    }
}

