/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.utils.Queue;
import com.sybase.jdbc2.utils.SyncObj;

public class SyncQueue {
    public static final int NEED = 10;
    public static final int WAITING = 11;
    public static final int SATISFIED = 12;
    public static final int OWNER = 13;
    public static final int TIMEOUT = 14;
    private Queue _waitList;
    private SyncObj _owner = null;

    public SyncQueue() {
        this._waitList = new Queue();
    }

    public SyncQueue(int n, int n2) {
        this._waitList = new Queue(n, n2);
    }

    protected int take(long l, SyncObj syncObj) {
        if (syncObj == this._owner) {
            return syncObj._state;
        }
        SyncObj syncObj2 = syncObj;
        synchronized (syncObj2) {
            if (syncObj._state != 10) {
                int n = syncObj._state;
                return n;
            }
            SyncQueue syncQueue = this;
            synchronized (syncQueue) {
                if (this._owner == null) {
                    this._owner = syncObj;
                    syncObj._state = 13;
                    int n = 13;
                    return n;
                }
                syncObj._state = 11;
                this._waitList.push(syncObj);
            }
            try {
                syncObj.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (syncObj._state == 11) {
                this._waitList.removeElement(syncObj);
                syncObj._state = 14;
            }
        }
        return syncObj._state;
    }

    protected void release(SyncObj syncObj) {
        SyncObj syncObj2 = syncObj;
        synchronized (syncObj2) {
            switch (syncObj._state) {
                case 10: {
                    syncObj._state = 12;
                    break;
                }
                case 11: {
                    syncObj._state = 12;
                    this._waitList.removeElement(syncObj);
                    syncObj.notify();
                }
            }
        }
    }

    protected synchronized void releaseNext(SyncObj syncObj) {
        if (syncObj != this._owner) {
            return;
        }
        this._owner = null;
        SyncObj syncObj2 = syncObj;
        synchronized (syncObj2) {
            syncObj._state = 10;
        }
        SyncObj syncObj3 = null;
        while ((syncObj3 = (SyncObj)this._waitList.popNoEx()) != null) {
            SyncObj syncObj4 = syncObj3;
            synchronized (syncObj4) {
                if (syncObj3._state == 11) {
                    syncObj3._state = 13;
                    this._owner = syncObj3;
                    syncObj3.notify();
                    return;
                }
            }
        }
    }

    protected synchronized SyncObj getOwner() {
        return this._owner;
    }

    public SyncObj dump() {
        return this._owner;
    }
}

