/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybUrlManager;
import com.sybase.jdbc2.jdbc.SybUrlProviderImplBase;
import com.sybase.jdbc2.utils.SybInterfacesEntry;
import com.sybase.jdbc2.utils.SybSqlIniParser;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;

public class SybSqlIniProvider
extends SybUrlProviderImplBase {
    private static final int ADDRESS = 0;
    private static final int HASERVER = 1;
    private static final int KERBEROS = 2;
    private static final int PROTOCOL = 4;
    private static final int PROPERTY = 5;
    private static final String[] KERBEROS_OID = new String[]{"1.3.6.1.4.1.897.4.6.6", "csfkrb5", "secmech"};
    private static final String[] PROTOCOL_TABLE = new String[]{"tli", "tcp", "nlwnsck"};
    private static final String[] ATTRIBUTE_TABLE = new String[]{"query", "hafailover", "secmech"};
    private static final String SYBASE_ADDRESS_PREFIX = "TCP#1#";
    private static final char SYBASE_ADDRESS_DELIMITER = ' ';
    private static final String PLACEHOLDER = "placeholder";
    private static final char HOSTPORT_DELIMITER = ':';
    private SybSqlIniParser _sqlIniParser = null;
    private SybInterfacesEntry _entry = null;

    public SybSqlIniProvider() {
        this._hostportList = new Vector();
        this._secondaryHostportList = new Vector();
    }

    public void init(String string, String string2, Properties properties, SybProperty sybProperty) throws SQLException {
        this._sybProps = sybProperty;
        int n = string2.indexOf("?");
        String string3 = "";
        if (n == -1) {
            ErrorMessage.raiseError("JZ019", string3);
        }
        if ((string3 = string2.substring(n + 1, string2.length())).equals("") || string3 == null) {
            ErrorMessage.raiseError("JZ019", string3);
        }
        string2 = string2.substring(string2.indexOf(":") + 3, n);
        this._sqlIniParser = new SybSqlIniParser();
        if (string2.equals("") || string2 == null) {
            ErrorMessage.raiseError("JZ021", string2);
        }
        try {
            this._sqlIniParser.open(string2);
        }
        catch (Exception exception) {
            ErrorMessage.raiseError("JZ021", exception.toString());
        }
        this._entry = this.getServerEntrys(string3);
        this.processAttrs(string2);
    }

    private SybInterfacesEntry getServerEntrys(String string) {
        return this._sqlIniParser.getEntry(string);
    }

    private void processAttrs(String string) throws SQLException {
        String string2 = null;
        String[] stringArray = this._sqlIniParser.getVariables(this._entry.getName());
        if (stringArray.length == 0) {
            ErrorMessage.raiseError("JZ024", this._entry.getName(), string);
        }
        int n = 0;
        while (n < stringArray.length) {
            switch (this.mapAttribute(stringArray[n])) {
                case 0: {
                    String string3;
                    int n2 = 0;
                    while (n2 < this._entry.getQuerySize()) {
                        this.isValidProtocol(this._entry.getProtocol(n2), string);
                        string3 = this._entry.getHostPort(n2);
                        if (!this._hostportList.contains(string3)) {
                            this._hostportList.addElement(string3);
                        }
                        ++n2;
                    }
                    if (this._hostportList.size() != 0) break;
                    ErrorMessage.raiseError("JZ024", this._entry.getName(), string);
                    break;
                }
                case 1: {
                    String string4;
                    String string3 = this._entry.getHaFailOver();
                    this._entry = this.getServerEntrys(string3);
                    int n3 = 0;
                    while (n3 < this._entry.getQuerySize()) {
                        this.isValidProtocol(this._entry.getProtocol(n3), string);
                        string4 = this._entry.getHostPort(n3);
                        if (!this._hostportList.contains(string4)) {
                            this._secondaryHostportList.addElement(string4);
                        }
                        ++n3;
                    }
                    if (this._secondaryHostportList.size() == 0) {
                        ErrorMessage.raiseError("JZ024", string3, string);
                    }
                    this._sybProps.setProperty(34, "true");
                    break;
                }
                case 2: {
                    String string4 = this._entry.getKerberosEntry();
                    ErrorMessage.raiseError("JZ027", string4, this._entry.getName(), string);
                    break;
                }
            }
            ++n;
        }
        if (string2 == null) {
            string2 = "Tds";
        }
        this._protocol = SybUrlManager.loadProtocol(string2);
        this._dbName = this._sybProps.getString(55);
    }

    private boolean isValidKerberos(String string, String string2) throws SQLException {
        String string3 = string;
        int n = string.indexOf(",");
        Vector<String> vector = new Vector<String>();
        while (n != -1) {
            String string4 = string.substring(0, n);
            vector.addElement(string4);
            string = string.substring(n + 1, string.length());
            n = string.indexOf(",");
        }
        if (!vector.contains(string)) {
            vector.addElement(string);
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < vector.size()) {
            string = (String)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < KERBEROS_OID.length) {
                if (string.equalsIgnoreCase(KERBEROS_OID[n2])) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (bl) {
                return true;
            }
            ++n2;
        }
        ErrorMessage.raiseError("JZ027", string3, this._entry.getName(), string2);
        return false;
    }

    private boolean isValidProtocol(String string, String string2) throws SQLException {
        int n = 0;
        while (n < PROTOCOL_TABLE.length) {
            if (string.equalsIgnoreCase(PROTOCOL_TABLE[n])) {
                return true;
            }
            ++n;
        }
        ErrorMessage.raiseError("JZ026", string, this._entry.getName(), string2);
        return false;
    }

    private int mapAttribute(String string) {
        int n = 0;
        while (n < ATTRIBUTE_TABLE.length) {
            if (string.equalsIgnoreCase(ATTRIBUTE_TABLE[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

